{--------------------------------------------------------}
{
{    Rotinas de teste do Brailex
{
{    Autor: Antonio Borges
{
{    Em 18/02/97
{
{--------------------------------------------------------}


uses crt, dos;

const
    latch1 = $80;
    latch2 = $40;

    espera        = 500;     { em milissegundos }

    esperaAperta  = 250;
    esperaSolta   = 250;   { testando, default 500 }

    esperaLF      = 1000;
    esperaCRLF    = 2500;
    esperaHome    = 8000;

    esperaMeiaTrava  = 450;

var
    corrDelay: integer;

{--------------------------------------------------------}
{                      delays
{--------------------------------------------------------}

procedure delay (x: integer);
var i: integer;
begin
    crt.delay (x * corrDelay);
end;

{--------------------------------------------------------}

procedure calibraDelay;
var 
    hora1, hora2: longint;
    h1, m1, s1, c1: word;
    h2, m2, s2, c2: word;
begin
    repeat
       gettime (h1,m1,s1,c1);
       hora1 := (((h1*60)+m1)*60+s1)*100+c1;
       crt.delay (1000);
       gettime (h2,m2,s2,c2);
       hora2 := (((h2*60)+m2)*60+s2)*100+c2;
    until hora2 > hora1;  { evita meia noite !}

    corrDelay := 103 div (hora2-hora1);
    if corrDelay < 1 then corrDelay := 1;
end;

{--------------------------------------------------------}

procedure xdelay (i: integer);
var j: integer;
begin
    for j := 1 to i do ;
end;

{--------------------------------------------------------}
{               acionamento basico
{--------------------------------------------------------}

procedure strobe;
begin
    xdelay (1);   port [$37a] := 0;
    xdelay (1);   port [$37a] := 1;
    xdelay (1);   port [$37a] := 0;
end;

{--------------------------------------------------------}

procedure escLatch1 (b: byte);
begin
     b := b xor $3f;
     port [$378] := b + latch1;  strobe;
end;

{--------------------------------------------------------}

procedure escLatch2 (b: byte);
begin
     b := b xor $3f;
     port [$378] := b + latch2;  strobe;
end;

{--------------------------------------------------------}
{                 rotinas de funcao
{--------------------------------------------------------}

procedure inicializa;
begin
     calibraDelay;

     escLatch1(0);
     escLatch2(0);
end;

{--------------------------------------------------------}

procedure repete;     { so' util para testes }
begin
    esclatch2 ($2);   delay (esperaLF);
    esclatch2 (0);    delay (espera);
end;

{--------------------------------------------------------}

procedure home;
begin
    esclatch2 ($1);   delay (esperaAperta);
    esclatch2 (0);    delay (esperaHome);
end;

{--------------------------------------------------------}

procedure crlf;
begin
    esclatch2 ($4);   delay (esperaCRLF);
    esclatch2 (0);    delay (esperaLF);
end;

{--------------------------------------------------------}

procedure meiaTrava;  { ok }
begin
    esclatch2 ($4);   delay (esperaMeiaTrava);
    esclatch2 (0);    delay (esperaSolta);
end;

{--------------------------------------------------------}

procedure lineFeed;  { ok }
begin
    esclatch2 ($8);   delay (esperaLF);
    esclatch2 (0);    delay (espera);
end;

{--------------------------------------------------------}

procedure lineBack;  { ok }
begin
    esclatch2 ($10);  delay (esperaLF);
    esclatch2 (0);    delay (espera);
end;

{--------------------------------------------------------}

procedure space;     { ok }
begin
    esclatch2 ($20);  delay (esperaAperta);
    esclatch2 (0);    delay (esperaSolta);
end;

{--------------------------------------------------------}

procedure caracBraille (b: byte);   { ok }
begin
    if b = 0 then
        space
    else
        begin
            esclatch1 (b);  delay (esperaAperta);
            esclatch1 (0);  delay (esperaSolta);
        end;
end;

{--------------------------------------------------------}
{                  programa principal
{--------------------------------------------------------}

var i: integer;

begin
    inicializa;
end.





