{--------------------------------------------------------}
{
{    Rotinas de teste do Brailex
{
{    Autor: Antonio Borges
{
{    Em 18/02/97
{
{--------------------------------------------------------}


uses crt, dos;

const
    latch1 = $80;
    latch2 = $40;

    esperaAposLF     = 500;
    esperaAperta     = 150;
    esperaSolta      = 350;  {500}
    esperaMeiaTrava1 = 500;
    esperaMeiaTrava2 = 1200;
    esperaMeiaTrava3 = 1000;
    esperaLF         = 500;
    esperaFimLf      = 1000;
    esperaCRLF       = 2500;
    esperaHome       = 500;

var
    corrDelay: integer;

const repulando = true;

{--------------------------------------------------------}
{                      delays
{--------------------------------------------------------}

procedure delay (x: integer);
var i: integer;
begin
    crt.delay (x * corrDelay);
end;

{--------------------------------------------------------}

procedure calibraDelay;
var 
    hora1, hora2: longint;
    h1, m1, s1, c1: word;
    h2, m2, s2, c2: word;
begin
    repeat
       gettime (h1,m1,s1,c1);
       hora1 := (((h1*60)+m1)*60+s1)*100+c1;
       crt.delay (1000);
       gettime (h2,m2,s2,c2);
       hora2 := (((h2*60)+m2)*60+s2)*100+c2;
    until hora2 > hora1;  { evita meia noite !}

    corrDelay := 103 div (hora2-hora1);
    if corrDelay < 1 then corrDelay := 1;
end;

{--------------------------------------------------------}

procedure xdelay (i: integer);
var j: integer;
begin
    for j := 1 to i do ;
end;

{--------------------------------------------------------}
{               acionamento basico
{--------------------------------------------------------}

procedure strobe;
begin
    xdelay (1);   port [$37a] := 0;
    xdelay (1);   port [$37a] := 1;
    xdelay (1);   port [$37a] := 0;
end;

{--------------------------------------------------------}

procedure escLatch1 (b: byte);
begin
     b := b xor $3f;
{     port [$378] := b;           strobe;}
     port [$378] := b + latch1;  strobe;
{     port [$378] := b;           strobe;}
end;

{--------------------------------------------------------}

procedure escLatch2 (b: byte);
begin
     b := b xor $3f;
{     port [$378] := b;           strobe;}
     port [$378] := b + latch2;  strobe;
{     port [$378] := b;           strobe;}
end;

{--------------------------------------------------------}
{                 rotinas de funcao
{--------------------------------------------------------}

procedure inicMaquina;
begin
     escLatch1(0);
     escLatch2(0);

     calibraDelay;
end;

{--------------------------------------------------------}

procedure repete;     { so' util para testes }
begin
    esclatch2 ($2);   delay (esperaLF);
    esclatch2 (0);    delay (esperaAposLF);
end;

{--------------------------------------------------------}

procedure lineFeed;  { ok }
begin
    esclatch2 ($8);   delay (esperaLF);
    esclatch2 (0);    delay (esperaAposLF);
end;

{--------------------------------------------------------}

procedure home;
begin
    esclatch2 ($1);   delay (esperaAperta);
    esclatch2 (0);    delay (esperaHome);
    if repulando then
        lineFeed;
end;

{--------------------------------------------------------}

procedure crlf;
begin
    esclatch2 ($4);   delay (esperaCRLF);
    esclatch2 (0);    delay (esperaSolta);
    delay (esperaAposLF);
    if repulando then lineFeed;
end;

{--------------------------------------------------------}

procedure meiaTrava (quanto: integer);  { ok }
begin
    esclatch2 ($4);   delay (quanto);
    esclatch2 (0);    delay (esperaMeiaTrava1);
    esclatch2 ($4);   delay (esperaMeiaTrava2);
    esclatch2 (0);    delay (esperaMeiaTrava3);
    if repulando then lineFeed;
end;

{--------------------------------------------------------}

procedure lineBack;  { ok }
begin
    esclatch2 ($10);  delay (esperaLF);
    esclatch2 (0);    delay (esperaAposLF);
end;

{--------------------------------------------------------}

procedure space;     { ok }
begin
    esclatch2 ($20);  delay (esperaAperta);
    esclatch2 (0);    delay (esperaSolta);
end;

{--------------------------------------------------------}

procedure caracBraille (b: byte);   { ok }
begin
    if b = 0 then
        space
    else
        begin
            esclatch1 (b);  delay (esperaAperta);
            esclatch1 (0);  delay (esperaSolta);
        end;
end;

{--------------------------------------------------------}
{                  programa principal
{--------------------------------------------------------}

var i: integer;

begin
    clrscr;
    writeln ('Rotinas de teste do Brailex - v1.0 de 25/2/97');
    writeln;
    write ('Coloque a maquina offline, ligue a interface e tecle enter');
    readln;
    writeln ('Inicializando interface ...');
    inicMaquina;

    write ('Tecle enter para iniciar o teste');
    readln;
(*
    writeln ('Executando 10 line feeds');
    for i := 1 to 10 do
        linefeed;

    writeln ('Executando 5 line backs');
    for i := 1 to 5 do
        lineBack;
*)
    writeln ('Executando 20 espacos');
    for i := 1 to 20 do
        space;

    writeln ('Executando 5 retornos de carro');
    for i := 1 to 5 do
         crlf;

    writeln ('Executando retorno ao inicio');
    home;

    write ('Posicione na area de escrita e tecle enter');
    readln;

    writeln ('Testando puncoes');
    for i := 1 to 5 do
        begin
            caracBraille (1);
            caracBraille (2);
            caracBraille (4);
            caracBraille (8);
            caracBraille (16);
            caracBraille (32);
        end;

    crlf;

    for i := 0 to 63 do
        begin
            caracBraille (i);
            if (i mod 16) = 15 then crlf;
        end;

    writeln ('Testando meia trava');
    for i := 1 to 40 do
        space;
    meiaTrava (300);

    for i := 1 to 40 do
        space;
    meiaTrava (500);

    writeln;
    writeln ('Fim de teste');

    inicMaquina;
end.
