{--------------------------------------------------------}
{
{     Programa para teclagem direta em Braille
{
{     Autor: Jose' Antonio Borges
{
{     Em 7/6/96
{
{--------------------------------------------------------}

{$M 1024, 0, 0}
program TBraille;
uses crt, dos;

const
    TESTE = false;

var
    Kbd_Vec: procedure;
    regs: registers;

    inibido, caixaAlta, maiusc, codificando, numerico, apertou: boolean;
    teclasApert, conjTeclado, status, carac, letra, masc, 
    codigo, codigo2: byte;

{
    Pontos Braille nao padronizados
        4   circunflexo
        45  arroba
        46  fecha colchete
        456 sublinhado
        5   til
        56  barra invertida (raiz)
        6   crase
}

const
    codMaiusc: char = ']';
    codNumero: char = '#';
    codIgnora: byte = $ff;

    tabTec: array [0..63] of string[2] = (

  {0}   ' ',  'a',  ',',  'b', '''''',  'k',  ';',  'l',
        '^^',  'c',  'i',  'f', '''i', 'm',  's',  'p',

  {1}   '~~', 'e', ':', 'h', '*', 'o', '!', 'r',
        '@', 'd', 'j', 'g', '~a', 'n', 't', 'q',

  {2}   '``', '^a', '?', '^e', '-', 'u', '{', 'v',
        ']', '`i', '~o', '`a', '''o', 'x', '`e', '''c',

  {3}   '\', '`u', '.', '"u', '}', 'z', '(', '''a',
        '_', '^o', 'w', '"i', '#', 'y', '''u', '''e' );

{$F+}

const
    letrasAlfa: set of byte = [16..25, 30..38, 44..50, 57];


{--------------------------------------------------------}
{                  rotina de interrupcao
{--------------------------------------------------------}

procedure novaInt9 (_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
                            _SI, _DI, _DS, _ES, _BP: word); interrupt;
label fim;

    {--------------------------------------------------------}

    procedure codifica;
    begin
        if numerico then
            begin
                if chr (codigo) in ['a'..'i'] then
                    codigo := ord ('1') + codigo-ord('a')
                else
                if chr (codigo) = 'j' then
                    codigo := ord('0')
                else
                if chr (codigo) = '''' then
                    codigo := ord('.')
                else
                if (chr (codigo) = '~') and (chr (codigo2) = '~') then
                    numerico := false;
            end;

        if (chr (codigo) = '{') or (chr (codigo) = '}') then
            begin
                codigo  := ord('"');
                codigo2 := ord('"');
            end;
    
        if maiusc or caixaAlta then
            begin
                if codigo in [ord('a')..ord('z')] then
                    codigo := codigo - $20;
                if codigo2 in [ord('a')..ord('z')] then
                    codigo2 := codigo2 - $20;
            end;

        if chr(codigo) = codNumero then
            begin
                numerico := true;
                codigo := codIgnora;
            end
        else
            if chr(codigo) = codMaiusc then
                begin
                    if maiusc then
                        caixaAlta := true;
                    maiusc := true;
                    codigo := codIgnora;
                end
            else
                maiusc := false;
    end;

    {--------------------------------------------------------}

    procedure interpTeclagem;
    begin
        codigo2 := codIgnora;

        if conjTeclado >= 64 then
            begin
                maiusc := false;
                caixaAlta := false;
                numerico := false;

                if conjTeclado = 64 then
                    codigo := ord (' ')
                else
                    codigo := ord (
                      tabTec [conjTeclado and $3f][1]) and $1f;
            end
        else
            begin
                codigo  := ord (tabTec [conjTeclado][1]);
                if length (tabTec [conjTeclado]) > 1 then
                    codigo2 := ord (tabTec [conjTeclado][2]);
                if codificando then
                    codifica;
            end;

        if codigo <> codIgnora then
            with regs do
                begin
                    ah := 5;   ch := codigo;  cl := ch;
                    intr ($16, regs);
                end;

        if codigo2 <> codIgnora then
            with regs do
                begin
                    ah := 5;   ch := codigo2;  cl := ch;
                    intr ($16, regs);
                end;

        conjTeclado := 0;
    end;

    {--------------------------------------------------------}

begin
     carac := port [$60];
     letra  := carac and $7f;

     if letra = 87 then       { libera teclado braille }
         begin
             if (carac and $80) <> 0 then   { soltando tecla }
                 begin
                     inibido := false;
                     sound (200);  delay (200);  nosound;

                     if codificando then
                         begin
                             codificando := false;
                             sound (400);  delay (200);  nosound;
                         end
                     else
                         begin
                             codificando := true;
                             sound (250);  delay (200);  nosound;
                         end;
                 end;

             goto fim;
         end;

     if letra = 88 then       { inibe teclado braille }
         begin
             inibido := true;
             codificando := true;
             sound (100);  delay (200);  nosound;
             goto fim;
         end;

     if inibido or not (letra in letrasAlfa) then
         begin
              conjTeclado := 0;
              teclasApert := 0;
              asm pushf; end;
              Kbd_Vec;
              exit;
         end;

     masc := 0;
     case letra of
         31:   masc := 4;     {s, d, f, j, k, l, espaco }
         32:   masc := 2;
         33:   masc := 1;
         36:   masc := 8;
         37:   masc := 16;
         38:   masc := 32;
         57:   masc := 64;
     end;

     apertou := (carac and $80) = 0;
     if apertou then
         begin
             conjTeclado := conjTeclado or masc;
             teclasApert := teclasApert or masc;
         end
     else
         begin
             teclasApert := teclasApert and (not masc);

             if teclasApert = 0 then
                 interpTeclagem;
         end;

fim:
     status := port [$61];
     port [$61] := status or $80;
     port [$61] := status;

     port [$20] := $20;
end;

{$F-}

{--------------------------------------------------------}
{                      inicializacao
{--------------------------------------------------------}

var c: char;
begin
    GetIntVec($9, @Kbd_Vec);
    SetIntVec($9, @novaInt9);

    codificando := true;
    inibido := false;
    maiusc := false;
    numerico := false;
    caixaAlta := false;
    teclasApert := 0;
    conjTeclado := 0;

    writeln;
    writeln ('Teclado Braille 1.0');
    writeln;
    writeln ('F11:  teclagem Braille');
    writeln ('      (chaveia codifica/nao codifica maiusculas e numeros');
    writeln ('F12:  teclagem convencional');
    writeln;
    sound (200);  delay (200);  nosound;
    sound (250);  delay (200);  nosound;

    if TESTE then
        begin
            repeat
                if keypressed then
                    write (readkey);
            until inibido;
            setIntVec ($9, @Kbd_Vec);
        end
    else
        keep (0);
end.
