{--------------------------------------------------------}
{
{    Programa de converso do cdigos para o Braivox
{
{    Autor: Jose' Antonio Borges
{
{    Em 18/3/99
{
{--------------------------------------------------------}

program transcod;
uses crt, sintvox, traduvox, intervox, dv;

var nomeArq, nomeSai, nomeArqCod: string;
    arq, arqsai, arqcod: text;
    tamTab: integer;
    txorig, txnovo: array [1..1000] of ^string;

{--------------------------------------------------------}
{                finaliza programa
{--------------------------------------------------------}

procedure finaliza;
begin
    tradFim;
    halt;
end;

{--------------------------------------------------------}
{             inicializa e abre arquivos
{--------------------------------------------------------}

procedure inicializa;
begin
    clrscr;
    sintInic (0, 'DIRTRANSCOD');
    if tradinic <> 0 then;

    writeln ('Conversor de codigos para o Braivox');
    sintSom ('CVINIC');
    writeln;
    writeln ('Qual o arquivo a converter ? ');
    sintSom ('CVNOMARQ');
    dvReadln (nomeArq);
    if nomeArq = '' then halt;

    assign (arq, nomeArq);
    {$I-}  reset (arq);  {$I+}
    if ioresult <> 0 then
        begin
            writeln ('Arquivo nao existe, programa terminado');
            sintSom ('CVARQNAO');
            finaliza;
        end;
    close (arq);

    writeln ('Qual o arquivo de saida ? ');
    sintSom ('CVNOMSAI');
    dvReadln (nomeSai);
    if nomeSai = '' then halt;
    assign (arqSai, nomeSai);
end;

{--------------------------------------------------------}
{                 carrega a codificacao
{--------------------------------------------------------}

procedure carregaCodigo;
var
    linha, p: integer;
    original, novoTexto, s: string;
begin
    writeln ('Qual o arquivo de codificacao ? Assumo \dosvox\codmat.amb');
    sintSom ('CVARQCOD');
    dvReadln (nomeArqCod);
    if nomeArqCod = '' then nomeArqCod := '\dosvox\codmat.amb';

    assign (arqCod, nomeArqCod);
    {$I-}  reset (arqCod);  {$I+}
    if ioresult <> 0 then
        begin
            writeln ('Arquivo de codificacao nao existe, programa terminado');
            sintSom ('CVCODNAO');
            finaliza;
        end;

    linha := 0;
    tamTab := 0;
    while not eof (arqCod) do
        begin
            readln (arqCod, s);
            linha := linha + 1;
            if (s = '') or (s[1] = ';') then
                { nada faz }
            else
            if s[1] <> '`' then
                begin
                    write ('Codigo invalido na linha ');
                    sintSom ('CVCODINV');
                    dvWriteInt (linha);
                    writeln;
                end
            else
                begin
                    original := '';
                    novoTexto := '';
                    tamTab := tamTab + 1;
                    p := 1;
                    while (p <= length (s)) and (s[p] <> ' ') do
                        begin
                            original := original + s[p];
                            p := p + 1;
                        end;
                    while (p <= length (s)) and (s[p] = ' ') do
                        p := p + 1;
                    while (p <= length (s)) and (s[p] <> ' ') do
                        begin
                            novoTexto := novoTexto + s[p];
                            p := p + 1;
                        end;

                    getMem (txorig [tamTab], length(original) + 1);
                    txorig [tamTab]^ := original;
                    getMem (txnovo [tamTab], length(novoTexto) + 1);
                    txnovo [tamTab]^ := novoTexto;
                end;
        end;

    close (arqCod);
end;

{--------------------------------------------------------}
{                 busca texto novo
{--------------------------------------------------------}

procedure buscaTroca (texto: string; posInicial: integer;
                      var avancar: integer; var troca: string);
var i, tam: integer;
begin
    troca := '';
    for i := 1 to tamTab do
        begin
            tam := length (txOrig [i]^);
            if copy (texto, posInicial, tam) = txOrig [i]^ then
                begin
                    troca := txNovo [i]^;
                    avancar := tam;
                    exit;
                end;
        end;

    avancar := 1;
    troca := texto [posInicial];
end;

{--------------------------------------------------------}
{        transcreve o texto fazendo alteracoes
{--------------------------------------------------------}

procedure transcreve;
var s, saida, troca: string;
    p, avancar: integer;
label errodisco;
begin
    reset (arq);
    rewrite (arqSai);

    while not eof (arq) do
        begin
            {$I-} readln (arq, s);  {$I+}
            if ioresult <> 0 then goto errodisco;

            p := 1;
            saida := '';
            while p <= length (s) do
                begin
                    if s[p] <> '`' then
                        begin
                            saida := saida + s[p];
                            p := p + 1;
                        end
                    else
                        begin
                            buscaTroca (s, p, avancar, troca);
                            p := p + avancar;
                            saida := saida + troca;
                        end;
                end;

            {$I-} writeln (arqSai, saida);   {$I+}
            if ioresult <> 0 then goto errodisco;
        end;


    if false then
        begin
erroDisco:
            writeln ('Problemas no disco');
            sintSom ('CVERRDSK');
        end;

    {$I-}  close (arq);  {$I+}
    if ioresult <> 0 then;
    {$I-}  close (arqSai); {$I+}
    if ioresult <> 0 then;
end;

{--------------------------------------------------------}
{             programa principal
{--------------------------------------------------------}

begin
    inicializa;
    carregaCodigo;
    transcreve;

    writeln ('Conversao terminada');
    sintSom ('CVFIM');
    finaliza;
end.
