*--------------------------------------------
* Manuteno de um cadastro de fitas cassete
* Autor: Antonio Borges
* em julho/95
*--------------------------------------------

*--------------------------------------------
* Programa principal
*--------------------------------------------

     inicializa ()
     processa ()
     finaliza ()
     return

*--------------------------------------------
* Rotina de inicializao
*--------------------------------------------

procedure inicializa
local resp

    limpaTela()
    portuvox ("Controle de fitas")

    @10, 20 say "Devo criar o banco de dados (s/n): "
    portuvox ("cria banco ? ")
    resp = upper(chr(inkey(0)))

    tocavox ("\windows\ding.wav")

    if upper (resp) = 'S'
        portuvox ("criando banco")
        estrutura = {}
        aadd (estrutura, {"codigo", "N", 9, 0} )
        aadd (estrutura, {"nome", "C", 30, 0} )
        aadd (estrutura, {"artista", "C", 30, 0} )
        dbcreate ("fitas", estrutura)
    endif

    close all
    return

*--------------------------------------------
* Rotina que limpa a tela
*--------------------------------------------

procedure limpaTela
     clear
     @0, 0 to 2, 79 double
     @1, 22 say "Sistema de Controle de Fitas Cassete"
     return

*--------------------------------------------
* Rotina de finalizacao
*--------------------------------------------

procedure finaliza
    limpaTela ()
    tocavox ("\windows\ding.wav")
    @7,10 say "Tchau, volte sempre."
    portuvox ("Tchau vlte sempre")
    return

*--------------------------------------------
* Rotina geral de processamento
*--------------------------------------------

procedure processa
local processando, opcao

     processando = .T.
     do while processando
         limpaTela ()
         @12,15 say "i - incluir fitas"
         @13,15 say "l - listar fitas"
         @14,15 say "a - alterar fitas"
         @15,15 say "f - fim"
         @10,10 say "Digite sua opo: "
         portuvox ("opo")

         opcao = upper (chr(inkey(0)))
         if opcao = 'I'
              incluirFita()
         elseif opcao = 'L'
              listarFitas()
         elseif opcao = 'A'
              alterarFitas()
         elseif opcao = 'F'
              processando = .F.
         else
              portuvox ("opes: i incluir le listar a alterar fe fim")
         endif
     enddo
     return

*--------------------------------------------
* Rotina de incluso
*--------------------------------------------

procedure incluirFitas
local cod, dia

    use fitas

    limpaTela()
    @10, 10 say ("Incluir nova fita")
    portuvox ("Incluir fita")

    append blank

    @12, 10 say "Digite o codigo: "
        portuvox ("cdigo")
        cod = lelinvox ()
        replace codigo with val (cod)

    @13, 10 say "Digite o nome: "
        portuvox ("nome")
        replace nome with lelinvox ()

    @14, 10 say "Digite o artista: "
        portuvox ("artista")
        replace artista with lelinvox ()

    close all
    return

*--------------------------------------------
* Rotina de listagem
*--------------------------------------------

procedure listarFitas
local numero, cont

    use fitas

    limpaTela()
    @10, 10 say ("Listagem das fitas")
    portuvox ("Listagem das fitas")

    numero = 0
    cont = 'S'        
    do while (.not. eof()) .and. (cont != 'N')
        limpaTela()
        @10, 10 say ("Listagem das fitas")

        numero++
        @12, 10 say ("registro:" + str(numero))
        @13, 10 say ("codigo  :" + str(codigo) )
        @14, 10 say ("nome    :" + nome )
        @15, 10 say ("artista :" + artista )

        portuvox ("registro " + str(numero))
        portuvox ("codigo "   + str(codigo))
        portuvox ("nome "     + nome )
        portuvox ("artista "  + artista )

        skip 1

        tocavox ("\windows\ding.wav")
        @22, 10 say ("Continua ? ")
        portuvox ("Continua ? ")
        cont = upper(chr(inkey(0)))
    enddo

    ? "Fim do arquivo"
    portuvox ("Fim do arquivo")

    close all
    return

*--------------------------------------------
* Rotina de alteracao
*--------------------------------------------

procedure alterarFitas
local up, down, enter, esc
local cod

    use fitas
    index on codigo to fitas

    limpaTela()
    portuvox ("Altera fita")
    @10, 10 say ("Alterar cadastro de fita")

    @12, 10 say "Informe o codigo: "
        portuvox ("Informe o cdigo")
        cod = val(lelinvox())

        seek cod
        if .not. found()
            @14, 10 say "No achei cdigo"
            portuvox ("No achei")
            return
        endif

    @20, 10 say "Use as setas para caminhar nos campos"
    portuvox ("Altere ou use as setas")

*------- tratamento generico de multi-campos  -------
*-------  use como modelo de seus programas   -------

    up    = "072"
    down  = "080"
    pgup  = "073"
    pgdn  = "081"
    enter = "013"
    esc   = "027"

    processando = .T.
    qualCampo = 1
    tecla = "   "

    maxCampos = 2
    do while processando

        do case
            case qualCampo = 1

                @13, 10 say "Nome: "
                portuvox ("nome")
                replace nome with edlinvox (nome, @tecla)

            case qualCampo = 2

                @14, 10 say "Digite o artista: "
                portuvox ("artista")
                replace artista with edlinvox (artista, @tecla)

        endcase

        do case
            case tecla = esc
                 processando = .F.
            case (tecla = down) .or. (tecla = enter)
                 qualCampo = qualCampo + 1
                if qualCampo > maxCampos
                     qualCampo = maxCampos
                 endif
            case tecla = up
                 qualCampo = qualCampo - 1
                 if qualCampo < 1
                     qualCampo = 1
                 endif

            *
            *  completar aqui outras opcoes
            *
        endcase

    enddo

*------- fim do tratamento generico de multi-campos  -------

    close all
    return

*--------------------------------------------
* Inclui o arquivo de interface sonora
*--------------------------------------------

#include "vox.ch"
