{--------------------------------------------------------}
{               fala parmetros em portugus
{--------------------------------------------------------}

uses traduvox, intervox, sintvox, playvox, crt, lenumstr;

var np: integer;
    soletrando: boolean;

{--------------------------------------------------------}

function ansiParaTela (c: char): char;
begin
    if c > #127 then
      case ord(c) of
        $E1: c:='';
        $E9: c:='';
        $ED: c:='';
        $F3: c:='';
        $FA: c:='';
        $C1: c:='';
        $C9: c:='';
        $CD: c:='';
        $D3: c:='';
        $DA: c:='';
        $E2: c:='';
        $EA: c:='';
        $F4: c:='';
        $C2: c:='';
        $CA: c:='';
        $D4: c:='';
        $E3: c:='';
        $F5: c:='';
        $C3: c:='';
        $D5: c:='';
        $E0: c:='';
        $C0: c:='';
        $FC: c:='u';   { provisorio }
        $DC: c:='U';   { provisorio }
        $E7: c:='';
        $C7: c:='';

        $C6: c:='';   { gerados pelo OCR }
        $E4: c:='';
        $D6: c:='';
    end;
    ansiParaTela := c;
end;


procedure inicFala;
var s: string;
    i, erro: integer;
begin
    soletrando := false;
    np := 1;

    s := paramstr(1) + '#';
    if s[1] = '/' then
       begin
           np := 2;
           delete (s, 1, 1);
           while s[1] <> '#' do
               begin
                   if upcase(s[1]) = 'R' then   selecTipoFonemas(3);
                   if upcase(s[1]) = 'C' then   selecTipoFonemas(4);
                   if upcase(s[1]) = 'S' then   soletrando := true;
                   delete (s, 1, 1);
               end;
        end;

        sintInic (0, '');

        erro := tradInic;
        if erro <> 0 then
            begin
                for i := 1 to paramcount do
                    sintclek;
                halt;
            end;
end;

{--------------------------------------------------------}

var
    s, s2, fonemas: string;
    subcad, resp: string;
    intervalo: integer;
    veloc: integer;
    n, i, j, erro: integer;
    c, r: integer;
    x: longint;

label fim;

begin
    if paramcount > 0 then
    begin
        inicFala;

        if soletrando then
            begin
                for i := np to paramcount do
                    begin
                        sintSoletra (paramstr(i));
                        if i <> paramcount then
                            sintClek;
                    end;
                goto fim;

            end;

        for i := np to paramcount do
        begin
            s := paramstr(i);
            while (s <> '') and (s[1] = ' ') do
                delete (s, 1, 1);

            s2 := '';
            for j := 1 to length (s) do
                s2 := s2 + ansiParaTela (s[j]);

            while s2 <> '' do
                begin
                    case s2[1] of
                         '0'..'9':
                             begin
                                 subcad := '';
                                 while (s2 <> '') and (s2[1] in ['0'..'9']) do
                                     begin
                                         subcad := subcad + s2[1];
                                         delete (s2, 1, 1);
                                     end;
                                 if length (subcad) > 5 then
                                     sintSoletra (subcad)
                                 else
                                     begin
                                         val (subcad, x, erro);
                                         falaNumeroConv (numeroParaString (x), MASCULINO);
                                     end;
                             end;

                         '.', ',', '/':
                             begin
                                 sintCarac (s2[1]);
                                 delete (s2, 1, 1);
                             end;

                    else
                       begin
                           compilaFonemas (s2, fonemas);
                           falaFonemas (fonemas, true);
                           s2 := '';
                       end;
                end;
            end;
        end;
    end;

fim:
    tradFim;
end.
