{--------------------------------------------------------}
{
{     Rotinas de comunicacao serial Full-Duplex Assincrona
{     Autores:  Antonio II, Carlos Mendes, Marcelo Ramos
{     Criada em Marco/86
{
{--------------------------------------------------------}

{$F+}

Unit comunic;

Interface
Uses crt, dos;

Procedure InicIntr (porta: word;  irq: byte;
                    vel: longint;  nbits, nstop: byte;
		    tipoParid: byte);
			    { Obs: nbits= 5, 6, 7, 8; nstop = 1, 2 }
			    { paridade: 0-sem,  1-impar,  2-par }
Procedure FinalIntr;
Procedure EscLink (c: char);
Function  ChegouLink: boolean;
Procedure LeLink (var c: char);
Procedure DesligaModem;
procedure LigaModem;
procedure delay (x: integer);
procedure debugComunic (faz: boolean);

Implementation

{ constantes, tipos e variaveis }

const   TAMBUF = 8192;          { tamanho do buffer }
        LIMMIN = 2000;          { controles do XON/XOFF }
        LIMMAX = 7000;

type    BUFCIRC = record
		       ptins, ptret     : integer;
		       dado             : array [0..TAMBUF-1] of byte;
		  end;

var     buflink         : BUFCIRC;
	salvaseg        : pointer;
	regs            : REGISTERS;
        corrDelay       : integer;
        enviouXOFF      : boolean;
        mascLeitLink    : byte;
        debug           : boolean;

{  portas do IBM/PC para comunicacoes  }
const
	CTL8259 = $20;
	EI8259  = $21;        { controle de interrupcoes da 8259 }
	CTL8259SLAVE = $A0;
	EI8259SLAVE  = $A1;   { controle de interrupcoes da 8259 secundaria }

        EOI = $20;     { comando end of interrupt }

var     LINECTL    : word;
	DIVISORL   : word;   {para acessar, ligar bit 7 de LINECTL (DLAB)}
	DIVISORH   : word;
	LINESTATUS : word;
	INTERRID   : word;
	INTERENB   : word;
	MODEMCTL   : word;
	MODEMSTATUS: word;
	RXBUF      : word;   {para acessar, desligar bit 7 de LINECTL (DLAB)}
	TXBUF      : word;

	irqNum     : word;
	intVal     : word;

{--------------------------------------------------------}
{              escreve um byte na porta serial
{--------------------------------------------------------}

procedure esclink (c: char);
begin
    if debug then
        begin
            textbackground (red);
            write (c);
            textbackground (blue);
        end;

    repeat until (port [LINESTATUS] and $20) <> 0;
    port [TXBUF] := ord (c);
end;

{--------------------------------------------------------}
{              trata buffer cheio (opcional)
{--------------------------------------------------------}

(*

procedure trataXonXoff;
var
    ncbuf: integer;
begin
    with buflink do
        begin
            ncbuf := ptins-ptret;
            if ncbuf < 0 then
                ncbuf := ncbuf + TAMBUF;
        end;

    if enviouXOff then
        begin
            if ncbuf < LIMMIN then
                begin
                    escLink (^Q);
                    enviouXOff := false;

                    { para poder ser usado tambem dentro da interrupcao }
                    repeat until (port [LINESTATUS] and $20) <> 0;
                end;
        end
    else
        begin
            if  ncbuf > LIMMAX then
                begin
                    escLink (^S);
                    enviouXOff := true;

                    repeat until (port [LINESTATUS] and $20) <> 0;
                end;
        end;
end;

*)

{--------------------------------------------------------}
{              tratamento da interrupcao
{--------------------------------------------------------}

procedure intlink; interrupt;
begin
    with buflink do
        repeat
	    dado[ptins] := port [RXBUF] and mascLeitLink;
            ptins := (ptins + 1) mod TAMBUF;
        until (port [INTERRID] and 1) <> 0;


    if irqNum >= 8 then
       begin
           port [CTL8259SLAVE] := EOI;        { end of interrupt }
           asm; nop; nop; nop; nop; end;
       end;

    port [CTL8259] := EOI;        { end of interrupt }

    {trataXonXoff;}
end;

{--------------------------------------------------------}
{              inicializacao das interrupcoes
{--------------------------------------------------------}

Procedure InicIntr (porta: word;  irq: byte;
                    vel: longint;  nbits, nstop: byte;
		    tipoParid: byte);
var
    d: word;
    val: byte;
begin
    case porta of
        1:  d := 0;
        2:  d := $100;
        3:  d := $10;
        4:  d := $110;
    else
        writeln ('Porta de comunicacao invalida: ', porta);
        halt;
    end;

    irqNum := irq;

    LINECTL     := $3fb-d;
    DIVISORL    := $3f8-d;  { para acessar, ligar bit 7 de LINECTL (DLAB) }
    DIVISORH    := $3f9-d;
    LINESTATUS  := $3fd-d;
    INTERRID    := $3fa-d;
    INTERENB    := $3f9-d;
    MODEMCTL    := $3fc-d;
    MODEMSTATUS := $3fe-d;
    RXBUF       := $3f8-d;  { para acessar, desligar bit 7 de LINECTL (DLAB) }
    TXBUF       := $3f8-d;

  { prepara buffer circular }

    buflink.ptins := 0;
    buflink.ptret := 0;

  { prepara vetor }

    if irqNum < 8 then
        intVal := 8 + irqNum
    else
        intVal := 104 + irqNum;

    getintvec (INTVAL, salvaseg);
    setintvec (INTVAL, addr (intlink));

  { velocidade }

    port [LINECTL]  := $80;   { liga dlab }
    port [DIVISORH] := word (115200 div vel)  shr   8;
    port [DIVISORL] := word (115200 div vel)  and $ff;

  { configuracao da comunicacao }
    val := ((nbits-5) and 3) +
	   ((nstop-1) and 1) shl 2;

    if nbits = 7 then
        mascLeitLink := $7f
    else
        mascLeitLink := $ff;

    case tipoParid of
	0: ;
	1: val := val + 7 shl 3;
	2: val := val + 5 shl 3;
    end;

    port [LINECTL] :=  val;       { seta parametros, desliga dlab }
    port [MODEMCTL] := $03;       { nao interrompe, rts/dtr }

    if irqNum < 8 then
        begin
            port [EI8259]  := port [EI8259] and
                                        (not (1 shl irqNum));
            port [CTL8259] := EOI;        { end of interrupt }
        end
    else
        begin
            port [EI8259SLAVE]  := port [EI8259SLAVE] and
                                        (not (1 shl (irqNum-8)));
            port [CTL8259SLAVE] := EOI;        { end of interrupt }
        end;

    port [MODEMCTL] := $0b;       { interrompe, rts/dtr }
    port [INTERENB] := $01;       { int. por chegada de dados }

    enviouXOFF := false;
end;

{--------------------------------------------------------}
{              finalizacao das interrupcoes
{--------------------------------------------------------}

procedure finalintr;
begin
    port [INTERENB] := $00;       { nao int. por chegada de dados }

    if irqNum < 8 then
        port [EI8259]  := port [EI8259] or
                                        (1 shl irqNum)
    else
        port [EI8259SLAVE]  := port [EI8259SLAVE] or
                                        (1 shl (irqNum-8));

    setintvec ($0c, salvaseg);
end;

{--------------------------------------------------------}
{                    desliga cts/rts
{--------------------------------------------------------}

procedure desligaModem;
begin
    port [MODEMCTL] := $08;       { tira rts/dtr }
end;

{--------------------------------------------------------}
{                      liga cts/rts
{--------------------------------------------------------}

procedure ligaModem;
begin
    port [MODEMCTL] := $0b;       { interrompe, rts/dtr }
end;

{--------------------------------------------------------}
{           ve se chegou dado na porta serial
{--------------------------------------------------------}

function chegoulink: boolean;
begin
    with buflink do
	chegoulink := ptins <> ptret;
end;

{--------------------------------------------------------}
{         le um dado do buffer circular da serial
{--------------------------------------------------------}

procedure lelink (var c: char);
begin
    repeat until chegoulink;

    with buflink do
	begin
	    c := chr (dado[ptret]);
	    ptret := (ptret + 1) mod TAMBUF;
	end;

    if debug then write (c);
end;

{--------------------------------------------------------}
{                      delay
{--------------------------------------------------------}

procedure delay (x: integer);
var i: integer;
begin
    crt.delay (x * corrDelay);
end;

{--------------------------------------------------------}
{                      calibra delay
{--------------------------------------------------------}

procedure calibraDelay;
var 
    hora1, hora2: longint;
    h1, m1, s1, c1: word;
    h2, m2, s2, c2: word;
begin
    repeat
       gettime (h1,m1,s1,c1);
       hora1 := (((h1*60)+m1)*60+s1)*100+c1;
       crt.delay (1000);
       gettime (h2,m2,s2,c2);
       hora2 := (((h2*60)+m2)*60+s2)*100+c2;
    until hora2 > hora1;  { evita meia noite !}

    corrDelay := 103 div (hora2-hora1);
    if corrDelay < 1 then corrDelay := 1;
end;

{--------------------------------------------------------}
{                   controla o debug
{--------------------------------------------------------}

procedure debugComunic (faz: boolean);
begin
    debug := faz;
end;

{--------------------------------------------------------}
{                   inicializacao geral
{--------------------------------------------------------}

begin
    buflink.ptins := 0;
    buflink.ptret := 0;

    calibraDelay;
    debug := false;
end.
