unit disdos;

interface
uses crt, dos, sintvox, readvox, disvars;

procedure converteAcentos (nomeorig, nomedest: string);
function existeArq (nomearq: string): boolean;
function pegaParam (nome: string): string;
procedure trocaParam (nome: string; valorNovo: string);
procedure chamaDOS;

implementation

{--------------------------------------------------------}
{   converte acentuacao de um arquivo para formato PC
{--------------------------------------------------------}

procedure converteAcentos (nomeorig, nomedest: string);
var 
    arq, arqsai: text;
    texto: string;
begin
    assign (arq, nomeorig);
    reset (arq);
    assign (arqsai, nomedest);
    {$i-} rewrite (arqsai); {$i+}

    while not eof (arq) do
        begin
            readln (arq, texto);
            texto := ansiParaPC (texto);
            writeln (arqsai, texto);
        end;

    close (arq);
    close (arqsai);
end;

{--------------------------------------------------------}
{                  ve se arquivo existe
{--------------------------------------------------------}

function existeArq (nomearq: string): boolean;
var existe: boolean;
    arq: file;
begin
    assign (arq, nomearq);
    {$I-}  reset (arq); {$i+}
    existe := ioresult = 0;
    if existe then close (arq);
    existeArq := existe;
end;

{--------------------------------------------------------}
{          pega um parametro de configuracao
{--------------------------------------------------------}

function pegaParam (nome: string): string;
var
    arq: text;
    nomearq, linha: string;

begin
    pegaParam := '';

    assign (arq, ambDiscaVox);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        exit;

    while not eof (arq) do
        begin
            readln (arq, linha);
            if pos (nome+'=', linha) = 1 then
                pegaParam := copy (linha, length (nome)+2,
                                   length (linha)-length (nome)-1);
        end;

    close (arq);
end;

{--------------------------------------------------------}
{          troca um parametro de configuracao
{--------------------------------------------------------}

procedure trocaParam (nome: string; valorNovo: string);
var
    arq, arqsai: text;
    nomearq, linha: string;
    posic: integer;
    achouParam: boolean;

begin
    assign (arq, ambDiscaVox);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        exit;

    assign (arqsai, '$.$$$');
    {$I-} rewrite (arqsai); {$I+}
    if ioresult <> 0 then
        exit;

    achouParam := false;
    while not eof (arq) do
        begin
            readln (arq, linha);
            posic := pos (nome+'=', linha);
            if posic = 1 then
                begin
                    linha := copy (linha, 1, length (nome)+1) + valorNovo;
                    achouParam := true;
                end;
            writeln (arqsai, linha);
        end;

    if not achouParam then
        writeln (arqsai, nome, '=', valorNovo);

    close (arq);
    close (arqsai);

    reset (arqsai);
    rewrite (arq);
    while not eof (arqsai) do
        begin
            readln (arqsai, linha);
            writeln (arq, linha);
        end;

    close (arqsai);
    close (arq);

    erase (arqsai);
end;

{--------------------------------------------------------}
{                  opcao de chamada do DOS
{--------------------------------------------------------}

procedure chamaDOS;
var nomeCom, comando: string;
label inicio;
begin

inicio:
    nomeCom := getenv ('COMSPEC');
    if nomecom = '' then
        nomeCom := 'C:\COMMAND.COM';

    clrscr;

    sintBip; sintBip; sintBip;

    SwapVectors;
    Exec(nomecom, '');
    SwapVectors;

    sintBip; sintBip;
end;

end.