{--------------------------------------------------------}
{
{     Rotinas de fala do Discavox
{
{     Autor: Jos Antonio Borges
{
{     Em abril/95
{
{--------------------------------------------------------}

unit disfala;
interface

uses crt, dos, sintvox, traduvox, intervox, readvox, playvox;

type str8 = string[8];

var falando: integer;
    falaTempInibida: boolean;

procedure falaTexto (s: string);
procedure xwrite (codFala: str8; cadeia: string);
procedure xwriteln (codFala: str8; cadeia: string);
procedure xreadln (var s: string);
function xreadInt: longint;
procedure acumulaPalavra (c: char);
procedure mensagem (m: string; escreve: boolean);
function letecla (npula: integer): char;

implementation

var
    palavra, fonemas: string;
    ultLetraFalada: char;
    nvezesFalada: integer;
    emIngles: boolean;
    rapida, condensada: boolean;

{--------------------------------------------------------}
{  fala um texto (separado para permitir outras linguas)
{--------------------------------------------------------}

procedure falaTexto (s: string);
begin
    sintetiza (s);
end;

{--------------------------------------------------------}
{                   escreve e fala cadeia
{--------------------------------------------------------}

procedure xwrite (codFala: str8; cadeia: string);
begin
    write (cadeia);

    pegaModoFala (rapida, condensada);
    falaRapida (false);
    falaCondensada (false);

    sintSom (codFala);
    falaRapida (rapida);
    falaCondensada (condensada);
end;

{--------------------------------------------------------}

procedure xwriteln (codFala: str8; cadeia: string);
begin
    writeln (cadeia);

    pegaModoFala (rapida, condensada);
    falaRapida (false);
    falaCondensada (false);

    sintSom (codFala);
    falaRapida (rapida);
    falaCondensada (condensada);
end;

{--------------------------------------------------------}
{                le teclado com eco
{--------------------------------------------------------}

procedure xreadln (var s: string);
var i: integer;
    c, c2: char;
begin
    s := '';
    repeat
        c := readkey;
        case c of
            #$1b:
                begin
                    for i := 1 to length (s) do
                        write (#$08, ' ', #$08);
                    s := '';
                    textBackground (RED);
                    sintSom ('DIDESIS');
                    textBackground (BLACK);
                    exit;
                end;

            #0:  c := readkey;

            #08:
                if length (s) > 0 then
                    begin
                        sintSom ('DIDEL');
                        sintCarac (s[length(s)]);
                        write (#$08, ' ', #$08);

                        s := copy (s, 1, length(s)-1);
                    end;

            #32..#255:
                begin
                    s := s + c;
                    if falando <> 0 then
                        sintCarac (c);
                    write (c);
                end;
        end;

    until c = #$0d;
    writeln;
end;

{--------------------------------------------------------}
{                 le um valor numerico
{--------------------------------------------------------}

function xreadInt: longint;
var valor: longint;
    s: string;
    erro: integer;
begin
    xreadln (s);
    if s = '' then
        valor := 0
    else
        begin
            val (s, valor, erro);
            if erro <> 0 then
                valor := 0;
        end;

    xreadInt := valor;
end;

{--------------------------------------------------------}
{                   ve se tem vogais
{--------------------------------------------------------}

function temVogais (palavra: string): boolean;
const
    consoantes: set of char = 
        ['b'..'d', 'f'..'h', 'j'..'n', 'p'..'t', 'v'..'z',
         'B'..'D', 'F'..'H', 'J'..'N', 'P'..'T', 'V'..'Z'];
var i: integer;
begin
    for i := 1 to length (palavra) do
        if not (palavra[i] in consoantes) then
             begin
                 temVogais := true;
                 exit;
             end;
    temVogais := false;
end;

{--------------------------------------------------------}
{           remove caracteres estranhos da fala
{--------------------------------------------------------}

procedure removeLixo (var s: string);
var bipa: boolean;
    i: integer;
begin
    bipa := false;
    for i := 1 to length (s) do
        if s[i] in [#$00..#$1f,
                    #$8c, #$91, #$92, #$9b..#$bf] then
            begin
                s[i] := ' ';
                bipa := true;
            end;

    if bipa then
        sintClek;
end;

{--------------------------------------------------------}
{                   acumula palavra
{--------------------------------------------------------}

procedure acumulaPalavra (c: char);
const ENTER = #$0d;
label fim;

begin
    if keypressed and (palavra = '') then exit;

    if (c = ultLetraFalada) and (not (c in ['0'..'9'])) then
        begin
            if nvezesFalada > 10 then goto fim;
            nvezesFalada := nvezesFalada + 1;
            if (nvezesFalada > 2) and (c <> ' ') then
                c := ENTER;
        end
    else
        begin
            ultLetraFalada := c;
            nvezesFalada := 0;
        end;

    if falando = 0 then goto fim;
    if falando = 2 then
         begin
             if c = #$0d then falando := 1;
             goto fim;
         end;

    if c = #$1b then
        begin
            falaTempInibida := true;
            exit;
        end;

    if falaTempInibida then
         begin
             if (c in ['A'..'Z', 'a'..'z']) then
                falaTempInibida := false;
            exit;
         end;

    if c = #$08 then
        delete (palavra, length(palavra), 1)
    else
    if not ((c in ['a'..'z']) or (c in ['A'..'Z']) or (c in ['0'..'9']) or
            (c >= #128) ) then
        begin
            if c > #$20 then
                palavra := palavra + c;

            if temVogais (palavra) then
                 begin
                     removeLixo (palavra);
                     falaTexto (palavra);
                 end
            else
                sintSoletra (palavra);

            palavra := '';
        end
    else
        palavra := palavra + c;

fim:
    if c = ENTER then sintclek;
end;

{--------------------------------------------------------}
{                   da' uma mensagem
{--------------------------------------------------------}

procedure mensagem (m: string; escreve: boolean);
var i: integer;
begin
    if escreve then
        begin
            if wherex <> 1 then writeln;
            textBackground (RED);
            write (m);
            textBackground (BLACK);
            clreol;
            writeln;
        end;
    for i := 1 to length (m) do
        acumulaPalavra (m[i]);
    acumulaPalavra (' ');
end;

{--------------------------------------------------------}
{              le uma tecla, pulando linhas
{--------------------------------------------------------}

function letecla (npula: integer): char;
var 
    i: integer;
    c: char;
begin
    c := readkey;
    write(c);
    sintcarac (c);
    for i := 1 to npula do writeln;
    letecla := c;
end;

begin
    palavra := '';
    falando := 1;
    falaTempInibida := false;
    ultLetraFalada := #$0;
    nvezesFalada := 0;
    emIngles := false;
end.
