{--------------------------------------------------------}
{            Discavox - Folheador de cartas
{--------------------------------------------------------}

unit disFolhe;

interface

uses
    crt, dos, playvox, readvox, sintvox, traduvox, intervox, videoiso,
    disvars, disutil, disprot,
    disfala, disdos;

procedure folheiaCartas;

implementation

type
    regCarta = record
        nomArqCarta: string[12];
        datahora: longint;
    end;

var
    numRegs: integer;
    regLido: array [1..200] of regCarta;
    arq: file of regCarta;
    cartaRec: text;

{--------------------------------------------------------}
{              monta lista de cartas
{--------------------------------------------------------}

procedure montaListaDeCartas;
var
    DirInfo: SearchRec;
    i, j: integer;
    temp: regCarta;

begin
    numRegs := 0;
    xwriteln ('DIMONLIS', 'Ordenando a lista de cartas por hora de chegada...');

    FindFirst ('*.CAR', Archive, DirInfo);
    while DosError = 0 do
            begin
                numRegs := numregs + 1;
                with regLido [numRegs] do
                    begin
                        nomArqCarta := dirInfo.name;
                        dataHora := dirInfo.Time;
                        FindNext (DirInfo);
                    end;
            end;

    for i := 1 to numRegs-1 do
        for j := i+1 to numRegs do
            begin
                if regLido[i].dataHora > regLido[j].dataHora then
                    begin
                        temp := reglido[i];
                        reglido[i] := reglido[j];
                        reglido[j] := temp;
                    end;
            end;


    if numRegs <> 0 then
        xwriteln ('DIOKORD', 'Ok, cartas ordenadas.');
end;


{--------------------------------------------------------}
{               busca uma cadeia na carta
{--------------------------------------------------------}

function buscaNaCarta (ncar: integer; texto: string): string;
var s: string;
    i: integer;
label pula, achou;
begin
    buscaNaCarta := '';

    assign (cartaRec, regLido [ncar].nomArqCarta);
    {$I-}  reset (cartaRec);  {$I+}
    if ioresult <> 0 then
        begin
            xwriteln ('DICARSU', 'Erro no disco: carta sumiu');
            exit;
        end;

    while not eof (cartaRec) do
        begin
            readln (cartaRec, s);
            for i := 1 to length (texto) do
                if upcase (texto[i]) <> upcase (s[i]) then
                    goto pula;

            buscaNaCarta := copy (s, length(texto) + 1, length (s) - length(texto));
            goto achou;
pula:;
        end;

achou:

    close (cartaRec);
end;


{--------------------------------------------------------}
{            isola o nome do autor e a data              }
{--------------------------------------------------------}

procedure pegaAutorData (texto: string; var autor, data: string);
var i, npal: integer;
begin
    while (texto <> ' ') and (texto [1] = ' ')  do
        delete (texto, 1, 1);

    if texto = '' then
        begin
            autor := '';
            data := '';
            exit;
        end;

    i := length (texto);

    for npal := 1 to 5 do
        begin
            while (i > 0) and (texto [i] <> ' ') do
                i := i - 1;
            while (i > 0) and (texto [i] = ' ') do
                i := i - 1;
        end;

    autor := copy (texto, 1, i);
    data  := copy (texto, i+2, length(texto) - i+1);
end;

{--------------------------------------------------------}
{                    le o autor da carta
{--------------------------------------------------------}

procedure leAutorCarta (ncar, comoLe: integer);
var texto, autor, data: string;
begin
    texto := buscaNaCarta (ncar, 'From:');
    if texto = '' then
        begin
            texto := buscaNaCarta (ncar, 'From');
            pegaAutorData (texto, autor, data);
        end
    else
        begin
            autor := texto;
            while (autor <> '') and (autor [1] <> '(') do
                delete (autor, 1, 1);
            delete (autor, 1, 1);

            while autor [length(autor)] = ' ' do
                delete (autor, length(autor), 1);
            if autor [length (autor)] = ')' then
                delete (autor, length(autor), 1);

            if autor = '' then
                autor := texto;
        end;

    writeln (autor);

    case comoLe of
        0: sintetiza (autor);
        1: sintSoletra (autor);
    end;
end;

{--------------------------------------------------------}
{                  ajuda no folheamento
{--------------------------------------------------------}

procedure ajudaFolheia;
begin
    textBackground(BLUE);

    if not keypressed then
        xwriteln ('DIAJUFL1', 'Folheie as cartas recebidas com as setas, depois tecle:');
    if not keypressed then
        xwriteln ('DIAJUFL2', 'L - para ler carta');
    if not keypressed then
        xwriteln ('DIAJUFL3', 'I - para obter informaes sobre a carta');
    if not keypressed then
        xwriteln ('DIAJUFL4', 'A - apagar a carta');
    if not keypressed then
        xwriteln ('DIAJUFL5', 'E - editar resposta');
    if not keypressed then
        xwriteln ('DIAJUFL6', 'C - copiar a carta para um arquivo');
    if not keypressed then
        xwriteln ('DIAJUFL7', 'ESC terminar folheamento');

    textBackground(BLACK);
    writeln;
end;

{--------------------------------------------------------}
{               informacoes sobre a carta
{--------------------------------------------------------}

procedure infoCarta (ncar: integer);
var s, autor, data: string;
    dia, mes, ano, hora, min: string[4];
    sem: string[10];
    nomarq: string;
    dt: dateTime;

begin
    nomarq := regLido [ncar].nomArqCarta;

    xwrite ('DIARQ', 'Arquivo ');
    writeln (nomarq);
    sintetiza (nomarq);

    xwrite ('DIASSU', 'Assunto: ');
    s := buscaNaCarta (ncar, 'Subject');
    writeln (s);
    if s [1] = ':' then delete (s, 1, 1);
    sintetiza (s);

    xwrite ('DIAUTOR', 'Enviada por ');
    s := buscaNaCarta (ncar, 'From:');
    if s [1] = ' ' then delete (s, 1, 1);
    writeln (s);
    sintetiza (s);

    data := buscaNaCarta (ncar, 'Date:');
    while (data <> '') and (data [1] = ' ') do delete (data, 1, 1);
    xwrite ('DIDATENV', 'Data de envio: ');

    sem := '';
    if not (data[1] in ['0'..'9']) then
        begin
           sem := copy (data, 1, 3);
           delete (data, 1, 5);
        end;

    dia := data[1];
    delete (data, 1, 1);
    if data [1] <> ' ' then
        begin
            dia := dia + data[1];
            delete (data, 1, 1);
        end;
    delete (data, 1, 1);

    mes := copy (data, 1, 3);
    delete (data, 1, 4);
    ano := '';
    data := data + ' ';
    while data[1] <> ' ' do
        begin
            ano := ano + data [1];
            delete (data, 1, 1);
        end;

    if sem = 'Sun' then sem := 'Domingo' else
    if sem = 'Mon' then sem := 'Segunda' else
    if sem = 'Tue' then sem := 'Terca'   else
    if sem = 'Wed' then sem := 'Quarta'  else
    if sem = 'Thu' then sem := 'Quinta'  else
    if sem = 'Fri' then sem := 'Sexta'   else
    if sem = 'Sat' then sem := 'Sabado';

    if mes = 'Jan' then mes := '1'  else
    if mes = 'Feb' then mes := '2'  else
    if mes = 'Mar' then mes := '3'  else
    if mes = 'Apr' then mes := '4'  else
    if mes = 'May' then mes := '5'  else
    if mes = 'Jun' then mes := '6'  else
    if mes = 'Jul' then mes := '7'  else
    if mes = 'Aug' then mes := '8'  else
    if mes = 'Sep' then mes := '9'  else
    if mes = 'Oct' then mes := '10' else
    if mes = 'Nov' then mes := '11' else
    if mes = 'Dec' then mes := '12';

    s := sem + ' ' + dia+ '/' + mes + '/' + ano;
    writeln (s);
    sintetiza (s);

    xwrite ('DIDATCHE', 'Data de chegada: ');
    unpackTime (reglido [ncar].datahora, dt);
    str (dt.day, dia);    str (dt.month, mes);  str (dt.year, ano);
    s := dia + '/' + mes + '/' + ano;

    writeln (s);
    sintetiza (s);
end;

{--------------------------------------------------------}
{                  chama um programa
{--------------------------------------------------------}

function chamaProg (nome, nomearq: string): boolean;
var nomeCom, nomeProg: string;
begin
    chamaProg := true;

    nomeCom := getenv ('COMSPEC');
    if nomecom = '' then
        nomeCom := 'C:\COMMAND.COM';

    nomeProg := sintAmbiente ('PGMDOSVOX');
    if nomeProg = '' then
         nomeProg := 'C:\DOSVOX\' + nome
    else
        begin
            if nomeProg [length(nomeProg)] <> '\' then
                nomeProg := nomeProg + '\';
            nomeProg := nomeProg + nome;
        end;

    if nomearq <> '' then
        nomeProg := nomeProg + ' ' + nomearq;

    tradFim;

    SwapVectors;
    Exec(nomecom, '/C ' + nomeProg);
    SwapVectors;

    if tradinic <> 0 then;

    if DosError <> 0 then
        begin
            xwriteln ('DIERRPRG', 'Erro ao chamar o programa');
            chamaProg := false;
        end;

    xwriteln ('DIVOLTA', 'Voltando ao Discavox...');
end;

{--------------------------------------------------------}
{                le a carta com o Levox
{--------------------------------------------------------}


procedure leCarta (ncar: integer);
begin
    if chamaProg ('LEVOX.EXE', regLido [ncar].nomarqCarta) then;
end;

{--------------------------------------------------------}
{                    apaga a carta
{--------------------------------------------------------}

procedure apagaCarta (var ncar: integer);
var s: string;
    c: char;
    i: integer;
begin
    xwriteln ('DICNFAPA', 'Confirma o apagamento desta carta com assunto');
    s := buscaNaCarta (ncar, 'Subject');
    if s[1] = ':' then delete (s, 1, 1);
    while (s <> '') and (s[1] = ':') do
        delete (s, 1, 1);

    writeln (s);
    sintetiza (s);
    xwrite ('DISIMNAO', '(S/N) ? ');
    c := upcase (letecla (1));

    if c = 'S' then
        begin
            assign (arq, regLido [ncar].nomarqCarta);
            {$I-}  erase (arq);  {$I+}
            if ioresult <> 0 then
                xwriteln ('DIERRDSK', 'Erro de escrita no disco')
            else
                begin
                    xwriteln ('DIOKAPA', 'Ok, carta apagada');
                    numRegs := numRegs - 1;
                    for i := ncar to numRegs do
                        regLido [i] := regLido [i+1];
                    ncar := ncar - 1;
                end;
        end;

end;

{--------------------------------------------------------}
{                 edita a resposta `a carta
{--------------------------------------------------------}

procedure editaResposta (ncar: integer);
var
    nomeDest: string;
    nomeArq: string;
    c: char;
    arqin, arqout: text;
    s, assunto: string;

label fim;

begin
    nomeDest := buscaNaCarta (ncar, 'From:');

    while (nomeDest <> '') and (nomeDest [1] = ' ') do
        delete (nomeDest, 1, 1);

    xwrite ('DIPOSMAN', 'Posso mandar para ');
    write (nomeDest);
    sintetiza (nomeDest);
    xwrite ('DISIMNAO', ' (s/n) ? ');
    c := upcase (letecla (1));

    if c = 'N' then
        begin
            xwriteln ('DIENDER', 'Qual o endereo eletrnico do destinatrio? ');
            xreadln (nomeDest);
            if nomeDest = '' then
                exit;
        end;

    nomeArq := regLido [ncar].nomarqCarta;
    nomeArq := copy (nomearq, 1, length (nomearq)-3) + 'RSP';

    assign (arqin, regLido [ncar].nomarqCarta);
    assign (arqout, nomearq);

    xwrite ('DICOPORG', 'Jogo no editor o texto original (s/n) ? ');
    c := upcase (letecla (1));

    if c = 'S' then
        begin
            {$I-} reset (arqin); {$I+}
            if ioresult <> 0 then
                begin
                    xwriteln ('DIERRLEI', 'Erro de leitura do arquivo');
                    exit;
                end;

            {$I-} rewrite (arqout);  {$i+}
            if ioresult <> 0 then
                begin
                    xwriteln ('DIERRESC', 'Erro de escrita no disco');
                    {$I-} close (arqin); {$I+}
                    if ioresult <> 0 then;
                    exit;
                end;

            while not eof (arqin) do
                begin
                    {$I-}  readln (arqin, s);  {$I+}
                    if ioresult <> 0 then
                        begin
                            xwriteln ('DIERRLEI', 'Erro de leitura do arquivo');
                            goto fim;
                        end;
                    {$I-} writeln (arqout, s);  {$I+}
                    if ioresult <> 0 then
                        begin
                            xwriteln ('DIERRDSK', 'Erro de escrita no disco');
                            goto fim;
                        end;
                end;

fim:
            {$I-} close (arqin); {$I+}
            if ioresult <> 0 then;
            {$I-} close (arqout); {$I+}
            if ioresult <> 0 then;
        end;


    if not chamaProg ('EDIVOX.EXE', nomeArq) then exit;

    xwrite ('DICNFENV', 'Confirma envio (s/n) ? ');
    c := upcase (letecla (1));
    if c <> 'N' then
        begin
            xwriteln ('DIASSUN', 'Qual o assunto da carta ? ');
            xreadln (assunto);

            nCartas := nCartas + 1;
            arqCarta [nCartas] := nomeArq;
            destCarta [nCartas] := nomeDest;
            assuntoCarta [nCartas] := assunto;

            xwriteln ('DIENVIO', 'Carta preparada para envio');
        end
    else
        begin
            {$I-}  erase (arqout);
            xwriteln ('DIOKAPA', 'Ok, carta apagada');
        end;
end;

{--------------------------------------------------------}
{                 joga a carta num arquivo
{--------------------------------------------------------}

procedure copiarCartaParaArquivo (ncar: integer);
const
    BUFSIZE = 1024;

var nomearq: string;
    arqin, arqout: file;
    buf: array [0..BUFSIZE-1] of byte;
    erro, nbytes: integer;
    tam: longint;

label fim;

begin
    xwriteln ('DIINFDST', 'Informe o nome completo do arquivo destino:');
    xreadln (nomearq);
    if nomearq = '' then
        exit;

    assign (arqin, regLido [ncar].nomarqCarta);
    assign (arqout, nomearq);

    {$I-} reset (arqin, 1); {$I+}
    if ioresult <> 0 then exit;
    {$I-} rewrite (arqout, 1); {$I+}
    if ioresult <> 0 then exit;

    tam := filesize (arqin);
    while tam > 0 do
        begin
            nbytes := BUFSIZE;
            if tam < BUFSIZE then nbytes := tam;

            {$I-} blockread  (arqin,  buf, nbytes); {$I+}
            if ioresult <> 0 then
                begin
                    xwriteln ('DIERRLEI', 'Erro de leitura do arquivo');
                    goto fim;
                end;

            {$I-} blockwrite (arqout, buf, nbytes); {$I+}
            erro := ioresult;
            if erro = 101 then
                begin
                    xwriteln ('DIERRESC', 'Erro de escrita no disco');
                    goto fim;
                end;

            tam := tam - BUFSIZE;
        end;

fim:

    {$I-} close (arqin);  {$I+}
    if ioresult <> 0 then;
    {$I-} close (arqout); {$I+}
    if ioresult <> 0 then;
end;

{--------------------------------------------------------}
{               folheia e responde cartas
{--------------------------------------------------------}

procedure folheiaCartas;
var 
    c: char;
    ncar: integer;

    procedure ultimoArquivo;
    begin
        textBackGround (MAGENTA);
        xwrite ('DIULTREG', 'Ultimo arquivo...');
        textBackGround (BLACK);
        writeln;
    end;

begin
    montaListaDeCartas;

    if numRegs = 0 then
        begin
            xwriteln ('DISEMCAR', 'No tem carta nenhuma neste diretrio');
            exit;
        end;

    textBackGround (MAGENTA);
    xwrite ('DIPODFOL', 'Folheando: use as setas, depois tecle sua opo');
    textBackground (BLACK);
    writeln;
    ncar := 0;

    repeat
        c := readkey;
        if c = #0 then
            begin
                c := readkey;
                case c of
                    BAIX:   begin
                                ncar := ncar + 1;
                                if ncar > numRegs then
                                    begin
                                        ncar := numRegs + 1;
                                        ultimoArquivo;
                                    end
                                else
                                    leAutorCarta (ncar, 0);
                            end;

                    CIMA:   begin
                                ncar := ncar - 1;
                                if ncar < 1 then
                                    begin
                                        ncar := 0;
                                        ultimoArquivo;
                                    end
                                else
                                    leAutorCarta (ncar, 0);
                            end;

                    ESQ:   if (ncar > 0) and (ncar <= numRegs) then
                                leAutorCarta (ncar, 0);  { todo }

                    DIR:   if (ncar > 0) and (ncar <= numRegs) then
                                leAutorCarta (ncar, 1);  { soletrando }

                    PGUP:   begin
                                ncar := ncar - 5;
                                if ncar < 1 then
                                    begin
                                        ncar := 0;
                                        ultimoArquivo;
                                    end;
                            end;

                    PGDN:   begin
                                ncar := ncar + 5;
                                if ncar > numRegs then
                                    begin
                                        ncar := numRegs + 1;
                                        ultimoArquivo;
                                    end;
                            end;

                    F1: ajudaFolheia;
                end;
            end
        else
            begin
                if (ncar > 0) and (ncar <= numRegs) then
                    case upcase(c) of
                        'I': infoCarta (ncar);
                        'L': leCarta (ncar);
                        'A': begin
                                 apagaCarta (ncar);
                                 if numRegs < 1 then
                                     begin
                                         xwriteln ('DISEMCAR',
                                      'No tem carta nenhuma neste diretrio');
                                         exit;
                                     end;
                             end;
                        'E': editaResposta (ncar);
                        'C': copiarCartaParaArquivo (ncar);
                    end
                else
                    ajudaFolheia;

                if c <> ESC then
                    begin
                        textBackGround (MAGENTA);
                        xwrite ('DICNTFOL', 'Continue folheando ou tecle ESC');
                        textBackGround (BLACK);
                        writeln;
                    end;
            end;

    until c = #$1b;
end;

begin
end.
