{--------------------------------------------------------}
{      Discavox - Modulo de comunicacao com a rende
{--------------------------------------------------------}

unit disRende;

interface

uses
    crt, dos, playvox, readvox, sintvox, traduvox, intervox, videoiso,
    disvars, disutil, disprot,
    disfala, disdos,
    disansi,
    disfolhe,
    comunic, xmodem,
    horavox, videovox;

procedure falaComRende;

implementation

{--------------------------------------------------------}
{                  mini-emulador de terminal
{--------------------------------------------------------}

procedure miniTerm;
var
    c: char;
    emulando: boolean;
    nomeComputador: string;
    i: integer;

label fim;

begin
    xwriteln ('DITELCOM', 'Informe o telefone do computador parceiro: ');
    xreadln (nomeComputador);
    if nomeComputador = '' then goto fim;

    for i := 1 to length (nomeComputador) do
        nomeComputador[i] := upcase (nomeComputador[i]);
    if nomeComputador[1] in ['A'..'Z'] then
         begin
             nomeComputador := pegaParam (nomeComputador);
             if nomeComputador = '' then nomeComputador := ' ';
         end;

    writeln;
    textBackground (BLUE);
    xwrite ('DIINSTRT', 'Tecle F4 para fala, F10 para sair do mini terminal');
    textBackGround (BLACK);
    writeln;

    if discaTelefone (nomeComputador) then;

    falando := 1;
    modoLynx := false;
    c := #0;
    emulando := true;
    inicAnsi;

    while emulando do
        begin
            if keypressed then
                begin
                    c := readkey;
                    if c <> #$0 then
                        esclink (c)
                    else
                        begin
                        c := readkey;
                            case c of
                                F4 : begin
                                     if falando = 0 then falando := 1
                                                    else falando := 0;
                                     if falando = 1 then sintSom ('DIFALLIG')
                                                    else sintSom ('DIFALDLG');
                                     end;

                                F9:  leitorDeTela;
                                F10: goto fim;
                            end;
                        end;
                end;

            if chegouLink then
                begin
                    lelink (c);
                    if c = #$0c then 
                        clrscr
                    else
                        ansiwrite (c);
                end;
        end;

fim:
    falando := 1;
    xwriteln ('DIFIMTRM', 'Mini terminal desativado');
end;

{--------------------------------------------------------}
{               manda pedidos para Rende
{--------------------------------------------------------}

procedure mandaParaRende;
var resp: char;
    salva: integer;
    salvaCor: word;
    numTel, conta, senha: string;
    ligacaoTelefonica: boolean;
    i: integer;
    c: char;

label confirma, liga, cancela, ligaDeNovo, direto, ramalDeNovo;

begin
    writeln;
    InicIntr (porta, irq, velocTerm, nbitsTerm, stopsTerm, paridTerm);

confirma:

{----------- escolhe ramal e opcao de mini-terminal ------------}

    if not empacotaPedidos then
        exit;

ramalDeNovo:
    textBackground (RED);
    xwrite ('DIRAMAL', 'Tecle o ramal (de 1 a 9), M para login manual ou ESC para desistir: ');
    textBackground (BLACK);

    resp := letecla (1);
    if resp = ESC then
        begin
            xwriteln ('DIDESIS', 'Desistiu...');
            goto cancela;
        end;

    if upcase(resp) = 'M' then
        begin
            miniTerm;

            writeln;
            textBackground (RED);
            xwrite ('DIISSO', 'Tecle ENTER para iniciar transmisso, ESC para cancelar');
            textBackground (BLACK);
            resp := letecla (1);
            if resp = ESC then
                begin
                    desligaTelefone (true);
                    xwriteln ('DICONDES', 'Conexo desativada.');
                    goto confirma;
                end;

            goto direto;
        end;

    if resp = #$0d then
         resp := '1'
    else
        if not (resp in ['1'..'9']) then
            goto ramalDeNovo;

{---------- le conta e senha -----------}

    xwrite ('DICONTA', 'Qual a sua conta ? ');
    xreadln (conta);
    if conta = '' then goto confirma;

    xwrite ('DISENHA', 'Qual a sua senha ? ');
    salvaCor := textAttr;
    textcolor (blue);
    textBackground (blue);
    salva := falando;
    falando := 0;
    xreadln (senha);
    textAttr := salvacor;
    clreol;
    falando := salva;

    if senha = '' then goto confirma;

{------------- realiza discagem de conexao -------------}

    textBackground (RED);
    xwriteln ('DIDISCAR', 'Ok, agora espere um pouco que eu vou discar.');
    textBackground (BLACK);
    clreol;

liga:
    numTel := pegaParam ('RENDE'+resp);
    ligacaoTelefonica := numTel [1] in ['0'..'9'];

    if ligacaoTelefonica and (not discaTelefone (numTel)) then
        begin
            while keypressed do resp := readkey;

            if ligacaoTelefonica then
                desligaTelefone (false);
            xwriteln ('DINAOLIG', 'No consegui me conectar.');

            while keypressed do resp := readkey;
            textBackground (RED);
            xwrite   ('DITENTA', 'Tecle outro ramal ou ESC para cancelar...');
            textBackground (BLACK);
            clreol;

            for i := 1 to 20 do
                begin
                    if keypressed then
                        begin
                            c := readkey;
                            sintCarac (c);
                            if c = #$1b then goto confirma;
                            if c in ['1'..'9'] then resp := c;
                            goto ligaDeNovo;
                        end;
                    delay (500);
                end;
ligaDeNovo:
            xwriteln ('DIDENOVO', 'Tentarei de novo...');
            goto liga;
        end;

    if not executaConexao (ord(resp) - ord ('0'), conta, senha) then
        begin
            writeln;
            xwriteln ('DIERCONT', 'O computador no aceitou sua conta.');
            if ligacaoTelefonica then
                desligaTelefone (false);
            goto ramalDeNovo;
        end;

{------------ dialogo com o programa parceiro ------------}

direto:
    if not ativaProgRende then
        begin
            xwriteln ('DINCOPRG', 'Conectou com o computador, mas no com o programa parceiro');
            goto confirma;
        end;

    if not enviaPedidos then 
        begin
            executaDesconexao;
            if ligacaoTelefonica then
                desligaTelefone (false);
            goto confirma;
        end;

    if recebeRespostas then
        begin
            executaDesconexao;
            if ligacaoTelefonica then
                desligaTelefone (false);
            desempacotaResposta;

            textBackground (RED);
            xwriteln ('DIOBRIG', 'A Rende agradece a voc por sua companhia');
            textBackground (BLACK);
            clreol;
            writeln;
            exit;
        end
    else
        goto confirma;

cancela:
     xwriteln ('DIDESCUL', 'Sinto muito amigo...');
     if ligacaoTelefonica then
         desligaTelefone (true);
     finalIntr;
end;

{--------------------------------------------------------}
{                   fala com a Rende
{--------------------------------------------------------}

procedure falaComRende;
var
    rendando: boolean;
    c: char;

{--------------------------------------------------------}

     procedure recebeTexto;
     var
         c, opcao: char;
         codinome: string;
     begin
         textBackground (MAGENTA);
         xwrite   ('DICODIN', 'Qual o codinome do texto ?');
         textBackground (BLACK);
         xreadln (codinome);
         if codinome <> '' then
             begin
                 ntextos := ntextos + 1;
                 texto[ntextos] := codinome;
             end
         else
             xwriteln ('DIPEDIR', 'Para pedir a lista de codinomes, selecione I');
     end;

{--------------------------------------------------------}

     procedure enviaCarta;
     var nomeArq, nomeDest, assunto: string;
     begin
         if nCartas >= 20 then
             begin
                 xwriteln ('DI20CART', 'S consigo mandar 20 cartas por vez.');
                 exit;
             end;

         xwriteln ('DIENDER', 'Qual o endereo eletrnico do destinatrio ? ');
         xreadln (nomeDest);
         if nomeDest = '' then exit;

         xwriteln ('DINOMCAR', 'Qual o nome do arquivo da carta ? ');
         xreadln (nomeArq);
         if not existeArq (nomeArq) then
             begin
                 xwriteln ('DIARQNAO', 'Esse arquivo no existe.');
                 exit;
             end;

         xwriteln ('DIASSUN', 'Qual o assunto da carta ? ');
         xreadln (assunto);

         nCartas := nCartas + 1;
         arqCarta [nCartas] := nomeArq;
         destCarta [nCartas] := nomeDest;
         assuntoCarta [nCartas] := assunto;

         xwriteln ('DIENVIO', 'Carta preparada para envio');
     end;

{--------------------------------------------------------}

     procedure recebeCartas;
     begin
         pediuCartas := true;
         xwriteln ('DIPEGO', 'Certo.  Quando completar a ligao eu pego as cartas para voc.');
     end;

{--------------------------------------------------------}

     procedure recebePrograma;
     var nome: string;
     begin
         if nProgs >= 5 then
             begin
                 xwriteln ('DI5PROG', 'S consigo atender a 5 programas por vez. Sinto muito.');
                 exit;
             end;

         xwriteln ('DIPROREC', 'Informe o nome do programa a receber:');
         xreadln (nome);
         if nome = '' then exit;

         nProgs := nProgs+ 1;
         nomeProg [nProgs] := nome;

         xwriteln ('DICOMPL', 'Ok. Quando completar a ligao eu pego para voc.');
     end;

{--------------------------------------------------------}

begin
    writeln;
    xwriteln ('DIRENDE', 'Servico RENDE - Projeto Intervox - NCE/UFRJ');
    writeln ('        com o apoio da Rede Nacional de Pesquisa do MCT');
    writeln ('        e do projeto RENDE/REINTEGRA da CECAE/USP');

    nCartas := 0;
    nProgs := 0;
    nTextos := 0;
    pediuCartas := false;

    rendando := true;
    while rendando do
        begin
            writeln;
            while keypressed do c := readkey;

            textBackground (RED);
            xwrite ('DIQUALOP', 'Rende - Qual opo ? ');
            textBackground (BLACK);
            clreol;

            c := upcase (letecla (1));
            case c of
                'I': begin
                         ntextos := ntextos + 1;
                         texto[ntextos] := 'indice.txt';
                     end;
                'T': recebeTexto;
                'E': enviaCarta;
                'F': folheiaCartas;
                'R': recebeCartas;
                'P': recebePrograma;
                ESC: rendando := false;
            else
                while keypressed do c := readkey;

                xwriteln ('DIAJUDR1', 'As opes da Rende so:');

                if not keypressed then
                    xwriteln ('DIAJUDR2', 'e - enviar uma carta');
                if not keypressed then
                    xwriteln ('DIAJUDR4', 'r - receber suas cartas');
                if not keypressed then
                    xwriteln ('DIAJUDR5', 'f - folhear cartas j recebidas');
                if not keypressed then
                    xwriteln ('DIAJUDR6', 'i - receber o indice dos textos');
                if not keypressed then
                    xwriteln ('DIAJUDR7', 't - receber um texto');
                if not keypressed then
                    xwriteln ('DIAJUDR8', 'p - receber programa distribudo pela RENDE');
                if not keypressed then
                    xwriteln ('DIAJUDR9', 'ESC - iniciar discagem de conexo');

                while keypressed do c := readkey;
            end;
        end;

    if (nCartas <> 0) or (pediuCartas)  or
       (nProgs <> 0)  or (ntextos <> 0) then
            mandaParaRende;
end;

end.