{--------------------------------------------------------}
{        Discavox - rotinas utilitarias
{--------------------------------------------------------}

unit disUtil;

interface
uses crt, disvars, comunic, disfala, sintvox, playvox;

procedure saiLink (s: string; espera: integer);
function discaTelefone (numeroTel: string): boolean;
procedure desligaTelefone (falando: boolean);


implementation

{--------------------------------------------------------}
{                   sai string no link
{--------------------------------------------------------}

procedure saiLink (s: string; espera: integer);
var i: integer;
    c: char;
begin
    for i := 1 to length (s) do
        begin
            esclink (s[i]);
            delay (50);
        end;

    for i := 1 to espera do
        begin
            while chegouLink do
                begin
                    lelink(c);
                    write (c);
                    if c = #$0a then
                        sintclek;
                end;
            delay (1);
        end;
end;

{--------------------------------------------------------}
{                     disca telefone
{--------------------------------------------------------}

function discaTelefone (numeroTel: string): boolean;
var toneOuPulse: char;
    c: char;
    s: string;
label fim;
begin
    discaTelefone := false;

    toneOuPulse := 'T';
    if pulse then toneOuPulse := 'P';
    saiLink ('ATH1'+ENTER, 500);
    saiLink ('ATD'+ toneOuPulse + numeroTel+ENTER, 1000);

    repeat
        s := '';
        repeat
            if chegoulink then
                begin
                    lelink (c);
                    write (c);
                    if c <> #$0a then
                        s := s + c;
                    acumulaPalavra (c);
                end;
        until (c = ENTER) or keypressed;

        if (copy (s, 1, 4)  = 'BUSY') or
           (copy (s, 1, 10) = 'NO CARRIER') or
           keypressed then
               goto fim;

    until copy (s, 1, 7) = 'CONNECT';

    discaTelefone := true;

fim:
end;

{--------------------------------------------------------}
{                   desliga telefone
{--------------------------------------------------------}

procedure desligaTelefone (falando: boolean);
begin
    if falando then
        xwriteln ('DIDESLIG', '...Desligando...');
    saiLink ('+++', 3000);
    saiLink ('ATH0'+ENTER, 500);
    saiLink ('ATS0=0'+ENTER, 500);
end;

begin
end.
