/*--------------------------------------------------------
 *
 *   Programa parceiro da RENDE
 *
 *   Autor: Antonio Borges e Luis Carlos Serpa
 *
 *   Em 8/5/95
 *
 *-------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#define DIRBASETEXTO "/home/quindim/trcosta/textos"
#define DIRBASEPROG  "/home/quindim/trcosta/prog"

#define FALSE 0
#define TRUE 1

FILE *arqScript;
char recebeCarta;
int ntextos, nprogs;
int numCartasRec, numCartasEnv;
char *nomeTexto[20], *nomeProg[20];

char *leScript(); 
char mandaRespostas();
char erroProtoc, comProtoc;

/*--------------------------------------------------------
 *                      programa principal
 *-------------------------------------------------------*/

main(argc, argv)
int argc;
char *argv[];
{
	char comando [256];
	char processando;

	inicializa (argc, argv);
	geraArqScript();
	if (erroProtoc) goto fim;

	arqScript = fopen ("rendescript", "r");

	processando = TRUE;
	while (processando)
	{
		if (leScript (comando) == NULL)
			strcpy (comando, "*FIM");

		if (!strcmp (comando, "*CARTA"))
			mandaCarta();
		else
		if (!strcmp (comando, "*PEDCARTA"))
			recebeCarta = 1;
		else
		if (!strcmp (comando, "*PEDTEXTO"))
			pedTexto();
		else
		if (!strcmp (comando, "*PEDLISTA"))
			pedLista();
		else
		if (!strcmp (comando, "*PEDPROG"))
			pedPrograma();
		else
		if (!strcmp (comando, "*FIM"))
		{
			montaRespostas();
			mandaRespostas();
			processando = FALSE;
		}
		else
		if (strcmp (comando, ""))  {
			printf ("Comando invalido: %s\n", comando);
			erroProtoc = TRUE;
		}

	}
	fclose (arqScript);
fim:
	finaliza ();
	geraLog();
}

/*--------------------------------------------------------
 *                      inicializacao
 *-------------------------------------------------------*/

inicializa (argc, argv)
int argc;
char *argv[];
{
	numCartasEnv = 0;
	ntextos = 0;
	nprogs = 0;
	recebeCarta = FALSE;
	erroProtoc  = FALSE;
	comProtoc   = FALSE;

	if (argc > 1)
		comProtoc = (argv[1][0] == '-' && argv[1][1] == 'x');

	if (!comProtoc)
		printf ("*RENDE\n");
}

/*--------------------------------------------------------
 *                      manda carta
 *-------------------------------------------------------*/

mandaCarta()
{
	FILE *arq;
	char lendo;
	char destino[256], assunto[256], linha[256];

	leScript (destino);
	leScript (assunto);

	lendo = TRUE;
	numCartasEnv++;        
	arq = fopen ("rendemail", "w");
	while (lendo)  {
		if (leScript (linha) == NULL)
			strcpy (linha, ">*FIM*<");
		if (!strcmp (linha, ">*FIM*<")) break;
		fprintf (arq, "%s\n", linha);
	}
	fclose (arq);

	chamaMailer (destino, assunto, "rendemail");
}

/*--------------------------------------------------------
 *              pedido de um texto
 *-------------------------------------------------------*/

pedTexto()
{
	char nome[256];

	leScript (nome);
	nomeTexto[ntextos] = (char *) malloc (strlen(nome)+1);
	strcpy (nomeTexto[ntextos], nome);
	if (ntextos < 20) ntextos++;
}

/*--------------------------------------------------------
 *              pedido de inscricao em lista
 *-------------------------------------------------------*/

pedLista()
{
	FILE *arq;
	char linha[256];

	leScript (linha);

	arq = fopen ("rendemail", "w");
	fprintf (arq, "subscribe %s\n", linha);
	fclose (arq);

	chamaMailer ("listserv@rende.usp.br", "", "rendemail");
}

/*--------------------------------------------------------
 *              pedido de programa
 *-------------------------------------------------------*/

pedPrograma()
{
	char nome[256];

	leScript (nome);
	nomeProg[nprogs] = (char *) malloc (strlen(nome)+1);
	strcpy (nomeProg[nprogs], nome);
	if (nprogs < 20) nprogs++;
}

/*--------------------------------------------------------
 *              monta o arquivo de respostas
 *-------------------------------------------------------*/

montaRespostas()
{
	FILE *arqComando, *arqSaida, *arqCarta, *arqTexto;
	char linha[256];
	char nomearq[256];
	char *status;
	int i, nc;
	
	arqSaida = fopen ("rendesai", "w");
	fprintf (arqSaida, "*RENDE\n");

	if (recebeCarta)  {
		arqComando = fopen ("rendecomando", "w");

                strcpy (nomearq, "/usr/spool/mail");
                strcat (nomearq, ".............");
		arqCarta = fopen (nomearq, "r..............");

		numCartasRec = 0;
                recCarta = 0;

                procCartas = 1;
                while (procCartas) {
                    if (fgets (linha, 256, arqCarta) == NULL)
                        procCartas = 0;
                    else {
                        if (strncmp (linha, "From:", 5) == 0) {
                            fprintf (arqSaida, "*CARTA\n");
                            numCartasRec++;
			    fprintf (arqSaida, "%d\n", numCartasRec);
                            recCarta = 1;
                        }

			for (nc=0; nc<256; nc++)
				if (linha[nc] == 0x1a)
					linha[nc] = ' ';
                        if (recCarta)  fputs (linha, arqSaida);
                }

		fclose (arqCarta);
		fprintf (arqSaida, ">*FIM*<\n");
	}

	for (i=0; i<ntextos; i++)  {
		strcpy (nomearq, DIRBASETEXTO);
		strcat (nomearq, "/");
		strcat (nomearq, nomeTexto[i]);
		arqTexto = fopen (nomearq, "r");
		if (arqTexto != NULL) {
			fprintf (arqSaida, "*TEXTO\n");
			fprintf (arqSaida, "%s\n", nomeTexto[i]);
			while (fgets (linha, 256, arqTexto) != NULL)
				fputs (linha, arqSaida);
			fprintf (arqSaida, ">*FIM*<\n");
			fclose (arqTexto);
		}
	}

	for (i=0; i<nprogs; i++)  {
		strcpy (nomearq, "uuencode ");
		strcat (nomearq, nomeProg[i]);
		strcat (nomearq, " < ");
		strcat (nomearq, DIRBASEPROG);
		strcat (nomearq, "/");
		strcat (nomearq, nomeProg[i]);
		strcat (nomearq, " > rendeprog");
		system (nomearq);

		arqTexto = fopen ("rendeprog", "r");
		if (arqTexto != NULL) {
			fprintf (arqSaida, "*PROG\n");
			fprintf (arqSaida, "%s\n", nomeProg[i]);
			while (fgets (linha, 256, arqTexto) != NULL)
				fputs (linha, arqSaida);
			fprintf (arqSaida, ">*FIM*<\n");
			fclose (arqTexto);
		}
	}

	fprintf (arqSaida, "*FIM\n");
	fclose (arqSaida);
}

/*--------------------------------------------------------
 *              acerta os newLines para MS-DOS
 *-------------------------------------------------------*/

void acertaNewLines ()
{
	FILE *arqSaida, *arqTrab;
	char linha[256];

	arqSaida = fopen ("rendesai", "r");
	arqTrab  = fopen ("rendetrab", "w");

	while (fgets (linha, 256, arqSaida) != NULL) {
		linha [strlen(linha)-1] = '\0';
		fprintf (arqTrab, "%s\r\n", linha);
	}
	fclose (arqSaida);
	fclose (arqTrab);
	unlink ("rendesai");
	rename ("rendetrab", "rendesai");
}

/*--------------------------------------------------------
 *              manda o arquivo de respostas
 *-------------------------------------------------------*/

char mandaRespostas()
{
	FILE *arqSaida;
	char linha[256];
	int l;

	l = 0;
	if (comProtoc)  {
		acertaNewLines();
		erroProtoc = xmodemSend ("rendesai");
	}
	else {
		sleep (2);
		printf ("*\n");
		sleep (2);
		arqSaida = fopen ("rendesai", "r");
		while (fgets (linha, 256, arqSaida) != NULL) {
			if (l++ > 15) {
				sleep (5);
				l = 0;
			}
			printf ("%s", linha);
		}
		fclose (arqSaida);
	}
	return (1);
}

/*--------------------------------------------------------
 *      apaga arquivos de trabalho e cartas do mailer
 *-------------------------------------------------------*/

finaliza()
{
	int i;
	FILE *arqComando;

	if ((!erroProtoc) && recebeCarta)  {
		arqComando = fopen ("rendecomando", "w");
                if (numCartasRec > 0)
                    fprintf (arqComando, "d %1-%d\n", numCartasRec);
		fclose (arqComando);
		system ("mail -N < rendecomando > rendecarta");
	}

	if (erroProtoc)
	    printf ("--- Erro no protocolo de comunicacao ---\n");
	else {
		unlink ("rendecomando");
		unlink ("rendemail");
		unlink ("rendeindex");
		unlink ("rendescript");
		unlink ("rendecarta");
		unlink ("rendesai");
		printf ("--- Rende - fim de trabalho ---\n");
	}
}

/*--------------------------------------------------------
 *              pega arquivo de script do parceiro
 *-------------------------------------------------------*/

geraArqScript()
{
	char comando[256];
	FILE *arqScript;

	if (comProtoc)  {
		erroProtoc = xmodemReceive ("rendescript") != 0;
	}
	else {
		arqScript = fopen ("rendescript", "w");
		do {
			if (gets(comando) == NULL)
				strcpy (comando, "*FIM");
			fprintf (arqScript, "%s\n", comando);

		} while (strcmp (comando, "*FIM"));

		fclose (arqScript);
	}
}

/*--------------------------------------------------------
 *              le uma linha do script
 *-------------------------------------------------------*/

char *leScript (comando)
char *comando;
{
	char *status;

	status = fgets (comando, 256, arqScript);
	if (status == NULL)  {
		comando [0] = '\0';
		return (status);
	}
	if (comando [strlen(comando)-1] == '\n')
		comando [strlen(comando)-1] = '\0';
	if (strlen(comando) > 0)
		if (comando [strlen(comando)-1] == '\r')
			comando [strlen(comando)-1] = '\0';
}

/*--------------------------------------------------------
 *              chama o mailer do Unix
 *-------------------------------------------------------*/

chamaMailer (destino, assunto, nomearq)
char *destino, *assunto, *nomearq;
{
	int i, tam;
	char comando[256];

	tam = strlen(assunto);
	for (i = 0; i<tam; i++)
		if (assunto[i] == '"')
			assunto[i] == '\'';

	sprintf (comando, "mail -s \"%s\" %s < %s", assunto, destino, nomearq);
	system (comando);
}

/*--------------------------------------------------------
 *                    gera arquivo de log
 *-------------------------------------------------------*/

geraLog ()
{
	int i;
	FILE *logfile;

	system ("whoami >> rendelog");
	system ("date >> rendelog");
	logfile = fopen ("rendelog", "a");
	fprintf (logfile, "%d cartas recebidas\n", numCartasRec);
	fprintf (logfile, "%d cartas enviadas\n", numCartasEnv);
	fprintf (logfile, "%d textos pedidos\n",  ntextos);
	for (i=0; i<ntextos; i++)        
	    fprintf (logfile, "%s\n", nomeTexto[i]);
	fprintf (logfile, "%d programas pedidos\n",  nprogs);
	for (i=0; i<nprogs; i++)        
	    fprintf (logfile, "%s\n", nomeProg[i]);
	fprintf (logfile, "-----------------------------------\n");
	fclose (logfile);
}
