{--------------------------------------------------------}
{
{     Realiza uuencode ou uudecode de um arquivo
{
{     Autor: Jos Antonio Borges
{
{     Em Abril/95
{
{     Baseado no programa Simtel de Toad Hall
{
{--------------------------------------------------------}

program uuvox;
uses disfala, sintvox, traduvox, intervox, uuenc, crt;
const
    OK = 0;
    NOT_FOUND = 1;
    READ_ERROR = 2;
    WRITE_ERROR = 3;
    INVALID_FORMAT = 4;
    INCOMPL_FILE = 5;


{--------------------------------------------------------}
{                    inicializao
{--------------------------------------------------------}

procedure inicializa;
var 
    i, erro: integer;
    s: string;
begin
    sintInic (0, 'DIRDISCAVOX');
    if tradinic <> 0 then
        begin
            xwriteln ('DIERTRAD', 'Erro no diretorio do tradutor');
            sintBip;  sintBip;  sintBip;
            delay (1000);
            halt;
        end;
end;

{--------------------------------------------------------}
{                      finalizao
{--------------------------------------------------------}

procedure finaliza;
begin
    tradfim;
end;

{--------------------------------------------------------}
{             controle geral do processamento
{--------------------------------------------------------}

procedure processa;
var 
    processando: boolean;
    c: char;
    result: integer;
    nomearq, narqout, s: string;
    arq: file;

begin
    writeln;
    mensagem ('Conversor de transmissor UNIX', true);
    writeln;
    mensagem ('Qual o nome do arquivo: ', true);
    xreadln (nomearq);
    if nomearq = '' then
        exit;

    assign (arq, nomearq);
    {$I-} reset (arq);  {$I+}
    if ioresult <> 0 then
        begin
            mensagem ('Arquivo inexistente', true);
            mensagem ('Programa cancelado', true);
            tradfim;
            halt;
        end;

    close (arq);

    repeat
        mensagem ('Tecle C para codificar D para decodificar', true);
        xreadln (s);
        c := upcase (s[1]);

        case c of
            'C': begin
                     mensagem ('Qual o nome do arquivo de saida: ', true);
                     xreadln (narqout);
                     if narqout = '' then
                         exit;

                     result := uuencode (nomearq, narqout);
                 end;

            'D': result := uudecode (nomearq);
        end;

    until c in ['C', 'D'];

    mensagem ('OK convertido', true);
end;

begin
    inicializa;
    processa;
    finaliza;
end.
