{--------------------------------------------------------}
{
{     Discavox - utilitrio de comunicaes
{
{     Autores: Antonio Borges e Valter Ponte
{
{     Cooperao tecnolgica NCE/UFRJ e RENDE/USP
{
{     Em abril/1995
{
{--------------------------------------------------------}

{$M 16565,0,100000}
program discavox;

uses 
    crt, dos, playvox, readvox, sintvox, traduvox, intervox, videoiso,
    disvars, disutil, disprot,
    disfala, disdos, disrende,
    disansi, disfax,
    comunic, xmodem,
    horavox, videovox;
    

const versao = '2.1';

{--------------------------------------------------------}
{           manda um arquivo para o computador
{--------------------------------------------------------}

procedure mandaArqComput (transmLineFeed: boolean);
var nomearq: string;
    resp: char;
    result: integer;
    arq: text;
    c: char;
    contaCarac: integer;
    s: string;
    espera, erro: word;

label cancela;

begin
    textBackground (RED);
    xwrite ('DINOMENV', 'Qual o nome do arquivo a enviar ? ');
    textBackground (BLACK);
    xreadln (nomearq);
    if nomearq = '' then 
        begin
            xwriteln ('DIENVCAN', 'Envio cancelado.');
            exit;
        end;

    if not existeArq (nomearq) then
        begin
            xwriteln ('DIARQNAO', 'Arquivo no existe.  Operao cancelada.');
            exit;
        end;

    textBackground (RED);
    xwrite ('DIENVGAR', 'Quer envio com garantia (s/n) ? ');
    textBackground (BLACK);
    resp := letecla (1);

    utilizaCrc (upcase (resp) = 'C');

    if upcase(resp) <> 'N' then
        begin
            xwriteln ('DIESPREC', 'Aguardando parceiro iniciar recepcao...');
            result := xmodemSend (nomearq);
            if result <> 0 then
                mostraErroXmodem (result)
            else
                xwriteln ('DITERTRA', 'Terminei transmissao.');
        end
    else
        begin
            xwriteln ('DIDELAY', 'Espera entre linhas em milissegundos (sugiro 500): ');
            xreadln (s);
            val (s, espera, erro);
            if erro <> 0 then espera := 500;

            xwriteln ('DITRANSM', 'Transmitindo...');

            assign (arq, nomearq);
            reset (arq);
            contaCarac := 0;
            while not eof (arq) do
                begin
                    read (arq, c);
                    if (c <> #$0a) or transmLineFeed then
                         esclink (c);

                    if c = #$0d then delay (espera);

                    if chegouLink then
                         begin
                             lelink (c);
                             if c = ^S then
                                 repeat
                                     if chegouLink then
                                          lelink (c);
                                     if keypressed then c := ^Q;
                                 until c = ^Q;
                         end;

                    contaCarac := contaCarac + 1;
                    if contaCarac >= 80 then
                        begin
                            contaCarac := 0;
                            begin sound (100); delay (100); nosound; end;
                        end;

                    if keypressed then
                        begin
                            c := readkey;
                            if c = #$1b then goto cancela;
                        end;
                end;
cancela:
            close (arq);

            repeat
                while chegoulink do lelink (c);
                delay (1000);
            until not chegoulink;

            xwriteln ('DITERTRA', 'Terminei transmissao.');
        end;
end;

{--------------------------------------------------------}
{           recebe um arquivo do computador
{-------------------------------------------------------}

procedure recebeArqComput;
var
    nomearq: string;
    result: integer;
    resp, c, tec: char;
    arq: text;
    erro: boolean;
    contaCarac: integer;

begin
    textBackground (RED);
    xwrite ('DINOMREC', 'Qual o nome do arquivo a receber ? ');
    textBackground (BLACK);
    xreadln (nomearq);
    if nomearq = '' then
        begin
            xwriteln ('DIRECCAN', 'Recepo cancelada.');
            exit;
        end;

    textBackground (RED);
    xwrite ('DITGARAN', 'O parceiro vai transmitir com garantia (s/n) ? ');
    textBackground (BLACK);
    resp := letecla (1);

    utilizaCrc (upcase (resp) = 'C');

    if upcase(resp) <> 'N' then
        begin
            xwriteln ('DIESPENV', 'Aguardando parceiro enviar...');
            result := xmodemReceive (nomearq);
            if result <> 0 then
                mostraErroXmodem (result)
            else
                xwriteln ('DIGRAV', 'Arquivo gravado');
        end
    else
        begin
            assign (arq, nomearq);
            {$I-} append (arq); {$I+}
            if ioresult <> 0 then
                {$I-} rewrite (arq); {$I+}
            if ioresult <> 0 then
                begin
                    xwriteln ('DIERRARQ', 'Erro ao criar arquivo. Recepcao cancelada');
                    exit;
                end;

            xwriteln ('DITCESCR', 'Tecle ESC para finalizar a recepo do arquivo');

            contaCarac := 0;
            erro := false;
            tec := 'x';
            repeat
                if chegouLink then
                    begin
                        lelink (c);
                        {$I-} write (arq, c); {$I+}
                        if ioresult <> 0 then erro := true;

                        contaCarac := contaCarac + 1;
                        if contaCarac >= 80 then
                            begin
                                contaCarac := 0;
                                begin sound (100); delay (100); nosound; end;
                            end;
                    end;

                if keypressed then
                    begin
                        tec := readkey;
                        if tec <> ESC then esclink (tec);
                    end;
            until tec = ESC;

            {$i-}  close (arq);  {$I+}
            if ioresult <> 0 then erro := true;

            if erro then
                xwriteln ('DITRUNC', 'Houve um erro na gravao.  Arquivo foi truncado.')
            else
                xwriteln ('DIGRAV', 'Arquivo gravado.')
        end;
end;

{--------------------------------------------------------}
{               seleciona velocidade de fala
{--------------------------------------------------------}

procedure selVelocFala;
var erro: integer;
    s: string;
    c: char;
    velocFala: integer;

label 1, 2, 3, fim;

begin
    tradFim;
    selecTipoFonemas (0);
    if tradInic <> 0 then;

    sintSom ('DIVELFAL');  { Qual a velocidade de fala de 1 a 4 ? }
    c := readkey;
    write (c);
    sintCarac (c);

    velocFala := ord (c) - ord ('0');
    if (velocFala < 1) or (velocFala > 4) then
        velocFala := 0;

    sintsom ('DISOLET');           { Soletra digitacao (s/n) ? }
    c := readkey;
    sintCarac (c);
    soletrando := upcase (c) = 'S';

fim:
    tradFim;
    selecTipoFonemas (velocFala);
    if tradInic <> 0 then
        begin
            tradFim;
            selecTipoFonemas (0);
            if tradInic <> 0 then;
        end;
    sintSom ('DIOK');
end;


{--------------------------------------------------------}
{               emula um terminal de computador
{--------------------------------------------------------}

procedure termComputador;
var 
    c: char;
    emulando: boolean;
    nomeComputador: string;
    salvaSolet: boolean;
    nomeArqLynx: string;

{--------------------------------------------------------}

    procedure ajudaTerm;
    begin
        if modoLynx then exit;

        writeln;
        textBackground(BLUE);
        xwriteln ('DIAJUDT2', 'F2 - transmite um arquivo');
        xwriteln ('DIAJUDT3', 'F3 - recebe um arquivo');
        xwriteln ('DIAJUDT4', 'F4 - seleciona modo de fala');
        xwriteln ('DIAJUDT5', 'F5 - seleciona modo WWW');
        xwriteln ('DIAJUDT6', 'F6 - limpa tela');
        xwriteln ('DIAJUDT7', 'F7 - disca de novo');
        xwriteln ('DIAJUDT8', 'F8 - fala hora');
        xwriteln ('DIAJUDT9', 'F9 - ativa leitor de tela');
        xwriteln ('DITECF10', 'Tecle F10 para desligar');
        textBackground(BLACK);
        clreol;
        writeln;
    end;

{--------------------------------------------------------}

    procedure controlaAutoArquiva;
    var x, y: integer;
    label errodisco;
    begin
       autoArquiva := not autoArquiva;

       if autoArquiva then
           begin
               sintSom ('DIAGRAV');   { autogravacao ativada }

               assign (arqAuto, 'discavox.$$$');

               {$I-}  reset (arqAuto);  {$I+}
               if ioresult = 0 then
                   begin
                       {$I-} append (arqAuto); {$I+}
                       if ioresult <> 0 then goto erroDisco;
                    end
               else
                   begin
                       {$I-} close (arqAuto); {$I+}
                       if ioresult <> 0 then;
                       {$I-} rewrite (arqAuto); {$I+}
                       if ioresult <> 0 then goto erroDisco;
                   end
           end
       else
           begin
               {$I-}   close (arqAuto);   {$I+}
               if ioresult <> 0 then
                   goto erroDisco
               else
                   begin
                       sintsom ('DIARGRAV');   { Arquivo gravado' }
                   end;
           end;

       exit;

erroDisco:
        sintSom ('DIERGRAV');  { Erro de gravacao }
    end;

{--------------------------------------------------------}

    function qualLinhaInversa: integer;
    var x, y: integer;
    begin
        for y := 1 to 25 do
            for x := 0 to 79 do
                if (mem[$b800:(y-1)*160+x*2+1] and $f0) <> 0 then
                     begin
                         qualLinhaInversa := y;
                         exit;
                     end;

        qualLinhaInversa := wherey;
    end;

{--------------------------------------------------------}

    procedure leLinhaVideo (n: integer);
    var s: string;
        i: integer;
        tudoBranco: boolean;
    begin
        if n < 1  then n := 1;
        if n > 25 then n := 25;

        tudoBranco := false;
        s := '';
        for i := 0 to 79 do
            begin
                c := chr (mem[$b800:(n-1)*160+i*2]);
                s := s + c;
                if c <> ' ' then tudoBranco := false;
            end;

        if tudoBranco then
            delay (1000)
        else
            falaTexto (ansiParaPc(s));

        sintClek;
    end;

{--------------------------------------------------------}

    procedure ligaDeslFalaTerm;
    begin
        if falando = 0 then
             falando := 1
        else
             falando := 0;

        if falando <> 0 then
            sintSom ('DIFALLIG')
        else
            sintSom ('DIFALDLG');
    end;

{--------------------------------------------------------}

    procedure selecModoLynx;
    begin
        falando := 1;

        modoLynx := not modoLynx;
        if modoLynx then
            begin
                salvaSolet := soletrando;
                soletrando := true;
                carregaGeradorISO;
                sintSom ('DILNXLIG');
            end
        else
            begin
                soletrando := salvaSolet;
                carregaGeradorIBM;
                sintSom ('DILNXDLG');
            end;
    end;

{--------------------------------------------------------}

    procedure recebeTelaLynx;
    var arq: text;
        espera: integer;
        c: char;
        s: string;
    label fim;


        function trataTeclado: boolean;
        begin
            trataTeclado := true;

            if keypressed then
                case c of
                    #$1b: begin
                              trataTeclado := false;
                              exit;
                          end;

                     #$0:
                          begin
                              c := readkey;
                              if c = TEND then leLinhaVideo (22)
                              else
                              if c = HOME then leLinhaVideo (1);
                          end;

                else
                         begin
                             esclink (readkey);
                             if soletrando then sintCarac (c);
                         end;
                end;
        end;


    begin
        xwrite ('DINOMREC', 'Qual o nome do arquivo a receber ? ');
        textBackground (BLACK);
        xreadln (s);
        if s <> '' then nomeArqLynx := s;

        assign (arq, nomeArqLynx);
        {$I-} reset (arq);  {$I+}
        if ioresult = 0 then
            begin
                close (arq);
                {$I-} append (arq); {$I+}
                if ioresult <> 0 then
                    begin
                        xwriteln ('DIERRARQ', 'Erro ao criar arquivo. Recepcao cancelada');
                        exit;
                    end;
            end
        else
            begin
                {$I-} rewrite (arq);  {$I+}
                if ioresult <> 0 then
                    begin
                        xwriteln ('DIERRARQ', 'Erro ao criar arquivo. Recepcao cancelada');
                        exit;
                    end;
            end;

        sintSom ('DIRECTEL');      { arquivando pagina www }

        esclink ('P');
        delay (2000);
        while chegouLink do
            lelink (c);
        esclink (#$1b);  esclink ('[');  esclink ('B');
        delay (1000);
        while chegouLink do
            lelink (c);
        esclink (#$1b);  esclink ('[');  esclink ('B');
        delay (1000);
        while chegouLink do
            lelink (c);

        esclink (#$0d);

        repeat
            if not trataTeclado then goto fim;

            if chegouLink then
                begin
                    lelink (c);
                    ansiwrite (c);
                    if c = ']' then esclink ('y');
                end;
        until c = ':';

        writeln (arq, '------------- Inicio de texto do Lynx ------------');
        esclink (#$0d);

        espera := 0;
        while espera < 30 do
             begin
                 if not trataTeclado then goto fim;

                 while chegouLink do
                     begin
                         espera := 0;
                         leLink (c);
                         ansiwrite (c);
                         write (arq, c);
                         if c = #$0d then sintclek;
                     end;

                 espera := espera + 1;
                 delay (200);
             end;
fim:
        writeln (arq);
        writeln (arq, '------------- Fim de texto do Lynx ------------');
        close (arq);

        sintSom ('DIGRAV');
        esclink (#$0d);
    end;

{--------------------------------------------------------}

    procedure trataControles;
    var c: char;
        salvax, salvay: integer;
        s: string;
        i: integer;
    begin
        c := readkey;
        case c of
             CTLF1: if modoLynx then
                        leLinhaVideo(qualLinhaInversa)
                    else
                        lelinhaVideo (wherey);

             ALTF1: if modoLynx then
                        begin
                            for i := 2 to 21 do
                               if not keypressed then lelinhaVideo (i);
                            while keypressed do c := readkey;
                        end
                    else
                        begin
                            for i := 1 to 24 do
                               if not keypressed then lelinhaVideo (i);
                            while keypressed do c := readkey;
                        end;

             F1   : ajudaTerm;
             F2   : begin
                        utilizaCrc (false);
                        mandaArqComput (false);
                    end;
             F3   : if modoLynx then
                        recebeTelaLynx
                    else
                        recebeArqComput;
             CTLF3: controlaAutoArquiva;
             F4   : ligaDeslFalaTerm;
             CTLF4: selVelocFala;
             F5   : selecModoLynx;
             F6   : textMode (CO80);
             F7   : if discaTelefone (nomeComputador) then;
             F8   : falaHora;
             CTLF8: falaDia;

             F9   : if modoLynx then
                        begin
                            salvax := wherex;
                            salvay := wherex;
                            gotoxy (1, qualLinhaInversa);
                            leitorDeTela;
                            gotoxy (salvax, salvay);
                        end
                    else
                        leitorDeTela;

             F10  : begin
                       salvax := wherex;
                       salvay := wherey;
                       window (1, 1, 80, 25);

                       gotoxy (54, 25);
                       textBackGround (BLACK);
                       clreol;
                       textBackGround (BLUE);
                       xwrite ('DICNFFIM', 'Confirma fim (s/n)');
                       textBackGround (BLACK);
                       clreol;
                       
                       c := readkey;
                       if upcase(c) = 'S' then
                           emulando := FALSE
                       else
                           begin
                               textBackground (BLUE);
                               gotoxy (54, 25);
                               write ('Tecle F10 para desligar');
                               textBackGround (BLACK);
                               clreol;
                           end;

                       window (1, 1, 80, 24);
                       gotoxy (salvax, salvay);
                    end;

             CTLF10 : chamaDOS;

             INS : lelinhaVideo (wherey);

             DEL : esclink (#$7f);

             HOME: if modoLynx then
                       lelinhaVideo (1)
                   else
                       begin
                           esclink (#$1b);  esclink ('[');  esclink ('H');
                       end;

             TEND: if modoLynx then
                       lelinhaVideo (22)
                   else
                       begin
                           esclink (#$1b);  esclink ('[');  esclink ('K');
                       end;

             PGUP: begin
                      esclink (#$1b);  esclink ('[');
                      esclink ('5');   esclink ('~');
                   end;

             PGDN: begin
                      esclink (#$1b);  esclink ('[');
                      esclink ('6');   esclink ('~');
                   end;

             CIMA: begin
                       esclink (#$1b);  esclink ('[');  esclink ('A');
                   end;
             BAIX: begin
                       esclink (#$1b);  esclink ('[');  esclink ('B');
                   end;
             ESQ : begin
                       esclink (#$1b);  esclink ('[');  esclink ('D');
                   end;
             DIR : begin
                       esclink (#$1b);  esclink ('[');  esclink ('C');
                   end;

            #16..#50:   { ALTS }
                     begin
                         c := tabAlt [ord(c)];
                         s := pegaParam ('MENS'+c);
                         for i := 1 to length(s) do
                             esclink (s[i]);
                     end;
         end;
    end;

{--------------------------------------------------------}

var
    i, erro: integer;
    conexaoLocal: boolean;

label inicio;

begin
inicio:
    xwriteln ('DITELCOM', 'Informe o telefone do computador parceiro: ');
    xreadln (nomeComputador);
    if nomeComputador = '' then exit;

    conexaoLocal := (nomeComputador = 'local') or
                    (nomeComputador = 'LOCAL');

    if not conexaoLocal then
        begin
            for i := 1 to length (nomeComputador) do
                nomeComputador[i] := upcase (nomeComputador[i]);
            if nomeComputador[1] in ['A'..'Z'] then
                 begin
                     nomeComputador := pegaParam (nomeComputador);
                     if nomeComputador = '' then
                         goto inicio;
                 end;
        end;

    clrscr;
    textBackground (BLUE);
    gotoxy (54, 25);
    xwrite ('DITECF10', 'Tecle F10 para desligar');
    textBackGround (BLACK);

    gotoxy (1,1);
    window (1, 1, 80, 24);

    InicIntr (porta, irq, velocTerm, nbitsTerm, stopsTerm, paridTerm);
    if not conexaoLocal then
        if discaTelefone (nomeComputador) then;

    modoLynx := false;
    inicAnsi;
    soletrando:= false;
    falando := 1;
    nomeArqLynx := 'lynx.$$$';

    c := #0;
    emulando := true;

    autoArquiva := false;

    while emulando do
        begin
            if keypressed then
                begin
                    c := readkey;
                    if modoLynx and (c = ^H) then
                        if (wherex <> 1) then
                            begin
                                sintSom ('DIDEL');
                                sintCarac (leTela (wherey, wherex-1));
                            end
                        else
                            sintbip;

                    if c = #$0 then
                        trataControles
                    else
                        begin
                            esclink (c);
                            if soletrando then
                                sintCarac (c);
                        end;
                end;

            if chegouLink then
                begin
                    repeat
                        lelink (c);
                        if c = #$0c then
                            clrscr
                        else
                            ansiwrite (c);
                    until (not chegouLink) or
                          (not modoLynx);    { para evitar perda de cleks }
                end;
        end;

    falando := 1;
    if autoArquiva then controlaAutoArquiva;

    if not conexaoLocal then
        desligaTelefone (true);
    finalIntr;

    window (1, 1, 80, 25);
    gotoxy (1, 25);

    carregaGeradorIBM;
    textColor(LIGHTGRAY);
    textBackground (BLACK);
    clreol;
end;

{--------------------------------------------------------}
{                   configurao
{--------------------------------------------------------}

procedure configura;
var c: char;
    numeroRende, s: string;

    function intstr (v: integer): string;
    var s: string;
    begin
        str(v, s);
        intstr := s;
    end;

begin
    writeln;
    xwriteln ('DICONFIG', 'Configurando comunicaes');
    writeln;

    write ('Porta (atualmente ', porta, '): ');
    sintsom ('DIPORTA');
    sintCarac (chr(porta+ord('0')));
    porta := xreadint;

    write ('IRQ (atualmente ', irq, '): ');
    sintsom ('DIIRQ');
    str (irq, s);
    sintSoletra (s);
    irq := xreadint;

    xwrite ('DIVEL', 'Velocidade (sugiro 2400): ');
    veloc     := xreadint;
    velocTerm := veloc;
    xwrite ('DIBITCAR', 'Numero de bits por caractere (sugiro 8): ');
    nbits     := xreadint;
    nbitsTerm := nbits;
    xwrite ('DISTOPBI', 'Numero de stop bits (sugiro 1): ');
    stops     := xreadint;
    stopsTerm := stops;
    xwrite ('DIPARID', 'Paridade: 0 sem, 1 impar, 2 par (sugiro 0): ');
    parid     := xreadint;
    paridTerm := parid;

    xwriteln ('DIOKCONF', 'Ok, configurado');
    xwrite   ('DISVDSK',  'Quer salvar em disco (s/n) ? ');
    s := 'N';
    xreadln (s);
    if upcase(s[1]) = 'S' then
        begin
            trocaParam ('PORTA', intstr (porta));
            trocaParam ('IRQ', intstr (irq));
            trocaParam ('VELOC', intstr (veloc));
            trocaParam ('VELOCTERM', intstr (velocTerm));
            trocaParam ('NBITS', intstr (nbits));
            trocaParam ('NBITSTERM', intstr (nbitsTerm));
            trocaParam ('STOPS', intstr (stops));
            trocaParam ('STOPSTERM', intstr (stopsTerm));
            trocaParam ('PARID', intstr (parid));
            trocaParam ('PARIDTERM', intstr (paridTerm));

            xwrite ('DINUMPRO', 'Qual o telefone do provedor (Enter deixa igual): ');
            xreadln (numeroRende);
            if numeroRende <> '' then
                begin
                    trocaParam ('RENDE', numeroRende);
                    trocaParam ('RENDE1', numeroRende);
                end;
        end;
end;

{--------------------------------------------------------}
{          trata tela de conversacao entre usuarios
{--------------------------------------------------------}

procedure inicTelaUsuario;
var i: integer;
begin
    window (1,1,25,80);
    clrScr;
    gotoxy (1, 13);
    for i := 1 to 8 do
        write ('----------');

    gotoxy (1, 25);
    textBackground (BLUE);
    xwrite ('DIF10TRM', 'Tecle F10 para desligar, F1 para ajuda');
    clreol;
    textBackground (BLACK);
    xcurDele := 1;  ycurDele := 1;
    xcurMeu  := 1;  ycurMeu := 1;
end;

{--------------------------------------------------------}

procedure saiMeuCarac (c: char);
begin
    window (1, 14, 80, 24);
    gotoxy (xcurMeu, ycurMeu);
    write (c);

    if falando = 1 then
        begin
            if c = ENTER then
                sintClek
            else
                sintcarac (c)
        end;

    if c = ENTER then
        writeln;
    xcurMeu := whereX;
    ycurMeu := whereY;
end;

{--------------------------------------------------------}

procedure saiCaracParceiro (c: char);
begin
    window (1, 1, 80, 12);
    gotoxy (xcurDele, ycurDele);
    write (c);
    acumulaPalavra (c);
    if c = ENTER then
        writeln;
    xcurDele := whereX;
    ycurDele := whereY;
end;

{--------------------------------------------------------}
{          ajuda na conversa com outro usuario
{--------------------------------------------------------}

procedure ajudaUsuario;
begin
    writeln;
    xwriteln ('DIAJUDU2', 'F2 - transmite um arquivo');
    xwriteln ('DIAJUDU3', 'F3 - recebe um arquivo');
    xwriteln ('DIAJUDU4', 'F4 - seleciona modo de fala');
    xwriteln ('DIAJUDU9', 'F9 - ativa leitor de tela');
    xwriteln ('DIAJUDU0', 'F10 - fim de comunicao');
end;

{--------------------------------------------------------}
{                    fala com gente
{--------------------------------------------------------}

procedure falaComGente;
var 
    c, opcao: char;
    nomeParceiro: string;
    conversando: boolean;
    salvax, salvay, i: integer;

{--------------------------------------------------------}

    procedure ligaDeslFala;
    begin
        if falando = 0 then
             falando := 1
        else
             falando := 0;

        if falando <> 0 then
            sintSom ('DIFALLIG')
        else
            sintSom ('DIFALDLG');
    end;

{--------------------------------------------------------}

    procedure trataControles;

    var c: char;
        s: string;
        i: integer;

    begin
        saiMeuCarac (ENTER);
        c := readkey;
        case c of
            F1   : ajudaUsuario;
            F2   : begin
                       utilizaCrc (true);
                       mandaArqComput (true);
                   end;
            F3   : recebeArqComput;
            F4   : ligaDeslFala;
            CTLF4: selVelocFala;
            F5   : ;
            F6   : ;
            F7   : ;
            F8   : falaHora;
            CTLF8: falaDia;
            F9   : leitorDeTela;
            F10  : begin
                       window (1, 1, 80, 25);
                       salvax := wherex;
                       salvay := wherey;

                       gotoxy (54, 25);
                       textBackGround (BLACK);
                       clreol;
                       textBackGround (BLUE);
                       xwrite ('DICNFFIM', 'Confirma fim (s/n)');
                       textBackGround (BLACK);
                       clreol;

                       c := readkey;
                       if upcase(c) = 'S' then
                           conversando := FALSE
                       else
                           begin
                               gotoxy (54, 25);
                               textBackground (BLUE);
                               clreol;
                               textBackGround (BLACK);
                           end;

                        gotoxy (salvax, salvay);
                    end;


            CTLF10  : chamaDOS;

            #16..#50:   { ALTS }
                     begin
                         c := tabAlt [ord(c)];
                         s := pegaParam ('MENS'+c);
                         for i := 1 to length(s) do
                             begin
                                 saiMeuCarac (s[i]);
                                 esclink (s[i]);
                             end;
                         saiMeuCarac (ENTER);
                         esclink (ENTER);
                     end;

            PGDN : inicTelaUsuario;
        end;

        xcurMeu := wherex;
        ycurMeu := wherey;
    end;

{--------------------------------------------------------}

    procedure trataAcentos (c: char);
    begin
        ex_acento := not ex_acento;

        if ex_acento then
            ult_acento := c
        else
            begin
                case ult_acento of
                    '''':  case c of
                                  'a': c := '';
                                  'e': c := '';
                                  'i': c := '';
                                  'o': c := '';
                                  'u': c := '';
                                  'A': c := '';
                                  'E': c := '';
                                  'I': c := '';
                                  'O': c := '';
                                  'U': c := '';
                                  'c': c := '';
                                  'C': c := '';

                           end;

                    '~':
                           case c of
                                  'a': c := '';
                                  'o': c := '';
                                  'A': c := '';
                                  'O': c := '';
                           end;

                    '`':
                           case c of
                                  'a': c := '';
                                  'A': c := '';
                           end;

                    '"':
                           case c of
                                  'u': c := '';
                                  'u': c := '';
                           end;
                    '^':
                           case c of
                                  'a': c := '';
                                  'e': c := '';
                                  'i': c := '';
                                  'o': c := '';
                                  'u': c := '';
                                  'A': c := '';
                                  'E': c := '';
                                  'I': c := '';
                                  'O': c := '';
                                  'U': c := '';
                           end;
                end;
                esclink (c);
                saiMeuCarac (c);
            end;
    end;

{--------------------------------------------------------}

begin
    textBackground (RED);
    xwrite ('DISCHAM', 'Tecle D para micro discar, E para esperar chamada, R para reconectar: ');
    textBackground (BLACK);
    opcao := upcase (letecla(1));
    if opcao = ESC then exit;

    InicIntr (porta, irq, veloc, nbits, stops, parid);

    if opcao = 'D' then
        begin
            xwriteln ('DISTELUS', 'Informe o telefone do usurio parceiro: ');
            xreadln (nomeParceiro);
            if nomeParceiro = '' then exit;
            if discaTelefone (nomeParceiro) then;
        end
    else
    if upcase(opcao) = 'R' then
        begin
            saiLink ('ATX1'+ENTER, 1000);
            xwriteln ('DICHRESP', 'Seu micro vai ser quem chama (C) ou responde (R) ? ');
            opcao := upcase (letecla(1));
                if opcao = 'C' then
                    saiLink ('ATDP'+ENTER, 1000)
                else
                    saiLink ('ATA'+ENTER, 1000);
        end
    else
        saiLink ('ATS0=1'+ENTER, 1000);

    inicTelaUsuario;

    c := #0;
    ex_acento := false;
    conversando := true;
    while conversando do
        begin
            if keypressed then
                begin
                    c := readkey;

                    if c = #$0 then
                        trataControles
                    else
                        if (c in acentos) or ex_acento then
                            trataAcentos (c)
                        else
                            begin
                                esclink (c);
                                saiMeuCarac (c);
                            end;
                end;

            if chegouLink then
                begin
                    lelink (c);
                    if c <> #$0a then
                        saiCaracParceiro (c);
                end;
        end;

    window (1, 1, 80, 25);
    gotoxy (1, 25);
    clreol;

    desligaTelefone (true);
    finalIntr;
    writeln;
end;

{--------------------------------------------------------}
{                    inicializao
{--------------------------------------------------------}

procedure inicializa;
var 
    i, erro: integer;
    s: string;
begin
    sintInic (0, 'DIRDISCAVOX');

    if tradinic <> 0 then
        begin
            xwriteln ('DIERTRAD', 'Erro no diretorio do tradutor');
            sintBip;  sintBip;  sintBip;
            delay (1000);
            halt;
        end;

    ambDiscavox := getenv ('AMBDISCAVOX');
    if ambDiscavox = '' then
            ambDiscaVox := copy (getenv('AMBDOSVOX'), 1, 2) +
                           '\DOSVOX\DISCAVOX.AMB';

    pulse := true;        { valores default }
    porta := 0;
    irq   := 0;
    veloc := 2400;
    nbits := 8;
    stops := 1;
    parid := 0;
    falando := 1;
    modoLynx := false;
    autoArquiva := false;

    if existeArq (ambDiscaVox) then
        begin
            if pegaParam ('DISCA') = 'TONE' then
                 pulse := false;

            s := pegaParam ('PORTA');
            val (s, porta, erro);
            if (porta < 1) or (porta > 4) then 
               porta := 4;

            s := pegaParam ('IRQ');
            val (s, irq, erro);

            s := pegaParam ('VELOC');
            val (s, veloc, erro);

            s := pegaParam ('NBITS');
            val (s, nbits, erro);

            s := pegaParam ('STOPS');
            val (s, stops, erro);
            if (stops < 0) or (stops > 2) then stops := 1;

            s := pegaParam ('PARID');
            val (s, parid, erro);
            if (parid < 0) or (parid > 2) then parid := 0;

            s := pegaParam ('VELOCTERM');
            val (s, velocterm, erro);

            s := pegaParam ('NBITSTERM');
            if s = '' then   
                nbitsterm := 8
            else
                val (s, nbitsterm, erro);

            s := pegaParam ('STOPSTERM');
            if s = '' then
                stopsterm := 1
            else
                val (s, stopsterm, erro);

            s := pegaParam ('PARID');
            if s = '' then
                paridterm := 0
            else
                val (s, paridterm, erro);

            s := 'S';
            s := pegaParam ('FALANDO');
            if s <> 'SIM' then
                begin
                    falando := 0;
                    sintCalado (true);
                end;
        end;

    if porta = 0 then
        porta := 4;

    if (irq < 3) or (irq > 15) then
        if porta = 4 then  irq := 3
                     else  irq := 4;

    clrscr;
    xwrite ('DIINIC', 'Sistema DISCAVOX - NCE/UFRJ, RENDE/USP e RNP - Verso ');
    writeln (versao);
    sintSoletra (versao);
    writeln;

    xwriteln ('DIINIMOD', 'Inicializando modem');

    InicIntr (porta, irq, veloc, nbits, stops, parid);

    if not existeArq (ambDiscaVox) then
        saiLink ('ATQ0V1E1X1S0=0'+ENTER, 1000)
    else
        begin
            for i := 0 to 9 do
                begin
                    str (i, s);
                    s := pegaParam ('INICMODEM'+s);
                    if s <> '' then
                        if s = 'ATZ' then
                            sailink (s+ENTER, 3000)
                        else
                            sailink (s+ENTER, 500);
                end;
        end;

    finalIntr;

    writeln;
    xwriteln ('DIFIMMOD', 'Inicializao do modem concluda, tecle ENTER');
    readln;

    clrscr;
    write ('Sistema DISCAVOX - NCE/UFRJ, RENDE/USP e RNP - Verso ');
    writeln (versao);
    writeln;
end;

{--------------------------------------------------------}
{                      finalizao
{--------------------------------------------------------}

procedure finaliza;
begin
    desligaTelefone (true);
    finalIntr;

    writeln;
    writeln;
    textBackground (BLUE);
    xwrite ('DIDESLI', 'Confira se seu telefone realmente desligou, certo ?');
    textBackground (BLACK);
    writeln;
    writeln;
    xwriteln ('DITCHAU', 'At logo,  um prazer servi-lo.');

    tradfim;
end;

{--------------------------------------------------------}
{             controle geral do processamento
{--------------------------------------------------------}

procedure processa;
var 
    processando: boolean;
    c: char;

    procedure ajuda;
        begin
            while keypressed do c := readkey;
            xwriteln ('DISAJUD1', 'As opes do Discavox so:');
            if not keypressed then
              xwriteln ('DISAJUD2', 'U - falar com outro usurio');
            if not keypressed then
              xwriteln ('DISAJUD3', 'R - falar com a Rende');
            if not keypressed then
              xwriteln ('DISAJUD4', 'T - vira terminal de um computador');
            if not keypressed then
              xwriteln ('DISAJUD5', 'F - envio de fax');
            if not keypressed then
              xwriteln ('DISAJUD6', 'C - configurar comunicacao com computador');
            if not keypressed then
              xwriteln ('DISAJUD7', 'ESC - termina o programa');
        end;


begin
    processando := true;
    while processando do
        begin
            textBackground (BLUE);
            writeln;
            while keypressed do c := readkey;
            xwrite ('DISOPCAO', 'Discavox - Qual sua opo ? ');
            textBackground (BLACK);
            clreol;
            c := upcase (letecla (1));
            case c of
                'U': falaComGente;
                'R': falaComRende;
                'T': termComputador;
                'F': enviaFax;
                'C': configura;

               #$1b:  processando := false;
                 #0:  begin
                          c := readkey;
                          if c = F10 then
                             processando := false
                          else
                             ajuda;
                      end;
            else
                ajuda;
            end;
        end;
end;

begin
    inicializa;
    processa;
    finaliza;
end.
