unit dosdisco;
interface
uses dos, crt,
     dosgeral, dosmsg, dosform, sintvox, intervox, readvox;

procedure trataDiscos;

implementation

{--------------------------------------------------------}
{             ajuda do processamento de arquivos
{--------------------------------------------------------}

procedure ajudaDiscos;
var i: integer;
    c: char;
begin
    writeln;
    for i := AJUDADSK_1 to AJUDADSK_99 do
         begin
             mensagem (i, 1);
             if keypressed then
                 begin
                     while keypressed do c := readkey;
                     sintBip;
                     exit;
                 end;
         end;
end;

{--------------------------------------------------------}
{                    verifica o espaco em disco
{--------------------------------------------------------}

procedure verifEspaco;
var
    dfree, dsize: longint;
begin
    dsize := disksize (0) div 1024;
    dfree := diskfree (0) div 1024;
    mensagem (DVTAMDSK, 0);
    falaNum (dsize, 1);
    mensagem (DVLIVDSK, 0);
    falaNum (dfree, 1);
end;

{--------------------------------------------------------}
{                escolhe o disco de trabalho
{--------------------------------------------------------}

procedure escolheDisco;
var
    dirAtual: string;
    c, c2: char;
begin
    mensagem (DVINFDIS, 0);
    pegaTeclado (c, c2);
        if upcase(c) in ['A'..'Z'] then
        begin
            soletra (c, 1);
            {$i-} chdir (c+':'); {$i+}
            if ioresult <> 0 then
                mensagem (DVERRUND, 1);
        end
    else
        mensagem (DVERRUND, 1);
end;

{--------------------------------------------------------}
{            informa diretorio de trabalho
{--------------------------------------------------------}

procedure informaDirTrab;
var dir: string;
begin
    getdir (0, Dir);
    mensagem (DVDIRATU, 0);
    soletra (copy (Dir, 1, 2), 0);
    sintetFala (copy (Dir, 3, length(Dir)-2) , 1);
end;

{--------------------------------------------------------}
{        seleciona diretorio de trabalho
{--------------------------------------------------------}

procedure selecDirTrab;
var novoDir: string;
    c: char;
begin
    mensagem (DVINFDIR, 1);
    novoDir := '';
    c := editaCampo (novoDir, wherex, wherey, 79, true);
    writeln;
    if c = #$1b then
        exit;

    novoDir := compacta (novoDir);
    if novoDir = '' then exit;

    {$I-} chdir (novoDir); {$i+}
    if ioresult <> 0 then
         mensagem (DVERRMUD, 1)
    else
         mensagem (DVOKMUD, 1);
end;

{--------------------------------------------------------}
{                         cria diretorio
{--------------------------------------------------------}

procedure criaDir;
var novoDir: string;
    c, c2: char;
begin
     mensagem (DVDIRCRI, 0);
     writeln;
     novoDir := '';
     c := editaCampo (novoDir, wherex, wherey, 79, true);
     novoDir := compacta (novoDir);
     writeln;
     if (c = #$1b) or (novoDir = '') then exit;

     {$I-} mkdir (novoDir); {$i+}
     if ioresult <> 0 then
          mensagem (DVERRCRI, 1)
     else
         begin
              mensagem (DVOKCRI, 1);
              mensagem (DVQUERD, 0);
              mensagem (DVSIMNAO, 0);
              pegaTeclado (c, c2);
              if c <> #0 then
                  soletra (c, 1)
              else
                  soletra (' ', 1);

              if upcase(c) = 'S' then
                   begin
                       {$I-} chdir (novoDir); {$i+}
                       if ioresult <> 0 then
                            mensagem (DVERRCRI, 1);
                   end;
         end;
end;

{--------------------------------------------------------}
{             funcoes de tratamento de discos
{--------------------------------------------------------}

procedure trataDiscos;
var
    tratandoDiscos: boolean;
    dirAtual: string;
    c, c2: char;
begin
    tratandoDiscos := true;
    while tratandoDiscos do
        begin
            getdir (0, diratual);

            textBackground (RED);
            mensagem (DVDISCOS, 0);
            mensagem (DVOQUE, 0);
            textBackground (BLACK);

            pegaTeclado (c, c2);

            if c = #$1b then
                begin
                    writeln;
                    mensagem (DVOK, 1);
                    tratandoDiscos := false;
                end
            else

            if (c = #0) and (c2 = F1) then
                 ajudaDiscos
            else
                 begin
                     soletra (c, 1);
                     tratandoDiscos := false;

                     case upcase(c) of

                         'E': verifEspaco;
                         'D': escolheDisco;
                         'C': criaDir;
                         'I': informaDirTrab;
                         'T': selecDirTrab;
                         'F': formataDisquete;
                     else
                         begin
                             mensagem (DVOPINV, 1);
                             tratandoDiscos := true;
                         end;
                     end;
                 end;
        end;
end;

end.

