unit dosform;
interface
uses dos, crt,
     dosgeral, dosmsg, sintvox, intervox, readvox;

procedure formataDisquete;

implementation

const
    tamStk = 20000;
    LF = $0a;

    NADA        = 0;
    JOGAENTER   = 1;
    JOGANOME    = 2;
    TERMINAPROG = 3;

var
    segStackNova: word;
    ender32: longint;
    endvideo: word;

    intDosIdleOrig: procedure;
    salvaint10, salvaInt28: pointer;

    acao: byte;
    nomeDisquete: string;
    erroFormat: boolean;

{--------------------------------------------------------}
{          interceptacao da interrupcao de video
{--------------------------------------------------------}

{$f+}

procedure trataIntVideo
                (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word);
          interrupt;

var funcao: byte;
    carac: char;
    ender: word;
    ignora: boolean;
    regs: registers;
    s: string[5];

begin
    funcao := AX shr 8;

    if (funcao = $09) or (funcao = $0a) or
       (funcao = $0e)  then   { escrever caractere no cursor ou tty}
            begin
                 carac := upcase (chr (AX and $ff));
                 s := s + carac;
                 if length (s) > 3 then
                      s := copy (s, 2, 3);

                 if s = '...' then
                     acao := JOGAENTER
                 else
                 if copy (s, 2, 2) = '):' then
                     acao := JOGANOME
                 else
                 if (s = 'S/N') or (s = 'Y/N') then
                     acao := TERMINAPROG;
            end;

    regs.Flags := Flags;
    regs.AX := AX;  regs.BX := BX;  regs.CX := CX;  regs.DX := DX;
    regs.SI := SI;  regs.DI := DI;  regs.DS := DS;  regs.ES := ES;
    regs.BP := BP;
    intr ($7d, regs);

    Flags := regs.Flags;
    Ax := regs.AX;  Bx := regs.BX;  CX := regs.CX;  DX := regs.DX;
    SI := regs.SI;  DI := regs.DI;  DS := regs.DS;  ES := regs.ES;
    BP := regs.BP;
end;

{--------------------------------------------------------}
{                 pega uma linha do video
{--------------------------------------------------------}

function pegaLinhaVideo (dy: integer): string;

var s: string;
    baseHard: word;
    y, ult, i: integer;

    function letela (linha, coluna: integer): char;
    begin
        letela := chr (mem [baseHard: (linha-1) * 160 + (coluna-1) * 2]);
    end;

    procedure pegaBaseHard;
    var c: char;
    begin
        baseHard := $b800;
        s := ' ';
        s := sintAmbiente ('VIDEO');
        c := upcase (s[1]);
        if (c = 'H') or (c = 'M') then baseHard := $b000;
    end;

label achei;

begin
    pegaBaseHard;
    y := wherey;
    s := '';

    for ult := 80 downto 1 do
        if letela (y+dy, ult) <> ' ' then goto achei;

achei:
    if ult < 1 then ult := 0;
    s := '';
    for i := 1 to ult do
       s := s + letela (y+dy, i);

    pegaLinhaVideo := s;
end;

{--------------------------------------------------------}
{           insere caractere no buffer de teclado
{--------------------------------------------------------}

procedure insBufTeclado (c: char);
var regs: registers;
begin
    regs.ah := 5;
    regs.ch := ord(c);
    regs.cl := ord(c);
    intr ($16, regs);
end;

{--------------------------------------------------------}
{        interceptacao da interrupcao de dos-idle
{--------------------------------------------------------}

procedure trataDosIdle; interrupt;
var i: integer;
    s: string;
begin
    asm pushf; end;
    intDosIdleOrig;

    if acao = NADA then exit;    

    asm;
        cli
        mov ax,ss
        mov bx,sp
        mov ss,segStackNova
        mov sp,tamStk
        push ax
        push bx
    end;

    setIntVec ($10, salvaint10);
    asm; sti; end;

    if acao = JOGAENTER then
        insBufTeclado (#$0d)
    else
    if acao = JOGANOME then
        begin
            for i := 1 to length (nomeDisquete) do
                insBufTeclado (nomeDisquete[i]);
            insBufTeclado (#$0d);
        end
    else
    if acao = TERMINAPROG then
        begin
            insBufTeclado ('n');
            insBufTeclado (#$0d);
            s := pegaLinhaVideo (-1);
            if s <> ' ' then
                erroFormat := true;
        end;

    asm; cli; end;
    setIntVec ($10, addr(trataIntVideo));

    asm
        pop ax
        pop ss
        mov sp,ax
        sti
    end;
end;

{$f-}

{--------------------------------------------------------}
{                  formata um disquete
{--------------------------------------------------------}

procedure formataDisquete;
var drive, dens: char;
    c, c2: char;
    s: string;
    regs: registers;
    param: string[4];
    tipoDrive: byte;
    densAlta: boolean;

    stack: array [0..tamStk+16] of byte;

begin
    mensagem (DVINFUNI, 0);
    pegaTeclado (c, c2);
    soletra (c, 1);
    drive := upcase (c);

    if not (drive in ['A','B']) then
        begin
            mensagem (DVDRVINV, 1);    { drive invalido }
            exit;
        end;

    regs.ah := 8;
    regs.dl := ord (drive) - ord ('A');
    intr ($13, regs);
    tipoDrive := regs.bl;

    if (tipoDrive = 2) or (tipoDrive = 4) then    { 2 = 1.2; 4 = 1.44 }
        begin
            mensagem (DVDENSAL, 0);   { posso densidade alta ? }
	    mensagem (DVSIMNAO, 0);
            pegaTeclado (c, c2);
            soletra (c, 1);
            densAlta := upcase(c) <> 'N';
        end;

    mensagem (DVNOMDSK, 0);
    nomeDisquete := '';
    c := editaCampo (nomeDisquete, wherex, wherey, 10, true);
    writeln;

    mensagem (DVINSDSK, 0);    {insira o disquete e tecle enter}
    pegaTeclado (c, c2);
    if (c = #$1b) or (c = #$03) then
        begin
            mensagem (DVFORCAN, 1);   { formatacao cancelada }
            exit;
        end;
    writeln;

    param := '';
    case tipoDrive of
        1: param := '360';
        2: if densAlta then param := '1.2'
                       else param := '360';
        3: param := '720';
        4: if densAlta then param := '1.44'
                       else param := '720';
    end;

    erroFormat := false;

    {--- chama o programa format e simula teclagem dele ---}

    ender32 := longint (seg(stack)) * longint (16) + longint (ofs(stack));
    segStackNova := word (ender32 shr 4) + 1;

    asm cli; end;
    getIntVec ($10, salvaint10);
    setIntVec ($7d, salvaint10);        { substitui interrupcao de video }
    setIntVec ($10, addr(trataIntVideo));
    getIntVec ($28, salvaint28);
    GetIntVec ($28, @IntDosIdleOrig);   { substitui interrupcao Dos Idle }
    SetIntVec ($28, addr (trataDosIdle));
    asm sti; end;

    exec ('c:\command.com', '/c format '+drive +': /u/f:' + param);

    asm cli; end;
    setIntVec ($10, salvaint10);        { restaura interrupcoes originais }
    setIntVec ($28, salvaint28);
    asm sti; end;

    if DosError <> 0 then
        mensagem (DVERRPRG, 1)
    else
    if erroFormat then
        begin
            mensagem (DVPROFOR, 1);
            sintetiza (pegaLinhaVideo (-6));
            sintetiza (pegaLinhaVideo (-5));
            sintetiza (pegaLinhaVideo (-4));
        end
    else
        mensagem (DVFORFIM, 1);
end;

end.
