unit dosgeral;
interface
uses crt, dosmsg, readvox, horavox;

procedure limpaBuf;
procedure pegaTeclado (var c1, c2: char);
function compacta (nome: string): string;

implementation

{--------------------------------------------------------}
{              pega um dado do teclado sem ecoar
{--------------------------------------------------------}

procedure pegaTeclado (var c1, c2: char);
begin
    c2 := ' ';
    c1 := readkey;
    if c1 = #0 then c2 := readkey;

    if (c1 = #0) and (c2 = F8) then
        begin
            falaHora;
            pegaTeclado (c1, c2);
        end;
end;

{--------------------------------------------------------}
{     tira brancos do inicio e do fim de uma cadeia
{--------------------------------------------------------}

function compacta (nome: string): string;
var s: string;
    i: integer;
begin
    s := nome;
    for i := 1 to length (s) do
        s[i] := upcase(s[i]);

    s := s + '*';
    while s[1] = ' ' do
        s := copy (s, 2, length(s)-1);
    s := copy (s, 1, length(s)-1);

    s := '*' + s;
    while s[length(s)] = ' ' do
        s := copy (s, 1, length(s)-1);
    s := copy (s, 2, length(s)-1);
    compacta := s;
end;

{--------------------------------------------------------}
{                limpa o buffer do teclado
{--------------------------------------------------------}

procedure limpaBuf;
var c: char;
begin
    while keypressed do
        c := readkey;
end;

end.
