unit dosimpr;
interface
uses dos, crt, printer, intervox,
     dosgeral, dosmsg, doscopia, readvox, sintvox;

procedure trataImpressao;
procedure fazImpressao (nomearq: string);

implementation

{--------------------------------------------------------}
{                   impressao braille
{--------------------------------------------------------}

procedure chamaProgImpressao (tipo: char; nomeArq: string);
var nomeCom, nome: string;
    nomeProg: string;
begin
    if upcase(tipo) = 'B' then
        nome := 'BRAIVOX.EXE'
    else
        nome := 'IMPRIVOX.EXE';

    nomeCom := getenv ('COMSPEC');
    if nomecom = '' then
        nomeCom := 'C:\COMMAND.COM';

    nomeProg := sintAmbiente ('PGMDOSVOX');
    if nomeProg = '' then
         nomeProg := 'C:\DOSVOX\' + nome
    else
        begin
            if nomeProg [length(nomeProg)] <> '\' then
                nomeProg := nomeProg + '\';
            nomeProg := nomeProg + nome;
        end;

    if nomearq <> '' then
        nomeProg := nomeProg + ' ' + nomearq;

    tradfim;

    SwapVectors;
    Exec(nomecom, '/C ' + nomeProg);
    SwapVectors;

    if tradinic <> 0 then;

    if DosError <> 0 then
        mensagem (DVERRPRG, 1)
    else
        mensagem (DVIMPFIM, 1);
end;

{--------------------------------------------------------}
{                    rotina de impressao
{--------------------------------------------------------}

procedure fazImpressao (nomearq: string);
var
    c, c2: char;

begin
    textBackground (MAGENTA);
    mensagem (DVCOMBRA, 0);
    textBackground (BLACK);

    pegaTeclado (c, c2);
    if c > #$20 then
        soletra (c, 1);

    if upcase(c) in ['B','C'] then
        chamaProgImpressao (c, nomearq)
    else
        begin
            writeln;
            mensagem (DVIMPCAN, 1);
        end;
end;

{--------------------------------------------------------}
{                  trata a impressao
{--------------------------------------------------------}

procedure trataImpressao;
var nomearq: string;
    arq: file;
begin
    mensagem (DVNOMIMP, 0);   { digite o nome do arquivo a imprimir }
    nomearq := lelinha;
    if nomearq = '' then exit;

    assign (arq, nomearq);
    {$i-}  reset (arq);  {$i+}
    if ioresult <> 0 then
        begin
            mensagem (DVARQNEX, 1);
            exit;
        end
    else
        close (arq);

    fazImpressao (nomearq);
end;

end.
