{$M 30000,0,50000}
{--------------------------------------------------------}
{
{    DOSVOX - interface do DOS para sintetizador de voz
{
{    Autor: Jose' Antonio Borges
{
{    Em 14/4/94
{
{--------------------------------------------------------}

program dosvox;

uses dos, crt, readvox,
     dosinter, dosgeral, dosmsg, dosdir, dosarq, dostec, dosdisco,
     dosdos, dosed, dosimpr, dosutil,
     sintVox, traduVox, interVox;

const
     versao = '1.6';

var
    processando: boolean;
    c, c2: char;

{--------------------------------------------------------}
{                    inicializacao
{--------------------------------------------------------}

procedure inicializa;
var i: integer;
     hora, min, seg, cent: word;
     c: char;
     dir, dirdef: string;

begin
     getdir (0, dirdef);

     clrscr;
     textBackground (BLUE);
     writeln ('*****     *****    *****   **   **   *****   **   **');
     writeln ('**  **   **   **  **    *  **   **  **   **   ** ** ');
     writeln ('**   **  **   **  **       **   **  **   **    ***  ');
     writeln ('**   **  **   **   *****   **   **  **   **     *   ');
     writeln ('**   **  **   **       **   ** **   **   **    ***  ');
     writeln ('**  **   **   **  *    **    ***    **   **   ** ** ');
     writeln ('*****     *****    *****      *      *****   **   **');
     writeln;

     sound (600);  delay (100); nosound;
     sound (1200); delay (100); nosound;
     sound (2400); delay (100); nosound;

     inicFala;

     textBackground (RED);
     mensagem (DVSISTOP, 0);   { sistema operacional Dosvox }
     if not keypressed then
         begin
             mensagem (DVVERSAO, 0);   { versao }
             soletra (versao, 1);      { qual versao }
             textBackground (BLACK);
             mensagem (DVNCE, 1);      { NCE/UFRJ }
         end
     else
         begin
             while keypressed do c := readkey;
             writeln;
         end;

     textBackground (BLACK);
     gettime (hora, min, seg, cent);

     if hora < 5 then
         mensagem (DVBOANOI, 2)   { boa noite }
     else if hora < 12 then
         mensagem (DVBOMDIA, 2)   { bom dia }
     else if hora < 18 then
         mensagem (DVBOATAR, 2)   { boa tarde }
     else
         mensagem (DVBOANOI, 2);  { boa noite }

     writeln ('O Kit DOSVOX, contendo o sintetizador LAYCAB, fones de ouvido,');
     writeln ('disquetes do sistema e fitas cassete com o manual de operacao,');
     writeln ('pode ser adquirido no Centro de Distribuicao DOSVOX.');
     writeln;
     writeln ('Para obter o kit: (021)527-8708 - Katia Multimidia M.E.');
     writeln ('Direcao tecnica:  (021)598-3117 - Prof. Jose'' Antonio Borges');
     writeln ('                  Internet : antonio2@nce.ufrj.br');
     writeln ('Duvidas tecnicas: (021)598-3198 - CAEC - UFRJ');
     writeln ('                  Marcelo Pimentel : tpiment@quindim.nc-rj.rnp.br');
     writeln ('                  Renato Costa     : trcosta@quindim.nc-rj.rnp.br');
     writeln ('WWW do Dosvox  :  http://www.nce.ufrj.br/aau/dosvox');
     writeln;

     dir := sintAmbiente('DIRDEFAULT');
     if dir <> '' then
         begin
             {$I-} chdir (dir); {$I+}
             if ioresult <> 0 then;
         end;
end;

{--------------------------------------------------------}
{                          restart
{--------------------------------------------------------}

procedure restart;
var
     cod: string;
     com: INTERCOM;

begin
    inicFala;

    leInterCom (com);    { codigo de retorno }

    with com do
        begin
            if retProg = $EEEE then
                mensagem (DVERINTC, 2)    { erro na intercomunicacao }
            else
                begin
                    if retProg <> 0 then
                        case retProg of
                            8:          mensagem (DVNAOCAB, 2);
                            2, 3, 5, 6: mensagem (DVPRGNAO, 2);
                        else
                            mensagem (DVERRPRG, 2);

                        end;
                end;
        end;

    if com.tipoProg = 'P' then
        begin
            mensagem (DVLEITEL, -1);
            if upcase (leiaTela) = 'P' then chamaDos;
        end
    else
        begin
            writeln;
            mensagem (DVVOLTA, 1);
        end;
end;


{--------------------------------------------------------}
{                  opcao de fim do DOSVOX
{--------------------------------------------------------}

procedure fimDOSVOX;
var 
    c, c2: char;
    com: INTERCOM;

begin
    mensagem (DVCNFFIM, 0);
    pegaTeclado (c, c2);
    if c > ' ' then
        soletra (c, 0);
    writeln;

    if upcase(c) <> 'S' then exit;

    clrscr;
    processando := false;
    mensagem (DVTRAB, 1);
    mensagem (DVTCHAU, 1);
    tradFim;

    leIntercom (com);
    if com.flag = COMOK then
        begin
            com.tipoProg := 'F';
            escIntercom (com);
        end;

    halt;
end;

{--------------------------------------------------------}
{                  mostra o nome do dono
{--------------------------------------------------------}

procedure mostraQuem;
var arq: text;
    nomeArq, s: string;
    i: integer;
begin
    nomeArq := sintAmbiente ('PGMDOSVOX');
    nomeArq := nomeArq + '\DOSVOX.DON';
    assign (arq, nomeArq);
    {$I-} reset (arq);  {$I+}
    if ioresult <> 0 then
        begin
            sintBip; sintBip; sintBip;
            exit;
        end;

    while not eof (arq) do
        begin
            readln (arq, s);
            for i := 1 to length (s) do
                s[i] := chr (ord (s[i]) xor ((i+10) mod 20));
            s := ansiParaPc (s);
            writeln (s);
            sintetiza (s);
        end;

    {$I-} close (arq); {$I+}
    if ioresult <> 0 then;
end;

{--------------------------------------------------------}
{                    programa principal
{--------------------------------------------------------}

    procedure ajudaPrincipal;
    var i: integer;
        c: char;
    begin
        writeln;
        for i := AJUDAPRINC_1 to AJUDAPRINC_99 do
            begin
                mensagem (i, 1);
                if keypressed then
                    begin
                        while keypressed do c := readkey;
                        sintBip;
                        exit;
                    end;
            end;
    end;

begin
     if paramstr(1) = '/restart' then
         restart
     else
         inicializa;

     processando := true;
     while processando do
         begin
             textBackground (BLUE);
             limpabuf;
             mensagem (DVDOSVOX, 0);
             mensagem (DVOQUE, 0);
             textBackground (BLACK);
             pegaTeclado (c, c2);

             if (c = #0) and (c2 = F1) then
                 ajudaPrincipal
             else
             if (c = #0) and (c2 = F9) then
                 begin
                     c := leiaTela;
                     writeln;
                 end
             else
                 begin
                     soletra (c, 1);
                     case upcase(c) of
                         'E': editarLerArquivo ('', 0, true);
                         'L': editarLerArquivo ('', 1, true);
                         'I': trataImpressao;
                         'A': trataArquivos;
                         'S': trataSubDiretorio;
                         'D': trataDiscos;
                         'T': testaTeclado;
                         'P': chamaDOS;
                         'U': chamaUtilitarios;
                         'Q': mostraQuem;
                    #$1b,'F': fimDOSVOX;

                     else
                         mensagem (DVOPINV, 1);
                         if keypressed then
                             begin
                                 while keypressed do c := readkey;
                                 sintBip;
                             end
                         else
                             mensagem (DVSEF1, 1);
                     end;
                 end;
         end;
end.
