{--------------------------------------------------------}
{
{    DOSVOX - unidade de intercomunicacao
{
{    Autor: Jose' Antonio Borges
{
{    Em 31/3/97
{
{--------------------------------------------------------}

unit dosInter;

interface
uses dos;

const
    COMOK = $75;

type 
    PINTERCOM = ^INTERCOM;

    INTERCOM = record
        flag: byte;
        nomeprog: string;
        tipoprog: char;         { P: programa comum, U: utilitario }
        retprog: word;
    end;


procedure inicIntercom (pcom: PINTERCOM);
procedure fimIntercom (pcom: PINTERCOM);
procedure escInterCom (msg: INTERCOM);
procedure leInterCom (var msg: INTERCOM);

implementation

var
    p: pointer;
    salvaInt: pointer;

{--------------------------------------------------------}

procedure inicIntercom (pcom: PINTERCOM);
begin
    getIntVec ($7c, salvaInt);
    setIntVec ($7c, pcom);
    pcom^.flag := COMOK;
end;

{--------------------------------------------------------}

procedure fimIntercom (pcom: PINTERCOM);
begin
    pcom^.flag := $0;
    setIntVec ($7c, salvaInt);
end;

{--------------------------------------------------------}

procedure escInterCom (msg: INTERCOM);
var q: pointer;
begin
    getIntVec ($7c, p);
    if p = q then
        begin
            writeln (#7, #7, #7, #7, #7);
            writeln ('Erro na intercomunicacao de processos');
        end;

    move (msg, p^, sizeof (INTERCOM));
end;

{--------------------------------------------------------}

procedure leInterCom (var msg: INTERCOM);
var s: string;
begin
    getIntVec ($7c, p);
    move (p^, msg, sizeof (INTERCOM));
end;

end.