unit dosmsg;
interface
uses crt, dos, traduvox, intervox, sintvox, lenumstr;

procedure mensagem (n, nlf: integer);
procedure soletra(s: string; nlf: integer);
procedure sintetFala (s: string; nlf: integer);
procedure falaNum (n: longint; nlf: integer);
procedure inicFala;

const
    CTLF1 = #94;
    F1    = #59;
    F8    = #66;
    F9    = #67;
    F10   = #68;
    INS   = #82;
    DEL   = #83;
    HOME  = #71;
    TEND  = #79;
    PGUP  = #73;
    PGDN  = #81;
    CIMA  = #72;
    BAIX  = #80;
    ESQ   = #75;
    DIR   = #77;

const
     DVSISTOP = 0;
     DVVERSAO = 1;
     DVNCE    = 2;
     DVBOMDIA = 3;
     DVBOATAR = 4;
     DVBOANOI = 5;
     DVSEF1   = 6;
     DVDOSVOX = 7;
     DVOQUE   = 8;

     DVAJUD01  = 11;
     DVAJUD02  = 12;
     DVAJUD03  = 13;
     DVAJU03A  = 14;
     DVAJUD04  = 15;
     DVAJUD05  = 16;
     DVAJUD5A  = 17;
     DVAJUD06  = 18;
     DVAJUD07  = 19;
     DVAJUD08  = 20;
     DVAJUD09  = 21;

     AJUDAPRINC_1  = DVAJUD01;
     AJUDAPRINC_99 = DVAJUD09;

     DVOPINV   = 22;
     DVTRAB    = 23;
     DVTCHAU   = 24;

     DVINIED   = 25;
     DVVOLTA   = 26;
     DVCNFFIM  = 27;

     DVESCDIR  = 30;
     DVDIRATU  = 31;
     DVOK      = 32;

     DVUNIATU  = 33;
     DVINFDIS  = 34;
     DVERRUND  = 35;
     DVUNDMUD  = 36;

     DVINFDIR  = 37;
     DVERRMUD  = 38;
     DVOKMUD   = 39;

     DVCANC    = 40;
     DVTENTER  = 41;
     DVDEL     = 42;

     DVDIRCRI  = 43;
     DVERRCRI  = 44;
     DVOKCRI   = 45;

     DVDIRAPA  = 46;
     DVERRAPA  = 47;
     DVOKAPA   = 48;

     DVAJUD10  = 50;
     DVAJUD11  = 51;
     DVAJUD12  = 52;
     DVAJUD13  = 53;
     DVAJUD14  = 54;
     DVAJUD15  = 55;
     DVAJUD16  = 56;
     DVAJUD17  = 57;

     AJUDADIR_1  = DVAJUD10;
     AJUDADIR_99 = DVAJUD17;

     DVDISCOS    = 59;

     DVCTLDSK    = 60;
     DVTAMDSK    = 61;
     DVLIVDSK    = 62;

     DVINFUNI    = 63;
     DVDRVINV    = 64;
     DVDENSAL    = 65;
     DVINSDSK    = 66;
     DVPROFOR    = 67;
     DVNOMDSK    = 68;
     DVFORCAN    = 69;
     DVFORFIM    = 70;

     DVSEMSUB    = 71;
     DVSUBDI1    = 72;
     DVSUBDI2    = 73;

     DVAJUD20    = 74;
     DVAJUD21    = 75;
     DVAJUD22    = 76;
     DVAJUD23    = 77;
     DVAJUD24    = 78;
     DVAJUD25    = 79;
     DVAJUD26    = 80;

     AJUDADSK_1  = DVAJUD20;
     AJUDADSK_99 = DVAJUD26;

     DVTECTAB    = 81;
     DVTECENT    = 82;
     DVTECESC    = 83;
     DVTECBCO    = 84;
     DVTECF10    = 85;
     DVTECINS    = 86;
     DVTECDEL    = 87;
     DVTECHOM    = 88;
     DVTECEND    = 89;
     DVTECPGU    = 90;
     DVTECPGD    = 91;
     DVTECCIM    = 92;
     DVTECBAI    = 93;
     DVTECESQ    = 94;
     DVTECDIR    = 95;

     DVTECLE     = 96;
     DVFIMTEC    = 97;
     DVFIMTST    = 98;

     DVAJUD31     =  99;
     DVAJUD32     = 100;
     DVAJUD33     = 101;
     DVAJUD34     = 102;
     DVAJU34A     = 103;
     DVAJUD35     = 104;
     DVAJUD36     = 105;
     DVAJUD37     = 106;
     DVAJUD38     = 107;
     DVAJUD39     = 108;
     DVAJUD40     = 109;

     AJUDAARQ_1   = DVAJUD31;
     AJUDAARQ_99  = DVAJUD40;

     DVVAZIO      = 111;
     DVARQ1       = 112;
     DVARQ2       = 113;
     DVOPCAO      = 114;
     DVTECBS      = 115;
     DVPROBLE     = 116;

     DVNAOSEL     = 117;
     DVTAMBYT     = 118;
     DVDATCRI     = 119;
     DVHORCRI     = 120;

     DVCNFAPA     = 121;
     DVSIMNAO	  = 122;
     DVFOIAPA     = 123;
     DVPRO        = 124;
     DVDESPRO     = 125;
     DVTROCA      = 126;
     DVTROCAD     = 127;

     DVMASC       = 128;
     DVNMASC      = 129;

     DVAJUD51     = 130;
     DVAJUD52     = 131;
     DVAJUD53     = 132;
     DVAJUD54     = 133;
     DVAJUD55     = 134;

     AJUDACOP_1   = DVAJUD51;
     AJUDACOP_99  = DVAJUD55;

     DVTIPCOP     = 135;
     DVINFDST     = 137;
     DVCANCG      = 138;
     DVNAOPOD     = 139;
     DVERRCOP     = 140;
     DVFOICOP     = 142;
     DVCOMPLE     = 143;

     DVERRLEI     = 144;
     DVERRESC     = 145;
     DVFALESP     = 146;
     DVNOMCOP     = 147;
     DVCNTSEL     = 148;
     DVNOMERR     = 149;
     DVFOIREP     = 150;

     DVNAODIR     = 152;

     DVTECCMD     = 155;

     DVCOMBRA     = 157;
     DVIMPCAN     = 158;
     DVIMPFIM     = 159;
     DVNAODSP     = 160;
     DVIMPCOM     = 161;

     DVLEITEL     = 163;

     DVSHIFT      = 164;
     DVCONTRL     = 165;
     DVNUM        = 166;
     DVNONUM      = 167;
     DVCAPS       = 168;
     DVNOCAPS     = 169;
     DVALT        = 170;

     DVSEMTRD     = 171;

     DVNOMIMP     = 172;
     DVESPIMP     = 173;
     DVARQIMP     = 174;
     DVARQNEX     = 175;

     DVQUERD      = 180;
     DVDIRNSL     = 181;
     DVQSOLET     = 182;
     DVNUMARQ     = 183;
     DVERRDIR     = 184;

     DVTECUTL     = 185;
     DVUTLNAO     = 186;
     DVESCF1      = 187;
     DVERRPRG     = 188;
     DVPRGNAO     = 189;
     DVNAOCAB     = 190;

     DVERINTC     = 191;

implementation

procedure mensagem (n, nlf: integer);
var s, nomearq: string;
    i: integer;
begin
     case n of

     DVSISTOP:  s := 'DVSISTOP|Sistema Operacional DOSVOX';
     DVVERSAO:  s := 'DVVERSAO| - Versao ';
     DVNCE:     s := 'DVNCE   |Nucleo de Computacao Eletronica da UFRJ';
     DVBOMDIA:  s := 'DVBOMDIA|Bom dia ! ';
     DVBOATAR:  s := 'DVBOATAR|Boa tarde !';
     DVBOANOI:  s := 'DVBOANOI|Boa noite !';
     DVSEF1:    s := 'DVSEF1  |Aperte F1 para ajuda.';
     DVDOSVOX:  s := 'DVDOSVOX|DOSVOX - ';
     DVOQUE:    s := 'DVOQUE  |O que voce deseja ? ';

     DVAJUD01:  s := 'DVAJUD01|As opcoes dos DOSVOX sao:';
     DVAJUD02:  s := 'DVAJUD02|        e - editar texto';
     DVAJUD03:  s := 'DVAJUD03|        i - imprimir';
     DVAJU03A:  s := 'DVAJU03A|        l - leitor vox';
     DVAJUD04:  s := 'DVAJUD04|        a - arquivos';
     DVAJUD05:  s := 'DVAJUD05|        d - discos';
     DVAJUD5A:  s := 'DVAJUD5A|        s - subdiretorios';
     DVAJUD06:  s := 'DVAJUD06|        t - testar o teclado';
     DVAJUD07:  s := 'DVAJUD07|        u - utilitarios falados';
     DVAJUD08:  s := 'DVAJUD08|        p - executar um programa comum do DOS';
     DVAJUD09:  s := 'DVAJUD09|        f - fim do DOSVOX';

     DVOPINV:   s := 'DVOPINV |Opcao invalida.';
     DVTRAB:    s := 'DVTRAB  |Trabalhar com voce e'' sempre bom !';
     DVTCHAU:   s := 'DVTCHAU |Tchau !';

     DVINIED:   s := 'DVINIED |Chamando editor.';
     DVVOLTA:   s := 'DVVOLTA |Voltando ao DOSVOX.';
     DVCNFFIM:  s := 'DVCNFFIM|Confirma fim do DOSVOX (S/N) ? ';

     DVESCDIR:  s := 'DVESCDIR|Subdiretorios - ';
     DVDIRATU:  s := 'DVDIRATU|O diretorio atual e'' ';

     DVAJUD10:  s := 'DVAJUD10|Use as setas para selecionar';
     DVAJUD11:  s := 'DVAJUD11|Depois tecle:';
     DVAJUD12:  s := 'DVAJUD12|        c - para criar novo subdiretorio';
     DVAJUD13:  s := 'DVAJUD13|        a - apagar o subdiretorio falado';
     DVAJUD14:  s := 'DVAJUD14|        t - seleciona-lo como diretorio de trabalho';
     DVAJUD15:  s := 'DVAJUD15|        i - obter dados sobre o diretorio atual';
     DVAJUD16:  s := 'DVAJUD16|        s - sair do diretorio de trabalho';
     DVAJUD17:  s := 'DVAJUD17|Teclando ESCAPE voce retorna ao DOSVOX.';

     DVOK:      s := 'DVOK    |Ok ! ';

     DVUNIATU:  s := 'DVUNIATU|A unidade de trabalho e'' ';
     DVINFDIS:  s := 'DVINFDIS|Informe novo disco de trabalho: ';
     DVERRUND:  s := 'DVERRUND|Nao consegui mudar de disco. Sinto muito.';
     DVUNDMUD:  s := 'DVUNDMUD|Disco de trabalho mudado para ';

     DVINFDIR:  s := 'DVINFDIR|Informe o novo diretorio de trabalho: ';
     DVERRMUD:  s := 'DVERRMUD|Desculpe mas nao consegui trocar para o diretorio pedido.';
     DVOKMUD:   s := 'DVOKMUD |Ok, troquei diretorio de trabalho';
     DVCANC:    s := 'DVCANC  |<Entrada cancelada>';
     DVTENTER:  s := 'DVTENTER|';    {tecle normalmente e depois ENTER}
     DVDEL:     s := 'DVDEL   |';    {'DEL';}

     DVDIRCRI:  s := 'DVDIRCRI|Nome do diretorio a criar: ';
     DVERRCRI:  s := 'DVERRCRI|Desculpe mas nao consegui criar o diretorio pedido.';
     DVOKCRI:   s := 'DVOKCRI |Ok, criei o diretorio !';

     DVDIRAPA:  s := 'DVDIRAPA|Nome do diretorio a apagar: ';
     DVERRAPA:  s := 'DVERRAPA|Desculpe: nao consegui apagar o diretorio pedido.';
     DVOKAPA:   s := 'DVOKAPA |Ok, apaguei o diretorio !';

     DVAJUD20:  s := 'DVAJUD20|As opcoes de manuseio de disco sao:';
     DVAJUD21:  s := 'DVAJUD21|        d - escolher disco para trabalho';
     DVAJUD22:  s := 'DVAJUD22|        e - verificar o espaco do disco de trabalho';
     DVAJUD23:  s := 'DVAJUD23|        f - formatar um disquete';
     DVAJUD24:  s := 'DVAJUD24|        i - informar diretorio de trabalho';
     DVAJUD25:  s := 'DVAJUD25|        t - selecionar diretorio de trabalho';
     DVAJUD26:  s := 'DVAJUD12|        c - para criar novo subdiretorio';

     DVDISCOS:  s := 'DVDISCOS|Discos - ';

     DVCTLDSK:  s := 'DVCTLDSK|Controle de disco - ';
     DVTAMDSK:  s := 'DVTAMDSK|Tamanho do disco em K: ';
     DVLIVDSK:  s := 'DVLIVDSK|Espaco livre em K: ';

     DVINFUNI:  s := 'DVINFUNI|Qual a unidade de disquete a formatar, A ou B ? ';
     DVDRVINV:  s := 'DVDRVINV|Drive invalido';
     DVDENSAL:  s := 'DVDENSAL|Posso usar densidade alta';
     DVINSDSK:  s := 'DVINSDSK|Insira o disquete e tecle Enter...';
     DVPROFOR:  s := 'DVPROFOR|Problemas na formatacao.  Vou ler a tela.';
     DVNOMDSK:  s := 'DVNOMDSK|Informe o nome do disquete (ate'' 10 letras): ';
     DVFORCAN:  s := 'DVFORCAN|Formatacao cancelada.';
     DVFORFIM:  s := 'DVFORFIM|Disquete bem formatado.';

     DVSEMSUB:  s := 'DVSEMSUB|Nao existem subdiretorios aqui';
     DVSUBDI1:  s := 'DVSUBDI1|Subdiretorios: Use as setas para selecionar';
     DVSUBDI2:  s := 'DVSUBDI2|Depois tecle sua opcao';

     DVTECLE:   s := 'DVTECLE |Aperte as teclas e eu falarei.';
     DVFIMTEC:  s := 'DVFIMTEC|O teste sera'' terminado quando voce apertar ESCAPE';

     DVTECBS:   s := 'DVTECBS |<backspace>';
     DVTECTAB:  s := 'DVTECTAB|<tab>';
     DVTECENT:  s := 'DVTECENT|<enter>';
     DVTECESC:  s := 'DVTECESC|<escape>';
     DVTECBCO:  s := 'DVTECBCO|<barra de espacos>';
     DVTECF10:  s := 'DVTECF10|f10';
     DVTECINS:  s := 'DVTECINS|<ins>';
     DVTECDEL:  s := 'DVTECDEL|<del>';
     DVTECHOM:  s := 'DVTECHOM|<home>';
     DVTECEND:  s := 'DVTECEND|<end>';
     DVTECPGU:  s := 'DVTECPGU|<page up>';
     DVTECPGD:  s := 'DVTECPGD|<page down>';
     DVTECCIM:  s := 'DVTECCIM|<cima>';
     DVTECBAI:  s := 'DVTECBAI|<baixo>';
     DVTECESQ:  s := 'DVTECESQ|<esquerda>';
     DVTECDIR:  s := 'DVTECDIR|<direita>';

     DVFIMTST:  s := 'DVFIMTST|O teste esta'' encerrado.';

     DVAJUD31:  s := 'DVAJUD31|Usando as setas voce selecionara'' um arquivo.';
     DVAJUD32:  s := 'DVAJUD32|Para operar com o ultimo que foi falado, as opcoes sao:';
     DVAJUD33:  s := 'DVAJUD33|      e -> editar o arquivo';
     DVAJUD34:  s := 'DVAJUD34|      i -> imprimir';
     DVAJU34A:  s := 'DVAJU34A|      l -> leitor vox';
     DVAJUD35:  s := 'DVAJUD35|      a -> apagar';
     DVAJUD36:  s := 'DVAJUD36|      d -> dados sobre o arquivo';
     DVAJUD37:  s := 'DVAJUD37|      p -> proteger ou desproteger';
     DVAJUD38:  s := 'DVAJUD38|      n -> trocar o nome';
     DVAJUD39:  s := 'DVAJUD39|      c -> para tirar uma copia dele';
     DVAJUD40:  s := 'DVAJUD40|      g -> selecionar grupos de arquivos';

     DVVAZIO:   s := 'DVVAZIO |Nao existe nenhum arquivo neste diretorio.';
     DVARQ1:    s := 'DVARQ1  |Arquivos: use as setas para selecionar.';
     DVARQ2:    s := 'DVARQ2  |Depois tecle sua opcao.';

     DVOPCAO:   s := 'DVOPCAO | -> opcao ';
     DVPROBLE:  s := 'DVPROBLE|Cuidado, houve problemas no disco !';
     DVNAOSEL:  s := 'DVNAOSEL|Nao posso fazer: nao existe nenhum arquivo selecionado';

     DVTAMBYT:  s := 'DVTAMBYT|Tamanho em bytes: ';
     DVDATCRI:  s := 'DVDATCRI|Data de criacao: ';
     DVHORCRI:  s := 'DVHORCRI|Hora de criacao: ';

     DVCNFAPA:  s := 'DVCNFAPA|Confirma apagamento de ';
     DVSIMNAO:  s := 'DVSIMNAO| (s/n) ? ';
     DVFOIAPA:  s := 'DVFOIAPA|Apaguei o arquivo ';

     DVPRO:     s := 'DVPRO   |Arquivo esta'' protegido para regravacao';
     DVDESPRO:  s := 'DVDESPRO|Arquivo esta'' desprotegido';
     DVTROCA:   s := 'DVTROCA |Informe o novo nome do arquivo ';
     DVTROCAD:  s := 'DVTROCAD|Troquei o nome do arquivo para ';

     DVMASC:    s := 'DVMASC  |Informe a mascara de selecao, p. ex., *.TXT';
     DVNMASC:   s := 'DVNMASC |Troquei a mascara de selecao de arquivos para ';

     DVAJUD51:  s := 'DVAJUD51|Para produzir copias voce tem as seguintes opcoes:';
     DVAJUD52:  s := 'DVAJUD52|       d -> copiar este arquivo para outro diretorio';
     DVAJUD53:  s := 'DVAJUD53|       t -> copiar todos os arquivos para outro diretorio';
     DVAJUD54:  s := 'DVAJUD54|       r -> criar replica deste arquivo';
     DVAJUD55:  s := 'DVAJUD55|       m -> mover todos os arquivos para outro diretorio';

     DVTIPCOP:  s := 'DVTIPCOP|Qual o tipo de copia ? ';

     DVINFDST:  s := 'DVINFDST|Informe o diretorio destino: ';
     DVCANCG:   s := 'DVCANCG |Certo, operacao foi cancelada';
     DVNAOPOD:  s := 'DVNAOPOD|O arquivo nao pode ser copiado sobre si mesmo !';
     DVERRCOP:  s := 'DVERRCOP|Sinto muito, deu erro no disco, portanto nao copiei.';
     DVFOICOP:  s := 'DVFOICOP| copiado.';
     DVCOMPLE:  s := 'DVCOMPLE|Perfeito, acabei.';

     DVERRLEI:  s := 'DVERRLEI|Houve um erro de leitura no arquivo original.';
     DVERRESC:  s := 'DVERRESC|Nao consegui escrever este arquivo.';
     DVFALESP:  s := 'DVFALESP|Nao existia espaco suficiente para escrever.';
     DVNOMCOP:  s := 'DVNOMCOP|Informe nome do arquivo replica: ';
     DVCNTSEL:  s := 'DVCNTSEL|Continue selecionando ou tecle ESC.';
     DVNOMERR:  s := 'DVNOMERR|Esse nome que voce escolheu nao e'' valido.';
     DVFOIREP:  s := 'DVFOIREP| foi replicado.';

     DVNAODIR:  s := 'DVNAODIR|Nao existem subdiretorios aqui.';

     DVTECCMD:  s := 'DVTECCMD|Tecle o comando.';

     DVCOMBRA:  s := 'DVCOMBRA|Deseja impressao comum ou braille ? ';
     DVIMPCAN:  s := 'DVIMPCAN|A impressao foi cancelada.';
     DVIMPFIM:  s := 'DVIMPFIM|Impressao finalizada.';
     DVNAODSP:  s := 'DVNAODSP|A impressora nao esta'' disponivel.';
     DVIMPCOM:  s := 'DVIMPCOM|Iniciando impressao comum.';

     DVLEITEL:  s := 'DVLEITEL|Tecle ESC para voltar ao DOSVOX.';

     DVSHIFT:   s := 'DVSHIFT |<Shift> ';
     DVCONTRL:  s := 'DVCONTRL|<Control> ';
     DVNUM:     s := 'DVNUM   |<Num.Lock> ';
     DVNONUM:   s := 'DVNONUM |<Sem Num.Lock> ';
     DVCAPS:    s := 'DVCAPS  |<Caps Lock> ';
     DVNOCAPS:  s := 'DVNOCAPS|<Sem Caps Lock> ';
     DVALT:     s := 'DVALT   |<Alt> ';

     DVSEMTRD:  s := 'DVSEMTRD|Erro no diretorio do tradutor.';

     DVNOMIMP:  s := 'DVNOMIMP|Digite o nome do arquivo a imprimir: ';
     DVESPIMP:  s := 'DVESPIMP|Qual o espacejamento (1, 2 ou 3) ? ';
     DVARQIMP:  s := 'DVARQIMP|Informe o nome do arquivo de impressora: ';
     DVARQNEX:  s := 'DVARQNEX|Arquivo nao existe, sinto muito.';

     DVQUERD:   s := 'DVQUERD |Ele vai ser o novo diretorio de trabalho ';
     DVDIRNSL:  s := 'DVDIRNSL|Nao posso fazer: nao existe subdiretorio selecionado';
     DVQSOLET:  s := 'DVQSOLET|Quer que soletre';

     DVNUMARQ:  s := 'DVNUMARQ|Numero de arquivos neste diretorio: ';
     DVERRDIR:  s := 'DVERRDIR|Erro: este diretorio nao esta'' acessivel';

     DVTECUTL:  s := 'DVTECUTL|Qual a letra do utilitario ? ';
     DVUTLNAO:  s := 'DVUTLNAO|Nao existe utilitario com esta letra.';
     DVESCF1:   s := 'DVESCF1 |Tecle F1 para ajuda ou ESC para cancelar.';
     DVERRPRG:  s := 'DVERRPRG|Erro na execucao do programa.';
     DVPRGNAO:  s := 'DVPRGNAO|Programa nao encontrado.';
     DVNAOCAB:  s := 'DVNAOCAB|Programa nao coube na memoria.';

     DVERINTC:  s := 'DVERINTC|Erro na intercomunicacao de processos';

     end;

     nomearq := copy (s, 1, 8);
     while nomearq[length(nomearq)] = ' ' do
         nomearq := copy (nomearq, 1, length(nomearq)-1);
     s := copy (s, 10, length (s)-9);

     if nlf >= 0 then
         write (s);
     for i := 1 to nlf do
         writeln;

     sintSom (nomearq);
end;

{--------------------------------------------------------}

procedure soletra(s: string; nlf: integer);
var i: integer;
begin
     write (s);
     for i := 1 to nlf do
         writeln;
     for i := 1 to length (s) do
         sintSoletra (s[i]);
end;

{--------------------------------------------------------}

procedure sintetFala (s: string; nlf: integer);
var fonemas: string;
    i: integer;
begin
     write (s);
     for i := 1 to nlf do
         writeln;

    if length (s) > 0 then
        begin
            compilaFonemas (s, fonemas);
            falaFonemas (fonemas, true);
        end;
end;

{--------------------------------------------------------}

procedure falaNum (n: longint; nlf: integer);
var c: char;
    s: string;
    i: integer;
begin
    write (n);
    for i := 1 to nlf do
         writeln;
    falaNumeroConv (numeroParaString (n), MASCULINO);
end;

{--------------------------------------------------------}

procedure inicFala;
var dir: string;
begin
    sintinic (0, 'DIRDOSVOX');
    if tradInic <> 0 then
        mensagem (DVSEMTRD, 1);
end;

end.
