{--------------------------------------------------------}
{
{    Busca e Substituicao de Cadeias
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edBusca;

interface
uses
    crt, dos,
    sintVox, readVox,
    edvars, edmensag, edAcento, edTela, edLinha;

procedure cmdBusca;
procedure buscaPalavra;
procedure buscaDeNovo;
procedure trocaPalavra;

implementation

{--------------------------------------------------------}

Procedure buscaPalavra;
var
    linha: string;
    x, i, j: integer;
    peganome: boolean;
begin
    fala ('EDTXTPRC');

    buscado := maiuscAnsi (semAcentos (leLinha));
    if buscado = '' then
        begin
            fala ('EDDESIST');
            exit;
        end;

    for i := posy to maxlinhas do
        begin
            linha := maiuscAnsi (semAcentos (texto [i]^));
            x := pos (buscado, linha);
            if x > 0 then
                begin
                    fala ('EDTXTENC');
                    posy := i;
                    posx := x;
                    exit;
                end;
        end;

    fala ('EDTXNENC');
end;

{--------------------------------------------------------}

Procedure buscaDeNovo;
var i, x: integer;
    linha: string;
begin
    for i := posy+1 to maxlinhas do
        begin
            linha := maiuscAnsi (semAcentos (texto [i]^));
            x := pos (buscado, linha);
            if x > 0 then
                begin
                    fala ('EDTXTENC');
                    posy := i;
                    posx := x;
                    exit;
                end;
        end;

    fala ('EDTXNENC');
end;

{--------------------------------------------------------}

procedure trocaPalavra;
var c: char;
    buscado, aTrocar: string;
    nl: integer;
    achou: boolean;

    function trocaTexto (nl: integer): boolean;
    var linha, saida: string;
        tamb: integer;
        x, salva: integer;
    begin
        linha := texto[nl]^;
        saida := '';
        tamb := length (buscado);

        trocaTexto := false;
        while linha <> '' do
            begin
                x := pos (buscado, linha);
                if x <= 0 then
                    begin
                        saida := saida + linha;
                        linha := '';
                    end
                else
                    begin
                        trocaTexto := true;
                        delete (linha, x, tamb);
                        if x > 1 then
                            saida := saida + copy (linha, 1, x-1);
                        saida := saida + atrocar;
                        linha := copy (linha, x, length(linha)-x+1);
                    end;
            end;

        salva := posy;
        posy := nl;
        removeLinha (false);
        insereLinha (saida, false);
        posy := salva;
    end;


begin
    fala ('EDTXTPRC');

    buscado := leLinha;
    if buscado = '' then
        begin
            fala ('EDDESIST');
            exit;
        end;

    fala ('EDINFTXT');
    aTrocar := leLinha;

    repeat
        fala ('EDTODBLK');
        c := leTeclaMaiusc;
        if c = #$1b then
            begin
                fala ('EDDESIST');
                exit;
            end;
    until c in ['T', 'B'];

    achou := false;
    if c = 'T' then
        begin
            for nl := 1 to maxLinhas do
                if trocaTexto (nl) then achou := true;
        end

    else
        begin
            if iniBloco > 0 then
                for nl := iniBloco to fimBloco do
                    if trocaTexto (nl) then achou := true;
        end;

    escreveTela;

    if achou then
        fala ('EDTXTTRC')
    else
        fala ('EDTXNENC');
end;

{--------------------------------------------------------}

procedure cmdBusca;
var
    tecla: char;
label deNovo;
begin

deNovo:
    fala ('EDOPCAO');   { qual opcao ? }
    tecla := leTeclaMaiusc;
    escreveTela;

    case tecla of

       'P': buscaPalavra;
       'N': buscaDeNovo;
       'T': trocaPalavra;

       #$0: begin
                ajuda ('EDAJBU', 4);
                goto deNovo;
            end;
      #$1b: begin
                fala ('EDDESIST');
                exit;
            end
    else
        sintBip;
    end;

    escreveTela;
end;

end.
