{--------------------------------------------------------}
{
{    Configuracoes
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edConfig;

interface
uses
    crt, dos, Playvox,
    sintVox, traduVox, interVox, readVox,
    edvars, edMensag, edTela;

procedure cmdConfig;
procedure acionaFala;
procedure acionaInsert;
procedure acionaAcentos;
procedure acionaSoletragem;
procedure acionaQuebraAuto;
procedure trocaVeloc;

implementation

{--------------------------------------------------------}

procedure acionaFala;
begin
    mudo := not mudo;
    if mudo then
        fala ('EDFALDLG')
    else
        fala ('EDFALACI');
end;

{--------------------------------------------------------}

procedure acionaInsert;
begin
    enterInsLinha := not enterInsLinha;
    if enterInsLinha then
        fala ('EDENTINS')
    else
        fala ('EDENTNIN');
end;

{--------------------------------------------------------}

procedure acionaAcentos;
begin
    acentuando := not acentuando;
    if acentuando then
        fala ('EDACENT')
    else
        fala ('EDNACENT');
end;

{--------------------------------------------------------}

Procedure acionaSoletragem;
begin
    soletrando := not soletrando;
    if soletrando then
        fala ('EDSOLETR')
    else
        fala ('EDNSOLET');
end;

{--------------------------------------------------------}

procedure acionaQuebraAuto;
begin
    quebraAuto := not quebraAuto;
    if quebraAuto then
        fala ('EDQAUTO')
    else
        fala ('EDNQAUTO');
end;

{--------------------------------------------------------}

procedure trocaVeloc;
var
    c, c2: char;
    veloc, erro: integer;
    s: string;

begin
    fala ('EDVELOC');  { Qual a velocidade de 1 a 4 ? }
    leTecla (c, c2);
    veloc := ord (c) and $f;
    if (veloc < 0) or (veloc > 4) then veloc := 0;  {default}

    tradFim;
    selecTipoFonemas (veloc);
    if tradInic <> 0 then
        begin
            tradFim;
            selecTipoFonemas (0);
            if tradInic <> 0 then;
        end;

    rapidinho := (c = '4');
end;

{--------------------------------------------------------}

procedure cmdConfig;
var
    tecla: char;
label deNovo;
begin

deNovo:
    fala ('EDOPCAO');   { qual opcao ? }
    tecla := leTeclaMaiusc;
    escreveTela;

    case tecla of

        'F': acionaFala;
        'I': acionaInsert;
        'A': acionaAcentos;
        'S': acionaSoletragem;
        'Q': acionaQuebraAuto;
        'V': trocaVeloc;

       #$0: begin
                ajuda ('EDAJCF', 7);
                goto deNovo;
            end;
      #$1b: begin
                fala ('EDDESIST');
                exit;
            end
    else
        sintBip;
    end;

    escreveTela;
end;


end.
