{--------------------------------------------------------}
{
{    Controle da Fala
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edFala;

interface
uses
    crt, dos,
    sintVox, traduVox, interVox, readVox, playVox,
    edVars, edTela, edMensag;

Procedure cmdFala;
Procedure falaPalavra;
Procedure falaRestoLinha;
Procedure falaRestoTexto;

implementation

{--------------------------------------------------------}

function isolaPalavra: string;
Var
    i, j  : Byte;
    f, palavra : String;

const
    alfa: set of char = ['a'..'z','A'..'Z', #128..#255];
    numeros: set of char = ['0'..'9'];
Begin
    f := texto [posy]^;

    palavra :='';
    isolaPalavra := '';
    If (posx > length(f)) or (length(f)=0)
        Then exit;

    j := posx;
    while (j < length(f)) and (f[j] = ' ')  Do
        inc (j);

    if not (f[j] in alfa) then
        begin
           If f[j] in numeros then
               Begin
                   while (j<=length(f)) and (f[j] in numeros) do
                       begin
                           palavra := palavra + f[j];
                           inc(j);
                       end;
               End
           Else
               begin
                   palavra := f[j];
                   inc(j);
               end;
        end
    else
        begin
            while  (j<=length(f)) and (f[j] in alfa) do
                begin
                    palavra:=palavra+ f[j];
                    inc (j);
                end;
        end;

    isolaPalavra := palavra;
    posx := j;
end;

{--------------------------------------------------------}

procedure soletraPalavra;
var palavra: string;
    i: integer;
begin
    if mudo then exit;

    palavra := isolaPalavra;
    sintRitmado (true);
    for i := 1 to length(palavra) do
        sintCarac (palavra[i]);
    sintRitmado (false);
end;

{--------------------------------------------------------}

procedure falaPalavra;
var palavra: string;
    c: char;
begin
    if mudo then exit;

    if posx <= 80 then
        gotoxy (posx, 15)
    else
        gotoxy (80, 15);

    palavra := isolaPalavra;
    if palavra = ' ' then
        sintclek
    else
        if length (palavra) > 0 then
            sintetiza (palavra)
        else
            sintBip;
end;

{--------------------------------------------------------}

procedure falaRestoLinha;
begin
    if mudo then exit;

    if length (texto [posy]^) = 0 then
        sintBip
    else
        while (posx <= length (texto [posy]^)) and (not keypressed) do
                falaPalavra;
end;

{--------------------------------------------------------}

procedure falaInicioLinha;
var salva: integer;
begin
    if mudo then exit;

    if length (texto [posy]^) = 0 then
        sintBip
    else
        begin
            salva := posx;
            posx := 1;
            while (posx+1 < salva) and (not keypressed) do
                    falaPalavra;
            posx := salva;
        end;
end;

{--------------------------------------------------------}

Procedure falaRestoTexto;
var c: char;
label fim;
begin
    if mudo then exit;

    repeat
        if posx <= 80 then
            gotoxy (posx, 15)
        else
            gotoxy (80, 15);

        if posy > maxLinhas then
            begin
                fala ('EDFIMTEX');
                goto fim;
            end
        else
            while (posx <= length (texto [posy]^)) and
                                  (not keypressed) do
                falaPalavra;

        if not keypressed then
            begin
                posy := posy + 1;
                posx := 1;
                if posy <= maxLinhas then sintClek;
                escreveTela;
            end;

    until keypressed;

fim:
    if posy > maxLinhas then
        begin
            posy := maxLinhas;
            posx := length (texto [posy]^)+1;
        end;
    while keypressed do
        c := readkey;
end;

{--------------------------------------------------------}

Procedure cmdFala;
var
    tecla: char;
label deNovo;
begin

deNovo:
    fala ('EDOPCAO');   { qual opcao ? }
    tecla := leTeclaMaiusc;
    escreveTela;

    case tecla of

       #$0d, 'F',
             'L': falaRestoLinha;
             'T': falaRestoTexto;
             'I': falaInicioLinha;

       #$0: begin
                ajuda ('EDAJFA', 4);
                goto deNovo;
            end;
      #$1b: begin
                fala ('EDDESIST');
                exit;
            end
    end;

    escreveTela;
end;

end.
