{--------------------------------------------------------}
{
{    Programa Editor Vocal
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{    Versao 3.0 de 25/4/96
{
{--------------------------------------------------------}

program Edivox;
uses
    crt,
    horaVox, traduVox, interVox, sintVox, readVox,
    videoIso,

    edVars,     { variaveis e acesso basico a elas }
    edMensag,   { mensagens }
    edFala,     { controle da fala }
    edTela,     { manuseio de tela }
    edCursor,   { manipulacao de caracteres e cursor }
    edAcento,   { tratamento dos acentos }
    edLinha,    { tratamento de linhas }
    edArq,      { funcoes de arquivos}
    edBloco,    { blocos de linhas }
    edBusca,    { busca e substituicao de textos }
    edMargem,   { margens e tabulacoes }
    edConfig;   { configuracao }


{-----------------------------}

procedure inicializa;
var
     erro: integer;
     i,j, h, m, s1, s2, c1, c2 : word;
     c: char;

begin

    checkbreak := false;
    sintInic (0, 'DIREDIVOX');
    dirSomEdivox := sintAmbiente ('DIREDIVOX');

    tamMaxLinha := 79;
    desenhaTelaInicial;

    while keypressed do c := readkey;

    nomeArq := '';
    if paramCount >= 1 then
        nomeArq := paramStr(1);

    if tradInic <> 0 then
        fala ('EDSEMTRD');
    fala ('EDMSGINI');

    margdir := 72;
    margesq := 1;
    ntabs := 0;

    mudo := false;
    enterInsLinha := false;
    soletrando := true;
    acentuando := true;
    quebraAuto := true;
    rapidinho := false;

    statusTecControle := 0;
    maxlinhas := 0;
    buscado := #0;
    linhaRemovida := '';

    salvaCurx := 1;
    salvaCury := 1;

    deslocEsqTela := 0;
    corLetra := LIGHTGRAY;
    corFundo := BLACK;

    inicBloco;
end;

{--------------------------------------------------------}

procedure comandoInterativo;
var tecla: char;

label deNovo;

begin
deNovo:
    fala ('EDCOMAND');   { comando ? }
    tecla := leTeclaMaiusc;
    escreveTela;

    case tecla of
       'C': cmdCursor;
       'L': cmdLinha;
       'P': cmdBusca;
       'M': cmdMargem;
       'A': cmdArquivo;
       'B': cmdBloco;
       'F': cmdFala;
       'I': cmdConfig;
       'E': trataLetrasEspeciais;
       #$0: begin
                ajuda ('EDAJIN', 10);
                goto deNovo;
            end;
      #$1b: begin
                fala ('EDDESIST');
                exit;
            end
    else
        sintBip;
    end;

    escreveTela;
end;

{--------------------------------------------------------}

procedure trataPFeALT (tecla: char);
Begin
    Case tecla of
        F1 :     falaPalavra;
        CTLF1 :  falaRestoLinha;
        ALTF1 :  falaRestoTexto;

        F2 :     salvaArquivo (1, maxlinhas, true);
        F3 :     begin
                     trocaarquivo;
                     inicBloco;
                 end;

        F4 :     acionaSoletragem;
        CTLF4 :  trocaVeloc;

        F5 :     buscaPalavra;
        CTLF5 :  buscaDeNovo;
        F6:      trocaPalavra;
        F7:      trocaTamTela;

        F8:      falaHora;
        CTLF8:   falaDia;

        F9:      comandoInterativo;
        F10:     pedeMargens;

        CTLPGUP: inicioTexto;
        CTLPGDN: fimTexto;

        CTLDIR:  palavraDir (true);
        CTLESQ:  palavraEsq (true);
        CTLHOME: setaVertCima;
        CTLEND:  setaVertBaixo;

        INS :    acionaInsert;
        DEL :    removeProxLetra;

        DIR :    setaDir;
        ESQ :    setaEsq;

        CIMA:    if (statusTecControle and CONTROL) <> 0 then
                     SetaVertCima
                 else
                     SetaCima;

        BAIX:    if (statusTecControle and CONTROL) <> 0 then
                     SetaVertBaixo
                 else
                     Setabaixo;

        HOME: coluna1;
        TEND: ultimaColuna;
        PGUP: voltaPag;
        PGDN: pulaPag;

        else  { of case }

            sintBip;
            sintBip;
    end;

    escreveTela;
End;

{--------------------------------------------------------}

function criaLinhaNaMargem: string;
var s: string;
    i: integer;
begin
    s := '';
    for i := 1 to margEsq-1 do
        s := s + ' ';

    if margEsq <= 1 then
        begin
            sintClek;
            sintClek;
        end;

    criaLinhaNaMargem := s;
end;

{--------------------------------------------------------}

procedure proxLinhaNaMargem;
var salva: string;

begin
    setaBaixo;
    salva := texto[posy]^;
    while length (salva) < margEsq do
        salva := salva + ' ';
    removeLinha (false);
    insereLinha (salva, false);
    posx := margEsq;
end;

{--------------------------------------------------------}

procedure trataControls (tecla: char);
begin
    case tecla of
        ^a : acionaAcentos;

        ^y : removelinha (true);
        ^d : apagaFimlinha;
        ^s : apagaInicioLinha;

        ^q : quebralinha;

        ^j:  { control enter }
             insereLinha (criaLinhaNaMargem, true);

        ^m : {tratamento de enter}
             if enterInsLinha or (posy = maxLinhas) then
                 insereProxLinha (criaLinhaNaMargem, true)
             else
                 proxLinhaNaMargem;

        ^I : tabula;
        ^t : tabulaInsere;
        ^h : removeLetra;
        ^b : trataBloco;

        ^l : informaLinha;
        ^c : informaColuna;

        ^u : voltaRemovida;
        ^e : trataLetrasEspeciais;
        ^x : gravaETermina;
        ^g : posicEmLinha;

        CTLBS:   apagaPalavra;

    else { case }
                       
        sintBip;   { teclas invalidas dao dois bips }
        sintBip;
    end;

    escreveTela;
end;

{--------------------------------------------------------}

function confirmasaida: boolean;
var resp: char;

begin
    confirmaSaida := true;

    repeat
        fala ('EDCNFSAI');     {--- confirma saida ---}
        resp := leTeclaMaiusc;
    until resp in ['S','N'];

    if resp = 'N' then
        begin
            confirmaSaida := false;
            exit;
        end;

    repeat                     {--- ve se quer salvar o arquivo ---}
        delay (500);
        fala ('EDQUERSV');
        resp := leTeclaMaiusc;
    until resp in ['S', 'N'];

    if resp = 'S' then
        salvaArquivo (1, maxLinhas, true);
end;

{--------------------------------------------------------}

var tecla, tecla2: char;
    progAcabou: boolean;

begin
{$R+}
    inicializa;
    if not abrearquivo then
        terminaPrograma;

    escreveTela;

    progAcabou := false;
    repeat
        repeat
            trataStatusTec (statusTecControle);
            gotoxy (posx-deslocEsqTela, 15);
        until keypressed;

        pegaTeclado (tecla, tecla2);

        case tecla of
             '''', '^', '~', '`','"':
                         if acentuando then
                             trataAcentos (tecla)
                         else
                             insereLetra (tecla);
             #32..#126,
             #128..#255: insereLetra (keybBr (tecla));

             #27 :       progAcabou := confirmasaida;

             #0:         trataPFeALT (tecla2);

             #1..#31, #127:
                         trataControls (tecla);
        End;

    Until progAcabou;

    terminaPrograma;
end.
