{--------------------------------------------------------}
{
{    Rotinas de tratamento de linhas do EDIVOX
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edLinha;

interface
uses
    crt, dos,
    edvars, sintVox, edMensag, edTela;

procedure cmdLinha;
Procedure insereLinha (conteudo : String; falando: boolean) ;
Procedure insereProxLinha (conteudo : String; falando: boolean) ;
Procedure Removelinha (falando: boolean);
procedure voltaRemovida;
procedure quebraLinha;

implementation

{--------------------------------------------------------}

Procedure insereLinha (conteudo : String; falando: boolean) ;
Var
    i : word;
    pont : frase;
    c: char;
Begin
    For i := maxLinhas downto posy  Do
        texto [i+1] := texto [i];

    inc (maxlinhas);

    getmem (texto[posy], length(conteudo) + 1);
    texto [posy]^ := conteudo;

    posx := length (conteudo)+1;

    if falando then
        fala ('EDLINSER');

    if maxavail < 10000 then
        repeat
            limpaBufTec;
            fala ('EDMEMPEQ');
            c := readkey;
        until c = #$0d;

    if posy < inibloco then
        inibloco := inibloco + 1;
    if posy <= fimbloco then
        fimbloco := fimbloco + 1;
    if posy < salvaCury then
        salvaCury := salvaCury + 1;
end;

{--------------------------------------------------------}

Procedure insereProxLinha (conteudo : String; falando: boolean) ;
Var
    i : word;
    pont : frase;
Begin
    posy := posy + 1;
    insereLinha (conteudo, false);

    if falando and (posy < maxlinhas) then
        fala ('EDLINSER');
end;

{-----------------------------}

Procedure Removelinha (falando: boolean);
Var
    p: word;
Begin
    linhaRemovida := texto[posy]^;

    If posy< maxlinhas then
        begin
            freemem (texto [posy], length (texto[posy]^)+1);
            dec (maxlinhas);
            For p :=posy to maxlinhas Do
                texto [p]:=texto [p+1];
       end
    else
        If posy = maxlinhas Then
            begin
                freemem (texto [posy], length (texto[posy]^)+1);
                getmem (texto [posy], 1);
                texto [posy]^ := '';
                if falando then sintBip;
            end;

    posx := 1;
    if falando then
        fala ( 'EDLINREM' );

    if posy < iniBloco then
        iniBloco := iniBloco - 1;
    if posy <= fimBloco then
        fimBloco := fimBloco - 1;

    if posy = salvaCury then
        begin
            salvaCurx := 1;
            salvaCury := 1;
        end;

    if posy < salvaCury then
        salvaCury := salvaCury - 1;
end;

{--------------------------------------------------------}

procedure voltaRemovida;
begin
    if linhaRemovida = '' then
        sintBip
    else
        begin
            insereLinha (linhaRemovida, true);
            linhaRemovida := '';
        end;
end;

{--------------------------------------------------------}

procedure juntaLinhas;
var linha: string;
    salvax, salvay: integer;
begin
    if posy < maxlinhas then
       begin
           if length (texto [posy]^) + length (texto [posy+1]^) > 250 then
               begin
                   fala ('EDLGRAND');
                   exit;
               end;

           linha := texto [posy]^ + ' ' + texto [posy+1]^;
           salvax := posx;  salvay := posy;
           removeLinha (false);
           removeLinha (false);
           insereLinha (linha, false);
           posx := salvax;  posy := salvay;
           fala ('EDLINJUN');
       end;
end;

{-----------------------------}

Procedure quebraLinha;
Var
   linha1, linha2: String;
Begin
    If posx = 1
       Then Begin
            insereLinha ('', false);
            posy := posy + 1;
            fala ('EDLINQUE');
            end
       Else
       If posx > length ( texto[posy]^) then
           juntaLinhas
       Else
           begin
               linha1 := copy (texto [posy]^, 1, posx-1);
               linha2 := copy (texto [posy]^, posx,
                                      length (texto[posy]^)-posx+1);
               removeLinha (false);
               insereLinha (linha2, false);
               insereLinha (linha1, false);
               posy := posy + 1;
               posx := 1;
               fala ('EDLINQUE');
            end;
end;

{--------------------------------------------------------}

procedure cmdLinha;
var
     tecla: char;
label deNovo;

begin

deNovo:
    fala ('EDOPCAO');   { qual opcao ? }
    tecla := leTeclaMaiusc;
    escreveTela;

    case tecla of

       'I': insereLinha ('', true);
  'A', 'N': insereProxLinha ('', true);
       'R': Removelinha (true);
       'V': voltaRemovida;
       'Q': quebraLinha;
       'J': juntaLinhas;

       #$0: begin
                ajuda ('EDAJLI', 7);
                goto deNovo;
            end;
      #$1b: begin
                fala ('EDDESIST');
                exit;
            end
    end;

    escreveTela;
end;

end.
