{--------------------------------------------------------}
{
{    Margens e Tabulacoes
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edMargem;

interface
uses
    crt, dos,
    sintVox, readVox,
    edvars, edlinha, edMensag, edTela, edcursor;

procedure cmdMargem;

procedure tabula;
procedure tabulaInsere;
procedure removeTabulacoes;
procedure insereTabulacao;
Procedure pedeMargens;

implementation

{--------------------------------------------------------}

procedure tabula;
var i, salva: integer;
    s: string;
label achou;
begin
    for i := 1 to ntabs do
       if tabs[i] > posx then
           begin
               posx := tabs[i];
               goto achou;
           end;

    if posx < margEsq then
        posx := margEsq
    else
        posx := ((posx+3) div 4) * 4 + 1;
    sintClek;

achou:
    s := texto[posy]^;
    if length (s) < (posx-1) then
        begin
            while length (s) < (posx-1) do
                s := s + ' ';
            salva := posx;
            removeLinha (false);
            insereLinha (s, false);
            posx := salva;
        end;
end;

{--------------------------------------------------------}

procedure tabulaInsere;
var posfinal, i, salva: integer;
    s: string;
label achou;
begin
    posFinal := ((posx+3) div 4) * 4 + 1;
    sintClek;
    sintClek;

    s := texto[posy]^;
    for i := posx+1 to posFinal do
        insert (' ', s, posx);

    removeLinha (false);
    insereLinha (s, false);
    posx := posFinal;
end;

{--------------------------------------------------------}

procedure removeTabulacoes;
begin
    ntabs := 0;
    fala ('EDTABCAN');  { tabulacoes canceladas }
end;

{--------------------------------------------------------}

procedure insereTabulacao;
var i, j: integer;
label fim;
begin
    for i := 1 to ntabs do
        begin
            if tabs[i] = posx then exit;
            if tabs[i] > posx then goto fim;
        end;

    i := ntabs+1;

fim:
    for j := ntabs downto i do
        tabs [j+1] := tabs [j];
    tabs[i] := posx;
    ntabs := ntabs + 1;

    fala ('EDTABINS');   { tabulacao inserida }
end;

{--------------------------------------------------------}

Procedure pedeMargens;
var
    v: integer;
    salvaMe, salvaMd: integer;
    s: string;
begin
    salvaMe := margEsq;
    salvaMd := margDir;

    repeat
        fala ('EDDIGME');
        xreadInt (v);
        if v > 0 then margEsq := v
                 else margEsq := 1;

        fala('EDDIGMD');
        xreadInt (v);
        if v > 0 then margDir := v
                 else margDir := 72;

        if margDir <= margEsq then
            begin
                fala ('EDMARINV');
                margEsq := salvaMe;
                margDir := salvaMd;
                exit;
            end;

    until margDir > margEsq;

    fala ('EDMARACI');

    if length(texto[posy]^) < margEsq-1 then
        begin
            posx := length (texto[posy]^)+1;
            while length(texto[posy]^) < margEsq-1 do
                insereLetra(' ');
        end;
end;

{--------------------------------------------------------}

procedure cmdMargem;
var
     tecla: char;
label deNovo;
begin

deNovo:
    fala ('EDOPCAO');   { qual opcao ? }
    tecla := leTeclaMaiusc;
    escreveTela;

    case tecla of

       'R': removeTabulacoes;
       'T': insereTabulacao;
       'M': pedeMargens;

       #$0: begin
                ajuda ('EDAJMA', 4);
                goto deNovo;
            end;
      #$1b: begin
                fala ('EDDESIST');
                exit;
            end
    end;

    escreveTela;
end;

end.
