{--------------------------------------------------------}
{
{    Controle da Fala
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edMensag;

interface
uses
    crt, dos,
    edvars, sintVox, traduVox, interVox, readVox, playvox;

function textoAjuda (f: string): string;
Procedure Fala (f: String);
function leTeclaMaiusc: char;

{--------------------------------------------------------}

implementation

var rapida, condensada: boolean;

function textoAjuda (f: string): string;
begin
    if f = 'EDAJIN1' then textoAjuda := 'Sao os seguintes:'
    else
    if f = 'EDAJIN2' then textoAjuda := '  C - comandos de cursor'
    else
    if f = 'EDAJIN3' then textoAjuda := '  L - linha'
    else
    if f = 'EDAJIN4' then textoAjuda := '  P - procura de textos'
    else
    if f = 'EDAJIN5' then textoAjuda := '  M - margem'
    else
    if f = 'EDAJIN6' then textoAjuda := '  A - arquivos'
    else
    if f = 'EDAJIN7' then textoAjuda := '  B - blocos de linhas'
    else
    if f = 'EDAJIN8' then textoAjuda := '  F - acionamento da fala'
    else
    if f = 'EDAJIN9' then textoAjuda := '  I - instalacao'
    else
    if f = 'EDAJIN10' then textoAjuda := '  E - letras especiais'
    else

    if f = 'EDAJLI1' then textoAjuda := 'Os comandos de linha sao:'
    else
    if f = 'EDAJLI2' then textoAjuda := '  I - insere uma linha acima'
    else
    if f = 'EDAJLI3' then textoAjuda := '  A - insere uma linha abaixo'
    else
    if f = 'EDAJLI4' then textoAjuda := '  R - remove linha'
    else
    if f = 'EDAJLI5' then textoAjuda := '  V - volta linha removida'
    else
    if f = 'EDAJLI6' then textoAjuda := '  Q - quebra linha em duas'
    else
    if f = 'EDAJLI7' then textoAjuda := '  J - junta duas linhas'
    else

    if f = 'EDAJCU1' then textoAjuda := 'Os comandos de cursor sao:'
    else
    if f = 'EDAJCU2' then textoAjuda := '  - - inicio do texto'
    else
    if f = 'EDAJCU3' then textoAjuda := '  + - fim do texto'
    else
    if f = 'EDAJCU4' then textoAjuda := '  A - avanca paragrafo'
    else
    if f = 'EDAJCU5' then textoAjuda := '  R - recua paragrafo'
    else
    if f = 'EDAJCU6' then textoAjuda := '  P - posiciona em certa linha'
    else
    if f = 'EDAJCU7' then textoAjuda := '  I - apaga inicio da linha'
    else
    if f = 'EDAJCU8' then textoAjuda := '  F - apaga fim da linha'
    else
    if f = 'EDAJCU9' then textoAjuda := '  L - informa linha'
    else
    if f = 'EDAJCU10' then textoAjuda := '  C - informa coluna'
    else
    if f = 'EDAJCU11' then textoAjuda := '  M - memoriza posicao do cursor'
    else
    if f = 'EDAJCU12' then textoAjuda := '  V - volta cursor `a posicao memorizada'
    else

    if f = 'EDAJBL1' then textoAjuda := 'Os comandos de bloco sao:'
    else
    if f = 'EDAJBL2' then textoAjuda := '  I - inicio do bloco'
    else
    if f = 'EDAJBL3' then textoAjuda := '  F - fim do bloco'
    else
    if f = 'EDAJBL4' then textoAjuda := '  M - move o bloco'
    else
    if f = 'EDAJBL5' then textoAjuda := '  C - copia o bloco'
    else
    if f = 'EDAJBL6' then textoAjuda := '  A - adiciona bloco a um arquivo'
    else
    if f = 'EDAJBL7' then textoAjuda := '  O - ordena o bloco'
    else
    if f = 'EDAJBL8' then textoAjuda := '  R - remove o bloco'
    else
    if f = 'EDAJBL9' then textoAjuda := '  D - desmarca o bloco'
    else
    if f = 'EDAJBL10' then textoAjuda := '  L - le arquivo gerando bloco'
    else
    if f = 'EDAJBL11' then textoAjuda := '  G - grava o bloco em arquivo'
    else
    if f = 'EDAJBL12' then textoAjuda := '  E - embeleza o bloco'
    else
    if f = 'EDAJBL13' then textoAjuda := '  P - paragrafo vira bloco'
    else
    if f = 'EDAJBL14' then textoAjuda := '  J - justifica paragrafo do cursor'
    else

    if f = 'EDAJMA1' then textoAjuda := 'Os comandos de margem sao:'
    else
    if f = 'EDAJMA2' then textoAjuda := '  M - informa margens'
    else
    if f = 'EDAJMA3' then textoAjuda := '  T - nova coluna de tabulacao'
    else
    if f = 'EDAJMA4' then textoAjuda := '  R - remove todas tabulacoes'
    else

    if f = 'EDAJAR1' then textoAjuda := 'Os comandos de arquivos sao:'
    else
    if f = 'EDAJAR2' then textoAjuda := '  I - informa nome do arquivo'
    else
    if f = 'EDAJAR3' then textoAjuda := '  S - salva arquivo e continua'
    else
    if f = 'EDAJAR4' then textoAjuda := '  N - edita um novo arquivo'
    else
    if f = 'EDAJAR5' then textoAjuda := '  C - salva como outro arquivo'
    else
    if f = 'EDAJAR6' then textoAjuda := '  F - salva e fim'
    else
    if f = 'EDAJAR7' then textoAjuda := '  A - abandona sem gravar'
    else
    if f = 'EDAJAR8' then textoAjuda := '  X - exporta formato IBM'
    else

    if f = 'EDAJBU1' then textoAjuda := 'Os comandos de busca sao:'
    else
    if f = 'EDAJBU2' then textoAjuda := '  P - procura texto'
    else
    if f = 'EDAJBU3' then textoAjuda := '  N - busca de novo'
    else
    if f = 'EDAJBU4' then textoAjuda := '  T - troca palavras por outras'
    else

    if f = 'EDAJFA1' then textoAjuda := 'Os comandos de fala sao:'
    else
    if f = 'EDAJFA2' then textoAjuda := '  I - fala inicio da linha'
    else
    if f = 'EDAJFA3' then textoAjuda := '  L - fala resto da linha'
    else
    if f = 'EDAJFA4' then textoAjuda := '  T - fala resto do texto'
    else

    if f = 'EDAJCF1' then textoAjuda := 'Os comandos de configuracao sao:'
    else
    if f = 'EDAJCF2' then textoAjuda := '  F - fala'
    else
    if f = 'EDAJCF3' then textoAjuda := '  I - insercao com Enter'
    else
    if f = 'EDAJCF4' then textoAjuda := '  A - acentuacao'
    else
    if f = 'EDAJCF5' then textoAjuda := '  S - soletragem'
    else
    if f = 'EDAJCF6' then textoAjuda := '  Q - quebra de linha automatica'
    else
    if f = 'EDAJCF7' then textoAjuda := '  V - velocidade'
    else

    if f = 'EDAJEM1' then textoAjuda := 'Os comandos de embelezamento sao:'
    else
    if f = 'EDAJEM2' then textoAjuda := '  C - centra bloco'
    else
    if f = 'EDAJEM3' then textoAjuda := '  M - acerta margens'
    else
    if f = 'EDAJEM4' then textoAjuda := '  A - alinha com as margens'
    else
    if f = 'EDAJEM5' then textoAjuda := '  T - tabula pela esquerda o bloco'
    else
    if f = 'EDAJEM6' then textoAjuda := '  I - intenta o bloco'
    else
    ;
end;

{--------------------------------------------------------}

Procedure Fala (f: String);
var arq: file;
    s: string;
begin
    gotoxy (1, 9);
    textBackground (BLUE);
    s := '----- erro de mensagem ???? ----';

    if f = 'EDMSGINI' then s := 'EDIVOX 3.0 - Autor: Marcelo Pimentel'
    else
    if f = 'EDSEMTRD' then s := 'Erro no diretorio do tradutor'
    else
    if f = 'EDQUERSV' then s := 'Quer salvar o arquivo (s/n) ? '
    else
    if f = 'EDFIMPRC' then s := 'Fim do EDIVOX - Autor: Marcelo Pimentel'
    else
    if f = 'EDDIGNOM' then s := 'Qual o nome do Arquivo? '
    else
    if f = 'EDREESCR' then s := 'Arquivo ja'' existe, reescreve (s/n) ?'
    else
    if f = 'EDARQGRV' then s := 'Arquivo gravado'
    else
    if f = 'EDARTRUN' then s := 'Arquivo enorme foi truncado'
    else
    if f = 'EDARQNOV' then s := 'Arquivo novo'
    else
    if f = 'EDARQCRG' then s := 'Arquivo carregado'
    else
    if f = 'EDQUERSN' then s := 'Quer salvar este texto (s/n)'
    else
    if f = 'EDERRESC' then s := 'Erro de escrita no arquivo'
    else
    if f = 'EDERRLEI' then s := 'Erro de leitura no arquivo'
    else
    if f = 'EDLINHA'  then s := 'Linha: '
    else
    if f = 'EDCOLUNA' then s := 'Coluna: '
    else
    if f = 'EDDEL'    then s := 'DEL'
    else
    if f = 'EDFALDLG' then s := 'Fala desligada'
    else
    if f = 'EDFALACI' then s := 'Fala acionada'
    else
    if f = 'EDLINREM' then s := 'Linha removida'
    else
    if f = 'EDCNFSAI' then s := 'Confirma saida (s/n) ? '
    else
    if f = 'EDDIGMD'  then s := 'Informe a margem direita: '
    else
    if f = 'EDDIGME'  then s := 'Informe a margem esquerda: '
    else
    if f = 'EDMARINV' then s := 'Margem invalida'
    else
    if f = 'EDMARACI' then s := 'Margem acionada'
    else
    if f = 'EDACENT'  then s := 'Acentuacao acionada'
    else
    if f = 'EDNACENT' then s := 'Acentuacao desligada'
    else
    if f = 'EDINITEX' then s := 'Inicio do texto'
    else
    if f = 'EDFIMTEX' then s := 'Fim do texto'
    else
    if f = 'EDBLKMOV' then s := 'Bloco movido'
    else
    if f = 'EDBLKCPY' then s := 'Bloco copiado'
    else
    if f = 'EDBLKCRG' then s := 'Bloco carregado'
    else
    if f = 'EDBLKADC' then s := 'Bloco adicionado'
    else
    if f = 'EDBLKORD' then s := 'Bloco ordenado'
    else
    if f = 'EDBLKCNT' then s := 'Bloco centrado'
    else
    if f = 'EDBLKTAB' then s := 'Bloco tabulado'
    else
    if f = 'EDBLKMRG' then s := 'Bloco margeado'
    else
    if f = 'EDBLKALI' then s := 'Bloco alinhado'
    else
    if f = 'EDBLKPAR' then s := 'Bloco paragrafo'
    else
    if f = 'EDBLKINV' then s := 'Bloco invalido'
    else
    if f = 'EDBLKREM' then s := 'Bloco removido'
    else
    if f = 'EDCMDBLK' then s := 'Comando de bloco: '
    else
    if f = 'EDBLKMAR' then s := 'Bloco marcado'
    else
    if f = 'EDINCOMP' then s := 'Bloco incompleto'
    else
    if f = 'EDINIBLK' then s := 'Inicio do bloco'
    else
    if f = 'EDFIMBLK' then s := 'Fim do bloco'
    else
    if f = 'EDJUSTIF' then s := 'Trecho justificado'
    else
    if f = 'EDPOSINV' then s := 'Posicao de bloco invalida'
    else
    if f = 'EDBLKDSM' then s := 'Bloco desmarcado'
    else
    if f = 'EDLINQUE' then s := 'Linha quebrada'
    else
    if f = 'EDAPAINI' then s := 'Apagado a esquerda'
    else
    if f = 'EDAPAFIM' then s := 'Apagado a direita'
    else
    if f = 'EDLINSER' then s := 'Linha nova'
    else
    if f = 'EDLGRAND' then s := 'Linha excederia 150 letras, nao juntei'
    else
    if f = 'EDLINJUN' then s := 'Linhas juntadas'
    else
    if f = 'EDTXTPRC' then s := 'Qual o texto ? '
    else
    if f = 'EDTXTENC' then s := 'Texto encontrado'
    else
    if f = 'EDTXNENC' then s := 'Texto nao encontrado'
    else
    if f = 'EDTXTTRC' then s := 'Texto trocado'
    else

    if f = 'EDARQNAO' then s := 'Arquivo nao existe'
    else
    if f = 'EDNOME'   then s := 'Nome deste arquivo: '
    else
    if f = 'EDFORTXT' then s := 'Usa acentuacao internacional (s/n) '
    else

    if f = 'EDLINGRA' then s := 'Linhas grandes foram divididas'
    else
    if f = 'EDNOMGRV' then s := 'Nome do arquivo a gravar: '
    else
    if f = 'EDESCCAN' then s := 'Gravacao de arquivo cancelada'
    else
    if f = 'EDDGNLIN' then s := 'Digite o numero da linha: '
    else
    if f = 'EDLINAO'  then s := 'Linha nao existe'
    else
    if f = 'EDVELOC'  then s := 'Qual a velocidade, de 1 a 4 ? '
    else
    if f = 'EDCOLMAR' then s := 'Informe a coluna da esquerda: '
    else
    if f = 'EDNCLIND' then s := 'Numero de colunas a indentar: '
    else
    if f = 'EDDESIST' then s := 'Desistiu... '
    else
    if f = 'EDTABINS' then s := 'Tabulacao inserida'
    else
    if f = 'EDTABCAN' then s := 'Tabulacoes canceladas'
    else
    if f = 'EDENTINS' then s := 'Enter vai inserir linha'
    else
    if f = 'EDENTNIN' then s := 'Enter nao vai inserir linha'
    else
    if f = 'EDSOLETR' then s := 'Soletragem acionada'
    else
    if f = 'EDNSOLET' then s := 'Soletragem desligada'
    else
    if f = 'EDMEMPEQ' then s := 'Memoria muito reduzida.  Tecle ENTER.'
    else
    if f = 'EDINFTXT' then s := 'Informe o novo texto: '
    else
    if f = 'EDTODBLK' then s := 'Todo texto (T) ou bloco (B): '
    else
    if f = 'EDCOMAND' then s := 'Qual comando? '
    else
    if f = 'EDOPCAO'  then s := 'Qual opcao? '
    else
    if f = 'EDQAUTO'  then s := 'Quebra automatica ligada'
    else
    if f = 'EDNQAUTO' then s := 'Quebra automatica desligada'

    else
    if f = 'EDNUM'    then s := 'Num Lock ligado'
    else
    if f = 'EDNONUM'  then s := 'Num Lock desligado'
    else
    if f = 'EDCAPS'   then s := 'Caps Lock ligado'
    else
    if f = 'EDNOCAPS' then s := 'Caps Lock desligado'

    ;

    write (s);
    textBackground (BLACK);
    clreol;

    assign (arq, dirSomEdivox + '\' + f + '.WAV');
    {$I-}  reset (arq);  {$I+}
    if ioresult <> 0 then
         sintetiza (s)
    else
        begin
            close (arq);

            pegaModoFala (rapida, condensada);
            falaRapida (false);
            falaCondensada (false);

            sintSom (f);
            falaRapida (rapida);
            falaCondensada (condensada);
        end;
end;

{--------------------------------------------------------}

function leTeclaMaiusc: char;
var tecla, tecla2: char;
begin
    leTecla (tecla, tecla2);
    leTeclaMaiusc := upcase (tecla);
end;

end.
