{--------------------------------------------------------}
{
{    Variaveis globais do EDIVOX
{
{    Autor: Marcelo Luis Pinheiro
{
{    Orientador Academico: Jose' Antonio Borges
{
{    Em 10/12/93
{
{--------------------------------------------------------}

Unit edVars;

interface

const
    versao = '3.3';
    MAXLINHASTEXTO = 7000;

type
    Frase = ^string;
    TipoTexto = Array [1..MAXLINHASTEXTO] of Frase;

var
    Texto : TipoTexto;           { o texto em si }
    maxLinhas: integer;          { quantas linhas preenchidas }

    posx, posy: integer;         { posicao do cursor no texto }
    margesq, margdir: integer;   { margens }
    inibloco, fimbloco: integer; { posicao do bloco marcado }
    novoini: integer;

    mudo,                        { totalmente calado }
    soletrando,                  { soletragem acionada }
    acentuando,                  { acentuacao acionada }
    enterInsLinha,               { enter insere linha }
    quebraAuto,                  { quebra automatica ao fim da linha }
    rapidinho: boolean;          { fala sintetica rapida }

    nomeArq : string;            { nome do arquivo editado }
    buscado : string;            { texto em busca }
    linhaRemovida: string;       { ultima linha removida }
    statusTecControle: word;     { status das teclas shift, control, etc }

    deslocEsqTela: word;         { deslocamento durante a escrita }
    videoVGA: boolean;           { gerador do video pode ser carregado }
    tamMaxLinha: integer;        { tamanho da linha para certa resolucao }
    corLetra, corFundo: integer; { cores de tracado }

    salvaCurx,                   { posicao salva do cursor }
    salvaCury: integer;

    ntabs: integer;              { numero de tabulacoes marcadas }
    tabs: array [1..30] of byte; { tabulacoes }

    dirSomEdivox: string;        { diretorio de mensagens do Edivox }

{--------------------------------------------------------}

const
    F1   = #59;
    F2   = #60;
    F3   = #61;
    F4   = #62;
    F5   = #63;
    F6   = #64;
    F7   = #65;
    F8   = #66;
    F9   = #67;
    F10  = #68;

    INS  = #82;
    DEL  = #83;
    HOME = #71;
    TEND = #79;
    PGUP = #73;
    PGDN = #81;
    CIMA = #72;
    BAIX = #80;
    ESQ  = #75;
    DIR  = #77;

    BS   = #08;

    CTLENTER = #10;

    CTLPGUP = #132;
    CTLPGDN = #118;
    CTLESQ  = #115;
    CTLDIR  = #116;

    CTLHOME = #119;
    CTLEND  = #117;

    CTLF1   = #94;
    CTLF2   = #95;
    CTLF4   = #97;
    CTLF5   = #98;
    CTLF8   = #101;
    CTLF9   = #102;
    CTLF10  = #103;

    ALTF1   = #104;

    CTLBS   = #127;

    CONTROL = 4;

implementation
end.
