{--------------------------------------------------------}
{
{     Cria texto para documentacao de um modelo do Cartex
{
{     Autor: Jose' Antonio Borges
{
{     Em 03/09/97
{
{--------------------------------------------------------}

program docartex;
uses crt, dos, sintvox, intervox, readvox, playvox;
var
    nomearq, nomesai: string;
    arq, arqsai: text;
    texto: array [1..500] of ^string;
    lin, col: integer;
    maxLin, iniTab: integer;
    lido: string;

{--------------------------------------------------------}

procedure xwrite (s: string);
var i: integer;
begin
    write (s);
    for i := 1 to length (s) do
        if s[i] = ':' then s[i] := ' ';
    sintetiza (s);
end;

{--------------------------------------------------------}

procedure xwriteln (s: string);
begin
    xwrite (s);
    writeln;
end;

{--------------------------------------------------------}

procedure cancela;
begin
    textBackground (RED);
    xwriteln ('Programa cancelado');
    textBackground (BLACK);
    tradFim;
    halt;
end;

{--------------------------------------------------------}

procedure abreArquivos;
var resp: char;
begin
    writeln;

    xwrite ('Nome do arquivo de entrada: ');
    nomearq := lelinha;
    if nomearq = '' then
        cancela;

    assign (arq, nomearq);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        begin
            xwriteln ('Arquivo nao existe');
            cancela;
        end;

    xwrite ('Nome do arquivo de saida: ');
    nomesai := lelinha;
    assign (arqsai, nomesai);
    {$I-} rewrite (arqsai); {$I+}
    if ioresult <> 0 then
        begin
            xwriteln ('Arquivo nao pode ser criado');
            cancela;
        end;

    lin := 0;
    col := 0;
    lido := '';
    maxlin := 0;
    iniTab := 9999;
end;

{--------------------------------------------------------}

procedure carregaTexto;
begin
    maxLin := 0;
    while not eof (arq) do
        begin
            maxLin := maxLin + 1;
            new (texto[maxLin]);
            readln (arq, texto[maxLin]^);
        end;

    close (arq);
end;

{--------------------------------------------------------}

function upper (s: string): string;
var s2: string;
    i: integer;
begin
    s2 := '';
    for i := 1 to length (s) do
        s2 := s2 + upcase (s[i]);
    upper := s2;
end;

{--------------------------------------------------------}

procedure substitui;

    procedure substNome;
    var s, subst: string;
    begin
        delete (lido, 1, 1);
        s := '';
        while (lido <> '') and (lido[1] <> '}') do
            begin
               s := s + lido[1];
               delete (lido, 1, 1);
            end;

        if lido = '' then
            begin
                str (lin, s);
                xwriteln ('Faltou fechar chave na linha ' + s);
                close (arqSai);
                cancela;
            end;

       delete (lido, 1, 1);

       if upper (s) = 'DATA' then
           writeln ('Data -> utiliza a do sistema')
       else
           begin
               xwriteln (s);
               writeln (arqSai, s);
           end;
    end;


begin
    while lido <> '' do
        begin
            if lido [1] = '{' then
                substNome
            else
                delete (lido, 1, 1);
        end;
end;

{--------------------------------------------------------}

var c: char;
begin
    sintinic (0, '');
    if tradinic <> 0 then
        begin
            writeln ('Erro no diretorio do tradutor DOSVOX');
            halt;
        end;
    falaCondensada (true);

    clrscr;
    textBackGround (BLUE);
    write ('Projeto DOSVOX - ');
    xwriteln ('Documentador de modelos de cartas padronizadas');
    textBackGround (BLACK);
    writeln;

    abreArquivos;
    carregaTexto;
    writeln (arqSai, 'Documentao do arquivo ', nomearq);
    writeln (arqSai);

    lin := 1;

    while lin < maxLin do
       begin
           lido := texto [lin]^;
           if copy (lido, 1, 2) = '{*' then
               begin
                   delete (lido, 1, 2);
                   if lido [length(lido)] = '}' then
                       delete (lido, length(lido), 1);
                   if lido [length(lido)] = '*' then
                       delete (lido, length(lido), 1);

                   textBackGround (MAGENTA);
                   xwriteln (lido);
                   writeln (arqSai, 'Descrio: ', lido);
                   writeln (arqSai);
                   textBackGround (BLACK);
                   writeln;
               end
           else
           if upper (lido) = '{INITAB}' then
               writeln (arqsai, '* Campos a seguir so repetidos')
           else
           if upper (lido) = '{FIMTAB}' then
               writeln (arqsai, '* Fim dos campos repetidos')
           else
               substitui;

           lin := lin + 1;
       end;

    close (arqsai);

    sintBip;
    sintBip;
    writeln;
    xwriteln ('Fim do Documentador');
    clreol;

    tradFim;
end.
