{--------------------------------------------------------}
{
{    Programa de impressao do DOSVOX
{
{    Impressao sem formatacao
{
{    Autor: Jose' Antonio Borges
{
{    Em marco/96
{
{--------------------------------------------------------}

unit impComum;
interface
uses dos, crt, sintvox, intervox, readvox, lenumstr,
     impvars, impmsg, impsaida;

procedure imprimeOriginal;
procedure imprimeBinario;

implementation

{--------------------------------------------------------}
{    le uma linha original, quebrando se muito grande
{--------------------------------------------------------}

procedure leLinhaArq (var s: string; maxCaracLinha: integer);
var nc, lidos: integer;
    c: char;
begin
    s := sobraLinha;
    sobraLinha := '';

    nc := 0;
    repeat
        if eof (arqentra) then
            begin
                acabouArq := true;
                exit;
            end;

            {$I-} blockread (arqentra, c, 1, lidos);  {$I+}
            if ioresult <> 0 then
                mensagem ('IMERRLEI');

            if (c = #$1a) or (lidos = 0) then
                begin
                    acabouArq := true;
                    exit;
                end;

            if c = #$0d then         { formato DOS }
                begin
                    {$I-} blockread (arqentra, c, 1, lidos);  {$I+}
                    if ioresult <> 0 then;
                    exit;
                end
            else
            if c = #$0a then exit;   { formato UNIX }

            nc := nc + 1;
            if nc > maxCaracLinha then
                sobraLinha := '|' + c
            else
                s := s + c;

    until nc > maxCaracLinha;
end;

{--------------------------------------------------------}
{                       pula paginas
{--------------------------------------------------------}

procedure pulaPaginas;
var p, l: integer;
    s: string;
begin
    sobraLinha := '';
    for p := 2 to pagInicial do
        begin
            for l := margemSup to margemInf do
                leLinhaArq (s, margemDir-margemEsq+1);
        end;

    numPag := pagInicial-1;
end;

{--------------------------------------------------------}
{            traduz uma linha para a saida
{--------------------------------------------------------}

procedure preparaLinha (s: string; var prep: string);
var i: integer;
begin
    prep := '';
    for i := 2 to margemEsq do
        prep := prep + ' ';

    for i := 1 to length (s) do
        prep := prep + tabCarac[s[i]]^;

    if nlinPag = margemInf then
        prep := prep + tabCarac [#$0d]^
    else
        prep := prep + pulaLinha;
end;

{--------------------------------------------------------}
{         imprime texto com um minimo de controle
{--------------------------------------------------------}

procedure imprimeOriginal;
var s, prep: string;
    i: integer;
label espacejou;
begin
    acabouArq := false;
    prtOk := true;
    nlinPag := 0;
    numPag := 0;

    pulaPaginas;

    while (not acabouArq) and prtOk do
        begin
            prtOk := trataCabecalho;

            if prtOk and (not acabouArq) then
                begin
                    leLinhaArq (s, margemDir-margemEsq+1);
                    if (s = '<p>') or (s = '<P>') then
                        begin
                            s := '';
                            nlinPag := 9999;
                        end;

                    preparaLinha (s, prep);
                    prtOk := jogaImpressora (prep);
                    nlinPag := nlinPag + 1;

                    preparaLinha (#$0d, prep);
                    for i := 2 to espacejamento do
                        begin
                            if prtok then prtOk := trataCabecalho;
                            if nlinPag = 0 then
                                begin
                                     nlinPag := 1;
                                     goto espacejou;
                                end;
                            if prtOk then prtok := jogaImpressora (prep);
                            nlinPag := nlinPag + 1;
                        end;
espacejou:
                end;
        end;
end;

{--------------------------------------------------------}
{           imprime texto sem controlar traducao
{--------------------------------------------------------}

procedure imprimeBinario;
var c, c2: char;
    nlidos: word;
    lido: string;

label cancelou;

begin
    pagInicial := 1;      { libera mecanismo de impressao }
    numPag := pagInicial;

    nlidos := 1;
    while (not eof (arqentra)) and (ioresult = 0) and (nlidos > 0) do
        begin
            {$I-} blockread (arqentra, lido[1], 128, nlidos); {$I-}
            lido[0] := chr(nlidos);
            if nlidos > 0 then
                if not jogaImpressora (lido) then
                    goto cancelou;

            if keypressed then
                begin
                    leTecla (c, c2);
                    if c = #$1b then
                        goto cancelou;
                end;
        end;

    exit;

cancelou:

    {$I-} blockwrite (arqsai, tabCarac[#$0d]^[1],
                      length (tabCarac[#$0d]^), nLidos); {$i+}
    if ioresult <> 0 then;     { limpa eventual lixo }

    mensagem ('IMCANC');
    if copiaAtual < ncopias then
        begin
            mensagem ('IMDESIST');
            leTecla (c, c2);
            writeln;

            if (c = #$1b) or (upcase(c) = 'S') then
               desistiu := true;
        end
    else
        desistiu := true;
end;


end.
