{--------------------------------------------------------}
{
{    Programa de impressao do DOSVOX
{
{    Impressao formatada
{
{    Autor: Jose' Antonio Borges
{
{    Em marco/96
{
{--------------------------------------------------------}

unit impform;

interface

uses dos, crt, sintvox, intervox, readvox, lenumstr,
     impvars, impmsg, impSaida;

procedure imprimeFormatado;

implementation

const
    debug = false;

    NORMAL       = 0;
    NEGRITO      = 1;
    ITALICO      = 2;
    SUBLINHADO   = 4;
    SUBESCRITO   = 8;
    SUPERESCRITO = 16;

type
    LETRALIDA = (ESPACO, CARACTERE, ABRECOMANDO, FIMLINHA, FIMARQ);
    COISALIDA = (BRANCOS, LETRAS, COMANDO, FIM);

var
    jaLido: boolean;
    ultLetra: char;
    ultCodigo: LETRALIDA;
    trecho: string;
    tipoTrecho: COISALIDA;

    processando: boolean;
    ultimoFoiNL: boolean;
    linhaVazia: boolean;

    linha, coluna: integer;
    linhaSaida, resto: string;
    atribSaida, atribResto: array [0..255] of byte;
    ultAtrib: byte;

    tipoLetra: integer;
    linhaPreparada: string;

{--------------------------------------------------------}
{                     inicializacao
{--------------------------------------------------------}

procedure inicFormatador;
begin
    jaLido := false;
    processando := true;
    ultimoFoiNL := false;

    tipoLetra := NORMAL;
    juntaLinhas := true;

    linha  := 1;
    coluna := 0;   { linha nao inicializada }
    linhaVazia := true;
    numPag := 0;
    nlinPag := 0;

    linhaPreparada := '';
    ultAtrib := NORMAL;
    prtOk := true;
    titulando := false;
end;

{--------------------------------------------------------}
{              pega um caractere do texto
{--------------------------------------------------------}

procedure pegaCarac (var c: char; var codigo: LETRALIDA);
var
    lidos: integer;
label
    inicio, fimDeArquivo;

begin
    if jaLido then
        begin
           c := ultLetra;
           codigo := ultCodigo;
           jaLido := false;
           exit;
        end;

inicio:
    if eof (arqEntra) then  goto fimDeArquivo;

    {$I-} blockread (arqEntra, c, 1, lidos);  {$I+}
    if (ioresult <> 0) then
        begin
            mensagem ('IMERRLEI');
            goto fimDeArquivo;
        end;

    if (lidos = 0) then  goto fimDeArquivo;

    case c of
        ' ':  codigo := ESPACO;
        '<':  codigo := ABRECOMANDO;
        #$0a: codigo := FIMLINHA;
        #$0d: goto inicio;
    else
        codigo := CARACTERE;
    end;

    ultLetra := c;
    ultCodigo := codigo;

    exit; 

fimDeArquivo:
    c := ' ';
    codigo := FIMARQ;
end;

{--------------------------------------------------------}
{                    desle um caractere
{--------------------------------------------------------}

procedure desle (c: char; codigo: LETRALIDA);
begin
    jaLido := true;
    ultLetra := c;
    ultCodigo := codigo;
end;

{--------------------------------------------------------}
{                 padroniza o comando
{--------------------------------------------------------}

procedure padronizaComando (var trecho: string);
var i: integer;
label fim;
begin
    i := 1;
    while i <= length (trecho) do
        begin
            if trecho[i] = ' ' then
                delete (trecho, i, 1)
            else
                begin
                    trecho [i] := upcase (trecho[i]);
                    i := i + 1;
                    if trecho[i] = '=' then
                        if copy (trecho,1,3) = 'TIT' then exit;
                end;
        end;
fim:
end;

{--------------------------------------------------------}
{                   pega um trecho conexo
{--------------------------------------------------------}

procedure pegaTrecho (var trecho: string; var tipoTrecho: COISALIDA);
var
    c: char;
    codigo: LETRALIDA;

    {--------------------------------------------------------}

    procedure processaFimLinha;
    begin
        if ultimoFoiNL or (not juntaLinhas) then
            begin
                tipoTrecho := COMANDO;
                trecho := 'NL';
                exit;
            end;

        pegaCarac (c, codigo);

        case codigo of

            ESPACO, FIMARQ, FIMLINHA:
                    begin
                        trecho := 'NL';
                        tipoTrecho := COMANDO;
                        ultimoFoiNL := true;
                    end;

            CARACTERE:
                    begin
                        if linhaVazia then
                            trecho := ''
                        else
                            trecho := ' ';
                        tipoTrecho := BRANCOS;
                    end;

        end;

        desle (c, codigo);
    end;

    {--------------------------------------------------------}

begin
    pegaCarac (c, codigo);
    if codigo <> FIMLINHA then
        ultimoFoiNL := false;

    trecho := '';
    case codigo of

        ESPACO:
            begin
                repeat
                    trecho := trecho + c;
                    pegaCarac (c, codigo);
                until codigo <> ESPACO;

                tipoTrecho := BRANCOS;
                linhaVazia := false;

                desle (c, codigo);
            end;

        CARACTERE:
            begin
                repeat
                    trecho := trecho + c;
                    pegaCarac (c, codigo);
                until codigo <> CARACTERE;

                tipoTrecho := LETRAS;
                linhaVazia := false;

                desle (c, codigo);
            end;

        ABRECOMANDO:
            begin
                pegaCarac (c, codigo);
                if c = '<' then
                    begin
                        trecho := '<';
                        tipoTrecho := LETRAS;
                    end
                else
                    begin
                        tipoTrecho := COMANDO;
                        repeat
                            trecho := trecho + c;
                            pegaCarac (c, codigo);
                        until (codigo = FIMLINHA) or (c = '>');
                    end;

                padronizaComando (trecho);

                if trecho = 'NL' then
                    begin
                        pegaCarac (c, codigo);
                        if (codigo <> FIMLINHA) then
                            desle (c, codigo);
                    end;

            end;

        FIMLINHA:
                processaFimLinha;

        FIMARQ:
            begin
                processando := false;
                tipoTrecho := FIM;
            end;
    end;
end;

{--------------------------------------------------------}
{                   da saida num caractere
{--------------------------------------------------------}

procedure daSaida (c: char);
begin
    linhaPreparada := linhaPreparada + tabCarac [c]^;
end;

{--------------------------------------------------------}
{        envia comando de controle para a saida
{--------------------------------------------------------}

procedure geraComando (s: string);
var i, p: integer;
begin
    for i := 0 to posTabForm-1 do
        if nomeForm [i] = s then
            begin
                for p := 1 to length (tabForm[i]^) do
                    daSaida (tabForm[i]^[p]);
                exit;
            end;
end;

{--------------------------------------------------------}
{             descarrega o buffer de impressao
{--------------------------------------------------------}

procedure descarregaImpressao;
var i: integer;
    dif: byte;
begin
    geraComando ('FN');
    geraComando ('FI');
    geraComando ('FS');
    geraComando ('FSO');
    geraComando ('FSU');

    ultAtrib := NORMAL;
    for i := 1 to length (linhaSaida) do
        begin
            dif := atribSaida[i] xor ultAtrib;
            if dif <> 0 then
                begin
                     if (dif and NEGRITO) <> 0 then
                         if (atribSaida [i] and NEGRITO) <> 0 then
                              geraComando ('IN')
                         else
                              geraComando ('FN');

                     if (dif and ITALICO) <> 0 then
                         if (atribSaida [i] and ITALICO) <> 0 then
                              geraComando ('II')
                         else
                              geraComando ('FI');

                     if (dif and SUBLINHADO) <> 0 then
                         if (atribSaida [i] and SUBLINHADO) <> 0 then
                              geraComando ('IS')
                         else
                              geraComando ('FS');

                     if (dif and SUPERESCRITO) <> 0 then
                         if (atribSaida [i] and SUPERESCRITO) <> 0 then
                              geraComando ('ISO')
                         else
                              geraComando ('FSO');

                     if (dif and SUBESCRITO) <> 0 then
                         if (atribSaida [i] and SUBESCRITO) <> 0 then
                              geraComando ('ISU')
                         else
                              geraComando ('FSU');
                end;

            daSaida (linhaSaida[i]);
            ultAtrib := atribSaida [i];
        end;

    for i := 1 to espacejamento do
        begin
            daSaida (#$0d);
            daSaida (#$0a);

            prtOk := trataCabecalho;
            if (nlinPag = 0) and (i <> 1) then
                begin
                     nlinPag := 1;
                     exit;
                end;

            if prtOK then
                begin
                    prtOk := jogaImpressora (linhaPreparada);
                    linhaPreparada := '';
                    nlinPag := nlinPag + 1;
                end;
        end;
end;

{--------------------------------------------------------}
{                inicializa linha de saida
{--------------------------------------------------------}

procedure inicLinhaSaida (resto: string);
var i: integer;

begin
    fillchar (atribSaida, 256, NORMAL);

    linhaSaida := '';
    for i := 1 to margemEsq-1 do
        linhaSaida := linhaSaida + ' ';

    linhaSaida := linhaSaida + resto;
    for i := 1 to length (resto) do
        atribSaida[margemEsq+i-1] := atribResto [i];

    coluna := margemEsq+length(resto);
end;

{--------------------------------------------------------}
{                     alinha a saida
{--------------------------------------------------------}

procedure alinhaSaida;
var pbr, primCarac, i, j: integer;
label limpouFim, achouNaoBranco, abreBrancos;

begin
    for i := length (linhaSaida) downto 1 do
        if linhaSaida [i] = ' ' then
            delete (linhaSaida, i, 1)
        else
            goto limpouFim;

    if length(linhaSaida) = 0 then exit;

limpouFim:
    for primCarac := 1 to length(linhaSaida) do
        if linhaSaida [primCarac] <> ' ' then
            goto achouNaoBranco;

achouNaoBranco:
    {testa se palavra unica}
    for i := primCarac to length (linhaSaida) do
        if linhaSaida[i] = ' ' then
           goto abreBrancos;

    exit;

abreBrancos:
    if (length (linhaSaida) <> margemDir) and
       (pos (' ', linhaSaida) > 0) then
        begin
            pbr := length(linhaSaida)-1;
            while length (linhaSaida) <> margemDir do
                begin
                    while (pbr > primCarac) and (linhaSaida [pbr] <> ' ') do
                        pbr := pbr - 1;
                    if pbr <= primCarac then
                        pbr := length(linhaSaida)-1
                    else
                        begin
                            insert (' ', linhaSaida, pbr);
                            for j := length (linhaSaida) downto pbr+1 do
                                 atribSaida [j] := atribSaida [j-1];
                            pbr := pbr - 1;
                        end;
                end;
        end;
end;

{--------------------------------------------------------}
{                       corta saida
{--------------------------------------------------------}

procedure cortaSaida;
var posic, posResto, posUltLetra, i: integer;
label limpouFim, achou, cortaFimLinha;

const
    consoantes: set of char = [
        'b'..'d','f'..'h','j'..'n','p'..'t','v'..'z',
        'B'..'D','F'..'H','J'..'N','P'..'T','V'..'Z' ];

    vogais: set of char = [
        'a','e','i','o','u',
        'A','E','I','O','U',
        '', '', '', '', '',
        '', '', '', '', '',
        '', '', '', '', '',
        '', '', '', '', '',
        '', '',

        '','','','','',
        '','','',
        '','','','','',
        '','',
        '','',
        '',
        '', '',
        '', '',
        '', '',
        '', '', '',
        '', '',
        '', '',
        '', '',
        '', '', '',
        '', '',
        '', '',
        '',
        ''
    ];

begin
    resto := '';

    if length (linhaSaida) <= margemDir then exit;

    for posic := margemDir+1 downto 2 do
        begin
            if linhaSaida [posic] = ' ' then
                goto achou;

            if separaSilaba and alinhaADireita and (posic < margemDir) and
                 (linhaSaida [posic-1] in vogais) and
                 (linhaSaida [posic]   in consoantes) and
                 (linhaSaida [posic+1] in vogais) then
                goto achou;
        end;

    posic := margemDir+1;

achou:
    posUltLetra := posic-1;
    while (posUltLetra > 0) and (linhaSaida [posUltLetra] = ' ') do
        posUltLetra := posUltLetra - 1;

    if posUltLetra = 0 then
        posUltLetra := margemDir;

    for posResto := posUltLetra+1 to length (linhaSaida) do
        if linhaSaida[posResto] <> ' ' then
            begin
                resto := copy (linhaSaida, posResto,
                                      length(linhaSaida)-posResto+1);
                for i := 1 to length(resto) do
                    atribResto [i] := atribSaida [i+posResto];
                goto cortaFimLinha;
            end;

cortaFimLinha:
    delete (linhaSaida, posUltLetra+1, length(linhaSaida)-posUltLetra);

    if linhaSaida [posUltLetra] = ' ' then
        repeat
            delete (linhaSaida, posUltLetra, 1);
        until (linhaSaida = '') or (linhaSaida [posUltLetra] <> ' ')
    else
        if linhaSaida [posUltLetra+1] in consoantes then
             linhaSaida := linhaSaida + '-';
end;

{--------------------------------------------------------}
{                      trata espacos
{--------------------------------------------------------}

procedure trataEspacos;
var i: integer;
begin
    if coluna = 0 then
        inicLinhaSaida ('');

    linhaSaida := linhaSaida + trecho;
    for i := 1 to length (trecho) do
        atribSaida [i+coluna-1] := tipoLetra;
    coluna := coluna + length(trecho);

    if coluna > margemDir then
        begin
            cortaSaida;
            if alinhaADireita then
                alinhaSaida;
            descarregaImpressao;
            inicLinhaSaida (resto);
        end;
end;

{--------------------------------------------------------}
{          trata um conjunto de letras e simbolos
{--------------------------------------------------------}

procedure trataLetras;
var i: integer;
begin
    if coluna = 0 then
        inicLinhaSaida ('');

    linhaSaida := linhaSaida + trecho;
    for i := 1 to length (trecho) do
        atribSaida [i+coluna-1] := tipoLetra;
    coluna := coluna + length(trecho);
end;

{--------------------------------------------------------}
{                    trata fim do texto
{--------------------------------------------------------}

procedure trataFim;
var alinhar: boolean;
begin
    if coluna = 0 then
        resto := ' '
    else
        resto := linhaSaida;

    while resto <> '' do
        begin
            cortaSaida;
            if (resto <> '') and alinhaADireita then
               alinhaSaida;

            descarregaImpressao;
            inicLinhaSaida (resto);
        end;

    coluna := 0;
    linhaSaida := ''
end;

{--------------------------------------------------------}
{              trata a execucao de um comando
{--------------------------------------------------------}

procedure trataComando;
var comando: string[3];

    function pegaNumero: integer;
    var posic, num, erro: integer;
    begin
        num := 0;
        posic := pos ('=', trecho);
        if posic > 0 then
            begin
                val (copy (trecho, posic+1, length(trecho)-posic), num, erro);
                if erro <> 0 then
                    begin
                        mensagem ('IMFORINV');
                        writeln (trecho);
                        sintSoletra (trecho);
                        trecho := '';
                    end;
            end
        else
            begin
                mensagem ('IMFORINV');
                writeln (trecho);
                sintSoletra (trecho);
                trecho := '';
            end;

        if num <= 0 then
           num := 1;

        pegaNumero := num;
    end;

begin
    comando := copy (trecho, 1, 3);
    if comando [3] = '=' then
        delete (comando, 3, 1);

    { comandos de margem e espacejamento }

    if comando = 'MS' then margemSup := pegaNumero
    else
    if comando = 'MI' then margemInf := pegaNumero
    else
    if comando = 'ME' then margemEsq := pegaNumero
    else
    if comando = 'MD' then margemDir := pegaNumero
    else
    if comando = 'EL' then espacejamento := pegaNumero
    else

    { titulo }

    if comando = 'TIT' then
        begin
            titulo := copy (trecho, 5, length(trecho)-4);
            titulando := true;
        end
    else
    if comando = 'NTIT' then
        titulando := false
    else

    { pausa entre paginas }

    if comando = 'PP' then
        fazPausa := true
    else
    if comando = 'NPP' then
        fazPausa := false
    else

    { alinhamento separacao de silabas }

    if comando = 'AL'  then  alinhaADireita := true
    else
    if comando = 'NAL' then  alinhaADireita := false
    else
    if comando = 'SS'  then  separaSilaba := true
    else
    if comando = 'NSS' then  separaSilaba := false
    else

    { tipo de letra }

    if comando = 'IN'  then  tipoLetra := tipoLetra or NEGRITO
    else
    if comando = 'FN'  then  tipoLetra := tipoLetra and not NEGRITO
    else
    if comando = 'IS'  then  tipoLetra := tipoLetra or SUBLINHADO
    else
    if comando = 'FS'  then  tipoLetra := tipoLetra and not SUBLINHADO
    else
    if comando = 'II'  then  tipoLetra := tipoLetra or ITALICO
    else
    if comando = 'FI'  then  tipoLetra := tipoLetra and not ITALICO
    else
    if comando = 'ISO' then  tipoLetra := tipoLetra or SUPERESCRITO
    else
    if comando = 'FSO' then  tipoLetra := tipoLetra and not SUPERESCRITO
    else
    if comando = 'ISU' then  tipoLetra := tipoLetra or SUBESCRITO
    else
    if comando = 'FSU' then  tipoLetra := tipoLetra and not SUBESCRITO
    else

    { fim de pagina e de paragrafo }

    if comando = 'P' then
        begin
            trataFim;
            nlinPag := 9999; 
            tipoLetra := NORMAL;
            linhaVazia := true;
        end
    else
    if comando = 'NL' then
        begin
            trataFim;
            tipoLetra := NORMAL;
            linhaVazia := true;
        end
    else

    { comandos especiais da impressora }

    if copy (comando, 1, 2) = 'CE' then
        geraComando (comando)
    else

    { comando invalido }

    if comando <> '' then
        begin
            mensagem ('IMFORINV');
            writeln (trecho);
            sintSoletra (trecho);
            trecho := '';
        end;
end;

{--------------------------------------------------------}
{
{--------------------------------------------------------}

procedure imprimeFormatado;
begin
    inicFormatador;
    inicLinhaSaida ('');

    while processando and prtOK do
        begin
            pegaTrecho (trecho, tipoTrecho);

            if debug then
                begin
                    writeln (ord (tipoTrecho), trecho);
                    if readkey = #$1b then exit;
                end;

            case tipoTrecho of
                BRANCOS: trataEspacos;
                LETRAS:  trataLetras;
                COMANDO: trataComando;
                FIM: trataFim;
            end;
        end;
end;

end.
