{--------------------------------------------------------}
{
{    Programa de impressao do DOSVOX
{
{    Autor: Jose' Antonio Borges
{
{    Em marco/96
{
{--------------------------------------------------------}

program Imprivox;
uses dos, crt, sintvox, intervox, readvox, lenumstr,
     impvars, impmsg, impcomum, impform, impsaida;

{--------------------------------------------------------}
{                  termina programa
{--------------------------------------------------------}

procedure terminaProg;
begin
    writeln;
    tradFim;
    halt;
end;

{--------------------------------------------------------}
{              erro no arquivo de configuracao
{--------------------------------------------------------}

procedure erroConfig (s: string);
var n: string;
begin
    mensagem ('IMCNFINV');
    writeln (linhaAmb);
    str (linhaAmb, n);
    sintSoletra (n);

    mensagem ('IMCONTEU');
    writeln (s);
    sintsoletra (s);

    terminaProg;
end;

{--------------------------------------------------------}
{                  fala um numero inteiro
{--------------------------------------------------------}

procedure xwriteInt (n: integer);
var s: string;
    i: integer;
begin
    str (n, s);
    write (s);
    for i := 1 to length (s) do
        sintcarac (s[i]);
end;   

{--------------------------------------------------------}
{                  le um numero inteiro
{--------------------------------------------------------}

procedure xreadInt (var valor: integer);
var s: string;
    erro: integer;
begin
    s := leLinha;
    if s = '' then
        exit
    else
        begin
            val (s, valor, erro);
            if erro <> 0 then
                valor := 0;
        end;
end;

{--------------------------------------------------------}
{                    pega um parametro
{--------------------------------------------------------}

function pegaParam (nome: string; nomearq: string): string;
var
    arq: text;
    linha: string;

begin
    pegaParam := '';

    assign (arq, nomearq);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        exit;

    while not eof (arq) do
        begin
            readln (arq, linha);
            if pos (nome+'=', linha) = 1 then
                pegaParam := copy (linha, length (nome)+2,
                                   length (linha)-length (nome)-1);
        end;

    close (arq);
end;

{--------------------------------------------------------}
{                 abre os arquivos
{--------------------------------------------------------}

procedure abreArquivos;
label fim;
begin
    if paramcount = 1 then
        nomeentra := paramstr(1)
    else
        begin
            mensagem ('IMNOMARQ');
            nomeEntra := leLinha;
            if nomeEntra = '' then
                goto fim;
        end;

    assign (arqentra, nomeentra);
    {$i-}  reset (arqentra, 1);  {$i+}
    if ioresult <> 0 then
        begin
            mensagem ('IMARQNAO');
            goto fim;
        end;

    mensagem ('IMARQIMP');
    nomesai := leLinha;
    if nomesai = '' then
        nomesai := 'prn';

    assign (arqsai, nomesai);
    {$i-}  rewrite(arqsai, 1);  {$i+}
    if ioresult <> 0 then
        begin
            mensagem ('IMERRCRI');
            goto fim;
        end;

    exit;

fim:
    mensagem ('IMPROCAN');
    terminaProg;
end;


{--------------------------------------------------------}
{       le um numero binario dentro de uma string
{--------------------------------------------------------}

function hexaParaBinario (s: string; var poslida: integer): char;
var valor: integer;
    fimNumero, iniciouNumero: boolean;
    c: char;

begin
    valor := 0;
    iniciouNumero := false;
    fimNumero := false;

    repeat
        if poslida > length (s) then
           c := ' '
        else
           begin
               c := upcase (s[poslida]);
               poslida := poslida + 1;
           end;

        if c in ['0'..'9'] then
            valor := (valor shl 4) or (ord (c) and $f)
        else
        if c in ['A'..'F'] then
            valor := (valor shl 4) or (ord (c)-ord('A') + 10)
        else
        if not iniciouNumero then
            erroConfig (s)
        else
            fimNumero := true;

        iniciouNumero := true;

    until fimNumero;

    hexaParaBinario := chr (valor);
    poslida := poslida - 1;
end;

{--------------------------------------------------------}
{           pega o codigo de traducao de uma letra
{--------------------------------------------------------}

procedure insereTabFormatador (s: string);

var i, poslida, posvet: integer;
    qualLetra: char;
    codigo: string;
    vetNumeros: string;

begin
    poslida := 1;
    vetNumeros := '';
    for i := length (s) downto 1 do
        begin
            if s[i] = ' ' then
                delete (s, i, 1)
            else
                s[i] := upcase (s[i]);
        end;

    poslida := pos ('=', s);
    nomeForm [posTabForm] := copy (s, 2, poslida-3);

    if poslida < 0 then
        erroConfig (s);

    poslida := poslida + 1;
    while poslida <= length (s) do
        begin
            vetNumeros := vetNumeros + hexaParaBinario (s, poslida);
            if (poslida < length(s)) and (s[poslida] <> ',') then
                erroConfig (s);
            poslida := poslida + 1;
        end;

    getmem (tabForm [posTabForm], length(vetNumeros) + 1);
    move (vetNumeros, tabForm [posTabForm]^, length(vetNumeros) + 1);

    posTabForm := posTabForm + 1;
end;

{--------------------------------------------------------}
{       pega um parametro do arquivo de configuracao
{--------------------------------------------------------}

procedure pegaParamDefault (s: string);
var f, i, valor, erro: integer;
    nome, resto: string;
begin
    for i := length (s) downto 1 do
        begin
            if s[i] = ' ' then
                delete (s, i, 1)
            else
                s[i] := upcase (s[i]);
        end;

    f := pos ('>', s);
    if (f <= 0) or (s[f+1] <> '=') then
        erroConfig (s);

    nome := copy (s, 2, f-2);
    resto := copy (s, f+2, length(s)-f-1);
    val (resto, valor, erro);

    if nome = 'MS' then margemSup := valor
    else
    if nome = 'MI' then margemInf := valor
    else
    if nome = 'ME' then margemEsq := valor
    else
    if nome = 'MD' then margemDir := valor
    else
    if nome = 'EL' then espacejamento := valor
    else
    if nome = 'PP' then fazPausa := resto[1] <> 'N'
    else
    if nome = 'SS' then separaSilaba := resto[1] <> 'N'
    else
    if nome = 'AL' then alinhaADireita := resto[1] <> 'N'
    else
       insereTabFormatador (s);
end;

{--------------------------------------------------------}
{           pega o codigo de traducao de uma letra
{--------------------------------------------------------}

procedure pegaCodLetra (s: string);

var i, poslida, posvet: integer;
    qualLetra: char;
    codigo: string;
    vetNumeros: string;

begin
    poslida := 1;
    vetNumeros := '';
    for i := length (s) downto 1 do
        begin
            if s[i] = ' ' then
                delete (s, i, 1)
            else
                s[i] := upcase (s[i]);
        end;


    qualLetra := hexaParaBinario (s, poslida);
    if s[poslida] <> '=' then
        erroConfig (s);

    poslida := poslida + 1;
    while poslida <= length (s) do
        begin
            vetNumeros := vetNumeros + hexaParaBinario (s, poslida);
            if (poslida < length(s)) and (s[poslida] <> ',') then
                erroConfig (s);
            poslida := poslida + 1;
        end;

    getmem (tabCarac [qualLetra], length(vetNumeros) + 1);
    move (vetNumeros, tabCarac [qualLetra]^, length(vetNumeros) + 1);
end;

{--------------------------------------------------------}
{                    inicializao
{--------------------------------------------------------}

procedure inicializa;
var 
    i, erro, result: integer;
    s: string;
    arq: text;
    c: char;

begin
    while keypressed do c := readkey;

    sintInic (0, 'DIRIMPRIVOX');

    writeln ('--------------------------------------------');
    mensagem ('IMINTRO');
    writeln ('--------------------------------------------');
    writeln;

    if tradinic <> 0 then
        begin
            mensagem ('IMERTRAD');
            sintBip;  sintBip;  sintBip;
            delay (1000);
            halt;
        end;

    ambImpriVox := getenv ('AMBIMPRIVOX');
    if ambImprivox = '' then
        begin
            ambImpriVox := pegaParam ('AMBIMPRIVOX', getenv('AMBDOSVOX'));
            if ambImprivox = '' then
                ambImpriVox := copy (getenv('AMBDOSVOX'), 1, 2) +
                           '\DOSVOX\PRINTER.AMB';
        end;

    {----- assume valores default -----}

    ncopias := 1;
    margemSup := 2;
    margemInf := 58;
    margemEsq := 8;
    margemDir := 79;
    fazPausa := false;
    separaSilaba := true;
    alinhaADireita := true;
    espacejamento := 1;
    pagInicial := 1;
    pagFinal := 9999;
    numInicial := 1;
    titulando := true;

    titulo := '';

    posTabForm := 0;

    for i := 0 to 255 do
        begin
            getmem (tabCarac[chr(i)], 2);
            tabCarac [chr(i)]^ := chr(i);
        end;

    assign (arq, ambImpriVox);
    {$I-} reset (arq);  {$I+}
    if ioresult <> 0 then
         begin
             mensagem ('IMCNFNAO');
             terminaProg;
         end;

    linhaAmb := 0;
    repeat
        {$I-}  readln (arq, s); {$I+}
        result := ioresult;
        if result = 0 then
            begin
                linhaAmb := linhaAmb + 1;

                if (s = '') or (s [1] = '*') then
                    { ignora }
                else
                    case upcase(s[1]) of
                        '<': pegaParamDefault (s);

                        '0'..'9',
                        'A'..'F':  pegaCodLetra (s);

                    else
                        erroConfig (s);
                    end;
            end;

    until eof (arq) or (result <> 0);

    pulaLinha := tabCarac [#$0d]^ + tabCarac [#$0a]^;
    pulaPag   := tabCarac [#$0c]^;

    abreArquivos;
end;

{--------------------------------------------------------}
{            pega parametros para a impressao
{--------------------------------------------------------}

procedure pegaParametros;
var c, c2: char;
label deNovo;
begin

    desistiu  := false;

deNovo:
    textBackground (RED);
    mensagem ('IMFORMAT');
    textBackground (BLACK); clreol;

    leTecla (c, c2);
    writeln;
    c := upcase (c);
    if c = #$1b then
        begin
            writeln;
            desistiu := true;
            exit;
        end;

    case upcase(c) of
        'F': tipoImpressao := FORMATADO;
        'O': tipoImpressao := ORIGINAL;
        'G': tipoImpressao := GRAFICO;
    else
        begin
            mensagem ('IMOPINV');
            goto denovo;
        end;
    end;

    if tipoImpressao = GRAFICO then
        exit;

    if tipoImpressao = ORIGINAL then
       begin
           mensagem ('IMFAZTIT');
           leTecla (c, c2);
           writeln;
           if upcase(c) = 'S' then
               begin
                   writeln;
                   mensagem ('IMTIT');
                   titulo := leLinha;
               end
           else
               titulando := false;
       end;

    textBackground (RED);
    mensagem ('IMPADRAO');
    textBackground (BLACK); clreol;
    leTecla (c, c2);
    writeln;

    if c = #$1b then
        begin
            writeln;
            desistiu := true;
            exit;
        end;

    if upcase(c) = 'N' then
        begin
            mensagem ('IMNCOP');    xreadInt (ncopias);
            mensagem ('IMESPAC');   xreadInt (espacejamento);
            mensagem ('IMMARSUP');  xreadInt (margemSup);
            mensagem ('IMMARINF');  xreadInt (margemInf);
            mensagem ('IMMARESQ');  xreadInt (margemEsq);
            mensagem ('IMMARDIR');  xreadInt (margemDir);
            mensagem ('IMPAGINI');  xreadint (pagInicial);
            mensagem ('IMPAGFIN');  xreadint (pagFinal);
            mensagem ('IMNUMINI');  xreadint (numInicial);

            mensagem ('IMFAZPAU');
            leTecla (c, c2);
            fazPausa := upcase(c) <> 'N';
            writeln;
        end;
end;

{--------------------------------------------------------}
{                       limpa memoria
{--------------------------------------------------------}

procedure limpaMemoria;
var i: integer;
begin
    for i := 0 to 255 do
        freemem (tabCarac[chr(i)], length(tabCarac[chr(i)]^)+1);
end;

{--------------------------------------------------------}
{                        impressao
{--------------------------------------------------------}

function impressao: boolean;
begin
    impressao := true;
    desistiu  := false;
    prtOk := true;

    case tipoImpressao of
        FORMATADO: imprimeFormatado;
        ORIGINAL:  imprimeOriginal;
    else
        imprimeBinario;
    end;

    if not desistiu and prtok then
        prtok := jogaImpressora (pulaPag)
    else
        impressao := false;

    sound (2400); delay (500); nosound;
    sound (1200); delay (500); nosound;
    sound (600);  delay (500); nosound;
end;

{--------------------------------------------------------}
{                   programa principal
{--------------------------------------------------------}

var
    s: string;
    imprimiuOk: boolean;

label fim;

begin
    inicializa;
    pegaParametros;
    if desistiu then goto fim;

    copiaAtual := 1;
    while copiaAtual <= ncopias do
        begin
            imprimiuOk := impressao;
            close (arqentra);

            {--- registra fim da copia ---}

            if imprimiuOk and (not desistiu) then
                begin
                    mensagem ('IMFIMCOP');
                    if ncopias <> 1 then
                        begin
                            writeln (': ', copiaAtual);
                            str (copiaAtual, s);
                            sintSoletra (s);
                        end
                    else
                        writeln;
                end;

            {--- reabre arquivo para proxima impressao ---}

            if copiaAtual < ncopias then
                begin
                    {$I-} reset (arqentra, 1);  {$I+}
                    if ioresult <> 0 then
                       begin
                           mensagem ('IMERRLEI');
                           desistiu := true;
                           goto fim;
                       end;
                end;

            copiaAtual := copiaAtual + 1;
        end;

fim:
    {$I-}  close (arqsai);  {$I+}
    if ioresult <> 0 then;

    if not desistiu then
        mensagem ('IMFIMTRA')
    else
        mensagem ('IMPROCAN');

    limpaMemoria;

    tradfim;
end.
