{--------------------------------------------------------}
{
{    Programa de impressao do DOSVOX
{
{    Modulo de saida para a impressora
{
{    Autor: Jose' Antonio Borges
{
{    Em marco/96
{
{--------------------------------------------------------}

unit impSaida;
interface
uses dos, crt, sintvox, intervox, readvox,
     impvars, impmsg;

function jogaImpressora (s: string): boolean;
function trataCabecalho: boolean;

implementation

{--------------------------------------------------------}
{             joga caractere na impressora
{--------------------------------------------------------}

function jogaImpressora (s: string): boolean;
var
    numEnviados: word;
    c, c2: char;

label inicio;

begin
    jogaImpressora := true;
    if numPag < pagInicial then exit;

inicio:
    {$I-} blockwrite (arqsai, s[1], length(s), numEnviados); {$i+}


    if ioresult <> 0 then
        begin
            mensagem ('IMERRIMP');
            mensagem ('IMENTESC');
            leTecla (c, c2);
            if c = #$1b then
                jogaImpressora := false
            else
                begin
                    s := copy (s, numEnviados, length(s) - numEnviados);
                    goto inicio;
                end;
        end;
end;

{--------------------------------------------------------}
{      trata o cabecalho e interrupcoes de impressao
{--------------------------------------------------------}

function trataCabecalho: boolean;
var i: integer;
    num, cabec: string;
    espaco, esquerda, direita: integer;
    ok: boolean;
    c, c2: char;
    s: string;

begin
    if keypressed then
        begin
            c := readkey;
            if c = #$1b then
                begin
                    mensagem ('IMCANC');
                    trataCabecalho := false;
                    exit;
                end;
        end;

    trataCabecalho := true;
    if nlinPag > margemInf then
        begin
            if numPag >= pagFinal then
                begin
                    acabouArq := true;
                    exit;
                end;

            trataCabecalho := jogaImpressora (pulaPag);
            nlinPag := 0;
        end;

    if nlinPag = 0 then
        begin
            if fazPausa then
                begin
                    sound (2400); delay (500); nosound;
                    sound (1200); delay (500); nosound;
                    sound (2400); delay (500); nosound;

                    textBackground (RED); clreol;
                    mensagem ('IMPAPEL');
                    textBackground (BLACK); clreol;

                    repeat
                        c := readkey;
                    until not keypressed;
                    writeln;
                    if c = #$1b then
                        begin
                            mensagem ('IMCANC');
                            trataCabecalho := false;
                            exit;
                        end;
                end;

            numPag := numPag + 1;

            if titulando then
                begin
                    str (numPag+numInicial-1, num);
                    num := '- ' + num + ' -';

                    espaco := (margemDir - margemEsq + 1) - length(num);
                    esquerda := (margemEsq-1) +
                                  (espaco - length(titulo)) div 2;
                    direita := (espaco - (length(titulo)+1)) div 2;

                    cabec := '';
                    for i := 1 to esquerda do
                        cabec := cabec + ' ';
                    for i := 1 to length(titulo) do
                        cabec := cabec + tabCarac [titulo[i]]^;
                    for i := 1 to direita do
                        cabec := cabec + ' ';
                    cabec := cabec + num;


                    s := '';
                    for i := 2 to margemSup do
                        s := s + pulaLinha;

                    trataCabecalho := jogaImpressora
                                   (s + cabec + pulaLinha + pulaLinha);
                    nlinPag := 5;
                end
            else
                begin
                    s := '';
                    for i := 2 to margemSup do
                        s := s + pulaLinha;

                    trataCabecalho := jogaImpressora (s);
                    nlinPag := 3;
                end;
        end;
end;

end.