{--------------------------------------------------------}
{
{     Margeia texto pela direita
{
{     Autor: Antonio II
{
{     Em 8 de agosto de 1995
{
{--------------------------------------------------------}

program margeia;
var 
    nomearq, nomesai: string;
    arq, arqsai: text;

type
    CODELEM = (LETRAS, BRANCOS, FIMPARAG, FIMTEXTO);
    COISALIDA = (CARACTERE, ESPACO, FIMLINHA, FIMARQ);

var
    ultLetra: char;
    ultCodigo: COISALIDA;
    jaLido, linhaEmBranco: boolean;
    maxCaracLinha, maxBrancos, ncsai, tampal: integer;
    linsai: string;
    ajusta: boolean;
    criterio, tipoSaida: integer;

{--------------------------------------------------------}

procedure pegaCarac (var c: char; var codigo: COISALIDA);
label inicio;
begin

inicio:

    if jaLido then
        begin
           c := ultLetra;
           codigo := ultCodigo;
           jaLido := false;
        end
    else
        begin
            if eof (arq) then
                begin
                    c := ' ';
                    codigo := FIMARQ;
                end
            else
                begin
                    read (arq, c);
                    case c of
                        ' ':  codigo := ESPACO;
                        #$0a: codigo := fimLinha;
                        #$0d: goto inicio;
                    else
                        codigo := CARACTERE;
                    end;
                end;

            ultLetra := c;
            ultCodigo := codigo;
        end;
end;

{--------------------------------------------------------}

procedure pegaPalavra (var palavra: string; var codigo: CODELEM);
var
    codLido: coisaLida;
    c: char;

label pegaProx;

begin
    if linhaEmBranco then
        begin
            codigo := FIMPARAG;
            linhaEmBranco := false;
            exit;
        end;

    pegaCarac (c, codLido);

pegaProx:
    case codLido of
        CARACTERE: 
            begin
                palavra := c;
                repeat
                    pegaCarac (c, codLido);
                    if codLido = CARACTERE then
                        palavra := palavra + c;
                until codLido <> CARACTERE;

                codigo := LETRAS;
                jaLido := true;
            end;

        ESPACO:
            begin
                palavra := c;
                repeat
                    pegaCarac (c, codLido);
                    if codLido = ESPACO then
                        palavra := palavra + c;
                until codLido <> ESPACO;

                codigo := BRANCOS;
                jaLido := true;
            end;


        FIMLINHA:
            begin
                codigo := BRANCOS;
                palavra := ' ';
                pegaCarac (c, codLido);
                if (codLido = FIMLINHA) then
                    begin
                        codigo := FIMPARAG;
                        linhaEmBranco := true;
                    end
                else
                if (codLido = ESPACO) or (codLido = FIMARQ) then
                    begin
                        codigo := FIMPARAG;
                        jaLido := true;
                    end
                else
                    jaLido := true;
            end;

        FIMARQ:
            begin
                palavra := '';
                codigo := FIMTEXTO;
            end;
        end;

end;

{--------------------------------------------------------}

procedure abreArquivos;
var resp: char;
begin
    writeln;

    write ('Nome do arquivo de entrada: ');
    readln (nomearq);

    assign (arq, nomearq);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        begin
            writeln ('Arquivo nao existe');
            halt;
        end;

    write ('Nome do arquivo de saida: ');
    readln (nomesai);
    assign (arqsai, nomesai);
    {$I-} rewrite (arqsai); {$I+}
    if ioresult <> 0 then
        begin
            writeln ('Arquivo nao pode ser criado');
            halt;
        end;

    write ('Qual o tamanho da linha: ');
    readln (maxCaracLinha);

    write ('Quantos brancos no maximo: ');
    readln (maxBrancos);

    write ('Ajusta pela coluna da direita? ');
    readln (resp);
    ajusta := upcase (resp) = 'S';

    jaLido := false;
    linSai := '';
    ncsai := 0;
end;

{--------------------------------------------------------}

procedure teste;
var palavra: string;
    cod: CODELEM;
begin
    repeat
         pegaPalavra (palavra, cod);
         writeln (ord(cod), '-', palavra,'-');
         readln;
    until cod = FIMTEXTO;
end;

{--------------------------------------------------------}

function contaLetras (palavra: string): integer;
begin
    contaLetras := length (palavra);
end;

{--------------------------------------------------------}

procedure ajustaLinha;
var pbr, primCarac, i: integer;
label limpouFim, achouNaoBranco;

begin
    for i := length (linsai) downto 1 do
        if linsai [i] = ' ' then
            delete (linsai, i, 1)
        else
            goto limpouFim;

    if length(linsai) = 0 then exit;

limpouFim:
    for primCarac := 1 to length(linsai) do
        if linsai [primCarac] <> ' ' then 
            goto achouNaoBranco;

achouNaoBranco:
    if (length (linsai) <> maxCaracLinha) and
       (pos (' ', linsai) > 0) then
        begin
            pbr := length(linsai)-1;
            while length (linsai) <> maxCaracLinha do
                begin
                    while (pbr > primCarac) and (linsai [pbr] <> ' ') do
                        pbr := pbr - 1;
                    if pbr <= primCarac then
                        pbr := length(linsai)-1
                    else
                        begin
                            linsai := copy (linsai, 1, pbr) + ' ' +
                                copy (linsai, pbr+1, length(linsai)-pbr);
                            pbr := pbr - 1;
                        end;
                end;
        end;
end;

{--------------------------------------------------------}

procedure daSaida;
var i: integer;
label ok;
begin
    for i := length (linsai) downto 1 do
        if linsai [i] = ' ' then
            delete (linsai, i, 1)
        else
            goto ok;
ok:
    writeln (arqsai, linsai);
    ncsai := 0;
    linsai := '';
end;

{--------------------------------------------------------}

var palavra: string;
    cod: CODELEM;

begin
    writeln ('Margeador para braille');
    abreArquivos;

    repeat
        pegaPalavra (palavra, cod);
        case cod of
            LETRAS:    begin
                           tampal := contaLetras (palavra);
                           if tampal + ncsai > maxCaracLinha then
                               begin
                                   if ajusta then
                                       ajustaLinha;
                                   daSaida;
                               end;
                           linSai := linSai + palavra;
                           ncsai := ncsai + tampal;
                       end;

            BRANCOS:   begin
                           if length(palavra) > maxBrancos then
                               palavra := copy (palavra, 1, maxBrancos);
                           linsai := linsai + palavra;
                           ncsai := ncsai + length (palavra);
                       end;

            FIMPARAG:  daSaida;

            FIMTEXTO:  if ncsai > 0 then
                              daSaida;
        end;


    until cod = FIMTEXTO;

    close (arq);
    close (arqsai);
end.