{--------------------------------------------------------}
{
{    TSR que mostra as letras da tela alfanumerica em
{    tamanho grande
{
{    Autor: Jose' Antonio Borges (projeto DOSVOX)
{
{    Em 23/09/94
{
{    Copie este programa e doe para uma pessoa de visao
{    subnormal. Se voce sabe programar, melhore-o.
{
{--------------------------------------------------------}

{$M $400,$0,$0}
{$F+}

program impgrand;
uses
    Crt, Dos;

var
    PrScrIntVec: Procedure;
    tela: array [0..3999] of byte;
    naLente: boolean;
    ampl, ultAmpl: byte;
    x, y, xmin, ymin: integer;
    endvid: word;

const
    CIMA  = #72;
    BAIX  = #80;
    ESQ   = #75;
    DIR   = #77;
    HOME  = #71;
    TEND  = #79;
    PGUP  = #73;
    PGDN  = #81;

{--------------------------------------------------------}
{                  Modelo das letras
{--------------------------------------------------------}

type MODELO = array [0..7] of byte;

const tabletra: array [0..255] of MODELO = (
        ($00, $00, $00, $00, $00, $00, $00, $00),   { #  0 }
        ($7e, $81, $a5, $81, $bd, $99, $81, $7e),   { #  1 }
        ($7e, $ff, $db, $ff, $c3, $e7, $ff, $7e),   { #  2 }
        ($6c, $fe, $fe, $fe, $7c, $38, $10, $00),   { #  3 }
        ($10, $38, $7c, $fe, $7c, $38, $10, $00),   { #  4 }
        ($38, $7c, $38, $fe, $fe, $92, $10, $7c),   { #  5 }
        ($00, $10, $38, $7c, $fe, $7c, $38, $7c),   { #  6 }
        ($00, $00, $00, $00, $00, $00, $00, $00),   { #  7 }
        ($00, $00, $00, $00, $00, $00, $00, $00),   { #  8 }
        ($00, $3c, $66, $42, $42, $66, $3c, $00),   { #  9 }
        ($00, $00, $00, $00, $00, $00, $00, $00),   { # 10 }
        ($0f, $07, $0f, $7d, $cc, $cc, $cc, $78),   { # 11 }
        ($3c, $66, $66, $66, $3c, $18, $7e, $18),   { # 12 }
        ($00, $00, $00, $00, $00, $00, $00, $00),   { # 13 }
        ($7f, $63, $7f, $63, $63, $67, $e6, $c0),   { # 14 }
        ($99, $5a, $3c, $e7, $e7, $3c, $5a, $99),   { # 15 }
        ($80, $e0, $f8, $fe, $f8, $e0, $80, $00),   { # 16 }
        ($02, $0e, $3e, $fe, $3e, $0e, $02, $00),   { # 17 }
        ($18, $3c, $7e, $18, $18, $7e, $3c, $18),   { # 18 }
        ($66, $66, $66, $66, $66, $00, $66, $00),   { # 19 }
        ($7f, $db, $db, $7b, $1b, $1b, $1b, $00),   { # 20 }
        ($3e, $63, $38, $6c, $6c, $38, $86, $fc),   { # 21 }
        ($00, $00, $00, $00, $7e, $7e, $7e, $00),   { # 22 }
        ($18, $3c, $7e, $18, $7e, $3c, $18, $ff),   { # 23 }
        ($18, $3c, $7e, $18, $18, $18, $18, $00),   { # 24 }
        ($18, $18, $18, $18, $7e, $3c, $18, $00),   { # 25 }
        ($00, $18, $0c, $fe, $0c, $18, $00, $00),   { # 26 }
        ($00, $30, $60, $fe, $60, $30, $00, $00),   { # 27 }
        ($00, $00, $c0, $c0, $c0, $fe, $00, $00),   { # 28 }
        ($00, $24, $66, $ff, $66, $24, $00, $00),   { # 29 }
        ($00, $18, $3c, $7e, $ff, $ff, $00, $00),   { # 30 }
        ($00, $ff, $ff, $7e, $3c, $18, $00, $00),   { # 31 }
        ($00, $00, $00, $00, $00, $00, $00, $00),   {      }
        ($18, $3c, $3c, $18, $18, $00, $18, $00),   { !    }
        ($6c, $6c, $6c, $00, $00, $00, $00, $00),   { "    }
        ($6c, $6c, $fe, $6c, $fe, $6c, $6c, $00),   { #    }
        ($18, $7e, $c0, $7c, $06, $fc, $18, $00),   { $    }
        ($00, $c6, $cc, $18, $30, $66, $c6, $00),   { %    }
        ($38, $6c, $38, $76, $dc, $cc, $76, $00),   { &    }
        ($30, $30, $60, $00, $00, $00, $00, $00),   { '    }
        ($18, $30, $60, $60, $60, $30, $18, $00),   { (    }
        ($60, $30, $18, $18, $18, $30, $60, $00),   { )    }
        ($00, $66, $3c, $ff, $3c, $66, $00, $00),   { *    }
        ($00, $18, $18, $7e, $18, $18, $00, $00),   { +    }
        ($00, $00, $00, $00, $00, $18, $18, $30),   { ,    }
        ($00, $00, $00, $7e, $00, $00, $00, $00),   { -    }
        ($00, $00, $00, $00, $00, $18, $18, $00),   { .    }
        ($06, $0c, $18, $30, $60, $c0, $80, $00),   { /    }
        ($7c, $ce, $de, $f6, $e6, $c6, $7c, $00),   { 0    }
        ($30, $70, $30, $30, $30, $30, $fc, $00),   { 1    }
        ($78, $cc, $0c, $38, $60, $cc, $fc, $00),   { 2    }
        ($78, $cc, $0c, $38, $0c, $cc, $78, $00),   { 3    }
        ($1c, $3c, $6c, $cc, $fe, $0c, $1e, $00),   { 4    }
        ($fc, $c0, $f8, $0c, $0c, $cc, $78, $00),   { 5    }
        ($38, $60, $c0, $f8, $cc, $cc, $78, $00),   { 6    }
        ($fc, $cc, $0c, $18, $30, $30, $30, $00),   { 7    }
        ($78, $cc, $cc, $78, $cc, $cc, $78, $00),   { 8    }
        ($78, $cc, $cc, $7c, $0c, $18, $70, $00),   { 9    }
        ($00, $18, $18, $00, $00, $18, $18, $00),   { :    }
        ($00, $18, $18, $00, $00, $18, $18, $30),   { ;    }
        ($18, $30, $60, $c0, $60, $30, $18, $00),   { <    }
        ($00, $00, $7e, $00, $7e, $00, $00, $00),   { =    }
        ($60, $30, $18, $0c, $18, $30, $60, $00),   { >    }
        ($3c, $66, $0c, $18, $18, $00, $18, $00),   { ?    }
        ($7c, $c6, $de, $de, $dc, $c0, $7c, $00),   { @    }
        ($30, $78, $cc, $cc, $fc, $cc, $cc, $00),   { A    }
        ($fc, $66, $66, $7c, $66, $66, $fc, $00),   { B    }
        ($3c, $66, $c0, $c0, $c0, $66, $3c, $00),   { C    }
        ($f8, $6c, $66, $66, $66, $6c, $f8, $00),   { D    }
        ($fe, $62, $68, $78, $68, $62, $fe, $00),   { E    }
        ($fe, $62, $68, $78, $68, $60, $f0, $00),   { F    }
        ($3c, $66, $c0, $c0, $ce, $66, $3a, $00),   { G    }
        ($cc, $cc, $cc, $fc, $cc, $cc, $cc, $00),   { H    }
        ($78, $30, $30, $30, $30, $30, $78, $00),   { I    }
        ($1e, $0c, $0c, $0c, $cc, $cc, $78, $00),   { J    }
        ($e6, $66, $6c, $78, $6c, $66, $e6, $00),   { K    }
        ($f0, $60, $60, $60, $62, $66, $fe, $00),   { L    }
        ($c6, $ee, $fe, $fe, $d6, $c6, $c6, $00),   { M    }
        ($c6, $e6, $f6, $de, $ce, $c6, $c6, $00),   { N    }
        ($38, $6c, $c6, $c6, $c6, $6c, $38, $00),   { O    }
        ($fc, $66, $66, $7c, $60, $60, $f0, $00),   { P    }
        ($7c, $c6, $c6, $c6, $d6, $7c, $0e, $00),   { Q    }
        ($fc, $66, $66, $7c, $6c, $66, $e6, $00),   { R    }
        ($7c, $c6, $e0, $78, $0e, $c6, $7c, $00),   { S    }
        ($fc, $b4, $30, $30, $30, $30, $78, $00),   { T    }
        ($cc, $cc, $cc, $cc, $cc, $cc, $fc, $00),   { U    }
        ($cc, $cc, $cc, $cc, $cc, $78, $30, $00),   { V    }
        ($c6, $c6, $c6, $c6, $d6, $fe, $6c, $00),   { W    }
        ($c6, $c6, $6c, $38, $6c, $c6, $c6, $00),   { X    }
        ($cc, $cc, $cc, $78, $30, $30, $78, $00),   { Y    }
        ($fe, $c6, $8c, $18, $32, $66, $fe, $00),   { Z    }
        ($78, $60, $60, $60, $60, $60, $78, $00),   { [    }
        ($c0, $60, $30, $18, $0c, $06, $02, $00),   { \    }
        ($78, $18, $18, $18, $18, $18, $78, $00),   { ]    }
        ($10, $38, $6c, $c6, $00, $00, $00, $00),   { ^    }
        ($00, $00, $00, $00, $00, $00, $00, $ff),   { _    }
        ($30, $30, $18, $00, $00, $00, $00, $00),   { `    }
        ($00, $00, $78, $0c, $7c, $cc, $76, $00),   { a    }
        ($e0, $60, $60, $7c, $66, $66, $dc, $00),   { b    }
        ($00, $00, $78, $cc, $c0, $cc, $78, $00),   { c    }
        ($1c, $0c, $0c, $7c, $cc, $cc, $76, $00),   { d    }
        ($00, $00, $78, $cc, $fc, $c0, $78, $00),   { e    }
        ($38, $6c, $64, $f0, $60, $60, $f0, $00),   { f    }
        ($00, $00, $76, $cc, $cc, $7c, $0c, $f8),   { g    }
        ($e0, $60, $6c, $76, $66, $66, $e6, $00),   { h    }
        ($30, $00, $70, $30, $30, $30, $78, $00),   { i    }
        ($0c, $00, $1c, $0c, $0c, $cc, $cc, $78),   { j    }
        ($e0, $60, $66, $6c, $78, $6c, $e6, $00),   { k    }
        ($70, $30, $30, $30, $30, $30, $78, $00),   { l    }
        ($00, $00, $cc, $fe, $fe, $d6, $d6, $00),   { m    }
        ($00, $00, $b8, $cc, $cc, $cc, $cc, $00),   { n    }
        ($00, $00, $78, $cc, $cc, $cc, $78, $00),   { o    }
        ($00, $00, $dc, $66, $66, $7c, $60, $f0),   { p    }
        ($00, $00, $76, $cc, $cc, $7c, $0c, $1e),   { q    }
        ($00, $00, $dc, $76, $62, $60, $f0, $00),   { r    }
        ($00, $00, $7c, $c0, $70, $1c, $f8, $00),   { s    }
        ($10, $30, $fc, $30, $30, $34, $18, $00),   { t    }
        ($00, $00, $cc, $cc, $cc, $cc, $76, $00),   { u    }
        ($00, $00, $cc, $cc, $cc, $78, $30, $00),   { v    }
        ($00, $00, $c6, $c6, $d6, $fe, $6c, $00),   { w    }
        ($00, $00, $c6, $6c, $38, $6c, $c6, $00),   { x    }
        ($00, $00, $cc, $cc, $cc, $7c, $0c, $f8),   { y    }
        ($00, $00, $fc, $98, $30, $64, $fc, $00),   { z    }
        ($1c, $30, $30, $e0, $30, $30, $1c, $00),   { {    }
        ($18, $18, $18, $00, $18, $18, $18, $00),   { |    }
        ($e0, $30, $30, $1c, $30, $30, $e0, $00),   { #125 }
        ($76, $dc, $00, $00, $00, $00, $00, $00),   { ~    }
        ($00, $10, $38, $6c, $c6, $c6, $fe, $00),   {     }
        ($7c, $c6, $c0, $c6, $7c, $0c, $06, $7c),   { #128 }
        ($00, $cc, $00, $cc, $cc, $cc, $76, $00),   { #129 }
        ($1c, $00, $78, $cc, $fc, $c0, $78, $00),   { #130 }
        ($7e, $81, $3c, $06, $3e, $66, $3b, $00),   { #131 }
        ($cc, $00, $78, $0c, $7c, $cc, $76, $00),   { #132 }
        ($e0, $00, $78, $0c, $7c, $cc, $76, $00),   { #133 }
        ($30, $30, $78, $0c, $7c, $cc, $76, $00),   { #134 }
        ($00, $00, $7c, $c6, $c0, $78, $0c, $38),   { #135 }
        ($7e, $81, $3c, $66, $7e, $60, $3c, $00),   { #136 }
        ($cc, $00, $78, $cc, $fc, $c0, $78, $00),   { #137 }
        ($e0, $00, $78, $cc, $fc, $c0, $78, $00),   { #138 }
        ($cc, $00, $70, $30, $30, $30, $78, $00),   { #139 }
        ($7c, $82, $38, $18, $18, $18, $3c, $00),   { #140 }
        ($e0, $00, $70, $30, $30, $30, $78, $00),   { #141 }
        ($c6, $10, $7c, $c6, $fe, $c6, $c6, $00),   { #142 }
        ($30, $30, $00, $78, $cc, $fc, $cc, $00),   { #143 }
        ($1c, $00, $fc, $60, $78, $60, $fc, $00),   { #144 }
        ($00, $00, $7f, $0c, $7f, $cc, $7f, $00),   { #145 }
        ($3e, $6c, $cc, $fe, $cc, $cc, $ce, $00),   { #146 }
        ($78, $84, $00, $78, $cc, $cc, $78, $00),   { #147 }
        ($00, $cc, $00, $78, $cc, $cc, $78, $00),   { #148 }
        ($00, $e0, $00, $78, $cc, $cc, $78, $00),   { #149 }
        ($78, $84, $00, $cc, $cc, $cc, $76, $00),   { #150 }
        ($00, $e0, $00, $cc, $cc, $cc, $76, $00),   { #151 }
        ($00, $cc, $00, $cc, $cc, $7c, $0c, $f8),   { #152 }
        ($c3, $18, $3c, $66, $66, $3c, $18, $00),   { #153 }
        ($cc, $00, $cc, $cc, $cc, $cc, $78, $00),   { #154 }
        ($18, $18, $7e, $c0, $c0, $7e, $18, $18),   { #155 }
        ($38, $6c, $64, $f0, $60, $e6, $fc, $00),   { #156 }
        ($cc, $cc, $78, $30, $fc, $30, $fc, $30),   { #157 }
        ($f8, $cc, $cc, $fa, $c6, $cf, $c6, $c3),   { #158 }
        ($0e, $1b, $18, $3c, $18, $18, $d8, $70),   { #159 }
        ($1c, $00, $78, $0c, $7c, $cc, $76, $00),   {     }
        ($38, $00, $70, $30, $30, $30, $78, $00),   {     }
        ($00, $1c, $00, $78, $cc, $cc, $78, $00),   {     }
        ($00, $1c, $00, $cc, $cc, $cc, $76, $00),   {     }
        ($00, $f8, $00, $b8, $cc, $cc, $cc, $00),   {     }
        ($fc, $00, $cc, $ec, $fc, $dc, $cc, $00),   {     }
        ($3c, $6c, $6c, $3e, $00, $7e, $00, $00),   {     }
        ($38, $6c, $6c, $38, $00, $7c, $00, $00),   {     }
        ($18, $00, $18, $18, $30, $66, $3c, $00),   {     }
        ($00, $00, $00, $fc, $c0, $c0, $00, $00),   {     }
        ($00, $00, $00, $fc, $0c, $0c, $00, $00),   {     }
        ($c6, $cc, $d8, $36, $6b, $c2, $84, $0f),   {     }
        ($c3, $c6, $cc, $db, $37, $6d, $cf, $03),   {     }
        ($18, $00, $18, $18, $3c, $3c, $18, $00),   {     }
        ($00, $33, $66, $cc, $66, $33, $00, $00),   {     }
        ($00, $cc, $66, $33, $66, $cc, $00, $00),   {     }
        ($22, $88, $22, $88, $22, $88, $22, $88),   {     }
        ($55, $aa, $55, $aa, $55, $aa, $55, $aa),   {     }
        ($db, $f6, $db, $6f, $db, $7e, $d7, $ed),   {     }
        ($18, $18, $18, $18, $18, $18, $18, $18),   {     }
        ($18, $18, $18, $18, $f8, $18, $18, $18),   {     }
        ($18, $18, $f8, $18, $f8, $18, $18, $18),   {     }
        ($36, $36, $36, $36, $f6, $36, $36, $36),   {     }
        ($00, $00, $00, $00, $fe, $36, $36, $36),   {     }
        ($00, $00, $f8, $18, $f8, $18, $18, $18),   {     }
        ($36, $36, $f6, $06, $f6, $36, $36, $36),   {     }
        ($36, $36, $36, $36, $36, $36, $36, $36),   {     }
        ($00, $00, $fe, $06, $f6, $36, $36, $36),   {     }
        ($36, $36, $f6, $06, $fe, $00, $00, $00),   {     }
        ($36, $36, $36, $36, $fe, $00, $00, $00),   {     }
        ($18, $18, $f8, $18, $f8, $00, $00, $00),   {     }
        ($00, $00, $00, $00, $f8, $18, $18, $18),   {     }
        ($18, $18, $18, $18, $1f, $00, $00, $00),   {     }
        ($18, $18, $18, $18, $ff, $00, $00, $00),   {     }
        ($00, $00, $00, $00, $ff, $18, $18, $18),   {     }
        ($18, $18, $18, $18, $1f, $18, $18, $18),   {     }
        ($00, $00, $00, $00, $ff, $00, $00, $00),   {     }
        ($18, $18, $18, $18, $ff, $18, $18, $18),   {     }
        ($18, $18, $1f, $18, $1f, $18, $18, $18),   {     }
        ($36, $36, $36, $36, $37, $36, $36, $36),   {     }
        ($36, $36, $37, $30, $3f, $00, $00, $00),   {     }
        ($00, $00, $3f, $30, $37, $36, $36, $36),   {     }
        ($36, $36, $f7, $00, $ff, $00, $00, $00),   {     }
        ($00, $00, $ff, $00, $f7, $36, $36, $36),   {     }
        ($36, $36, $37, $30, $37, $36, $36, $36),   {     }
        ($00, $00, $ff, $00, $ff, $00, $00, $00),   {     }
        ($36, $36, $f7, $00, $f7, $36, $36, $36),   {     }
        ($18, $18, $ff, $00, $ff, $00, $00, $00),   {     }
        ($36, $36, $36, $36, $ff, $00, $00, $00),   {     }
        ($00, $00, $ff, $00, $ff, $18, $18, $18),   {     }
        ($00, $00, $00, $00, $ff, $36, $36, $36),   {     }
        ($36, $36, $36, $36, $3f, $00, $00, $00),   {     }
        ($18, $18, $1f, $18, $1f, $00, $00, $00),   {     }
        ($00, $00, $1f, $18, $1f, $18, $18, $18),   {     }
        ($00, $00, $00, $00, $3f, $36, $36, $36),   {     }
        ($36, $36, $36, $36, $ff, $36, $36, $36),   {     }
        ($18, $18, $ff, $18, $ff, $18, $18, $18),   {     }
        ($18, $18, $18, $18, $f8, $00, $00, $00),   {     }
        ($00, $00, $00, $00, $1f, $18, $18, $18),   {     }
        ($ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff),   {     }
        ($00, $00, $00, $00, $ff, $ff, $ff, $ff),   {     }
        ($f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0),   {     }
        ($0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f),   {     }
        ($ff, $ff, $ff, $ff, $00, $00, $00, $00),   {     }
        ($00, $00, $76, $dc, $c8, $dc, $76, $00),   {     }
        ($00, $78, $cc, $f8, $cc, $f8, $c0, $c0),   {     }
        ($00, $fc, $cc, $c0, $c0, $c0, $c0, $00),   {     }
        ($00, $00, $fe, $6c, $6c, $6c, $6c, $00),   {     }
        ($fc, $cc, $60, $30, $60, $cc, $fc, $00),   {     }
        ($00, $00, $7e, $d8, $d8, $d8, $70, $00),   {     }
        ($00, $66, $66, $66, $66, $7c, $60, $c0),   {     }
        ($00, $76, $dc, $18, $18, $18, $18, $00),   {     }
        ($fc, $30, $78, $cc, $cc, $78, $30, $fc),   {     }
        ($38, $6c, $c6, $fe, $c6, $6c, $38, $00),   {     }
        ($38, $6c, $c6, $c6, $6c, $6c, $ee, $00),   {     }
        ($1c, $30, $18, $7c, $cc, $cc, $78, $00),   {     }
        ($00, $00, $7e, $db, $db, $7e, $00, $00),   {     }
        ($06, $0c, $7e, $db, $db, $7e, $60, $c0),   {     }
        ($38, $60, $c0, $f8, $c0, $60, $38, $00),   {     }
        ($78, $cc, $cc, $cc, $cc, $cc, $cc, $00),   {     }
        ($00, $7e, $00, $7e, $00, $7e, $00, $00),   {     }
        ($18, $18, $7e, $18, $18, $00, $7e, $00),   {     }
        ($60, $30, $18, $30, $60, $00, $fc, $00),   {     }
        ($18, $30, $60, $30, $18, $00, $fc, $00),   {     }
        ($0e, $1b, $1b, $18, $18, $18, $18, $18),   {     }
        ($18, $18, $18, $18, $18, $d8, $d8, $70),   {     }
        ($18, $18, $00, $7e, $00, $18, $18, $00),   {     }
        ($00, $76, $dc, $00, $76, $dc, $00, $00),   {     }
        ($38, $6c, $6c, $38, $00, $00, $00, $00),   {     }
        ($00, $00, $00, $18, $18, $00, $00, $00),   {     }
        ($00, $00, $00, $00, $18, $00, $00, $00),   {     }
        ($0f, $0c, $0c, $0c, $ec, $6c, $3c, $1c),   {     }
        ($58, $6c, $6c, $6c, $6c, $00, $00, $00),   {     }
        ($70, $98, $30, $60, $f8, $00, $00, $00),   {     }
        ($00, $00, $3c, $3c, $3c, $3c, $00, $00),   {     }
        ($00, $00, $00, $00, $00, $00, $00, $00)    {     }
    );

{--------------------------------------------------------}
{                     pinta uma letra
{--------------------------------------------------------}

procedure pintaLetra (carac: byte;
                      ximg, yimg: integer;
                      ampl, corl, fundo: byte);

var pmod: ^MODELO;
    i: byte;
    lin, col, ax, ay: byte;
    byteLetra, bitLetra: byte;
    salva, endvid: word;

begin
    pmod := @tabletra[carac];
    endvid := word(yimg)*320 + word(ximg);

    for lin := 0 to 7 do
        for ay := 1 to ampl do
            begin
                salva := endvid;
                byteLetra := pmod^[lin];

                for col := 0 to 7 do
                    begin
                        bitLetra := byteLetra and $80;
                        byteLetra := byteLetra shl 1;

                        if bitLetra <> 0 then
                            fillchar (mem [$a000:endvid], ampl, corl)
                        else
                            fillchar (mem [$a000:endvid], ampl, fundo);
                        endvid := endvid + ampl;
                    end;

                endvid := salva + 320;
            end;
end;

{--------------------------------------------------------}
{                    desenha o cursor
{--------------------------------------------------------}

procedure desenhaCursor;
var ximg, yimg: longint;
    endvid: word;
    ay: byte;
begin
    ximg := (x-1-xmin) * 8 * ampl;
    yimg := (y-ymin) * 8 * ampl - ampl;
    endvid := word(yimg)*word(320)+word(ximg);
    for ay := 1 to ampl do
        begin
            fillchar (mem[$a000:endvid], ampl*7, 6);
            endvid := endvid - 320;
        end;
end;

{--------------------------------------------------------}
{              produz uma ampliacao de tela
{--------------------------------------------------------}

procedure AmpliaTela;
var
    xt, yt: byte;
    ind: word;
    carac, cor, fundo, corl: byte;
    ximg, yimg: integer;
    ncol, nlin: integer;

begin
    ncol := 320 div (8*ampl);
    nlin := 200 div (8*ampl);

    for yt := ymin to ymin+nlin-1 do
        begin
             ind := (yt*80+xmin)*2;
             for xt := xmin to xmin+ncol-1 do
                 begin
                     carac := tela [ind];
                     cor := tela [ind+1];
                     fundo := cor shr 4;
                     corl  := cor and $f;
                     ind := ind + 2;

                     ximg := (xt-xmin) * 8 * ampl;
                     yimg := (yt-ymin) * 8 * ampl;
                     pintaLetra (carac, ximg, yimg, ampl, corl, fundo);
                 end;
        end;
    
    if (x>=xmin) and (x<=xmin+ncol) and
       (y>=ymin) and (y<=ymin+nlin) then
           desenhaCursor;
end;

{--------------------------------------------------------}
{            controle da ampliacao por teclado
{--------------------------------------------------------}

procedure controlaAmpliacao;
var c: char;
    reg: registers;
    nletx, nlety: integer;
begin
    ampl := ultAmpl;                     { volta a ultima ampliacao }
    nletx := 80 div ampl;
    nlety := 25 div ampl;
    xmin := x - 30 div ampl;             { posiciona copia da tela }
    ymin := y - 12 div ampl;

    repeat
        nletx := (320 div 8) div ampl;
        nlety := (200 div 8) div ampl;
        if xmin < 0 then xmin := 0;      { checa limites }
        if ymin < 0 then ymin := 0;
        if xmin+nletx >= 80 then
            xmin := 80-nletx;
        if ymin+nlety > 25 then
            ymin := 25-nlety;

        if not keypressed then
            ampliaTela;

        c := readkey;
        case c of 
            '1'..'4':
                begin
                    ampl := ord (c) and $f;
                    reg.ax := $13;       { limpa tela }
                    intr ($10, reg);
                end;

            #$0d: xmin := 0;
            ' ' : xmin := xmin + 1;

            #0  : begin
                        c := readkey;
                        case c of
                            DIR:  xmin := xmin + 4;
                            ESQ:  xmin := xmin - 4;
                            CIMA: ymin := ymin - 1;
                            BAIX: ymin := ymin + 1;

                            HOME: xmin := 0;
                            TEND: xmin := 999;
                            PGUP: ymin := 0;
                            PGDN: ymin := 999;
                        end;
                    end;
        end;
    until c = #$1b;

    ultAmpl := ampl;
end;

{--------------------------------------------------------}
{                   rotina de print screen
{--------------------------------------------------------}

procedure GeraTela;  interrupt;
var reg: registers;
begin
    if naLente then
        exit;
    naLente := true;

    x := wherex;                         { salva cursor }
    y := wherey;
    move (mem [$b800:0], tela, 4000);    { tira copia da tela }

    reg.ax := $13;                       { entra em modo grafico }
    intr ($10, reg);

    controlaAmpliacao;                   { faz as ampliacoes }

    reg.ax := $3;                        { sai de modo grafico }
    intr ($10, reg);

    move (tela, mem [$b800:0], 4000);    { recupera tela }
    gotoxy (x, y);                       { recupera cursor }

    naLente := false;
end;

{--------------------------------------------------------}
{                    programa principal
{--------------------------------------------------------}

begin
    textbackground (blue);
    clreol;
    writeln ('Ampliador de tela para visao subnormal - v.1.0');
    clreol;
    write  ('Projeto DOSVOX - Nucleo de Computacao Eletronica da UFRJ');
    textbackground (black);
    writeln;
    writeln ('Para aumentar a tela, tecle PRINT SCREEN');
    writeln ('1 a 4 sao os fatores de ampliacao.  Setas movem tela. ESC termina.');

    naLente := false;
    ultAmpl := 2;    { valor default da ampliacao }

    { Insere nova ISR na cadeia de PrScr }
    GetIntVec ($5, @PrScrIntVec);
    SetIntVec ($5, Addr(GeraTela));

    Keep (0); { Termina, ficando residente }
end.
