{--------------------------------------------------------}
{
{   Leitor de textos VOX
{
{   Autor:  Jose' Antonio Borges
{
{   Em 24/12/94
{
{--------------------------------------------------------}

Program leVox;

Uses
    CRT, DOS, horavox, readvox, leNumStr, Traduvox, Intervox, SintVox, playvox;

const
    versao = '1.3a';
    graveiVoz = true;

var
    processando: boolean;
    comandou: boolean;
    nomeArqLeit: string;
    posArq, tamArq: longint;
    arqLeit: file of char;
    clekFimLinha, pontuando: boolean;
    linhaAtual: integer;
    velocFala: integer;

    ecoando, parado, jaLido: boolean;
    ultLido: char;
    ultBusca: string;

{--------------------------------------------------------}
{                    constantes do teclado
{--------------------------------------------------------}

const
    F1    = #59;
    F2    = #60;
    F3    = #61;
    F4    = #62;
    F5    = #63;
    F6    = #64;
    F7    = #65;
    F8    = #66;
    F9    = #67;
    F10   = #68;

    INS   = #82;
    DEL   = #83;
    HOME  = #71;
    TEND  = #79;
    PGUP  = #73;
    PGDN  = #81;
    CIMA  = #72;
    BAIX  = #80;
    ESQ   = #75;
    DIR   = #77;

    CTLPGUP = #132;
    CTLPGDN = #118;
    CTLESQ  = #115;
    CTLDIR  = #116;

    CTLF1   =  #94;
    CTLF2   =  #95;
    CTLF4   =  #97;
    CTLF5   =  #98;
    CTLF9   =  #102;
    CTLF10  =  #103;

    CTLENTER = #10;

const
    NUMEROS: set of char = ['0'..'9'];
    CONTROL: set of char = [#$0..#$19];

var
    ALFA: set of char;

{--------------------------------------------------------}
{            traducao do arquivo para fala
{--------------------------------------------------------}

function ansiParaFala (s: string): string;
var c: char;
    s2: string;
    c2: string[2];
    i: integer;
begin
    s2 := '';
    for i := 1 to length (s) do
        begin
            c := s[i];

            if c > #127 then      { de tela para ansi }
              case c of
                '': c:= #$E1;
                '': c:= #$E9;
                '': c:= #$ED;
                '': c:= #$F3;
                '': c:= #$FA;
                '': c:= #$C1;
                '': c:= #$C9;
                '': c:= #$CD;
                '': c:= #$D3;
                '': c:= #$DA;
                '': c:= #$E2;
                '': c:= #$EA;
                '': c:= #$F4;
                '': c:= #$C2;
                '': c:= #$CA;
                '': c:= #$D4;
                '': c:= #$E3;
                '': c:= #$F5;
                '': c:= #$C3;
                '': c:= #$D5;
                '': c:= #$E0;
                '': c:= #$C0;
              { 'u': c:= #$FC; }
              { 'U': c:= #$DC; }
                '': c:= #$E7;
                '': c:= #$C7;
            end;

            c2 := c;
            if c > #127 then
              case ord(c) of
                $E1: c2:='a''';   { de ansi para acentos }
                $E9: c2:='e''';
                $ED: c2:='i''';
                $F3: c2:='o''';
                $FA: c2:='u''';
                $C1: c2:='A''';
                $C9: c2:='E''';
                $CD: c2:='I''';
                $D3: c2:='O''';
                $DA: c2:='U''';
                $E2: c2:='a^';
                $EA: c2:='e^';
                $F4: c2:='o^';
                $C2: c2:='A^';
                $CA: c2:='E^';
                $D4: c2:='O^';
                $E3: c2:='a~';
                $F5: c2:='O~';
                $C3: c2:='A~';
                $D5: c2:='O~';
                $E0: c2:='a''';
                $C0: c2:='A''';
                $FC: c2:='u';   { provisorio }
                $DC: c2:='U';   { provisorio }
                $E7: c2:='ss';
                $C7: c2:='SS';

                $C6: c2:='a~';   { gerados pelo OCR }
                $E4: c2:='o~';
                $D6: c2:='I''';
            else
                     c2:=' '
            end;

            s2 := s2 + c2;
        end;

    ansiParaFala := s2;
end;

{--------------------------------------------------------}
{             conversao para caracteres de tela
{--------------------------------------------------------}

function ansiParaTela (c: char): char;
begin
    if c > #127 then
      case ord(c) of
        $E1: c:='';
        $E9: c:='';
        $ED: c:='';
        $F3: c:='';
        $FA: c:='';
        $C1: c:='';
        $C9: c:='';
        $CD: c:='';
        $D3: c:='';
        $DA: c:='';
        $E2: c:='';
        $EA: c:='';
        $F4: c:='';
        $C2: c:='';
        $CA: c:='';
        $D4: c:='';
        $E3: c:='';
        $F5: c:='';
        $C3: c:='';
        $D5: c:='';
        $E0: c:='';
        $C0: c:='';
        $FC: c:='u';   { provisorio }
        $DC: c:='U';   { provisorio }
        $E7: c:='';
        $C7: c:='';

        $C6: c:='';   { gerados pelo OCR }
        $E4: c:='';
        $D6: c:='';
    end;
    ansiParaTela := c;
end;

{--------------------------------------------------------}
{                  tratamento de mensagens
{--------------------------------------------------------}

const
    LVSEMTRD = 0;
    LVLEITOR = 1;
    LVFIM    = 2;
    LVERR    = 3;
    LVCOMFIM = 4;
    LVDIGNOM = 5;
    LVNAOEXI = 6;
    LVVOLTA  = 7;
    LVERRLEI = 8;
    LVPROCAN = 9;
    LVDESIS  = 10;
    LVTECF1  = 11;
    LVPLIM   = 12;
    LVOK     = 18;
    LVFIMARQ = 19;
    LVQAVAN  = 20;

    LVVELOC  = 21;
    LVINIPAR = 22;
    LVFIMPAR = 23;
    LVINITXT = 24;
    LVFIMTXT = 25;
    LVPARAM  = 26;
    LVCLKFIM = 27;
    LVPONTUA = 28;

    LVPROC   = 30;
    LVCONTIN = 31;
    LVOPBUSC = 32;
    LVACH    = 33;
    LVNACH   = 34;

    LVMRKIN  = 35;
    LVMRKOP  = 36;
    LVLINHA  = 37;

    LVAJUDA1 = 60;
    LVAJUDA2 = 61;
    LVAJUDA3 = 62;
    LVAJUDA4 = 63;
    LVAJUDA5 = 64;
    LVAJUDA6 = 65;
    LVAJUDA7 = 66;
    LVAJUDA8 = 67;
    LVAJUDA9 = 68;
    LVAJUD10 = 69;
    LVAJUDAn = LVAJUD10;


procedure mensagem (n, nlf: integer);
var 
    s, nomearq: string;
    fonemas: string;
    i: integer;
begin
    case n of

    LVSEMTRD:  s := 'LVSEMTRD|Erro no diretorio do tradutor';
    LVLEITOR:  s := 'LVLEITOR@Leitor VOX - verso ';
    LVFIM   :  s := 'LVFIM   |Fim de leitura';
    LVERR   :  s := 'LVERR   |Opo errada.  ';
    LVCOMFIM:  s := 'LVCOMFIM|Confirma fim (s/n)? ';
    LVDIGNOM:  s := 'LVDIGNOM|Nome do arquivo: ';
    LVNAOEXI:  s := 'LVNAOEXI|Arquivo no existe';
    LVVOLTA :  s := 'LVVOLTA |Voltei ao texto que estava lendo';
    LVERRLEI:  s := 'LVERRLEI|Erro de leitura do arquivo';
    LVPROCAN:  s := 'LVPROCAN|Programa foi cancelado';
    LVDESIS :  s := 'LVDESIS |Desistiu';
    LVTECF1 :  s := 'LVTECF1 |Tecle F1 para ajuda';
    LVPLIM  :  s := 'LVPLIM  |';

    LVOK    :  s := 'LVOK    |OK';
    LVFIMARQ:  s := 'LVFIMARQ|Fim de arquivo';
    LVQAVAN :  s := 'LVQAVAN |Quantas linha avano ?';

    LVINITXT:  s := 'LVINIPAR|Voltei ao inicio do texto';
    LVFIMTXT:  s := 'LVFIMPAR|Avancei para o fim do texto';

    LVVELOC :  s := 'LVVELOC |Qual a velocidade, de 1 a 4 ? ';
    LVPARAM :  s := 'LVPARAM |Modificando modo de fala.';
    LVCLKFIM:  s := 'LVCLKFIM|Poe clek ao fim da linha ? ';
    LVPONTUA:  s := 'LVPONTUA|Falo a pontuacao ? ';

    LVPROC  :  s := 'LVPROC  |Qual o texto a buscar ? ';
    LVCONTIN:  s := 'LVCONTIN@(O mesmo texto)';
    LVOPBUSC:  s := 'LVOPBUSC|Todo texto (T) ou proxima (P) ? ';
    LVACH   :  s := 'LVACH   |Achei';
    LVNACH  :  s := 'LVNACH  |Nao encontrei';
    LVLINHA :  s := 'LVLINHA |Linha ';

    LVAJUDA1:  s := 'LVAJUDA1|Use setas e controles para andar no texto';
    LVAJUDA2:  s := 'LVAJUDA2|Enter ou espao continuam a leitura.     ';
    LVAJUDA3:  s := 'LVAJUDA3|F1  - ajuda                              ';
    LVAJUDA4:  s := 'LVAJUDA4|F2  - nada                               ';
    LVAJUDA5:  s := 'LVAJUDA5|F3  - troca de arquivo                   ';
    LVAJUDA6:  s := 'LVAJUDA6|F4  - altera os parametros de sintese    ';
    LVAJUDA7:  s := 'LVAJUDA7|F5  - procura um texto                   ';
    LVAJUDA8:  s := 'LVAJUDA8|F6  - nada                               ';
    LVAJUDA9:  s := 'LVAJUDA9|F7  - avanca varias linhas               ';
    LVAJUD10:  s := 'LVAJUD10|ESC - termina leitura                    ';

    end;

    nomearq := copy (s, 1, 8);
    while nomearq[length(nomearq)] = ' ' do
        nomearq := copy (nomearq, 1, length(nomearq)-1);

    if s[9] <> '@' then
        textBackground (BLUE);

    s := copy (s, 10, length (s)-9);

    write (s);
    textBackground (BLACK);

    for i := 1 to nlf do
        writeln;

    if graveiVoz then
        sintSom (nomearq)
    else
        begin
            compilaFonemas (s, fonemas);
            falaFonemas (fonemas, true);
        end;
end;

{--------------------------------------------------------}
{                    abre arquivo
{--------------------------------------------------------}

const 
    NOVO     = 0;
    PEDENOME = 1;
    REABRE   = 2;

function abreArquivo (opcao: integer): boolean;
var
    c: char;

begin
    jaLido := false;

    nomeArqLeit := '';
    if (paramCount = 0) or (opcao = PEDENOME) then
        begin
            mensagem (LVDIGNOM, 0);
            c := editaCampo (nomeArqLeit, wherex, wherey, 79-wherex, true);

            if (c = #$1b) or (nomeArqLeit = '') then
                begin
                    writeln;
                    mensagem (LVDESIS, 1);
                    abreArquivo := false;
                    exit;
                end;

            writeln;
        end
    else
        nomeArqLeit := paramStr(1);

    assign (arqleit, nomeArqLeit);
    {$I-} reset (arqleit); {$I+}
    if ioresult <> 0 then
        begin
            mensagem (LVNAOEXI, 1);
            abreArquivo := false;
        end
    else
        begin
            tamArq := fileSize (arqLeit);
            abreArquivo := true;
            linhaAtual := 1;
        end;
end;

{--------------------------------------------------------}
{                   pede arquivo novo
{--------------------------------------------------------}

procedure arquivoNovo;
var
    salva: string;
begin
    salva := nomeArqLeit;
    close (arqLeit);

    if not abreArquivo (PEDENOME) then
        begin
            mensagem (LVVOLTA, 1);
            nomeArqLeit := salva;
            if not abreArquivo (REABRE) then
                begin
                    mensagem (LVERRLEI, 1);
                    mensagem (LVPROCAN, 1);
                    halt;
                end;
        end
    else
        begin
            posArq := 0;
            linhaAtual := 1;
        end;
end;

{--------------------------------------------------------}
{                    inicializacao
{--------------------------------------------------------}

procedure inicializa;
var s: string;
    erro: integer;
begin
    textBackground (BLACK);
    clrscr;
    textBackground (BLUE);
    writeln ('**      ******   **   **   *****   **   **');
    writeln ('**      **       **   **  **   **   ** ** ');
    writeln ('**      **       **   **  **   **    ***  ');
    writeln ('**      ****     **   **  **   **     *   ');
    writeln ('**      **        ** **   **   **    ***  ');
    writeln ('**      **         ***    **   **   ** ** ');
    writeln ('******  ******      *      *****   **   **');
    textBackground (BLACK);
    writeln;

   sintinic (0, 'DIRLEVOX');
   if tradInic <> 0 then
       mensagem (LVSEMTRD, 1);

    mensagem (LVLEITOR, 0);   { Leitor Vox }
    writeln (versao);
    writeln;

    if not abreArquivo (NOVO) then
        begin
            mensagem (LVPROCAN, 2);
            tradFim;
            halt;
        end;

    writeln;
    ALFA := ['A'..'Z'] + ['a'..'z'] + [#128..#255];

    posArq := 0;
    pontuando := false;
    ecoando := true;
    clekFimLinha := true;
    ultBusca := '';
    velocFala := 0;

    linhaAtual := 1;
end;

{--------------------------------------------------------}
{                  opcao de fim do DOSVOX
{--------------------------------------------------------}

procedure fimLeVOX;
var c, c2: char;
begin
    close (arqLeit);
    mensagem (LVFIM, 2);
    clrscr;
    tradFim;
end;

{--------------------------------------------------------}
{               modifica parametros da sintese
{--------------------------------------------------------}

procedure paramSintese;
var erro: integer;
    s: string;
    c: char;

label 1, 2, 3, fim;

begin
    writeln;
    mensagem (LVPARAM, 1);   { modificando modo de fala }

    mensagem (LVCLKFIM, 0);  { Poe cleck ao fim da linha ? }
    c := readkey;
    if c = #$1b then goto fim;
    write (c); sintCarac (c);
    clekFimLinha := upcase(c) = 'S';

    writeln;
    mensagem (LVPONTUA, 0);  { Fala pontuacao ? }
    c := readkey;
    if c = #$1b then goto fim;
    write (c); sintCarac (c);
    pontuando := upcase(c) = 'S';

    writeln;
    mensagem (LVVELOC, 0);  { Qual a velocidade de 1 a 4 ? }
    c := readkey;
    write (c); sintCarac (c);

    velocFala := ord (c) - ord ('0');
    if (velocFala < 1) or (velocFala > 4) then
        velocFala := 0;

fim:
    writeln;
    mensagem (LVOK, 1);
end;

{--------------------------------------------------------}
{                    leitura de caracteres
{--------------------------------------------------------}

procedure desleCarac (c: char);
begin
    jaLido := true;
    ultLido := c;
end;

function leCarac: char;
var c: char;
begin
    if jaLido then
        begin
            lecarac := ultLido;
            jaLido := false;
        end
    else
        begin
            if posArq < 0 then
                begin
                    posArq := 0;
                    linhaAtual := 1;
                    seek (arqleit, 0);
                end;
 
            if posArq >= tamArq then
                c := ' '
            else
                begin
                    read (arqleit, c);
                    posArq := posArq + 1;
                    if ecoando then
                        write (ansiParatela (c));
                end;
            leCarac := c;
        end;
end;

{--------------------------------------------------------}
{                recua ate' certo caractere
{--------------------------------------------------------}

procedure recua (c: char);
var c2: char;
begin
    sintClek;
    repeat
        if posArq <= 0 then
            begin
                posarq := 0;
                seek (arqLeit, 0);
                linhaAtual := 1;
                writeln;
                mensagem (LVINITXT, 1);
                exit;
            end;

        posArq := posArq - 1;
        seek (arqLeit, posArq);
        read (arqLeit, c2);
        if c2 = #$0a then
            linhaAtual := linhaAtual - 1;
        seek (arqLeit, posArq);
    until c = c2;

    write (#13); clreol;
end;

{--------------------------------------------------------}
{                 avanca ate certo caractere
{--------------------------------------------------------}

procedure avanca (c: char);
var cc: char;
begin
    if posArq >= TamArq then
        mensagem (LVFIMTXT, 1)
    else
        begin
            sintClek;
            repeat
                 cc := leCarac;
                 if cc = #$0a then
                     linhaAtual := linhaAtual + 1;
            until (cc = c) or (posArq >= TamArq);

            if posArq >= TamArq then
                begin
                    writeln;
                    mensagem (LVFIMTXT, 1);
                end;
        end;
end;

{--------------------------------------------------------}
{                volta um caractere
{--------------------------------------------------------}

procedure voltaCarac (falando: boolean);
var c: char;
begin
    if not parado then writeln;

    if posarq <= 0 then
        mensagem (LVINITXT, 1)
    else
       begin
           posArq := posArq - 1;
           seek (arqLeit, posArq);
           read (arqLeit, c);
           if c = #$0a then
               linhaAtual := linhaAtual - 1;

           sintCarac (ansiParaTela(c));
           seek (arqLeit, posArq);
       end;
end;

{--------------------------------------------------------}
{                avanca um caractere
{--------------------------------------------------------}

procedure avancaCarac;
var c: char;
begin
    if posarq >= tamArq then
        mensagem (LVFIMTXT, 1)
    else
       begin
           c := leCarac;
           sintCarac (ansiParaTela(c));
           if c = #$0a then
               linhaAtual := linhaAtual + 1;
       end;
end;

{--------------------------------------------------------}
{               inicio ou fim da frase
{--------------------------------------------------------}

procedure inicioFrase;
begin
    sintClek;
    sintClek;
    recua ('.');
end;

{--------------------------------------------------------}

procedure fimFrase;
begin
    sintClek;
    sintClek;
    avanca ('.');
end;

{--------------------------------------------------------}
{                 sobe ou desce uma linha
{--------------------------------------------------------}

procedure sobeLinha;
var c: char;
begin
    recua (#$0a);
end;

{--------------------------------------------------------}

procedure desceLinha;
begin
    avanca (#$0a);
end;

{--------------------------------------------------------}
{                 inicio ou fim do texto
{--------------------------------------------------------}

procedure inicioTexto;
var c: char;
begin
    posArq := 0;
    recua (#$0a);
    while keypressed do c := readkey;
    linhaAtual := 1;
end;

{--------------------------------------------------------}

procedure fimTexto;
var c: char;
    salva: boolean;
begin
    salva := ecoando;
    ecoando := false;
    avanca (#$ff);
    ecoando := salva;
    while keypressed do c := readkey;
end;

{--------------------------------------------------------}
{              volta ao inicio do paragrafo
{--------------------------------------------------------}

procedure inicioParagrafo;
var 
    pos1, pos2: longint;
begin
    posarq := posarq - 2;
    if posarq < 0 then posarq := 0;

    pos1 := posarq;
    repeat
        pos2 := pos1;
        recua (#$0a);
        pos1 := posArq;
        if posArq = 0 then exit;
    until pos2 - pos1 <= 2;
end;

{--------------------------------------------------------}
{                    vai ao fim do paragrafo
{--------------------------------------------------------}

procedure fimParagrafo;
var 
    pos1, pos2: longint;
begin
    pos2 := posarq+2;
    repeat
        pos1 := pos2;
        avanca (#$0a);
        pos2 := posArq;
        if pos2 >= tamarq then exit;
    until pos2 - pos1 <= 2;
end;

{--------------------------------------------------------}
{                  volta ao ultimo branco
{--------------------------------------------------------}

procedure voltaPalavra;
begin
    voltaCarac (false);
    if posArq <> 0 then 
        recua (' ');
end;

{--------------------------------------------------------}
{                    avanca linhas
{--------------------------------------------------------}

procedure avancaLinhas;
var
    s: string;
    c: char;
    i, navan: longint;
    erro: integer;

label fim;

begin
    writeln;
    mensagem (LVQAVAN, 0);
    s := '';
    c := editaCampo (s, wherex, wherey, 30, true);
    if c = #$1b then
        exit;
    writeln;

    val (s, navan, erro);
    if erro <> 0 then navan := 0;

    ecoando := false;
    for i := 1 to navan do
         begin
             repeat 
                 c := lecarac;
                 if posArq >= tamArq then
                     begin
                         mensagem (LVFIMTXT, 1);
                         goto fim;
                     end;
             until c = #$0a;
             linhaAtual := linhaAtual + 1;
         end;
    mensagem (LVOK, 1);
fim:
    ecoando := true;
end;

{--------------------------------------------------------}
{                   procura um texto
{--------------------------------------------------------}

procedure procuraTexto;
var 
    s, lido: string;
    c, opcao: char;
    i, salvaPos, salvaLinha: longint;
    achou: boolean;

label fim;

begin
    salvaPos := posArq;
    salvaLinha := linhaAtual;

    writeln;
    mensagem (LVPROC, 0);
    s := '';
    c := editaCampo (s, wherex, wherey, 30, true);
    if c = #$1b then
        exit;

    if s = '' then
        begin
             s := ultBusca;
             mensagem (LVCONTIN, 1);
             opcao := 'P';
        end
    else
        begin
            writeln;
            mensagem (LVOPBUSC, 0);
            c := readkey;
            if c = #$1b then goto fim;
            sintCarac (c);
            opcao := upcase(c);
        end;

    ultBusca := s;
    writeln;

    for i := 1 to length (s) do
        s[i] := ansiParaTela (upcase(s[i]));

    if opcao <> 'P' then
        begin
            seek (arqLeit, 0);
            posArq := 0;
            linhaAtual := 0;
        end;

    lido := '';
    achou := false;

    ecoando := false;
    repeat
         c := leCarac;
         if c = #$0a then
             linhaAtual := linhaAtual + 1;

         lido := lido + ansiParaTela(upcase(c));
         if length(lido) > length(s) then
             delete (lido, 1, 1);
         achou := lido = s;
    until (posArq >= tamArq) or achou;
    ecoando := true;

    if achou then
        begin
            for i := 1 to length(s) do
                voltaCarac (false);
            mensagem (LVACH, 1);
        end
    else
        begin
            mensagem (LVNACH, 1);
            posArq := salvaPos;
            linhaAtual := salvaLinha;
            seek (arqLeit, posArq);
        end;

fim:
end;

{--------------------------------------------------------}
{                        ajuda
{--------------------------------------------------------}

procedure ajuda;
var 
    i: integer;
    c: char;

label fim;

begin
    writeln;
    for i := LVAJUDA1 to LVAJUDAn do
        begin
            mensagem (i, 1);
            if keypressed then goto fim;
        end;

fim:
    while keypressed do c := readkey;
end;

{--------------------------------------------------------}
{                    trata os comandos
{--------------------------------------------------------}

procedure nada;
begin
    mensagem (LVERR, 0);
    mensagem (LVTECF1, 1);
end;

{--------------------------------------------------------}

procedure comandos (c: char);
begin
    case c of

        CTLF1: comandou := true;

        F1   : ajuda;
        F2   : nada;
        F3   : arquivoNovo;
        F4   : paramSintese;
        F5   : procuraTexto;
        F6   : nada;
        F7   : avancaLinhas;
        F8   : falaHora;
        F9   : nada;
        F10  : nada;

        HOME : inicioFrase;
        TEND : fimFrase;
        PGUP : inicioParagrafo;
        PGDN : fimParagrafo;
        CIMA : sobeLinha;
        BAIX : desceLinha;
        ESQ  : voltaCarac (true);
        DIR  : avancaCarac;

        CTLPGUP: inicioTexto;
        CTLPGDN: fimTexto;
        CTLESQ:  voltaPalavra;
        CTLDIR:  avanca (' ');

    end;
end;

{--------------------------------------------------------}
{                    trata o teclado
{--------------------------------------------------------}

procedure trataTeclado;
var
    c: char;
begin
    sintBip;
    sintBip;

    parado := false;
    jalido := false;
    writeln;

    comandou := false;
    repeat
        c := readkey;
        case c of
            #$1b:  begin
                      mensagem (LVCOMFIM, 0);
                      c := readkey;
                      writeln (c);
                      sintCarac (c);

                      if upcase(c) = 'S' then
                          begin
                              processando := false;
                              comandou := true;
                          end;
                  end;

            #$0d, ' ':  if parado then
                            comandos (CTLF1)
                        else
                            parado := true;

            ^L:         begin
                            mensagem (LVLINHA, 0);
                            textBackground (blue);
                            falaNumeroConv (numeroParaString (linhaAtual),
                                            MASCULINO);
                            textBackground (black);
                            writeln;
                        end;

            #$08, #$09: comandos (c);

            #0:         comandos (readkey);
        else
            nada;
        end;

        parado := true;

    until comandou;

    clreol;
end;

{--------------------------------------------------------}
{              pega proxima palavra no texto
{--------------------------------------------------------}

function pegaTrecho: string;
var s: string;
    c: char;


    procedure pegaLetras;
    begin
        s := c;
        c := leCarac;
        while (c in ALFA) or (c = '-') do
            begin
                if c = '-' then
                    s := s + ' '
                else
                    s := s + c;
                c := leCarac;
            end;

        if c = #$0d then c := lecarac;
    
        if c <> ' ' then
            desleCarac (c);
    end;

{--------------------------------------------------------}

    procedure pegaNumero;
    var v, salvapos: longint;
        erro: integer;
        s2: string;
    begin
        s2 := c;
        c := leCarac;
        while c in ['0'..'9'] do
            begin
                s2 := s2 + c;
                c := leCarac;
            end;

        val (s2, v, erro);
        falanumeroconv (numeroParaString(v), masculino);

        if (c = '.') and not pontuando then
           s := s + ' . '
        else
        if (c = ',') and not pontuando then
           s := s + ' , '
        else
        if c <> ' ' then
            desleCarac (c);
    end;

{--------------------------------------------------------}

    procedure trataControles;
    var i, espera: integer;
    begin
        s := ' ';
        case c of
            #$09: sintBip;

            #$0c: for i := 0 to 4 do
                      sintclek;

            #$0a:
                begin
                    linhaAtual := linhaAtual + 1;
                    if clekFimLinha then sintClek;
                    espera := 0;
                    repeat
                        c := leCarac;
                        if c = #$0a then
                            begin
                                linhaAtual := linhaAtual + 1;
                                if clekFimLinha then sintClek;
                                espera := espera + 1;
                            end;

                    until not (c in [#$0d, #$0a]);
                    desleCarac (c);

                    if espera > 0 then
                        delay (200);
                end;
        end;
    end;

{--------------------------------------------------------}

begin
    s := '';

    c := leCarac;

    if c in NUMEROS then pegaNumero
    else
    if c in ALFA    then pegaLetras
    else
    if c in CONTROL then trataControles
    else
        s := c;

    pegaTrecho := ansiParaFala (s);
end;

{--------------------------------------------------------}
{                    fala o arquivo
{--------------------------------------------------------}

procedure falaArquivo;
var 
    palavras, fonemas: string;

begin
    tradFim;
    selecTipoFonemas (velocFala);
    if tradInic <> 0 then
        begin
            tradFim;
            selecTipoFonemas (0);
            if tradInic <> 0 then;
        end;


    while posArq < tamArq do
        begin
            if keypressed then 
                begin
                    tradFim;
                    selecTipoFonemas (0);
                    if tradInic <> 0 then;
                    exit;
                end;

            palavras := pegaTrecho;

            compilaFonemas (palavras, fonemas);
            falaFonemas (fonemas, pontuando);
        end;

    if posArq >= tamArq then
        begin
            writeln;
            tradFim;
            selecTipoFonemas (0);
            if tradInic <> 0 then;

            mensagem (LVFIMARQ, 1);
            trataTeclado;
        end;
end;

{--------------------------------------------------------}
{                    programa principal
{--------------------------------------------------------}

begin
     inicializa;

     processando := true;
     while processando do
         begin
             if keypressed then
                 trataTeclado
             else
                 falaArquivo;
         end;

     fimLeVOX;
end.
