{--------------------------------------------------------}
{
{     Rotinas de fala para ensino
{
{     Autor: Jos Antonio Borges
{
{     Em janeiro/96
{
{--------------------------------------------------------}

unit dv;
interface

uses crt, dos, sintvox, traduvox, intervox, lenumstr;

var dvFalando: integer;

procedure dvReadLn (var s: string);
procedure dvReadInt (var valor: integer);
procedure dvReadReal (var valor: real);
function  dvReadKey: char;

procedure dvWrite (s: string);
procedure dvWriteLn (s: string);
procedure dvWriteInt (valor: integer);
procedure dvWriteLnInt (valor: integer);
procedure dvWriteReal (valor: real; ndig, ndec: integer);
procedure dvWriteLnReal (valor: real; ndig, ndec: integer);

procedure dvMensagem (som: string; s: string);

implementation

var
    fon: string;

{--------------------------------------------------------}
{               converte para codigo PC
{--------------------------------------------------------}

procedure ansiParaPC (var s: string);
var i: integer;
    c: char;
begin
    for i := 1 to length (s) do
        begin
            c := s[i];
            if c > #127 then
              case ord(c) of
                $E1: c:='';
                $E9: c:='';
                $ED: c:='';
                $F3: c:='';
                $FA: c:='';
                $C1: c:='';
                $C9: c:='';
                $CD: c:='';
                $D3: c:='';
                $DA: c:='';
                $E2: c:='';
                $EA: c:='';
                $F4: c:='';
                $C2: c:='';
                $CA: c:='';
                $D4: c:='';
                $E3: c:='';
                $F5: c:='';
                $C3: c:='';
                $D5: c:='';
                $E0: c:='';
                $C0: c:='';
                $FC: c:='u';  {provisorio}
                $DC: c:='U';  {provisorio}
                $E7: c:='';
                $C7: c:='';
            end;
            s[i] := c;
        end;
end;
{--------------------------------------------------------}
{                le teclado com eco
{--------------------------------------------------------}

procedure dvreadln (var s: string);
var i: integer;
    c, c2: char;
begin
    s := '';
    repeat
        c := readkey;
        case c of
            #$1b:
                begin
                    for i := 1 to length (s) do
                        begin
                            write (#$08, ' ', #$08);
                            sintClek;
                        end;
                    s := '';
                    sintClek;
                end;

            #0:  c := readkey;

            #08:
                if length (s) > 0 then
                    begin
                        sintClek;
                        sintCarac (s[length(s)]);
                        write (#$08, ' ', #$08);

                        s := copy (s, 1, length(s)-1);
                    end;

            #32..#255:
                begin
                    s := s + c;
                    if dvFalando <> 0 then
                        sintCarac (c);
                    write (c);
                end;
        end;

    until c = #$0d;
    writeln;
    ansiParaPC (s);
end;

{--------------------------------------------------------}
{                le um valor inteiro
{--------------------------------------------------------}

procedure dvReadInt (var valor: integer);
var s: string;
    x, y, i, erro: integer;

label deNovo;

begin
    x := wherex; y := wherey;
deNovo:
    dvreadln (s);
    val (s, valor, erro);
    if erro <> 0 then
        begin
            gotoxy (x, y);
            for i := 1 to length (s) do write (' ');
            sintBip; sintBip; sintBip;
            gotoxy (x, y);
            goto deNovo;
        end;
end;

{--------------------------------------------------------}
{                 le um valor real
{--------------------------------------------------------}

procedure dvReadReal (var valor: real);
var s: string;
    x, y, i, erro: integer;

label deNovo;

begin
    x := wherex; y := wherey;
deNovo:
    dvreadln (s);
    val (s, valor, erro);
    if erro <> 0 then
        begin
            gotoxy (x, y);
            for i := 1 to length (s) do write (' ');
            sintBip; sintBip; sintBip;
            gotoxy (x, y);
            goto deNovo;
        end;
end;

{--------------------------------------------------------}
{            le uma tecla falando, sem ecoar
{--------------------------------------------------------}

function dvReadKey: char;
var c: char;
begin
    c := readkey;
    sintCarac (c);
    dvReadKey := c;
end;

{--------------------------------------------------------}
{               escreve e fala uma cadeia
{--------------------------------------------------------}

procedure dvWrite (s: string);
begin
    write (s);
    compilaFonemas (s, fon);
    falaFonemas (fon, true);
end;

{--------------------------------------------------------}
{        escreve e fala uma cadeia pulando linha
{--------------------------------------------------------}

procedure dvWriteLn (s: string);
begin
    writeln (s);
    compilaFonemas (s, fon);
    falaFonemas (fon, true);
end;

{--------------------------------------------------------}
{           escreve e fala um numero inteiro
{--------------------------------------------------------}

procedure dvWriteInt (valor: integer);
var s: string;
begin
    write (valor);
    s := numeroParaString (valor);
    compilaFonemas (s, fon);
    falaFonemas (fon, true);
end;

{--------------------------------------------------------}
{           escreve e fala um numero real
{--------------------------------------------------------}

procedure dvWriteReal (valor: real; ndig, ndec: integer);
var i, inteiro: longint;
    frac: real;
    s: string;
begin
    write (valor:ndig:ndec);
    inteiro := trunc (valor);
    s := numeroParaString (inteiro);
    compilaFonemas (s, fon);
    falaFonemas (fon, true);

    if ndec <> 0 then
        sintCarac ('.');

    frac := valor - inteiro;
    for i := 1 to ndec do
         begin
             frac := frac * 10;
             inteiro := trunc (frac);
             sintCarac (chr(inteiro+ord('0')));
             frac := frac - inteiro;
         end;
end;

{--------------------------------------------------------}
{    escreve e fala um numero inteiro pulando linha
{--------------------------------------------------------}

procedure dvWriteLnInt (valor: integer);
begin
    dvWriteInt (valor);
    writeln;
end;

{--------------------------------------------------------}
{    escreve e fala um numero real pulando linha
{--------------------------------------------------------}

procedure dvWriteLnReal (valor: real; ndig, ndec: integer);
begin
    dvWriteReal (valor, ndig, ndec);
    writeln;
end;

{--------------------------------------------------------}
{                   escreve e fala cadeia
{--------------------------------------------------------}

procedure dvMensagem (som: string; s: string);
begin
    writeln (s);
    sintSom (som);
end;

begin
    sintinic (0, '');
    if tradinic <> 0 then;
end.
