{--------------------------------------------------------}
{       televox - rotinas de tratamento de itens
{--------------------------------------------------------}

unit telitem;

interface
Uses
    CRT, DOS, TelDados, TelTela,
    Readvox, Traduvox, Intervox, SintVox;

procedure removeTodosItens (posTab: integer);
procedure atualizaItem (qual, posTab: integer; campo: string);
procedure novoRegistro (postab: integer);
function obtemItem (qual, postab: integer): string;
function mostraItem (qual, postab: integer; falando: boolean): string;
procedure mostraItens (postab: integer);
function editaItem (qual, posTab: integer; altera: boolean): char;
function passeiaNosItens (postab: integer; alterando: boolean): char;
procedure removeRegistro (postab: integer);
procedure limpaLista;

implementation

{--------------------------------------------------------}
{                    atualiza um item
{--------------------------------------------------------}

procedure atualizaItem (qual, posTab: integer; campo: string);
var pcampo: pString;
begin
    if qual > NUMCAMPOS then exit;

    with listaFone[postab]^ do
        case qual of
                1: pcampo := nome;
                2: pcampo := telefone;
                3: pcampo := endereco;
                4: pcampo := cidade;
                5: pcampo := cep;
                6: pcampo := observ[1];
                7: pcampo := observ[2];
                8: pcampo := observ[3];
                9: pcampo := observ[4];
               10: pcampo := observ[5];
               11: pcampo := observ[6];
        end;

    if pcampo <> NIL then
        freemem (pcampo, length(pcampo^)+1);

    if campo = '' then
        pcampo := NIL
    else
        begin
            getmem (pcampo, length (campo)+1);
            move (campo, pcampo^, length (campo)+1);
        end;

    with listaFone[postab]^ do
        case qual of
                1: nome      := pcampo;
                2: telefone  := pcampo;
                3: endereco  := pcampo;
                4: cidade    := pcampo;
                5: cep       := pcampo;
                6: observ[1] := pcampo;
                7: observ[2] := pcampo;
                8: observ[3] := pcampo;
                9: observ[4] := pcampo;
               10: observ[5] := pcampo;
               11: observ[6] := pcampo;
        end;
end;

{--------------------------------------------------------}
{          remove todos os itens de um registro
{--------------------------------------------------------}

procedure removeTodosItens (posTab: integer);
var qual: integer;
begin
    for qual := 1 to 11 do
         atualizaItem (qual, posTab, '');
end;

{--------------------------------------------------------}
{                 cria novo item
{--------------------------------------------------------}

procedure novoRegistro (postab: integer);
var qual: integer;
begin
    new (listaFone [postab]);
    with listaFone[postab]^ do
        begin
            status := 0;
            nome := NIL;
            telefone := NIL;
            endereco := NIL;
            cidade := NIL;
            cep := NIL;
            observ[1] := NIL;
            observ[2] := NIL;
            observ[3] := NIL;
            observ[4] := NIL;
            observ[5] := NIL;
            observ[6] := NIL;
        end;
end;

{--------------------------------------------------------}
{                  obtem um item pelo numero
{--------------------------------------------------------}

function obtemItem (qual, postab: integer): string;
var
    texto, fala: string;
    pcampo: pString;
    campo: string;
begin
    with listaFone [postab]^ do
            case qual of
                1: pcampo := nome;
                2: pcampo := telefone;
                3: pcampo := endereco;
                4: pcampo := cidade;
                5: pcampo := cep;
                6: pcampo := observ[1];
                7: pcampo := observ[2];
                8: pcampo := observ[3];
                9: pcampo := observ[4];
               10: pcampo := observ[5];
               11: pcampo := observ[6];
            end;

    if pcampo = NIL then
        obtemItem := ''
    else
        obtemItem := pcampo^;
end;

{--------------------------------------------------------}
{                  mostra itens na tela
{--------------------------------------------------------}

function mostraItem (qual, postab: integer; falando: boolean): string;
var
    texto, fala: string;
    pcampo: pString;
    campo: string;
begin
    texto := tabTexto [qual];
    fala := tabFala [qual];
    campo := obtemItem (qual, posTab);

    gotoxy (1, 12+qual);
    textBackground (RED);
    write (texto:15);
    textBackground (BLACK);
    write (ansiParaPC (campo));
    clreol;

    if falando then
        sintsom (fala);

    mostraItem := campo;
end;

{--------------------------------------------------------}
{                   mostra os itens na tela
{--------------------------------------------------------}

procedure mostraItens (postab: integer);
var qual: integer;
    s: string;
begin
    for qual := 1 to NUMCAMPOS do
        s := mostraItem (qual, postab, false);
end;

{--------------------------------------------------------}
{                    edita um item
{--------------------------------------------------------}

function editaItem (qual, posTab: integer; altera: boolean): char;
var
    campo: string;

begin
    campo := mostraItem (qual, posTab, true);
    editaItem := editaCampo (campo, 16, qual+12, 65, altera);
    atualizaItem (qual, posTab, campo);
end;

{--------------------------------------------------------}
{                 passeia sobre os itens
{--------------------------------------------------------}

function passeiaNosItens (postab: integer; alterando: boolean): char;
var
    qual: integer;
    acabou: boolean;
    c: char;

begin
    qual := 1;
    acabou := false;
    repeat
        c := editaItem (qual, postab, alterando);
        case c of
            CIMA:              qual := qual - 1;
            BAIX, TAB, ENTER:  qual := qual + 1;

            CTLPGUP, CTLPGDN,
            ESC, PGUP, PGDN:   acabou := true;
        end;
        if qual < 1 then qual := 1;
        if qual > NUMCAMPOS then qual := NUMCAMPOS;

    until acabou;
    passeiaNosItens := c;
end;

{--------------------------------------------------------}
{                   remove um registro
{--------------------------------------------------------}

procedure removeRegistro (postab: integer);
var i: integer;
begin
    removeTodosItens (postab);
    dispose (listaFone [postab]);
    if postab <= cadastrados then
        begin
            for i := postab to cadastrados-1 do
                listaFone [i] := listaFone [i+1];
            cadastrados := cadastrados - 1;
        end;
end;

{--------------------------------------------------------}
{                  limpa a lista
{--------------------------------------------------------}

procedure limpaLista;
var i: integer;
begin
    for i := 1 to cadastrados do
        begin
            removeTodosItens (i);
            dispose (listaFone [i]);
        end;

    cadastrados := 0;
end;

end.
