{--------------------------------------------------------}
{
{    Rotinas de conversao para impressora
{
{    Autor: Jose' Antonio Borges
{
{    Em abril/96
{
{--------------------------------------------------------}

unit codPrint;
interface
uses dos, crt;

function inicTabPrinter (ambImpriVox: string): boolean;
procedure fimTabPrinter;
function traduzTabPrinter (s: string): string;

implementation
var
    tabCarac: array [char] of ^string;
    arq: text;
    linhaAmb: integer;

{--------------------------------------------------------}
procedure erroConfig (s: string);
begin
    writeln (#$07, #$07, #$07, #$07, 'Arquivo bichado, linha ', linhaAmb);
    writeln (s);
    halt;
end;

{--------------------------------------------------------}
{        le um numero binario dentro de uma string
{--------------------------------------------------------}

function hexaParaBinario (s: string; var poslida: integer): char;
var valor: integer;
    fimNumero, iniciouNumero: boolean;
    c: char;

begin
    valor := 0;
    iniciouNumero := false;
    fimNumero := false;

    repeat
        if poslida > length (s) then
           c := ' '
        else
           begin
               c := upcase (s[poslida]);
               poslida := poslida + 1;
           end;

        if c in ['0'..'9'] then
            valor := (valor shl 4) or (ord (c) and $f)
        else
        if c in ['A'..'F'] then
            valor := (valor shl 4) or (ord (c)-ord('A') + 10)
        else
        if not iniciouNumero then
            erroConfig (s)
        else
            fimNumero := true;

        iniciouNumero := true;

    until fimNumero;

    hexaParaBinario := chr (valor);
    poslida := poslida - 1;
end;

{--------------------------------------------------------}
{           pega o codigo de traducao de uma letra
{--------------------------------------------------------}

procedure pegaCodLetra (s: string);

var i, poslida, posvet: integer;
    qualLetra: char;
    codigo: string;
    vetNumeros: string;

begin
    poslida := 1;
    vetNumeros := '';
    for i := length (s) downto 1 do
        begin
            if s[i] = ' ' then
                delete (s, i, 1)
            else
                s[i] := upcase (s[i]);
        end;


    qualLetra := hexaParaBinario (s, poslida);
    if s[poslida] <> '=' then
        erroConfig (s);
    poslida := poslida + 1;
    while poslida <= length (s) do
        begin
            vetNumeros := vetNumeros + hexaParaBinario (s, poslida);
            if (poslida < length(s)) and (s[poslida] <> ',') then
                erroConfig (s);
            poslida := poslida + 1;
        end;

    getmem (tabCarac [qualLetra], length(vetNumeros) + 1);
    move (vetNumeros, tabCarac [qualLetra]^, length(vetNumeros) + 1);
end;


{--------------------------------------------------------}
{                       limpa memoria
{--------------------------------------------------------}

procedure fimTabPrinter;
var i: integer;
begin
    for i := 0 to 255 do
        if tabCarac[chr(i)] = NIL then
            begin
                freemem (tabCarac[chr(i)], length(tabCarac[chr(i)]^)+1);
                tabCarac[chr(i)] := NIL;
            end;
end;

{--------------------------------------------------------}
{    configura tabela de codigos para a impressora
{--------------------------------------------------------}

function inicTabPrinter (ambImpriVox: string): boolean;
var i, result: integer;
    s: string;
label fim;
begin
    inicTabPrinter := true;

    assign (arq, ambImpriVox);
    {$I-} reset (arq);  {$I+}
    if ioresult <> 0 then
         begin
             inicTabPrinter := false;
             fimTabPrinter;
         end;

    for i := 0 to 255 do
        begin
            getmem (tabCarac[chr(i)], 2);
            tabCarac [chr(i)]^ := chr(i);
        end;

    linhaAmb := 0;
    repeat
        {$I-}  readln (arq, s); {$I+}
        result := ioresult;
        if result = 0 then
            begin
                linhaAmb := linhaAmb + 1;

                if (s = '') or (s [1] = '*') then
                    { ignora }
                else
                    case upcase(s[1]) of
                        '<': ;
                        '0'..'9',
                        'A'..'F':  pegaCodLetra (s);
                    else
                        erroConfig (s);
                    end;
            end;

    until eof (arq) or (result <> 0);
end;


{--------------------------------------------------------}
{            traduz uma cadeia para a impressora
{--------------------------------------------------------}

function traduzTabPrinter (s: string): string;
var r: string;
    i: integer;
begin
    r := '';
    for i := 1 to length (s) do
        r := r + tabCarac [s[i]]^;
    traduzTabPrinter := r;
end;


var i: integer;
begin
    for i := 0 to 255 do
        tabCarac[chr(i)] := NIL;
end.
