{--------------------------------------------------------}
{
{   Sistema de Sintese da Fala
{
{   Funcao : A partir do texto compilado pelo modulo
{            traduvox, falar o texto
{
{   Autor  :  Jose' Antonio Borges
{
{   Data de criacao : Junho de 1994
{
{   Alterado por : Kelly Christine Correa
{
{   Data Alteracao : outubro de 1994
{
{--------------------------------------------------------}

unit intervox;

interface

uses dos, traduvox, sintvox, playvox, lenumstr;

function tradInic: integer;
function inicFonemas (tipo: integer): boolean;
procedure falaFonemas (fonemas: string; comPontuacao: boolean);
procedure selecTipoFonemas (tipo: integer);
procedure tradFim;
procedure sintetiza (s: string);

implementation

var tipoAtualFon: integer;

{--------------------------------------------------------}
{           modulo de interpretacao da fala
{--------------------------------------------------------}

const
    debug = false;

    VOGAIS: set of char = ['a','e','i','o','u','w','y',
                           'A','E','I','O','U'];

    VOGAIS_MESMO: set of char = ['a','e','i','o','u',
                                'A','E','I','O','U'];

    CONSOANTES: set of char = ['b','c','d','f','g','j','k','l','m','n',
                               'p','q','r','s','t','v','x','z'];

    SEMIVOGAIS: set of char = ['y','w'];

    ACENTOS: set of char = ['~', '^'];

type
    VETBYTE = array [0..65000] of byte;
    PBYTE = ^VETBYTE;

    INFODIFONE = record
        nomedifo: string[8];
        tamdifo: word;
        posdifo: longint;
    end;

    TABDIFONES = array [0..2000] of INFODIFONE;

    stringPeq = string[40];
    stringuinha = string[12];

var
    tabDifo: ^TABDIFONES;
    tamTabDifo: integer;

    arqDifones: file;
    dirLetras, dirDifones, nomarqDifones: string[80];

    pf: integer;
    silabaForte: integer;
    difone: boolean;
    Pant : PBYTE;
    TamArqAnt: word;

    intervalo: integer;
    portaHard: word;

    intPonto, intVirgula, intPtVirgula, intDoisPontos: integer;
    quantoCorta, minimoResto: integer;
    picotaFala, alteraVoz: boolean;

{--------------------------------------------------------}
{                   trata duplo buffer
{--------------------------------------------------------}

Procedure FalaDuploBuffer (pNovo: PBYTE; tamArqNovo: word; perc: real);
begin
    if debug then
        writeln ('.... tamanho: ', tamArqNovo*perc:5:0);

    while estaFalando do;
    if tamArqAnt <> 0 then
        freemem (pAnt, tamArqAnt);

    if tamArqNovo <> 0 then
        fala (pNovo, round (tamArqNovo*perc));

    pAnt := pNovo;
    tamArqAnt := tamArqNovo;
end;

{--------------------------------------------------------}
{                     trata silencio
{--------------------------------------------------------}

Procedure silencio (espaco: integer);
var i: integer;
    p: PBYTE;
begin
    while espaco > 0 do
        begin
            getmem (p, 100);
            for i := 0 to 99 do
                p^[i] := $80;
            falaDuploBuffer (p, 100, 1.0);
            espaco := espaco - 100;
        end;
end;

{--------------------------------------------------------}
{           carrega o buffer de fala do arquivo
{--------------------------------------------------------}

procedure falaRuido;
var
    tamArq: word;
    Pmem: PBYTE;
    i: integer;

begin
    tamArq := 300;
    getmem (Pmem, tamArq);
    for i := 0 to tamArq-1 do
        pMem^[i] := random(80);
    FalaDuploBuffer (PMem, TamArq, 1.0);
end;

{--------------------------------------------------------}

function falaLetra (nomearq: stringuinha): boolean;
var arq: file;
    tamArq: word;
    Pmem: PBYTE;
    result: integer;

begin
    falaLetra := false;

    assign (arq, dirLetras + nomearq+'.wav');
    {$i-} reset (arq, 1);  {$i+}
    result := ioresult;

    if result = 0 then
        begin
            seek (arq, 48);
            TamArq := filesize(arq) - 49;
            getmem (PMem, TamArq);
            blockread (arq, Pmem^, TamArq) ;
            close (arq);

            FalaDuploBuffer (PMem, TamArq, 1.0);
            falaLetra := true;
        end;
end;

{--------------------------------------------------------}

function falaDifone (nomearq: stringuinha; silabaForte: integer;
                     perc: real): boolean;
var
    inicio, fim, indTab: integer;
    tamArq, i: integer;
    posArq: longint;
    Pmem: PBYTE;
    p: ^byte;

label achou;

begin
    for i := 1 to length (nomearq) do
         nomearq[i] := upcase (nomearq[i]);

    falaDifone := true;
    inicio := 0;
    fim := tamTabDifo;

    while (inicio <= fim) do
        begin
            indTab := (inicio + fim) div 2;

            with tabDifo^[indTab] do
                begin
                    if nomeDifo = nomearq then
                        goto achou;
                    if nomearq > nomeDifo then
                        inicio := indTab+1
                    else
                        fim := indTab-1;
                end;
        end;

    falaDifone := false;
    exit;

achou:
    with tabDifo^[indTab] do
        begin
            posArq := posDifo;
            TamArq := tamDifo;

            if (silabaForte < 2) and (length (nomearq) > 2) then
                begin
                    tamArq := tamDifo - quantocorta;
                    if (tamArq < minimoResto) then
                        if tamDifo < minimoResto then
                            tamArq := tamDifo
                        else
                            TamArq := minimoResto;

                end;

            if maxAvail < tamArq then
                begin
                    falaDifone := false;
                    exit;
                end;

            getmem (PMem, TamArq);

            seek (arqDifones, posArq);
            blockread (arqDifones, Pmem^, TamArq) ;

            FalaDuploBuffer (PMem, TamArq, Perc);
        end;

end;

{--------------------------------------------------------}

Procedure CarregaBufFala (nomearq: stringuinha;
                          Perc: real; silabaForte: integer);
var 
    leu: boolean;
    vogal: char;

begin
    if nomearq [1] = '_' then
        leu := falaLetra (nomearq)
    else
        leu := falaDifone (nomearq, silabaForte, perc);

    if (not leu) and (length (nomearq) <= 2) then
        begin
            falaRuido;     { nao houve jeito de sintetizar }
            exit;
        end;

    if leu then
        begin
            if debug then
                writeln (nomearq, ': achei');
        end

    else      { se nao existe difone, sintetiza mais ou menos }
        begin
            if nomearq [length (nomearq)] in VOGAIS then
                 begin
                     carregaBufFala (copy (nomearq, 1, length(nomearq)-1),
                                                    Perc*0.8, silabaForte);
                     carregaBufFala ('$'+nomearq[length(nomearq)],
                                                    Perc, silabaForte);
                     exit;
                 end;

            if (copy (nomearq, length (nomearq)-3, 4) = 'CIRC') and
                     (length (nomearq) > 6) then
                begin
                    CarregaBufFala (copy (nomearq, 1, length (nomearq)-5),
                                                   perc*0.8, silabaForte);
                    carregaBufFala ('$'+ copy (nomearq,
                                   length (nomearq)-4, 5), Perc, silabaForte);
                    exit;
                end;

            if copy (nomearq, length (nomearq)-2, 3) = 'TIL' then
                begin
                    nomearq := copy (nomearq, 1, length(nomearq)-3);
                    vogal := upcase (nomearq [length (nomearq)]);
                    if (vogal = 'I') or (vogal = 'U') then
                        carregaBufFala (nomearq, Perc*0.8, silabaForte)
                    else
                        carregaBufFala (nomearq+'CIRC', Perc*0.8, 2);

                    carregaBufFala ('$nn', 0.8, 1);
                    exit;
                end;

       end;
end;

{--------------------------------------------------------}
{         seleciona arquivos para carga na memoria
{--------------------------------------------------------}

Procedure CarregaFala (s: stringuinha; Perc: real);
const
    MAIUSCULAS: set of char = ['A','E','I','O','U'];
var
    i: integer;
    nomearq: stringuinha;
    tonica: boolean;
begin
    tonica := false;

    nomearq := '$';
    if s[1] = '_' then
        begin
            str (ord(s[2]), nomearq);
            nomearq := '_' + nomearq;
        end
    else
        for i := 1 to length (s) do
            begin
                if (s[i] in MAIUSCULAS) then
                    begin
                        tonica := true;
                        silabaForte := 2;   { para garantir dois acentos }
                    end;

                case s[i] of
                    '^' :  begin
                             carregaBufFala (nomearq+'CIRC', Perc, silabaForte);
                             nomearq := '$';
                           end;

                    '~' :  begin
                             carregaBufFala (nomearq+'TIL', Perc,silabaForte);
                             nomearq := '$';
                           end;
                else
                    nomearq := nomearq + s[i];
                end;

    end;

    if nomearq <> '$' then
        carregaBufFala (nomearq, Perc, silabaForte);

    if tonica then
        silabaForte := 0;
end;

{--------------------------------------------------------}
{    traduz do fonema compilado para nome de arquivos
{--------------------------------------------------------}

procedure traduzSilaba (s: stringPeq; Perc: real);
begin
    if (length (s) = 0) then exit;

    if length (s) = 1 then
        begin
            carregaFala (s, Perc);
            exit;
        end;

    if length (s) > 2 then
        begin
            if (s[1] in CONSOANTES) and (s[2] in CONSOANTES) then
                begin
                    if (copy (s, 1, 2) <> 'dj') and
                       (copy (s, 1, 2) <> 'nh') and
                       (copy (s, 1, 2) <> 'rr') and
                       (copy (s, 1, 2) <> 'ks') and
                       (copy (s, 1, 3) <> 'tch') then
                       begin
                           carregaFala (s[1], 1.0);
                           traduzSilaba (copy (s, 2, length(s)-1),Perc);
                           exit;
                       end;
                end;

            if copy (s, length(s)-1, 2) = 'rr' then
                begin
                    traduzSilaba (copy (s, 1, length(s)-2),Perc);
                    carregaFala ('rr',Perc);
                    exit;
                end;

            if s[length(s)] in CONSOANTES then
                begin
                    traduzSilaba (copy (s, 1, length(s)-1),Perc);
                    traduzSilaba (s[length(s)],Perc);
                    exit;
                end;
        end;

    if s[length(s)] in SEMIVOGAIS then
        begin
            if s[length(s)-1] in VOGAIS then
                begin
                    if length (s) > 2 then
                        begin
                            traduzSilaba (copy (s, 1, length(s)-1), 0.4);
                            CarregaFala (copy (s, length(s)-1, 2), Perc);
                            exit;
                        end;
                end;

            if s[length(s)-1] in ACENTOS then
                if length (s) > 3 then
                    begin
                        if s [length(s)-1] = '~' then
                            traduzSilaba (copy (s, 1, length(s)-2)+'^', 0.4)
                        else
                            traduzSilaba (copy (s, 1, length(s)-1), 0.4);
                        carregaFala (s[length(s)-2]+s[length(s)]
                                     +s[length(s)-1],Perc);
                        exit;
                    end
                else
                    begin
                        carregaFala (s[1]+s[3]+s[2],Perc);
                        exit;
                    end;

        end;

    if (s <> '_s') and (s[length(s)] = 's') then
        begin
            traduzSilaba (copy (s, 1, length(s)-1), 0.5);
            carregaFala ('s',Perc);
            exit;
        end;

    CarregaFala (s, Perc);
end;

{--------------------------------------------------------}
{                   rotina geral de fala
{--------------------------------------------------------}

procedure falaFonemas (fonemas: string; comPontuacao: boolean);

{--------------------------------------------------------}

    function isolaSilaba: stringPeq;
    var s: stringPeq;
        pequeno: boolean;
    begin
        if fonemas [pf] = '[' then
            begin
                silabaForte := 1;
                pf := pf + 1;
            end;

        s := '';
        pequeno := true;
        while (not (fonemas [pf] in [ ']', ' '])) and pequeno do
            begin
		case fonemas [pf] of
                    '_':  begin
                              pf := pf + 1;
                              s := s + '_' + fonemas [pf];
                          end;

                    '|':  s := '_TRACO';

                    '/':  begin
                              pequeno := length (s) <= 8;
                              if not pequeno then pf := pf - 1;
                          end;
                else
                          s := s + fonemas [pf];
                end;

                pf := pf + 1;
            end;

        pf := pf + 1;

        if (not comPontuacao) and (s[1] = '_') and (length(s) = 2) then
                case s[2] of
		    ',':  begin
                              s := '';  silencio (intVirgula);
                          end;

		    '.':  begin
                              s := '';  silencio (intPonto);
                          end;

		    ';':  begin
                              s := '';  silencio (intPtVirgula);
                          end;

                    ':':  begin
                              s := '';  silencio (intDoisPontos);
                          end;
                end;

        isolaSilaba := s;
    end;

{--------------------------------------------------------}

var fon: stringPeq;

begin
    pf := 1;
    silabaForte := 1;
    Pant := nil;
    tamArqAnt := 0;

    falaRapida (alteraVoz);
    falaCondensada (picotaFala);

    InicFala(portaHard);

    While pf <= length (fonemas) do
        begin
            fon := isolaSilaba;
            if debug then writeln (fon);
            traduzSilaba (fon, 1.0);

            if fonemas[pf-1] <> ' ' then
                 silencio (intervalo);
        end;

    { Falta falar o ultimo fonema  }
    falaDuploBuffer (NIL, 0, 0.0);
    FinalizaFala ;
end;

{--------------------------------------------------------}
{               inicializa os diretorios
{--------------------------------------------------------}

function inicFonemas (tipo: integer): boolean;
var s, dir, dirDiscoDifones: string;
    porta: stringuinha;
    arqIndice: file;
    erro: integer;
    nomarqDifones: stringuinha;
    fatorPontuacao: integer;
    v: char;

label fim;

begin
    tabDifo := NIL;
    inicFonemas := false;
    portaHard := sintPortaHard (sintAmbiente ('PORTASINT'));

    getdir (0, dir);

    dirLetras := sintAmbiente ('DIRLETRAS');
    if dirLetras = '' then dirLetras := 'c:\dosvox\som\letras';

    {$I-}  chdir (copy (dirLetras, 1, 2)); {$I+}
    if ioresult <> 0 then;
    getdir (0, dirDiscoDifones);

    {$I-} chdir (dirLetras); {$I+}
    if ioresult <> 0 then
        goto fim;
    if dirLetras [length (dirLetras)] <> '\' then
        dirLetras:= dirLetras + '\';

    dirDifones := sintAmbiente ('DIRDIFONES');
    if dirDifones = '' then dirDifones := 'c:\dosvox\som\difones';
    {$I-} chdir (dirDifones); {$I+}
    if ioresult <> 0 then
        goto fim;
    if dirDifones [length (dirDifones)] <> '\' then
        dirDifones:= dirDifones + '\';

    if tipo = 0 then
        val(sintAmbiente ('TIPOFALA'), tipo,  erro);
    v := chr (tipo + ord('0'));

    quantoCorta := 0;
    minimoResto := 0;
    intervalo   := 0;
    val (sintAmbiente ('CORTEFON'    + v), quantoCorta,  erro);
    val (sintAmbiente ('SOBRAFON'    + v), minimoResto,  erro);
    val (sintAmbiente ('INTERPAL'    + v), intervalo, erro);

    s := sintAmbiente ('PICOTADO' + v);
    picotaFala := upcase (s[1]) = 'S';
    s := sintAmbiente ('ALTERVOZ' + v);
    alteraVoz := upcase (s[1]) = 'S';

    val (sintAmbiente ('REDUCPONTUA' + v), fatorPontuacao, erro);
    if fatorPontuacao = 0 then fatorPontuacao := 1;

    intPonto  := 12000 div fatorPontuacao;
    intVirgula := 4000 div fatorPontuacao;
    intPtVirgula := 5000 div fatorPontuacao;
    intDoisPontos  := 8000 div fatorPontuacao;

    nomarqDifones := sintAmbiente ('ARQDIFO' + v);
    if nomarqDifones = '' then
        nomarqDifones := 'DIFONES';

    assign (arqIndice, dirDifones + nomarqDifones + '.IND');
    {$i-} reset (arqIndice, 1); {$i+}
    if ioresult <> 0 then goto fim;

    tamTabDifo := filesize (arqIndice) div sizeof (INFODIFONE);
    if maxAvail < filesize (arqIndice) then
        begin
            close (arqIndice);
            goto fim;
        end;

    getMem (tabdifo, filesize (arqIndice));
    blockread (arqIndice, tabdifo^, filesize (arqIndice));
    close(arqIndice);

    assign (arqDifones, dirDifones + nomarqDifones + '.DIF');
    {$i-} reset (arqDifones, 1); {$i+}
    if ioresult <> 0 then goto fim;

    falaCondensada (picotaFala);
    falaRapida (alteraVoz);

    inicFonemas := true;

fim:
    {$I-} chdir (dirDiscoDifones);  {$I+}  if ioresult <> 0 then;
    {$I-} chdir (dir);              {$I+}  if ioresult <> 0 then;
end;

{--------------------------------------------------------}
{               fecha o arquivo de fonemas               }
{--------------------------------------------------------}

procedure tradFim;
begin
    libMemTradutor;
    {$I-} close (arqDifones); {$I+}
    if ioresult <> 0 then ;

    if tabDifo <> NIL then
        freemem (tabDifo, tamTabDifo * sizeof (INFODIFONE));
    tabDifo := NIL;
end;

{--------------------------------------------------------}
{           seleciona velocidade dos fonemas
{--------------------------------------------------------}

procedure selecTipoFonemas (tipo: integer);
begin
    tipoAtualFon := tipo;
end;

{--------------------------------------------------------}
{               inicializacao do tradutor
{--------------------------------------------------------}

function tradInic: integer;
begin
    if not inicFonemas (tipoAtualFon) then
        begin
            tradinic := 1;
            exit;
        end;

    if not inicTradutor (dirDifones + 'regras.rgr') then
        begin
            tradinic := 2;
            exit;
        end;

    if not carregaExcessoes (dirDifones + 'portug.exc') then
        begin
            tradinic := 2;
            exit;
        end;

    tradinic := 0;
end;

{--------------------------------------------------------}
{                   sintetiza uma cadeia
{--------------------------------------------------------}

procedure sintetiza (s: string);
var fon: string;
    encontrouHifen: boolean;
    subcad: string;
    erro: integer;
    x: longint;
    c: char;

    ultLetra: char;
    nrepUlt: integer;

const 
    alfa: set of char = [' ', 'A'..'Z', 'a'..'z', #128..#255];
    alfapuro: set of char = ['A'..'Z', 'a'..'z', #128..#255];

begin
    ultLetra := ' ';
    nrepUlt := 0;

    while s <> '' do
        begin
            if s[1] = '0' then
                begin
                    sintSom ('_zero');
                    delete (s, 1, 1);
                end
            else

            if s[1] in ['1'..'9'] then
                begin
                    encontrouHifen := false;
                    subcad := '';
                    while (s <> '') and (s[1] in ['0'..'9', '-']) do
                        begin
                            subcad := subcad + s[1];
                            if s[1] = '-' then
                                encontrouHifen := true;
                            delete (s, 1, 1);
                        end;
                    if encontrouHifen then  { provavel numero de telefone }
                        sintSoletra (subcad)
                    else
                        begin
                            val (subcad, x, erro);
                            falaNumeroConv (numeroParaString (x), MASCULINO);
                        end;
                end
            else

            if s[1] in alfa then
                begin
                    subcad := '';
                    while (s <> '') and (s[1] in Alfa) do
                        begin
                            subcad := subcad + s[1];
                            delete (s, 1, 1);
                        end;

                    compilaFonemas (subcad, fon);
                    falaFonemas (fon, false);

                    if (s[1] = '-') and (s[2] in alfapuro) then
                        delete (s, 1, 1);
                end
            else


                begin
                    c := s[1];

                    if ultLetra = c then
                        begin
                            nrepUlt := nrepUlt + 1;
                            if nrepUlt > 3 then
                                begin
                                    sintclek;
                                    c := ' ';
                                end;
                        end
                    else
                        begin
                            nrepUlt := 0;
                            ultLetra := c;
                        end;

                    if (c <> ' ') then
                        sintCarac (c);

                    delete (s, 1, 1);
                end;
        end;
end;

begin
    tabDifo := NIL;
    tipoAtualFon := 0;   { o default de DOSVOX.AMB }
end.
