{--------------------------------------------------------}
{
{   Playvox - versao Pascal da rotina PLAY
{
{   Rotinas de controle de fala da caixa LAYCAB
{
{   Autor do original em Assembler: Orlando Jose' Rodrigues Alves
{
{   Traducao para Pascal: Jose' Antonio Borges
{
{   Em agosto/94
{
{--------------------------------------------------------}

{$r-}

unit playvox;

interface
uses dos, crt;

procedure InicFala (porta: word);
procedure FinalizaFala;
procedure Fala (buffer: pointer; nbytes: word);
function EstaFalando: boolean;
function posBufFala: word;
procedure teclaCortaFala (opcao: boolean);
procedure falaRapida (opcao: boolean);
procedure falaCondensada (opcao: boolean);
procedure pegaModoFala (var rapid, condens: boolean);

implementation

const
    FREQ1:     word = $6c;
    TEMPOPAD1: word = 606;

    FREQ2:     word = $52;
    TEMPOPAD2: word = 909;

type
    BUFFALA = array [0..65000] of byte;
    PBUFFALA = ^BUFFALA;

var
    freq, tempoPadrao: word;
    falando: boolean;
    instalado: boolean;
    noSpeaker: boolean;
    naSblast:  boolean;

    bufPtr: PBUFFALA;
    bufSize: word;
    contaTempo: word;
    portaParalela: word;
    indBuf: word;
    teclaCorta: boolean;
    condensado: boolean;

    int8Original: pointer;
    rot8Original: procedure;

{--------------------------------------------------------}
{                  Tratamento de interrupcao
{--------------------------------------------------------}

{$f+}
procedure processaTimer; interrupt;
var
    regs: registers;

begin
    contaTempo := contaTempo + 1;

    if contaTempo = tempoPadrao then    {18.2 vezes por segundo}
        begin
            contaTempo := 0;
            asm; pushf; end;
            rot8Original;
        end
    else
        port [$20] := $20;

    if falando then
        begin
            if noSpeaker then
                begin
                    { metodo threshold }
                    if bufPtr^[indBuf] > 127 then
                        port [$61] := port [$61] or 2
                    else
                    if bufPtr^[indBuf] < 127 then
                        port [$61] := port [$61] and not 2;
                end
            else

            if naSblast then
                begin
                    repeat until (port [portaParalela+$c] and $80) = 0;
                    port [portaParalela+$0c] := $10;
                    repeat until (port [portaParalela+$c] and $80) = 0;
                    port [portaParalela+$0c] := bufPtr^[indBuf];
                end
            else
                port [portaParalela] := bufPtr^[indBuf];

            if condensado and ((indbuf mod 500) = 499) then
                indbuf := indbuf + 500;

            indBuf := indBuf + 1;
            if indBuf >= bufSize then
                falando := false;
        end;
end;

{$f-}

{--------------------------------------------------------}
{       Prepara interrupcao do timer para 11.025 Khz
{--------------------------------------------------------}

procedure InicFala (porta: word);
begin

{ --- Inicializa as variaveis internas --- }

    falando:= false;
    bufSize := 0;
    contaTempo := 0;
    instalado := true;
    portaParalela := porta;
    noSpeaker := portaParalela = 0;
    naSblast := (portaParalela = $220) or (portaParalela = $240) or
                (portaParalela = $260) or (portaParalela = $280);

{ --- Salva a interrupcao de timer antiga --- }

    asm cli; end;   { disable interrupts }

    getIntVec (8,   int8Original);
    move (int8Original, rot8Original, 4);
    setIntVec (8, addr (processaTimer));

{ --- Reprograma o 8254 (PIT - Programable Interval Timer) para  --- }
{ --- gerar interrupcoes na frequencia de 11khz --- }

    port [$43] := $36;
    asm nop; nop; nop; nop; nop; end;
    port [$40] := freq and $ff;
    asm nop; nop; nop; nop; nop; end;
    port [$40] := freq shr 8;

    if naSblast then   { speaker on }
        begin
            repeat until (port [portaParalela+$c] and $80) = 0;
            port [portaParalela+$0c] := $d1;
        end;

    asm sti; end;   { enable interrupts }
end;

{--------------------------------------------------------}
{                Inicia uma fala
{--------------------------------------------------------}

procedure fala (buffer: pointer; nbytes: word);
begin
    if not instalado then exit;

    bufPtr := buffer;
    bufSize := nbytes;
    indBuf := 0;
    falando:= true;
end;

{--------------------------------------------------------}
{                informa posicao atual de fala
{--------------------------------------------------------}

function posBufFala: word;
begin
     posBufFala := indbuf;
end;

{--------------------------------------------------------}
{                     ve se esta falando
{--------------------------------------------------------}

function EstaFalando: boolean;
begin
    EstaFalando := falando;
    if teclaCorta and keypressed then
        falando := false;
end;

{--------------------------------------------------------}
{                 Desinstala interrupcao
{--------------------------------------------------------}

procedure FinalizaFala;
begin
    if not instalado then exit;

    falando:= false;
    instalado := false;

{ --- reprograma 8254 para 1/18.2 s ---}

    asm cli; end;   { disable interrupts }

    port [$43] := $36;
    asm nop; nop; nop; nop; nop; end;
    port [$40] := 0;
    asm nop; nop; nop; nop; nop; end;
    port [$40] := 0;

    setIntVec (8,   int8Original);

    asm sti; end;   { enable interrupts }

    if naSblast then         { repouso no alto falante e speaker off}
        begin
            repeat until (port [portaParalela+$c] and $80) = 0;
            port [portaParalela+$0c] := $10;
            repeat until (port [portaParalela+$c] and $80) = 0;
            port [portaParalela+$0c] := $80;
            repeat until (port [portaParalela+$c] and $80) = 0;
            port [portaParalela+$0c] := $d3;
        end
    else
    if not noSpeaker then
        port [portaParalela] := $80;   
end;

{--------------------------------------------------------}
{           especifica se teclado corta fala
{--------------------------------------------------------}

procedure teclaCortaFala (opcao: boolean);
begin
    teclaCorta := opcao;
end;


{--------------------------------------------------------}
{               altera os parametros do relogio
{--------------------------------------------------------}

procedure falaRapida (opcao: boolean);
begin
    if opcao then
        begin
            freq := FREQ2;
            tempoPadrao := TEMPOPAD2;
        end
    else
        begin
            freq := FREQ1;
            tempoPadrao := TEMPOPAD1;
        end;
end;

{--------------------------------------------------------}

procedure falaCondensada (opcao: boolean);
begin
    condensado := opcao;
end;

{--------------------------------------------------------}

procedure pegaModoFala (var rapid, condens: boolean);
begin
    rapid := freq = FREQ2;
    condens := condensado;
end;

{--------------------------------------------------------}

begin
    instalado := false;
    falando:= false;
    noSpeaker := false;
    naSblast := false;
    teclaCorta := false;
    falaRapida (false);
    falaCondensada (false);
end.
