{--------------------------------------------------------}
{
{   Editor de Campo
{
{   Autor:  Jose' Antonio Borges
{
{   Rio de Janeiro, Junho de 1994
{
{--------------------------------------------------------}

unit readvox;

interface
    uses crt, traduVox, interVox, sintVox, horaVox, videoIso;

    function ansiParaPC (s: string): string;
    function PCparaANSI (s: string): string;
    function maiuscAnsi (s: string): string;
    procedure modoANSI (opcao: boolean);

    procedure limpaBufTec;
    procedure pegaTeclado (var c1, c2: char);
    procedure leTecla (var c1, c2: char);
    function compactaLinha (nome: string): string;
    function editaCampo (var campo: string; x, y, tamanho: integer;
                         altera: boolean): char;
    function leLinha: string;
    procedure xreadInt (var valor: integer);
    procedure xwriteInt (n: integer);

const
    CTLF1 = #94;

    F1    = #59;
    F2    = #60;
    F3    = #61;
    F4    = #62;
    F5    = #63;
    F6    = #64;
    F7    = #65;
    F8    = #66;
    F9    = #67;
    F10   = #68;

    INS   = #82;
    DEL   = #83;
    HOME  = #71;
    TEND  = #79;
    PGUP  = #73;
    PGDN  = #81;
    CIMA  = #72;
    BAIX  = #80;
    ESQ   = #75;
    DIR   = #77;
    ENTER = #13;
    BS    = #08;
    ESC   = #27;
    TAB   = #09;

    CTLPGUP = #132;
    CTLPGDN = #118;
    CTLESQ  = #115;
    CTLDIR  = #116;
    CTLBS   = #127;

implementation

var falando: boolean;
    inserindo: boolean;
    campoPC: string;
    emAnsi: boolean;

{--------------------------------------------------------}
{              transforma caracteres para video
{--------------------------------------------------------}

function ansiParaPC (s: string): string;
var i: integer;
    c: char;

const
    tabPC: array [#$a0..#$ff] of char = (

    #$a0,#$a1,#$a2,#$a3,#$a4,#$a5,#$a6,#$15,
    #$a8,#$a9,#$a6,#$ab,#$ac,#$ad,#$ae,#$af,
    #$b0,#$b1,#$b2,#$b3,#$b4,#$b5,#$b6,#$b7,
    #$b8,#$b9,#$a7,#$bb,#$bc,#$bd,#$be,#$bf,

    '','','','','','','','','','','','','','','','',
    '','','','','','','','x','0','','','U','','Y','','',
    '','','','','','','','','','','','','','','','',
    '','','','','','','','x','0','','','u','','y','','' );

var sansi: string;

begin
    sansi := s;
    for i := 1 to length (s) do
        if s[i] >= #$a0 then
            sansi[i] := tabPC [s[i]];

    ansiParaPC := sansi;
end;

{--------------------------------------------------------}
{             transforma caracteres para ANSI
{--------------------------------------------------------}

function PCparaANSI (s: string): string;
var i: integer;
    c: char;
    sPC: string;
begin
    sPC := s;
    for i := 1 to length (s) do
        if s[i] > #$7f then
            begin
                c := s[i];
                case c of
                    '': c:= #$E1;
                    '': c:= #$E9;
                    '': c:= #$ED;
                    '': c:= #$F3;
                    '': c:= #$FA;
                    '': c:= #$C1;
                    '': c:= #$C9;
                    '': c:= #$CD;
                    '': c:= #$D3;
                    '': c:= #$DA;
                    '': c:= #$E2;
                    '': c:= #$EA;
                    '': c:= #$F4;
                    '': c:= #$C2;
                    '': c:= #$CA;
                    '': c:= #$D4;
                    '': c:= #$E3;
                    '': c:= #$F5;
                    '': c:= #$C3;
                    '': c:= #$D5;
                    '': c:= #$E0;
                    '': c:= #$C0;
                    '': c:= #$FC;
                    '': c:= #$DC;
                    '': c:= #$E7;
                    '': c:= #$C7;
                end;
                sPC[i] := c;
            end;

    PCparaANSI := sPC;
end;

{--------------------------------------------------------}
{             calcula uma string em maiuscula
{--------------------------------------------------------}

function maiuscAnsi (s: string): string;
var x: string;
    i: integer;
begin
    x := s;
    for i:= 1 to length (s) do
        if x[i] in ['a'..'z'] then
            x[i] := upcase (x[i])
        else
            if x[i] in [#$e0..#$ff] then
                x[i] := chr (ord(x[i]) - $20);
    maiuscAnsi := x;
end;

{--------------------------------------------------------}
{                limpa o buffer do teclado
{--------------------------------------------------------}

procedure limpaBufTec;
var c: char;
begin
    while keypressed do
        c := readkey;
end;

{--------------------------------------------------------}
{              pega um dado do teclado sem ecoar
{--------------------------------------------------------}

procedure pegaTeclado (var c1, c2: char);
begin
    c2 := ' ';
    c1 := readkey;
    if c1 = #0 then c2 := readkey;

    if (c1 = #0) and (c2 = F8) then
        begin
            falaHora;
            pegaTeclado (c1, c2);
        end;
end;

{--------------------------------------------------------}
{                 le uma tecla, ecoando
{--------------------------------------------------------}

procedure leTecla (var c1, c2: char);
begin
    pegaTeclado (c1, c2);
    if c1 in [#32..#126, #127..#255] then
        begin
            sintcarac (c1);
            write (c1);
        end;
end;

{--------------------------------------------------------}
{                 ve se palavra tem vogal
{--------------------------------------------------------}

function temVogal (s: string): boolean;
const 
    CONSOANTES: set of char =
    ['B','C','D','F','G','H','J','K','L','M',
     'N','P','Q','R','S','T','V','X','Z'];

var i: integer;

begin
    temVogal := true;
    for i := 1 to length (s) do
         if not (upcase (s[i]) in CONSOANTES) then exit;
    temVogal := false;
end;

{--------------------------------------------------------}
{     tira brancos do inicio e do fim de uma cadeia
{--------------------------------------------------------}

function compactaLinha (nome: string): string;
var s: string;
    i: integer;
begin
    s := nome;
    for i := 1 to length (s) do
        s[i] := upcase(s[i]);

    s := s + '*';
    while s[1] = ' ' do
        s := copy (s, 2, length(s)-1);
    s := copy (s, 1, length(s)-1);

    s := '*' + s;
    while s[length(s)] = ' ' do
        s := copy (s, 1, length(s)-1);
    s := copy (s, 2, length(s)-1);
    compactaLinha := s;
end;

{--------------------------------------------------------}
{                    edita um item
{--------------------------------------------------------}

function editaCampo (var campo: string; x, y, tamanho: integer;
                     altera: boolean): char;
var c, c2: char;
    curx, i: integer;
    fonemas: string;

label fechaCampo;

{--------------------------------------------------------}

type
    TABDIGIT = array [1..14] of char;

const
    acentuaveis: set of char = ['A','E','I','O','U','C', 'N',
                                'a','e','i','o','u','c', 'n'];
const
    crases:   TABDIGIT = (#$c0, #$c8, #$cc, #$d2, #$d9, 'C',  'n',
                          #$e0, #$e8, #$ec, #$f2, #$f9, 'C',  'N');

    agudos :  TABDIGIT = (#$c1, #$c9, #$cd, #$d3, #$da, #$c7, 'n',
                          #$e1, #$e9, #$ed, #$f3, #$fa, #$e7, 'N');

    circunfs: TABDIGIT = (#$c2, #$ca, #$ce, #$d4, #$db, 'C',  'n',
                          #$e2, #$ea, #$ee, #$f4, #$fb, 'C',  'N');

    tils:     TABDIGIT = (#$c3, 'E',  'I',  #$d5, 'U',  'C',  #$d1,
                          #$e3, 'E',  'I',  #$f5, 'U',  'C',  #$f1);

    tremas:   TABDIGIT = (#$c4, #$cb, #$cf, #$d6, #$dc, 'C',  'n',
                          #$e4, #$eb, #$ef, #$f6, #$fc, 'C',  'N');

{--------------------------------------------------------}

    procedure trocaLetra (var c: char; tabl: TABDIGIT);
    begin
        if c in [ '''', '^', '`', '~', '"' ] then exit;
        case c of
            'A': c := tabl[1];
            'E': c := tabl[2];
            'I': c := tabl[3];
            'O': c := tabl[4];
            'U': c := tabl[5];
            'C': c := tabl[6];
            'N': c := tabl[7];
            'a': c := tabl[8];
            'e': c := tabl[9];
            'i': c := tabl[10];
            'o': c := tabl[11];
            'u': c := tabl[12];
            'c': c := tabl[13];
            'n': c := tabl[14];
        end;
    end;

{--------------------------------------------------------}

    procedure caracComum (c: char);
    begin
        if not altera then
            exit;

        if curx > tamanho then
            begin
                sintBip;
                exit;
            end;

        if c in [ '''', '^', '`', '~', '"'] then
            begin
                c2 := readkey;

                if c2 in acentuaveis then
                    case c of
                        '''': trocaLetra (c2, agudos);
                        '^' : trocaLetra (c2, circunfs);
                        '`' : trocaLetra (c2, crases);
                        '~' : trocaLetra (c2, tils);
                        '"' : trocaLetra (c2, tremas);
                    end;
                c := c2;
            end;

        if falando then
            sintCarac (c);

        insert (c, campo, curx);
        delete (campo, tamanho+1, 1);
        curx := curx + 1;
        if (not inserindo) then
            delete (campo, curx, 1);
    end;

{--------------------------------------------------------}

    procedure delCarac;
    var campoPc: string;
        c: char;
    begin
        if not altera then
            exit;

        c := campo [curx];
        delete (campo, curx, 1);
        campo := campo + ' ';

        gotoxy (x, y);
        campoPC := copy (campo, 1, tamanho);
        write (campoPC);
        gotoxy (x+curx-1, y);

        sintSom ('_DEL');
        sintCarac(c);
    end;

{--------------------------------------------------------}

    procedure falaPalavra;
    var palavra: string;
        c: char;
        i, salvacur: integer;
    begin
        campo := campo + #0;
        salvacur := curx;
        while (campo [curx] = ' ') do
            curx := curx + 1;

        c := upcase (campo [curx]);
        case c of
            #0: sintBip;

            'A'..'Z', #128..#255:
                begin
                    palavra := '';
                    repeat
                        palavra := palavra + campo[curx];
                        curx := curx + 1;
                    until not (upcase (campo[curx]) in
                            ['A'..'Z', #128..#255]);
                    if temVogal (palavra) then
                        begin
                            compilaFonemas (palavra, fonemas);
                            falaFonemas (fonemas, true);
                        end
                    else
                        sintSoletra (palavra);
                end;

            '0'..'9', '-':
                begin
                    palavra := '';
                    repeat
                        palavra := palavra + campo[curx];
                        curx := curx + 1;
                    until not (campo[curx] in ['0'..'9']);
                    compilaFonemas (palavra, fonemas);
                    falaFonemas (fonemas, true);
                end;

            '/' : begin
                      sintSom ('/');
                      curx := curx + 1;
                  end;

        else
            begin
                palavra := campo [curx];
                curx := curx + 1;
                compilaFonemas (palavra, fonemas);
                falaFonemas (fonemas, true);
            end;
        end { case };

        campo := copy (campo, 1, length(campo)-1);
        if c = #0 then
            curx := salvacur;
    end;

{--------------------------------------------------------}

    procedure avancaPalavra;
    var tam: integer;
        c: char;
    begin
        tam := length (campo);
        campo := campo + ' @';

        c := campo [curx];
        if c <> ' ' then
            if c in ['0'..'9'] then
                repeat
                    curx := curx + 1;
                    c := campo [curx];
                until not (c in ['0'..'9'])
            else
                repeat
                    curx := curx + 1;
                    c := campo [curx];
                until not (c in ['a'..'z', 'A'..'Z', #128..#255]);

        if c = ' ' then
            repeat
                curx := curx + 1;
                c := campo [curx];
            until c <> ' ';

        campo := copy (campo, 1, tam);

        if curx > tam+1 then
            begin
                curx := length(campo)+1;
                repeat
                    curx := curx - 1;
                until (curx = 0) or (campo[curx] <> ' ');
                curx := curx + 1;
                sintBip;
            end
        else
            sintClek;
    end;

{--------------------------------------------------------}

    procedure recuaPalavra;
    var tam: integer;
        c: char;
    begin
        tam := length (campo);
        campo := ' @' + campo;
        curx := curx + 2;

        repeat
            curx := curx - 1;
            c := campo [curx];
        until c <> ' ';

        if c in ['0'..'9'] then
            repeat
                curx := curx - 1;
                c := campo [curx];
            until not (c in ['0'..'9'])
        else
            repeat
                curx := curx - 1;
                c := campo [curx];
            until not (c in ['a'..'z', 'A'..'Z', #128..#255]);

        campo := copy (campo, 3, tam);
        curx := curx - 1;

        if curx <= 0 then
            begin
                curx := 1;
                sintBip;
            end
        else
            sintClek;
    end;

{--------------------------------------------------------}

begin
    campo := campo + '                                                    '
                   + '                                                    ';
    curx := 1;
    if (y = 25) and (tamanho+x-1 >= 80) then
        tamanho := 80-x;
    repeat
        gotoxy (x, y);
        campoPC := copy (campo, 1, tamanho);
        if geradorISOcarregado then
            write (campoPC)
        else
            write (ANSIparaPC (campoPC));

        gotoxy (curx+x-1, y);
        pegaTeclado (c, c2);

        if c = #0 then
            begin
                case c2 of
                    ESQ: if curx <= 1 then
                              sintBip
                          else
                              begin
                                  curx := curx - 1;
                                  sintCarac (campo [curx]);
                              end;

                    DIR: begin
                              if curx >= 65 then
                                  sintBip
                              else
                                  sintCarac (campo [curx]);
                              curx := curx + 1;
                         end;

                    HOME: curx := 1;

                    TEND:  begin
                              curx := 81;
                              repeat
                                  curx := curx - 1;
                              until (curx = 0) or (campo[curx] <> ' ');
                              curx := curx + 1;
                          end;

                    INS: begin
                             inserindo := not inserindo;
                             if inserindo then
                                 sintSom ('_INS')     {Insercao ligada}
                             else
                                 sintSom ('_NINS');   {Insercao desligada}
                         end;

                    DEL: delCarac;

                    F1:  falaPalavra;

                    F4:  begin
                             falando := not falando;
                             if falando then
                                 sintSom ('_FALACI')   {Fala acionada}
                             else
                                 sintSom ('_FALDLG');  {Fala desligada}
                         end;

                    CTLDIR: avancaPalavra;

                    CTLESQ: recuaPalavra;

                    CTLF1:  begin
                             compilaFonemas (campo, fonemas);
                             falaFonemas (fonemas, true);
                          end;
                else
                    goto FechaCampo;
                end
            end
        else
            begin
                c2 := c;
                case c of
                    ENTER, ESC: begin
                                    c2 := c;
                                    goto FechaCampo;
                                end;

                    BS:    begin
                               if curx = 1 then
                                   sintBip
                               else
                                   begin
                                       curx := curx - 1;
                                       delCarac;
                                   end;
                           end;

                    ^D:    if altera then
                           begin
                               for i := curx to length (campo) do
                                   campo [i] := ' ';
                               sintSom ('_APFCPO');
                           end;

                    ^Y:    if altera then
                           begin
                               for i := 1 to length (campo) do
                                   campo [i] := ' ';
                               sintSom ('_CPOAPA');
                               curx := 1;
                           end;

                    #0..#31: ;
                else
                    caracComum (c);
                end;
            end;
    until false;

fechaCampo:
    editaCampo := c2;

    curx := tamanho+1;
    repeat
        curx := curx - 1;
    until (curx = 0) or (campo[curx] <> ' ');

    if curx = 0 then
        campo := ''
    else
        campo := copy (campo, 1, curx);

    if not emAnsi then
        campo := ansiParaPc (campo);
end;

{--------------------------------------------------------}
{                  seleciona modo ANSI
{--------------------------------------------------------}

procedure modoAnsi (opcao: boolean);
begin
   emAnsi := opcao;
end;

{--------------------------------------------------------}
{                      le uma linha
{--------------------------------------------------------}

function leLinha: string;
var s: string;
begin
    s := '';
    if editaCampo (s, wherex, wherey, 80-wherex, true) = #$1b then
        leLinha := ''
    else
        lelinha := s;
    writeln;
end;

{--------------------------------------------------------}
{                  le um numero inteiro
{--------------------------------------------------------}

procedure xreadInt (var valor: integer);
var s: string;
    erro: integer;
begin
    s := leLinha;
    if s = '' then
        exit
    else
        begin
            val (s, valor, erro);
            if erro <> 0 then
                valor := 0;
        end;
end;

{--------------------------------------------------------}
{                  fala um numero inteiro
{--------------------------------------------------------}

procedure xwriteInt (n: integer);
var s: string;
    i: integer;
begin
    str (n, s);
    write (s);
    for i := 1 to length (s) do
        sintcarac (s[i]);
end;   

begin
    falando := true;
    inserindo := true;
    emAnsi := true;
end.
