{--------------------------------------------------------}
{
{   Sistema de Sintese da Fala
{
{   Funcao : Modulo de geracao do som
{
{   Autores:  Jose' Antonio Borges
{             Marcelo Pimentel Pinheiro
{
{   Data de criacao : Janeiro de 1994
{
{   Alterado por : Kelly Christine Correa
{
{   Data Alteracao : Outubro de 1994
{
{--------------------------------------------------------}

{$r-}
unit SintVox;
interface
uses crt, dos, playvox;

const
    MAXFILESIZE = 8192;
type
    BUFFALA = array [0..MAXFILESIZE] of byte;
    PBUFFALA = ^BUFFALA;

var
    diretAplic: pathstr;

function  SintAmbiente (nome: string): string;
function  SintPortaHard (porta: string): word;
Procedure SintInic (vel: integer; nomeAplic: string);
Procedure SintBip;
Procedure SintClek;

Procedure SintSom (nomeSom: string);
Procedure SintArqSom (nomeSom: string);
procedure SintBuf (pbuf: PBUFFALA; tambuf: word);
Procedure SintCarac (ch: char );
Procedure SintSoletra (s: String);
Procedure SintCalado (opcao: boolean);
procedure SintRitmado (opcao: boolean);
procedure SintPorta (n: integer);
procedure delay (x: integer);

{--------------------------------------------------------}

implementation

var
    diretLetras: pathstr;

    calaBoca: boolean;
    ritmado: boolean;
    portaHard: word;
    vetfala, vetfala2: BUFFALA;
    h1, m1, s1, c1: word;
    rapidinho: boolean;
    corrDelay: integer;

{--------------------------------------------------------}

function SintAmbiente (nome: string): string;
var
    arq: text;
    nomearq, linha: string;

begin
    nomearq := getenv ('AMBDOSVOX');
    if nomearq = '' then
        nomearq := 'c:\dosvox\dosvox.amb';

    SintAmbiente := '';

    assign (arq, nomearq);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        exit;

    while not eof (arq) do
        begin
            readln (arq, linha);
            if pos (nome+'=', linha) = 1 then
                SintAmbiente := copy (linha, length (nome)+2,
                                             length (linha)-length (nome)-1);
        end;

    close (arq);
end;

{--------------------------------------------------------}

function pegaHexa (s: string): word;
var valor: word;
    h: byte;
    i: integer;
begin
    valor := 0;
    for i := 2 to length (s) do
        begin
            h := ord(upcase(s[i])) - ord('0');
            if h > 10 then h := h - 7;
            valor := (valor shl 4) or h;
        end;
    pegaHexa := valor;
end;

{--------------------------------------------------------}

function sintPortaHard (porta: string): word;
var
    valor: word;
begin
    valor := $378;   { default }

    if porta = '0' then valor := 0
    else
    if porta = '2' then valor := $278
    else
    if porta = '3' then valor := $3bc
    else
    if porta[1] = '$' then valor := pegaHexa (porta);

    sintPortaHard := valor;
end;

{--------------------------------------------------------}

procedure SintInic (vel: integer; nomeAplic: string);
var
    i: word;
    porta: string;
    c: char;
    opcao, caminho: string;
begin
    calaBoca := false;
    
    porta := sintAmbiente ('PORTASINT');
    portaHard := sintPortaHard (porta);

    opcao := sintAmbiente ('CORTAFALA');
    teclaCortaFala (upcase (opcao[1]) = 'S');

    diretAplic := sintAmbiente (nomeAplic);
    if diretAplic = '' then diretAplic := '.\';
    if diretAplic [length (diretAplic)] <> '\' then
        diretAplic:= diretAplic + '\';

    diretLetras := sintAmbiente ('DIRLETRAS');
    if diretLetras = '' then diretLetras := 'c:\dosvox\som\letras\';
    if diretLetras [length (diretLetras)] <> '\' then
        diretLetras:= diretLetras + '\';

    gettime (h1, m1, s1, c1);
end;

{--------------------------------------------------------}

Procedure SintBip;
var i, j: integer;
    t, tempo: word;
    v: array [0..600] of byte;
    c: char;

begin
    i := 0;
    while i < 600 do
        begin
            v[i] := $80; inc (i);
            v[i] := $70; inc (i);
            v[i] := $60; inc (i);
            v[i] := $50; inc (i);
            v[i] := $40; inc (i);
            v[i] := $50; inc (i);
            v[i] := $60; inc (i);
            v[i] := $70; inc (i);
        end;

    v[600] := $80;

    InicFala(portaHard);
    fala(addr(v), 601);
    while EstaFalando do
                ;
    FinalizaFala;

    delay (100);
end;

{--------------------------------------------------------}

procedure SintClek;
var i, t: integer;
    v: array [0..60] of byte;
begin
    for i := 0 to 59 do
        v[i] := random($60)+$80;

    v[60] := $80;

    InicFala(portaHard);
    fala(addr(v), 61);
    while EstaFalando do
                ;
    FinalizaFala;
    delay (10);
end;

{--------------------------------------------------------}

procedure SintBuf (pbuf: PBUFFALA; tambuf: word);
var i, esp: word;
begin
    if tambuf = 0 then exit;

    InicFala(portaHard);
    fala(pbuf, tambuf);
    while EstaFalando do
                ;
    FinalizaFala;
end;

{--------------------------------------------------------}

procedure SintSom (nomeSom: string);
var
    arq: file;
    palavra: string;
    cont: byte;
    pos, esp: word;
    i, nbytes: word;
    tam: longint;
    s: string[4];
    h2, m2, s2, c2: word;
    qualBuf: byte;

	procedure ImpoeRitmo;
        var dif: integer;
	begin
	    repeat
		gettime (h2, m2, s2, c2);
                if (s2 < s1) then s2 := s1 + 1;
                dif := (s2-s1) * 100 + (c2-c1);
	    Until dif > 30;
            gettime (h1, m1, s1, c1);
        end;
begin
    If calaBoca Then exit;

    if nomeSom[1] = '_'then
        assign (arq, diretLetras + nomeSom + '.wav')
    else
        assign (arq, diretAplic   + nomeSom + '.wav');

    {$I-} reset (arq, 1);  {$I+}
    if (ioresult <> 0) then
        begin
            if nomeSom [1] <> '_' then
                for i := 1 to length (nomeSom) do
                    begin
                         str (ord (nomeSom[i]), s);
                         sintSom ('_' + s);
                    end
            else
                SintBip;
            exit;
        end;

    if ritmado then
        impoeRitmo;

    tam := filesize (arq) - 1;
    pos := 48;

    qualBuf := 1;
    inicFala (portaHard);

    while tam > 0 do
        begin
            if tam > MAXFILESIZE then
                nbytes := MAXFILESIZE
            else
                nbytes := tam;

            if qualBuf = 1 then
                begin
                    blockread (arq, vetFala, nbytes);
                    while estaFalando do
                                 ;
                    if rapidinho and (nbytes < MAXFILESIZE) then
                        fala (@vetFala[pos+(nbytes-pos) div 8],
                                        (nbytes-pos) div 2)
                    else
                        fala (@vetFala[pos], nbytes-pos);
                    qualBuf := 2;
                end
            else
                begin
                    blockread (arq, vetFala2, nbytes);
                    while estaFalando do
                                 ;
                    if rapidinho and (nbytes < MAXFILESIZE) then
                        fala (@vetFala2[pos+(nbytes-pos) div 8],
                                        (nbytes-pos) div 2)
                    else
                        fala (@vetFala2[pos], nbytes-pos);
                    qualBuf := 1;
                end;

            pos := 0;
            tam := tam - MAXFILESIZE;
        end;

    while estaFalando do
                ;
    finalizaFala;

    close (arq);
end;

{--------------------------------------------------------}

procedure SintArqSom (nomeSom: string);
var salva: string;
begin
    salva := diretAplic;
    diretAplic := '';
    sintSom (nomeSom);
    diretAplic := nomeSom;
end;

{--------------------------------------------------------}

Procedure SintCarac (ch: char);
var s: string[4];
begin
    str (ord(ch), s);
    if keypressed then
        rapidinho := true;
    SintSom ('_' + s);

    rapidinho := false;
end;

{--------------------------------------------------------}

Procedure SintSoletra (s: String);
var i: integer;
begin
    for i := 1 to length (s) do
        SintCarac (s[i]);
end;

{--------------------------------------------------------}

procedure SintRitmado (opcao: boolean);
begin
    ritmado := opcao;
end;

{--------------------------------------------------------}

procedure SintCalado (opcao: boolean);
begin
    calaBoca := opcao;
end;

{--------------------------------------------------------}

procedure SintPorta (n: integer);
begin
    portaHard := n;
end;

{--------------------------------------------------------}
{                      delay
{--------------------------------------------------------}

procedure delay (x: integer);
var i: integer;
begin
    crt.delay (x * corrDelay);
end;

{--------------------------------------------------------}
{                      calibra delay
{--------------------------------------------------------}

procedure calibraDelay;
var 
    hora1, hora2: longint;
    h1, m1, s1, c1: word;
    h2, m2, s2, c2: word;
begin
    repeat
       gettime (h1,m1,s1,c1);
       hora1 := (((h1*60)+m1)*60+s1)*100+c1;
       crt.delay (1000);
       gettime (h2,m2,s2,c2);
       hora2 := (((h2*60)+m2)*60+s2)*100+c2;
    until hora2 > hora1;  { evita meia noite !}

    corrDelay := 103 div (hora2-hora1);
    if corrDelay < 1 then corrDelay := 1;
end;


begin
    ritmado := false;
    calaBoca := false;
    portaHard := $378;
    rapidinho := false;
    calibraDelay;
end.
