{--------------------------------------------------------}
{
{   Sistema de Sintese da Fala
{
{   Funcao : Modulo de geracao do som
{
{   Autores:  Jose' Antonio Borges
{             Marcelo Pimentel Pinheiro
{
{   Data de criacao : Janeiro de 1994
{
{   Alterado por : Kelly Christine Correa
{
{   Data Alteracao : Outubro de 1994
{
{--------------------------------------------------------}

{$r-}
unit SintVox;
interface
uses crt, dos, playvox;

const
    MAXFILESIZE = 8192;
type
    BUFFALA = array [0..MAXFILESIZE] of byte;
    PBUFFALA = ^BUFFALA;

function  SintAmbiente (nome: string): string;
function  SintPortaHard (porta: string): word;
Procedure SintInic (vel: integer; nomeAplic: string);
Procedure SintBip;
Procedure SintClek;

Procedure SintSom (nomeSom: string);
Procedure SintArqSom (nomeSom: string);
procedure SintBuf (pbuf: PBUFFALA; tambuf: word);
Procedure SintCarac (ch: char );
Procedure SintSoletra (s: String);
Procedure SintCalado (opcao: boolean);
procedure SintRitmado (opcao: boolean);
procedure SintPorta (n: integer);
procedure delay (x: integer);

{--------------------------------------------------------}

implementation

var
    diretAplic,
    diretFonemas: pathstr;
    corrDelay: integer;

{--------------------------------------------------------}

function SintAmbiente (nome: string): string;
var
    arq: text;
    nomearq, linha: string;

begin
    nomearq := getenv ('AMBDOSVOX');
    if nomearq = '' then
        nomearq := 'c:\dosvox\dosvox.amb';

    SintAmbiente := '';

    assign (arq, nomearq);
    {$I-} reset (arq); {$I+}
    if ioresult <> 0 then
        exit;

    while not eof (arq) do
        begin
            readln (arq, linha);
            if pos (nome+'=', linha) = 1 then
                SintAmbiente := copy (linha, length (nome)+2,
                                             length (linha)-length (nome)-1);
        end;

    close (arq);
end;

{--------------------------------------------------------}

function pegaHexa (s: string): word;
var valor: word;
    h: byte;
    i: integer;
begin
    valor := 0;
    for i := 2 to length (s) do
        begin
            h := ord(upcase(s[i])) - ord('0');
            if h > 10 then h := h - 7;
            valor := (valor shl 4) or h;
        end;
    pegaHexa := valor;
end;

{--------------------------------------------------------}

function sintPortaHard (porta: string): word;
var
    valor: word;
begin
    valor := $378;   { default }

    if porta = '0' then valor := 0
    else
    if porta = '2' then valor := $278
    else
    if porta = '3' then valor := $3bc
    else
    if porta[1] = '$' then valor := pegaHexa (porta);

    sintPortaHard := valor;
end;

{--------------------------------------------------------}

procedure SintInic (vel: integer; nomeAplic: string);
var
    i: word;
    porta: string;
    c: char;
    opcao, caminho: string;
begin
    porta := sintAmbiente ('PORTASINT');

    opcao := sintAmbiente ('CORTAFALA');
    teclaCortaFala (upcase (opcao[1]) = 'S');

    diretAplic := sintAmbiente (nomeAplic);
    if diretAplic = '' then diretAplic := '.\';
    if diretAplic [length (diretAplic)] <> '\' then
        diretAplic:= diretAplic + '\';

    diretFonemas := sintAmbiente ('DIRFONEMAS');
    if diretFonemas = '' then diretFonemas := 'c:\dosvox\som\letras\';
    if diretFonemas [length (diretFonemas)] <> '\' then
        diretFonemas:= diretFonemas + '\';
end;

{--------------------------------------------------------}

Procedure SintBip;
var i, j: integer;
    t, tempo: word;
    v: array [0..600] of byte;
    c: char;

begin
    write (#$7);
end;

{--------------------------------------------------------}

procedure SintClek;
begin
end;

{--------------------------------------------------------}

procedure SintBuf (pbuf: PBUFFALA; tambuf: word);
var i, esp: word;
begin
end;

{--------------------------------------------------------}

procedure SintSom (nomeSom: string);
begin
end;

{--------------------------------------------------------}

procedure SintArqSom (nomeSom: string);
begin
end;

{--------------------------------------------------------}

Procedure SintCarac (ch: char);
begin
end;

{--------------------------------------------------------}

Procedure SintSoletra (s: String);
begin
end;

{--------------------------------------------------------}

procedure SintRitmado (opcao: boolean);
begin
end;

{--------------------------------------------------------}

procedure SintCalado (opcao: boolean);
begin
end;

{--------------------------------------------------------}

procedure SintPorta (n: integer);
begin
end;

{--------------------------------------------------------}
{                      delay
{--------------------------------------------------------}

procedure delay (x: integer);
var i: integer;
begin
    crt.delay (x * corrDelay);
end;

{--------------------------------------------------------}
{                      calibra delay
{--------------------------------------------------------}

procedure calibraDelay;
var 
    hora1, hora2: longint;
    h1, m1, s1, c1: word;
    h2, m2, s2, c2: word;
begin
    repeat
       gettime (h1,m1,s1,c1);
       hora1 := (((h1*60)+m1)*60+s1)*100+c1;
       crt.delay (1000);
       gettime (h2,m2,s2,c2);
       hora2 := (((h2*60)+m2)*60+s2)*100+c2;
    until hora2 > hora1;  { evita meia noite !}

    corrDelay := 103 div (hora2-hora1);
    if corrDelay < 1 then corrDelay := 1;
end;

begin
    calibraDelay;
end.
