{--------------------------------------------------------}
{    Carregador de caracteres ISO para o video do PC
{    Autor: Pedro Salenbauch
{    Convertido para Turbo Pascal por Antonio Borges
{    Em Abril/96
{--------------------------------------------------------}

unit videoISO;

Interface

uses dos;

procedure carregaGeradorISO;
procedure carregaGeradorIBM;

var geradorIsoCarregado: boolean;

Implementation

const
    geradorCarac: array [0..16*256-1] of byte =  (
        $00, $00, $00, $00, $00, $00, $00, $00,  { $00: "." }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $7E, $81, $A5, $81, $81, $BD,  { $01: "." }
        $99, $81, $81, $7E, $00, $00, $00, $00,
        $00, $00, $7E, $FF, $DB, $FF, $FF, $C3,  { $02: "." }
        $E7, $FF, $FF, $7E, $00, $00, $00, $00,
        $00, $00, $00, $00, $6C, $FE, $FE, $FE,  { $03: "." }
        $FE, $7C, $38, $10, $00, $00, $00, $00,
        $00, $00, $00, $00, $10, $38, $7C, $FE,  { $04: "." }
        $7C, $38, $10, $00, $00, $00, $00, $00,
        $00, $00, $00, $18, $3C, $3C, $E7, $E7,  { $05: "." }
        $E7, $99, $18, $3C, $00, $00, $00, $00,
        $00, $00, $00, $18, $3C, $7E, $FF, $FF,  { $06: "." }
        $7E, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $18, $3C,  { $07: "." }
        $3C, $18, $00, $00, $00, $00, $00, $00,
        $FF, $FF, $FF, $FF, $FF, $FF, $E7, $C3,  { $08: "." }
        $C3, $E7, $FF, $FF, $FF, $FF, $FF, $FF,
        $00, $00, $00, $00, $00, $3C, $66, $42,  { $09: "." }
        $42, $66, $3C, $00, $00, $00, $00, $00,
        $FF, $FF, $FF, $FF, $FF, $C3, $99, $BD,  { $0A: "." }
        $BD, $99, $C3, $FF, $FF, $FF, $FF, $FF,
        $00, $00, $1E, $0E, $1A, $32, $78, $CC,  { $0B: "." }
        $CC, $CC, $CC, $78, $00, $00, $00, $00,
        $00, $00, $3C, $66, $66, $66, $66, $3C,  { $0C: "." }
        $18, $7E, $18, $18, $00, $00, $00, $00,
        $00, $00, $3F, $33, $3F, $30, $30, $30,  { $0D: "." }
        $30, $70, $F0, $E0, $00, $00, $00, $00,
        $00, $00, $7F, $63, $7F, $63, $63, $63,  { $0E: "." }
        $63, $67, $E7, $E6, $C0, $00, $00, $00,
        $00, $00, $00, $18, $18, $DB, $3C, $E7,  { $0F: "." }
        $3C, $DB, $18, $18, $00, $00, $00, $00,
        $00, $80, $C0, $E0, $F0, $F8, $FE, $F8,  { $10: "." }
        $F0, $E0, $C0, $80, $00, $00, $00, $00,
        $00, $02, $06, $0E, $1E, $3E, $FE, $3E,  { $11: "." }
        $1E, $0E, $06, $02, $00, $00, $00, $00,
        $00, $00, $18, $3C, $7E, $18, $18, $18,  { $12: "." }
        $18, $7E, $3C, $18, $00, $00, $00, $00,
        $00, $00, $66, $66, $66, $66, $66, $66,  { $13: "." }
        $66, $00, $66, $66, $00, $00, $00, $00,
        $00, $00, $7F, $DB, $DB, $DB, $7B, $1B,  { $14: "." }
        $1B, $1B, $1B, $1B, $00, $00, $00, $00,
        $00, $7C, $C6, $60, $38, $6C, $C6, $C6,  { $15: "." }
        $6C, $38, $0C, $C6, $7C, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $16: "." }
        $FE, $FE, $FE, $FE, $00, $00, $00, $00,
        $00, $00, $18, $3C, $7E, $18, $18, $18,  { $17: "." }
        $18, $7E, $3C, $18, $7E, $00, $00, $00,
        $00, $00, $18, $3C, $7E, $18, $18, $18,  { $18: "." }
        $18, $18, $18, $18, $00, $00, $00, $00,
        $00, $00, $18, $18, $18, $18, $18, $18,  { $19: "." }
        $18, $7E, $3C, $18, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $18, $0C, $FE,  { $1A: "." }
        $0C, $18, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $30, $60, $FE,  { $1B: "." }
        $60, $30, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $C0, $C0, $C0,  { $1C: "." }
        $C0, $FE, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $28, $6C, $FE,  { $1D: "." }
        $6C, $28, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $10, $38, $38, $7C,  { $1E: "." }
        $7C, $FE, $FE, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $FE, $FE, $7C, $7C,  { $1F: "." }
        $38, $38, $10, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $20: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $18, $3C, $3C, $3C, $18, $18,  { $21: "!" }
        $18, $00, $18, $18, $00, $00, $00, $00,
        $00, $66, $66, $66, $24, $00, $00, $00,  { $22: """ }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $6C, $6C, $FE, $6C, $6C,  { $23: "#" }
        $6C, $FE, $6C, $6C, $00, $00, $00, $00,
        $18, $18, $7C, $C6, $C2, $C0, $7C, $06,  { $24: "$" }
        $86, $C6, $7C, $18, $18, $00, $00, $00,
        $00, $00, $00, $00, $C2, $C6, $0C, $18,  { $25: "%" }
        $30, $60, $C6, $86, $00, $00, $00, $00,
        $00, $00, $38, $6C, $6C, $38, $76, $DC,  { $26: "&" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $06, $0C, $18, $00, $00, $00, $00, $00,  { $27: "'" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $0C, $18, $30, $30, $30, $30,  { $28: "(" }
        $30, $30, $18, $0C, $00, $00, $00, $00,
        $00, $00, $30, $18, $0C, $0C, $0C, $0C,  { $29: ")" }
        $0C, $0C, $18, $30, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $66, $3C, $FF,  { $2A: "*" }
        $3C, $66, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $18, $18, $7E,  { $2B: "+" }
        $18, $18, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $2C: "," }
        $00, $18, $18, $18, $30, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $FE,  { $2D: "-" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $2E: "." }
        $00, $00, $18, $18, $00, $00, $00, $00,
        $00, $00, $00, $00, $02, $06, $0C, $18,  { $2F: "/" }
        $30, $60, $C0, $80, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $C6, $CE, $D6, $D6,  { $30: "0" }
        $E6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $18, $38, $78, $18, $18, $18,  { $31: "1" }
        $18, $18, $18, $7E, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $06, $0C, $18, $30,  { $32: "2" }
        $60, $C0, $C6, $FE, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $06, $06, $3C, $06,  { $33: "3" }
        $06, $06, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $0C, $1C, $3C, $6C, $CC, $FE,  { $34: "4" }
        $0C, $0C, $0C, $1E, $00, $00, $00, $00,
        $00, $00, $FE, $C0, $C0, $C0, $FC, $0E,  { $35: "5" }
        $06, $06, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $38, $60, $C0, $C0, $FC, $C6,  { $36: "6" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $FE, $C6, $06, $06, $0C, $18,  { $37: "7" }
        $30, $30, $30, $30, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $C6, $C6, $7C, $C6,  { $38: "8" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $C6, $C6, $7E, $06,  { $39: "9" }
        $06, $06, $0C, $78, $00, $00, $00, $00,
        $00, $00, $00, $00, $18, $18, $00, $00,  { $3A: ":" }
        $00, $18, $18, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $18, $18, $00, $00,  { $3B: ";" }
        $00, $18, $18, $30, $00, $00, $00, $00,
        $00, $00, $00, $06, $0C, $18, $30, $60,  { $3C: "<" }
        $30, $18, $0C, $06, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $FE, $00,  { $3D: "=" }
        $00, $FE, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $60, $30, $18, $0C, $06,  { $3E: ">" }
        $0C, $18, $30, $60, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $C6, $0C, $18, $18,  { $3F: "?" }
        $18, $00, $18, $18, $00, $00, $00, $00,
        $00, $00, $00, $7C, $C6, $C6, $DE, $DE,  { $40: "@" }
        $DE, $DC, $C0, $7C, $00, $00, $00, $00,
        $00, $00, $10, $38, $6C, $C6, $C6, $FE,  { $41: "A" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $00, $00, $FC, $66, $66, $66, $7C, $66,  { $42: "B" }
        $66, $66, $66, $FC, $00, $00, $00, $00,
        $00, $00, $3C, $66, $C2, $C0, $C0, $C0,  { $43: "C" }
        $C0, $C2, $66, $3C, $00, $00, $00, $00,
        $00, $00, $F8, $6C, $66, $66, $66, $66,  { $44: "D" }
        $66, $66, $6C, $F8, $00, $00, $00, $00,
        $00, $00, $FE, $66, $62, $68, $78, $68,  { $45: "E" }
        $60, $62, $66, $FE, $00, $00, $00, $00,
        $00, $00, $FE, $66, $62, $68, $78, $68,  { $46: "F" }
        $60, $60, $60, $F0, $00, $00, $00, $00,
        $00, $00, $3C, $66, $C2, $C0, $C0, $DE,  { $47: "G" }
        $C6, $C6, $66, $3A, $00, $00, $00, $00,
        $00, $00, $C6, $C6, $C6, $C6, $FE, $C6,  { $48: "H" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $00, $00, $3C, $18, $18, $18, $18, $18,  { $49: "I" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $1E, $0C, $0C, $0C, $0C, $0C,  { $4A: "J" }
        $CC, $CC, $CC, $78, $00, $00, $00, $00,
        $00, $00, $E6, $66, $6C, $6C, $78, $78,  { $4B: "K" }
        $6C, $66, $66, $E6, $00, $00, $00, $00,
        $00, $00, $F0, $60, $60, $60, $60, $60,  { $4C: "L" }
        $60, $62, $66, $FE, $00, $00, $00, $00,
        $00, $00, $C3, $E7, $FF, $FF, $DB, $DB,  { $4D: "M" }
        $C3, $C3, $C3, $C3, $00, $00, $00, $00,
        $00, $00, $C6, $E6, $F6, $FE, $DE, $CE,  { $4E: "N" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $00, $00, $38, $6C, $C6, $C6, $C6, $C6,  { $4F: "O" }
        $C6, $C6, $6C, $38, $00, $00, $00, $00,
        $00, $00, $FC, $66, $66, $66, $7C, $60,  { $50: "P" }
        $60, $60, $60, $F0, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $C6, $C6, $C6, $C6,  { $51: "Q" }
        $C6, $D6, $DE, $7C, $0C, $0E, $00, $00,
        $00, $00, $FC, $66, $66, $66, $7C, $6C,  { $52: "R" }
        $66, $66, $66, $E6, $00, $00, $00, $00,
        $00, $00, $7C, $C6, $C6, $60, $38, $0C,  { $53: "S" }
        $06, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $FF, $DB, $99, $18, $18, $18,  { $54: "T" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $C6, $C6, $C6, $C6, $C6, $C6,  { $55: "U" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $C6, $C6, $C6, $C6, $C6, $C6,  { $56: "V" }
        $C6, $6C, $38, $10, $00, $00, $00, $00,
        $00, $00, $C3, $C3, $C3, $C3, $C3, $DB,  { $57: "W" }
        $DB, $FF, $66, $66, $00, $00, $00, $00,
        $00, $00, $C6, $C6, $6C, $6C, $38, $38,  { $58: "X" }
        $6C, $6C, $C6, $C6, $00, $00, $00, $00,
        $00, $00, $66, $66, $66, $66, $3C, $18,  { $59: "Y" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $FE, $C6, $86, $0C, $18, $30,  { $5A: "Z" }
        $60, $C2, $C6, $FE, $00, $00, $00, $00,
        $00, $00, $3C, $30, $30, $30, $30, $30,  { $5B: "[" }
        $30, $30, $30, $3C, $00, $00, $00, $00,
        $00, $00, $00, $00, $80, $C0, $60, $30,  { $5C: "\" }
        $18, $0C, $06, $02, $00, $00, $00, $00,
        $00, $00, $3C, $0C, $0C, $0C, $0C, $0C,  { $5D: "]" }
        $0C, $0C, $0C, $3C, $00, $00, $00, $00,
        $10, $38, $6C, $C6, $00, $00, $00, $00,  { $5E: "^" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $5F: "_" }
        $00, $00, $00, $FF, $00, $00, $00, $00,
        $60, $30, $18, $00, $00, $00, $00, $00,  { $60: "`" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $78, $0C, $7C,  { $61: "a" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $E0, $60, $60, $78, $6C, $66,  { $62: "b" }
        $66, $66, $66, $DC, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $7C, $C6, $C0,  { $63: "c" }
        $C0, $C0, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $1C, $0C, $0C, $3C, $6C, $CC,  { $64: "d" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $7C, $C6, $FE,  { $65: "e" }
        $C0, $C0, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $38, $6C, $64, $60, $F0, $60,  { $66: "f" }
        $60, $60, $60, $F0, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $76, $CC, $CC,  { $67: "g" }
        $CC, $CC, $CC, $7C, $0C, $CC, $78, $00,
        $00, $00, $E0, $60, $60, $6C, $76, $66,  { $68: "h" }
        $66, $66, $66, $E6, $00, $00, $00, $00,
        $00, $00, $18, $18, $00, $38, $18, $18,  { $69: "i" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $06, $06, $00, $0E, $06, $06,  { $6A: "j" }
        $06, $06, $06, $06, $66, $66, $3C, $00,
        $00, $00, $E0, $60, $60, $66, $6C, $78,  { $6B: "k" }
        $78, $6C, $66, $E6, $00, $00, $00, $00,
        $00, $00, $38, $18, $18, $18, $18, $18,  { $6C: "l" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $E6, $FF, $DB,  { $6D: "m" }
        $DB, $DB, $DB, $DB, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $DC, $66, $66,  { $6E: "n" }
        $66, $66, $66, $66, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $7C, $C6, $C6,  { $6F: "o" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $DC, $66, $66,  { $70: "p" }
        $66, $66, $66, $7C, $60, $60, $F0, $00,
        $00, $00, $00, $00, $00, $76, $CC, $CC,  { $71: "q" }
        $CC, $CC, $CC, $7C, $0C, $0C, $1E, $00,
        $00, $00, $00, $00, $00, $DC, $76, $62,  { $72: "r" }
        $60, $60, $60, $F0, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $7C, $C6, $60,  { $73: "s" }
        $38, $0C, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $10, $30, $30, $FC, $30, $30,  { $74: "t" }
        $30, $30, $36, $1C, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $CC, $CC, $CC,  { $75: "u" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $66, $66, $66,  { $76: "v" }
        $66, $66, $3C, $18, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $C3, $C3, $C3,  { $77: "w" }
        $DB, $DB, $FF, $66, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $C6, $6C, $38,  { $78: "x" }
        $38, $38, $6C, $C6, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $C6, $C6, $C6,  { $79: "y" }
        $C6, $C6, $C6, $7E, $06, $0C, $F8, $00,
        $00, $00, $00, $00, $00, $FE, $CC, $18,  { $7A: "z" }
        $30, $60, $C6, $FE, $00, $00, $00, $00,
        $00, $00, $0E, $18, $18, $18, $70, $18,  { $7B: "{" }
        $18, $18, $18, $0E, $00, $00, $00, $00,
        $00, $00, $18, $18, $18, $18, $00, $18,  { $7C: "|" }
        $18, $18, $18, $18, $00, $00, $00, $00,
        $00, $00, $70, $18, $18, $18, $0E, $18,  { $7D: <fecha colchete> }
        $18, $18, $18, $70, $00, $00, $00, $00,
        $00, $00, $76, $DC, $00, $00, $00, $00,  { $7E: "~" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $10, $38, $6C, $C6,  { $7F: <del> }
        $C6, $C6, $FE, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $80: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $81: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $82: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $83: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $84: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $85: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $86: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $87: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $88: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $89: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $8A: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $8B: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $8C: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $8D: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $8E: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $8F: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $90: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $91: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $92: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $93: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $94: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $95: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $96: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $97: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $98: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $99: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $9A: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $9B: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $9C: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $10, $30, $7F, $FF,  { $9D: " " }
        $7F, $30, $10, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $08, $0C, $FE, $FF,  { $9E: " " }
        $FE, $0C, $08, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $FF, $FF,  { $9F: " " }
        $FF, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $A0: " " }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $18, $18,  { $A1: "" }
        $00, $18, $18, $18, $18, $18, $18, $18,
        $00, $18, $18, $7C, $C6, $C0, $C0, $C0,  { $A2: "" }
        $C6, $7C, $18, $18, $00, $00, $00, $00,
        $00, $38, $6C, $64, $60, $F0, $60, $60,  { $A3: "" }
        $60, $60, $E6, $FC, $00, $00, $00, $00,
        $00, $00, $00, $00, $C6, $7C, $C6, $C6,  { $A4: "" }
        $C6, $C6, $7C, $C6, $00, $00, $00, $00,
        $00, $00, $00, $66, $66, $3C, $18, $7E,  { $A5: "" }
        $18, $7E, $18, $18, $00, $00, $00, $00,
        $00, $18, $18, $18, $18, $18, $00, $00,  { $A6: "" }
        $18, $18, $18, $18, $18, $00, $00, $00,
        $00, $7C, $C6, $60, $38, $6C, $C6, $C6,  { $A7: "" }
        $6C, $38, $0C, $C6, $7C, $00, $00, $00,
        $C6, $C6, $00, $00, $00, $00, $00, $00,  { $A8: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $7C, $82, $9A, $A2,  { $A9: "" }
        $A2, $9A, $82, $7C, $00, $00, $00, $00,
        $00, $00, $3C, $6C, $6C, $3E, $00, $7E,  { $AA: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $36, $6C, $D8,  { $AB: "" }
        $6C, $36, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $FE, $06,  { $AC: "" }
        $06, $06, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $FE,  { $AD: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $7C, $82, $B2, $AA, $B2, $AA,  { $AE: "" }
        $AA, $82, $7C, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $FF, $00, $00, $00,  { $AF: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $38, $6C, $6C, $38, $00, $00, $00,  { $B0: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $18, $18, $7E, $18,  { $B1: "" }
        $18, $00, $00, $7E, $00, $00, $00, $00,
        $00, $3C, $66, $0C, $18, $32, $7E, $00,  { $B2: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $7C, $06, $3C, $06, $06, $7C, $00,  { $B3: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $0C, $18, $30, $00, $00, $00, $00,  { $B4: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $66, $66, $66,  { $B5: "" }
        $66, $66, $66, $7C, $60, $60, $C0, $00,
        $00, $00, $00, $00, $00, $FE, $6C, $6C,  { $B6: "" }
        $6C, $6C, $6C, $6C, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $18, $3C,  { $B7: "" }
        $3C, $18, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,  { $B8: "" }
        $00, $00, $18, $18, $0C, $2C, $18, $00,
        $00, $18, $38, $18, $18, $18, $3C, $00,  { $B9: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $38, $6C, $6C, $38, $00, $7C,  { $BA: "" }
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $D8, $6C, $36,  { $BB: "" }
        $6C, $D8, $00, $00, $00, $00, $00, $00,
        $00, $60, $E0, $62, $66, $6C, $18, $30,  { $BC: "" }
        $66, $CE, $9A, $3F, $06, $06, $00, $00,
        $00, $60, $E0, $62, $66, $6C, $18, $30,  { $BD: "" }
        $60, $DC, $86, $0C, $18, $3E, $00, $00,
        $00, $E0, $30, $62, $36, $EC, $18, $30,  { $BE: "" }
        $66, $CE, $9A, $3F, $06, $06, $00, $00,
        $00, $00, $30, $30, $00, $30, $30, $60,  { $BF: "" }
        $C0, $C6, $C6, $7C, $00, $00, $00, $00,
        $C0, $60, $10, $38, $6C, $C6, $C6, $FE,  { $C0: "" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $06, $0C, $10, $38, $6C, $C6, $C6, $FE,  { $C1: "" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $38, $6C, $C6, $38, $6C, $C6, $C6, $FE,  { $C2: "" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $76, $DC, $00, $38, $6C, $C6, $C6, $FE,  { $C3: "" }
        $C6, $C6, $C6, $C6, $00, $00, $00, $00,
        $C6, $C6, $00, $10, $38, $6C, $C6, $C6,  { $C4: "" }
        $FE, $C6, $C6, $C6, $00, $00, $00, $00,
        $38, $6C, $38, $10, $38, $6C, $C6, $C6,  { $C5: "" }
        $FE, $C6, $C6, $C6, $00, $00, $00, $00,
        $00, $00, $3F, $73, $D9, $D8, $DA, $FE,  { $C6: "" }
        $DA, $D9, $DB, $DF, $00, $00, $00, $00,
        $00, $00, $3C, $66, $C2, $C0, $C0, $C0,  { $C7: "" }
        $C0, $C2, $66, $3C, $18, $70, $00, $00,
        $30, $18, $00, $FE, $66, $62, $68, $78,  { $C8: "" }
        $68, $62, $66, $FE, $00, $00, $00, $00,
        $0C, $18, $00, $FE, $66, $62, $68, $78,  { $C9: "" }
        $68, $62, $66, $FE, $00, $00, $00, $00,
        $38, $6C, $00, $FE, $66, $62, $68, $78,  { $CA: "" }
        $68, $62, $66, $FE, $00, $00, $00, $00,
        $C6, $C6, $00, $FE, $66, $62, $68, $78,  { $CB: "" }
        $68, $62, $66, $FE, $00, $00, $00, $00,
        $30, $18, $00, $3C, $18, $18, $18, $18,  { $CC: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $0C, $18, $00, $3C, $18, $18, $18, $18,  { $CD: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $3C, $66, $00, $3C, $18, $18, $18, $18,  { $CE: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $66, $66, $00, $3C, $18, $18, $18, $18,  { $CF: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $F8, $6C, $66, $66, $F6, $F6,  { $D0: "" }
        $66, $66, $6C, $F8, $00, $00, $00, $00,
        $76, $DC, $00, $C6, $E6, $F6, $FE, $DE,  { $D1: "" }
        $CE, $C6, $C6, $C6, $00, $00, $00, $00,
        $30, $18, $00, $7C, $C6, $C6, $C6, $C6,  { $D2: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $18, $30, $00, $7C, $C6, $C6, $C6, $C6,  { $D3: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $38, $6C, $00, $7C, $C6, $C6, $C6, $C6,  { $D4: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $76, $DC, $00, $7C, $C6, $C6, $C6, $C6,  { $D5: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $C6, $C6, $00, $7C, $C6, $C6, $C6, $C6,  { $D6: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $7F, $FB, $D9, $DA, $DE, $DA,  { $D7: "" }
        $D8, $D9, $FB, $7F, $00, $00, $00, $00,
        $00, $04, $7C, $CE, $CE, $D6, $D6, $D6,  { $D8: "" }
        $D6, $E6, $E6, $7C, $40, $00, $00, $00,
        $30, $18, $00, $C6, $C6, $C6, $C6, $C6,  { $D9: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $18, $30, $00, $C6, $C6, $C6, $C6, $C6,  { $DA: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $38, $6C, $00, $C6, $C6, $C6, $C6, $C6,  { $DB: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $C6, $C6, $00, $C6, $C6, $C6, $C6, $C6,  { $DC: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $0C, $18, $00, $66, $66, $66, $66, $3C,  { $DD: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $F0, $60, $7C, $66, $66, $66,  { $DE: "" }
        $66, $7C, $60, $F0, $00, $00, $00, $00,
        $00, $00, $78, $CC, $CC, $CC, $D8, $CC,  { $DF: "" }
        $C6, $C6, $C6, $CC, $00, $00, $00, $00,
        $00, $60, $30, $18, $00, $78, $0C, $7C,  { $E0: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $18, $30, $60, $00, $78, $0C, $7C,  { $E1: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $10, $38, $6C, $00, $78, $0C, $7C,  { $E2: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $76, $DC, $00, $78, $0C, $7C,  { $E3: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $CC, $CC, $00, $78, $0C, $7C,  { $E4: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $38, $6C, $38, $00, $78, $0C, $7C,  { $E5: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $EC, $36, $36,  { $E6: "" }
        $7E, $D8, $D8, $6E, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $7C, $C6, $C0,  { $E7: "" }
        $C0, $C0, $C6, $7C, $18, $70, $00, $00,
        $00, $60, $30, $18, $00, $7C, $C6, $FE,  { $E8: "" }
        $C0, $C0, $C6, $7C, $00, $00, $00, $00,
        $00, $0C, $18, $30, $00, $7C, $C6, $FE,  { $E9: "" }
        $C0, $C0, $C6, $7C, $00, $00, $00, $00,
        $00, $10, $38, $6C, $00, $7C, $C6, $FE,  { $EA: "" }
        $C0, $C0, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $C6, $C6, $00, $7C, $C6, $FE,  { $EB: "" }
        $C0, $C0, $C6, $7C, $00, $00, $00, $00,
        $00, $60, $30, $18, $00, $38, $18, $18,  { $EC: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $0C, $18, $30, $00, $38, $18, $18,  { $ED: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $18, $3C, $66, $00, $38, $18, $18,  { $EE: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $66, $66, $00, $38, $18, $18,  { $EF: "" }
        $18, $18, $18, $3C, $00, $00, $00, $00,
        $00, $00, $34, $18, $2C, $06, $3E, $66,  { $F0: "" }
        $66, $66, $66, $3C, $00, $00, $00, $00,
        $00, $00, $76, $DC, $00, $DC, $66, $66,  { $F1: "" }
        $66, $66, $66, $66, $00, $00, $00, $00,
        $00, $60, $30, $18, $00, $7C, $C6, $C6,  { $F2: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $18, $30, $60, $00, $7C, $C6, $C6,  { $F3: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $10, $38, $6C, $00, $7C, $C6, $C6,  { $F4: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $76, $DC, $00, $7C, $C6, $C6,  { $F5: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $C6, $C6, $00, $7C, $C6, $C6,  { $F6: "" }
        $C6, $C6, $C6, $7C, $00, $00, $00, $00,
        $00, $00, $00, $00, $66, $DE, $D9, $DF,  { $F7: "" }
        $DE, $D8, $D9, $6E, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $7C, $CE, $DE,  { $F8: "" }
        $F6, $E6, $C6, $7C, $00, $00, $00, $00,
        $00, $60, $30, $18, $00, $CC, $CC, $CC,  { $F9: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $18, $30, $60, $00, $CC, $CC, $CC,  { $FA: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $30, $78, $CC, $00, $CC, $CC, $CC,  { $FB: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $00, $CC, $CC, $00, $CC, $CC, $CC,  { $FC: "" }
        $CC, $CC, $CC, $76, $00, $00, $00, $00,
        $00, $0C, $18, $30, $00, $C6, $C6, $C6,  { $FD: "" }
        $C6, $C6, $C6, $7E, $06, $0C, $F8, $00,
        $00, $00, $E0, $60, $60, $7C, $66, $66,  { $FE: "" }
        $66, $66, $66, $7C, $60, $60, $F0, $00,
        $00, $00, $C6, $C6, $00, $C6, $C6, $C6,  { $FF: "" }
        $C6, $C6, $C6, $7E, $06, $0C, $78, $00
    );

var regs: registers;

{--------------------------------------------------------}

procedure carregaGeradorISO;
begin
    with regs do
        begin
            ah := $11;  al := 0;
            bh := 16;   bl := 1;
            cx := 256;
            dx := 0;
            es := seg (geradorCarac);
            bp := ofs (geradorCarac);
            intr ($10, regs);

            ah := $11;  al := 3;
            bl := 1;
            intr ($10, regs);
        end;

    geradorIsoCarregado := true;
end;

{--------------------------------------------------------}

procedure carregaGeradorIBM;
begin
    with regs do
        begin
            ah := $11;  al := 4;
            bl := 1;    bh := 0;
            intr ($10, regs);

            ah := $11;  al := 3;
            bh := 1;
            intr ($10, regs);
        end;

    geradorIsoCarregado := false;
end;

begin
    geradorIsoCarregado := false;
end.
