; VOX - leitor de telas
; Autor: Orlando Jose' Rodrigues Alves
; Em Marco/94

code segment para public 'code'
    assume cs:code,ds:code,es:code,ss:code
    org 100h

maxtimes equ 3bbbh     ; Numero de operacoes necessarias para o 486DX 50Mhz
waittime equ 510       ; Numero de waits entre cada pulso na porta

MAXLINELEN equ 160


main proc near
    jmp  start

; Area de variaveis globais
dosflag label dword
_dosflag dw 2 dup(0)

oldtimer label dword
_oldtimer dw 2 dup(0)

oldkey label dword
_oldkey dw 2 dup(0)

oldidle label dword
_oldidle dw 2 dup(0)

called db 0
active db 0

_alt db 0
_esc db 0

cursor dw 0

waitinstr dw 0

default_dirname    db 'C:\DOSVOX\SOM\LETRAS\',0
default_dirlength  dw 8

dirlength dw 0
dirname  db 80 dup(0)
         db 20 dup(0)
fileaux  db MAXLINELEN+1 dup(0)

filebuf  db 15000 dup(0)

linestr  db MAXLINELEN+1 dup(0)
linepos  dw 0


blink proc near

    inc  si
    xor  byte ptr ds:[si],80h
    dec  si

    ret

blink endp

read_char proc near

    mov  al,byte ptr ds:[si]

    ret

read_char endp

gotoxy proc near

    push ax
    push bx

    mov  ah,2
    mov  bh,0
    int  10h

    call blink

    pop  bx
    pop  ax

    ret

gotoxy endp

open_file proc near

    ; DS:DX = Nome do arquivo
    mov  ax,3d00h   ; Abre o arquivo para leitura
    int  21h

    jc   open_erro  ; Se houve erro desvia

    mov  bx,ax      ; Senao guarda em BX o handle do arquivo
    mov  al,1
    ret

open_erro:
    xor  al,al
    ret

open_file endp

close_file proc near

    ; BX = handle para o arquivo
    mov  ah,3eh
    int  21h

    ret

close_file endp


init_linestr proc near

    mov  word ptr cs:linepos,0
    push di
    mov  di,offset linestr
    mov  byte ptr cs:[di],0
    pop  di
    ret

init_linestr endp

invert_line proc near

    cmp  word ptr cs:linepos,1
    jg   invert_continue

    ret

invert_continue:
    push ax
    push cx
    push si
    push di
    push ds
    push es

    push cs
    push cs
    pop  ds
    pop  es

    mov  si,offset linestr
    xor  cx,cx

    cld

find_strend:
    lodsb
    cmp  al,0
    je   found_strend
    inc  cx
    jmp  find_strend

found_strend:
    mov  di,si
    dec  di
    dec  di

    mov  si,offset linestr

    cmp  di,si    ; Se a string estiver vazia sai
    jl   invert_end

    mov  ax,cx
    shr  ax,1     ; Divide por dois o contador
    mov  cx,ax

invert_loop:
    mov  al,ds:[si]  ; AL = DS:[SI]
    mov  ah,es:[di]
    mov  ds:[si],ah
    mov  es:[di],al   ; ES:[DI] = AL
    inc  si
    dec  di
    loop invert_loop

invert_end:
    pop  es
    pop  ds
    pop  di
    pop  si
    pop  cx
    pop  ax

    ret

invert_line endp


store_char proc near

    push bx
    push si

    mov  bx,offset linestr
    mov  si,word ptr cs:linepos
    cmp  si,MAXLINELEN
    jg   store_end

    mov  cs:[bx+si],al
    inc  si
    mov  byte ptr cs:[bx+si],0
    inc  word ptr cs:linepos

store_end:
    pop  si
    pop  bx

    ret

store_char endp


key_return proc near
    push ax
    push bx

    inc  dh
    cmp  dh,18h
    jg   key_return100

    add  si,160
    mov  al,dl
    xor  ah,ah
    sub  si,ax
    sub  si,ax

    xor  dl,dl
    jmp  key_return_end

key_return100:
    mov  ax,0e07h  ; Apita se for a ultima linha
    xor  bh,bh
    int  10h

    dec  dh

key_return_end:
    call gotoxy

    pop  bx
    pop  ax

    ret

key_return endp

key_home proc near

    push ax

    mov  ax,dx
    xor  ah,ah

    ; Subtrae duas vezes o numero de colunas (caracter e atributo)
    sub  si,ax
    sub  si,ax

    xor  dl,dl
    call gotoxy

    pop  ax

    ret

key_home endp

key_end proc near

    push ax
    push cx

    mov  al,dh
    xor  ah,ah
    mov  cl,160
    mul  cl     ; AX = AX*160
    add  ax,158
    mov  si,ax

    std    ; Altera a direcao da busca

    mov  dl,79

key_endloop:
    lodsb
    dec  si

    dec  dl
    cmp  dl,0     ; Se chegou `a coluna 0 interrompe
    je   key_end_end
    cmp  al,20h   ; Se for espaco continua a busca
    je   key_endloop

key_end_end:
    inc  dl
    add  si,2
    call gotoxy

    cld    ; Restaura a direcao original da busca

    pop  cx
    pop  ax

    ret

key_end endp

key_ctrl_home proc near

    xor  si,si

    xor  dx,dx
    call gotoxy

    ret

key_ctrl_home endp

key_ctrl_end proc near

    mov  si,0f9eh
    sub  si,158

    mov  dx,1800h    ; DH = Linha 24   DL = Coluna 79
    call gotoxy

    ret

key_ctrl_end endp

key_right proc near

    mov  al,1

    inc  dl

    inc  si         ; Caracter e atributo
    inc  si

    cmp  dl,4fh     ; Verifica se ultrapassou a ultima coluna
    jle  right_end  ; Se nao ultrapassou retorna

    cmp  dh,18h     ; Se ja esta' na ultima linha da um apito de erro
    jl   right_next_line

    mov  dl,4fh
    mov  si,0f9eh

    mov  ax,0e07h  ; Apita se for a ultima linha
    xor  bh,bh
    int  10h

    xor  al,al

    jmp  right_end


right_next_line:
    xor  dl,dl     ; Zera a coluna ...
    inc  dh        ; ... e incrementa a linha

right_end:
    call gotoxy

    ret

key_right endp

key_left proc near

    mov  al,1

    dec  dl

    dec  si        ; Caracter e atributo
    dec  si

    cmp  dl,0      ; Verifica se ultrapassou a primeira coluna
    jge  left_end  ; Se nao ultrapassou retorna

    cmp  dh,0      ; Se ja esta' na primeira linha da um apito de erro
    jg   left_next_line

    xor  dl,dl
    xor  si,si

    mov  ax,0e07h  ; Apita se for a ultima linha
    xor  bh,bh
    int  10h

    xor  al,al

    jmp  left_end

left_next_line:
    mov  dl,4fh    ; Posiciona na ultima coluna ...
    dec  dh        ; ... e decrementa a linha

left_end:
    call gotoxy

    ret

key_left endp


key_up proc near

    mov  al,1

    dec  dh     ; Decrementa a linha

    sub  si,0a0h ; 160 bytes

    cmp  dh,0   ; Se estiver dentro dos limites continua
    jge  up_end

    inc  dh     ; Senao permanece mesma linha
    add  si,0a0h

    mov  ax,0e07h  ; Apita se for a primeira linha
    xor  bh,bh
    int  10h

    xor  al,al

up_end:
    call gotoxy

    ret

key_up endp

key_down proc near

    mov  al,1

    inc  dh      ; Incrementa a linha

    add  si,0a0h ; 160 bytes

    cmp  dh,18h  ; Se estiver dentro dos limites continua
    jle  down_end

    dec  dh      ; Senao permanece na mesma linha
    sub  si,0a0h

    mov  ax,0e07h  ; Apita se for a ultima linha
    xor  bh,bh
    int  10h

    xor  al,al

down_end:
    call gotoxy

    ret

key_down endp

key_ctrl_left proc near

    call blink
    call key_left
    cmp  al,1     ; Verifica se conseguiu andar para direita
    je   cl_l100_0

    jmp  cl_end1

cl_l100_0:
    call init_linestr

cl_l100:
    call read_char
    cmp  al,32
    jne  cl_l200 ; while ( read_char() == 32 ) key_left()

    call blink

    call key_left
    cmp  dl,0      ; Se estiver na primeira coluna para
    je   cl_l250

    cmp  al,0
    jne  cl_l100    ; Se conseguiu andar para a esquerda continua

    jmp  cl_end

cl_l200:
    call read_char
    cmp  al,32
    je   cl_l300 ; while ( read_char() != 32 ) key_left()

    call store_char ; Guarda o caracter numa string

    call blink

    call key_left
    cmp  dl,0       ; Se estiver na primeira coluna para
    je   cl_l250

    cmp  al,0
    jne  cl_l200

cl_l250:
    call read_char
    call store_char
    call invert_line
    call speak_line
    jmp  cl_end1

cl_l300:
    call invert_line
    call speak_line

cl_end:
    call blink
    call key_right

cl_end1:
    call init_linestr
    ret

key_ctrl_left endp

key_ctrl_right proc near

    call init_linestr

cr_l100:
    call read_char
    cmp  al,32
    je   cr_l200_0 ; while ( read_char() != 32 ) key_right()

    call blink

    call store_char

    call key_right
    cmp  dl,4fh     ; Se estiver na ultima coluna para
    je   cr_l250

    cmp  al,0
    jne  cr_l100    ; Se conseguiu andar para a esquerda continua

    jmp  cr_end

cr_l250:
    call speak_line
    jmp  cr_end

cr_l200_0:
    call speak_line

cr_l200:
    call read_char
    cmp  al,32
    jne  cr_end    ; while ( read_char() != 32 ) key_right()

    call blink

    call key_right
    cmp  dl,4fh    ; Se estiver na ultima coluna para
    je   cr_l300

    cmp  al,0
    jne  cr_l200

cr_l300:
    call read_char
    call speak_char

cr_end:
    call init_linestr
    ret

key_ctrl_right endp


strcpy proc near

strl100:
    mov  al,es:[si]
    inc  si
    cmp  al,0
    je   strend
    mov  ds:[bx],al
    inc  bx
    jmp  strl100

strend:
    mov  byte ptr ds:[bx],0

    ret

strcpy endp

output_file proc near

    push bx
    push cx
    push dx
    push si

    ; DS:DX = Nome do arquivo
    call open_file
    cmp  al,1
    jne  output_end

    ; Le o header do arquivo (50 bytes) e descarta
    mov  ah,3fh
    mov  cx,50
    mov  dx,offset filebuf
    int  21h

readloop:
    ; Le os bytes do arquivo
    mov  ah,3fh
    mov  cx,15000
    mov  dx,offset filebuf
    int  21h

    cmp  ax,0    ; Se chegou ao fim do arquivo para de ler e fecha
    je   output_close

    mov  cx,ax   ; Numero de bytes
    mov  si,dx
    mov  dx,378h

output_bytes:
    lodsb

just_output:
    out  dx,al

    push cx
    mov  cx,word ptr cs:waitinstr

    ; Delay de output na porta
output_clockloop1:
    dec  cx
    mov  ax,es:[bx] ; Nao importa p/ onde ES:BX apontam e' apenas o acesso que
                    ; importa
    sub  ax,ax
    cmp  cx,1
    jg   output_clockloop1

    pop  cx

    dec  cx
    jnz  output_bytes

    jmp  readloop

output_close:
    call close_file

    mov  al,1

output_end:

    pop  si
    pop  dx
    pop  cx
    pop  bx

    ret

output_file endp


speak_line proc near

    push ax
    push bx
    push dx
    push di
    push ds

    push cs
    pop  ds

    mov  bx,offset linestr

line_start:
    mov  di,offset fileaux
    mov  byte ptr cs:[di],0
    xor  ah,ah

line_loop:
    mov  al,cs:[bx]  ; Pega o caracter e verifica se e' limitador

    cmp  al,0
    jne  line_l040

    jmp  line_end

line_l040:
    cmp  al,47       ; Verifica se e' delimitador
    jle  line_l100   ; Se for desvia
    cmp  al,58       ; Verifica se e' delimitador
    jge  line_l050   ; Se for testa pelo limite superior dos delimitadores
    jmp  line_l060   ; Senao continua o processamento

line_l050:
    cmp  al,63       ; Verifica se e' delimitador
    jle  line_l100   ; Se for desvia

line_l060:
    ; Incrementa o contador de caracteres
    inc  ah

    ; Inclui o caracter no buffer auxiliar
    mov  cs:[di],al
    inc  di

    ; Apenas delimita fim da linha por '\0' para compatibilizar com a versao
    ; que falava a palavra
    mov  byte ptr cs:[di],0

    inc  bx
    jmp  line_loop

line_l100:
    ; Finaliza a string e tenta falar a palavra. se nao conseguir soletra
;    mov  byte ptr cs:[di],'.'
;    inc  di
;    mov  byte ptr cs:[di],'W'
;    inc  di
;    mov  byte ptr cs:[di],'A'
;    inc  di
;    mov  byte ptr cs:[di],'V'
;    inc  di
;    mov  byte ptr cs:[di],0
;
;    push ax
;    push si
;    push bx
;    push ds
;
;    push cs
;    pop  ds
;    mov  si,offset fileaux
;    mov  bx,offset dirname
;    add  bx,word ptr dirlength
;    call strcpy
;
;    pop  ds
;    pop  bx
;    pop  si
;    pop  ax
;
;    push ax
;    push dx
;    mov  dx,offset dirname
;    call output_file
;    cmp  al,0
;    pop  dx
;    pop  ax
;    jne  line_l200
;
    ; Nesta versao apenas soletra a frase. Aguardando completar a finaliza-
    ; cao por fonemas
    push bx
    push ax

    mov  bx,offset fileaux

spell_line:
    mov  al,cs:[bx]
    inc  bx
;    cmp  al,'.'     ; Versao antiga
    cmp  al,0        ; Agora testa pelo fim de string
    je   line_l150
    call speak_char
    jmp  spell_line

line_l150:
    pop  ax
    pop  bx

line_l200:
    cmp  al,47       ; Verifica se e' delimitador
    jle  line_l400   ; Se for deve falar o caracter
    cmp  al,58       ; Verifica se e' delimitador
    jge  line_l300   ; Se for testa pelo limite superior dos delimitadores
    jmp  line_start  ; Senao continua o processamento

line_l300:
    cmp  al,63       ; Verifica se e' delimitador
    jle  line_l400
    jmp  line_start  ; Se for desvia

line_l400:
    call speak_char  ; No caso dos delimitadores fala
    inc  bx

    jmp  line_start

line_end:
    push di
    mov  di,offset fileaux
    cmp  byte ptr cs:[di],0
    pop  di
    jne  line_end_speak_line
    jmp  line_end1

line_end_speak_line:

    ; Finaliza a string e tenta falar a palavra. se nao conseguir soletra
;    mov  byte ptr cs:[di],'.'
;    inc  di
;    mov  byte ptr cs:[di],'W'
;    inc  di
;    mov  byte ptr cs:[di],'A'
;    inc  di
;    mov  byte ptr cs:[di],'V'
;    inc  di
;    mov  byte ptr cs:[di],0
;
;    push ax
;    push si
;    push bx
;    push ds
;
;    push cs
;    pop  ds
;    mov  si,offset fileaux
;    mov  bx,offset dirname
;    add  bx,word ptr dirlength
;    call strcpy
;
;    pop  ds
;    pop  bx
;    pop  si
;    pop  ax
;
;    push ax
;    push dx
;    mov  dx,offset dirname
;    call output_file
;    cmp  al,0
;    pop  dx
;    pop  ax
;    jne  line_end1

    push bx
    push ax

    mov  bx,offset fileaux

spell_line1:
    mov  al,cs:[bx]
    inc  bx
;    cmp  al,'.'    ; Versao antiga
    cmp  al,0       ; Agora testa pelo fim de string
    je   line_l500
    call speak_char
    jmp  spell_line1

line_l500:
    pop  ax
    pop  bx

line_end1:

    push bx
    mov  bx,offset fileaux
    mov  byte ptr cs:[bx],0
    mov  bx,offset dirname
    add  bx,word ptr cs:dirlength
    mov  byte ptr cs:[bx],0
    pop  bx

    pop  ds
    pop  di
    pop  dx
    pop  bx
    pop  ax

    ret

speak_line endp

speak_char proc near
    ; DS:DX apontam para o nome do arquivo

    push ds
    push si
    push dx
    push cx
    push bx
    push ax

    push cs
    pop  ds

    mov  bx,offset dirname
    add  bx,word ptr dirlength

    ; O nome do arquivo e: _###.WAV. Onde ### e' o cod. ASCII do caracter
    mov  byte ptr cs:[bx],'_'
    inc  bx

    push ax
    push cx
    mov  cl,100
    xor  ah,ah
    cmp  al,100
    jl   spl100
    div  cl
    add  al,'0'
    mov  byte ptr cs:[bx],al
    inc  bx
    xchg ah,al

spl100:
    mov  cl,10
    xor  ah,ah
    cmp  al,10
    jge  spl150
    mov  byte ptr cs:[bx],'0'
    inc  bx
    jmp short spl200

spl150:
    div  cl
    add  al,'0'
    mov  byte ptr cs:[bx],al
    inc  bx
    xchg ah,al

spl200:
    add  al,'0'
    mov  byte ptr cs:[bx],al
    inc  bx
    pop  cx
    pop  ax

    mov  byte ptr cs:[bx],'.'
    mov  byte ptr cs:[bx+1],'W'
    mov  byte ptr cs:[bx+2],'A'
    mov  byte ptr cs:[bx+3],'V'
    mov  byte ptr cs:[bx+4],0

    push cs
    pop  ds
    mov  dx,offset dirname

    call output_file

    pop  ax
    pop  bx
    pop  cx
    pop  dx
    pop  si
    pop  ds

    ret

speak_char endp

process_screen proc near

    push  ax
    push  bx
    push  cx
    push  dx
    push  si
    push  di
    push  ds
    push  es

    ; Guarda a posicao do cursor para restaurar depois
    mov   ah,3
    xor   bh,bh
    int   10h

    mov   word ptr cs:cursor,dx

    ; Aponta o par DS:SI para o inicio da tela
    mov   ax,0b800h
    mov   ds,ax

    ; Calcula a posicao do cursor
    mov   cl,160
    mov   al,dh
    xor   ah,ah
    mul   cl
    mov   si,ax

    ; Salva a coluna final
    mov   cl,dl

    ; Inicializa as coordenadas do cursor
    mov   dl,0      ; DH = LINHA    DL = COLUNA
    call  gotoxy
    call  blink

speak_actual_line:

    push  cx

    call  read_char
    call  speak_char

    call  blink

    inc   dl
    call  gotoxy

    ; Verifica se chegou ao fim. Senao, fala o proximo caracter
    cmp   dl,cl
    pop   cx
    jg    end_speak_actual_line

    inc   si
    inc   si

    jmp  short speak_actual_line

end_speak_actual_line:

    call  blink

    ; Se ja estiver no inicio da linha nao retrocede. Posiciona na posicao
    ; original do cursor, se necessario
    cmp   dl,0
    je    proc_loop

    call  blink

    dec   dl
    call  gotoxy

proc_loop:
    ; Le uma tecla
    mov   ah,0
    int   16h

    cmp   ax,4700h  ; Verifica se e' HOME
    jne   myend

    call  blink
    call  key_home

    call  read_char
    call  speak_char

    jmp   proc_loop

myend:
    cmp   ax,4f00h  ; Verifica se e' END
    jne   up

    call  blink
    call  key_end

    call  read_char
    call  speak_char

    jmp   proc_loop

up:
    cmp   ax,4800h  ; Verifica se e' UP
    jne   down

    call  blink
    call  key_up

    call  read_char
    call  speak_char

    jmp   proc_loop

down:
    cmp   ax,5000h  ; Verifica se e' DOWN
    jne   left

    call  blink
    call  key_down

    call  read_char
    call  speak_char

    jmp   proc_loop

left:
    cmp   ax,4b00h  ; Verifica se e' LEFT
    jne   right

    call  blink
    call  key_left

    call  read_char
    call  speak_char

    jmp   proc_loop

right:
    cmp   ax,4d00h  ; Verifica se e' RIGHT
    jne   ctrl_left

    call  blink
    call  key_right

    call  read_char
    call  speak_char

    jmp   proc_loop

ctrl_left:
    cmp   ax,7300h  ; Verifica se e' CTRL-LEFT
    jne   ctrl_right

    call  key_ctrl_left

    jmp   proc_loop

ctrl_right:
    cmp   ax,7400h  ; Verifica se e' CTRL-RIGHT
    jne   ctrl_home

    call  key_ctrl_right

    jmp   proc_loop

ctrl_home:
    cmp   ax,7700h  ; Verifica se e' CTRL-HOME
    jne  ctrl_end

    call  blink
    call key_ctrl_home

    call  read_char
    call  speak_char

    jmp  proc_loop

ctrl_end:
    cmp   ax,7500h  ; Verifica se e' CTRL-HOME
    jne   return

    call  blink
    call key_ctrl_end

    call  read_char
    call  speak_char

    jmp  proc_loop

return:
    cmp  ax,1c0dh   ; Verifica se e' RETURN
    jne  key_f1

    call blink
    call key_return

    call  read_char
    call  speak_char

    jmp  proc_loop

key_f1:                 ; F1 = CTRL+'->'
    cmp   ax,3b00h
    jne   escape

    call  key_ctrl_right

    jmp   proc_loop

escape:
    cmp   ax,011bh  ; Verifica se e' ESC
    je    get_out

    jmp   proc_loop

get_out:

    ; Restaura a posicao do cursor
    mov   dx,cs:cursor
    call  gotoxy

    pop   es
    pop   ds
    pop   di
    pop   si
    pop   dx
    pop   cx
    pop   bx
    pop   ax

    ret

process_screen endp

newtimer proc near

    ; Executa a funcao antiga
    pushf
    call cs:oldtimer

    ; Verifica se o programa foi chamado
    cmp  byte ptr cs:called,1
    jne  timersai

    ; Verifica se o DOS esta ocupado
    push es
    push bx
    push ax
    mov  ax,cs:_dosflag[2]
    mov  es,ax
    mov  bx,cs:_dosflag
    cmp  byte ptr es:[bx],0
    pop  ax
    pop  bx
    pop  es
    jne  timersai

    ; Reseta a flag de chamada
    mov  byte ptr cs:called,0

    ; Indica que ja foi chamado
    mov  byte ptr cs:active,1

    ; Processa tela
    call process_screen

    ; Indica que ja terminou a chamada
    mov  byte ptr cs:active,0

timersai:
    iret

newtimer endp


newkey proc near
    ; Verifica se o programa ja esta ativo. Se estiver ignora
    cmp  byte ptr cs:active,1
    je   newkey_end

    push ax

    in   al,60h     ; Le o codigo da tecla

    mov  ah,0
    test al,80h     ; Testa se pressionou ou soltou a tecla
    jnz  keyl100    ; Se soltou mantem o codigo 0 para a variavel
    inc  ah         ; Senao passa para 1 indicando que foi 'pressionar'

keyl100:
    and  al,7fh
    cmp  al,38h     ; Se for ALT
    jne  keyl200
    mov  cs:_alt,ah
    jmp  testa_teclas
keyl200:
    cmp  al,1       ; Pode ser ESC
    jne  jump_key
    mov  cs:_esc,ah

testa_teclas:
    cmp  byte ptr cs:_alt,1
    jne  jump_key
    cmp  byte ptr cs:_esc,1
    jne  jump_key

    ; Reseta as flags
    mov  byte ptr cs:_alt,0
    mov  byte ptr cs:_esc,0

    ; A combinacao de tecla foi gerada. Liga a flag de chamada
    mov  byte ptr cs:called,1 ; O timer vai chamar a funcao que processa

jump_key:
    pop  ax

newkey_end:

    jmp  cs:oldkey

newkey endp


newidle proc near
    ; Processa a interruupcao antiga
    pushf
    call cs:oldidle

    cli                         ; Desabilita interrupcoes

    cmp  byte ptr cs:called,1   ; Se foi chamado processa
    jne  idlesai

    mov  byte ptr cs:called,0   ; Desliga flag
    mov  byte ptr cs:active,1   ; Indica que esta ativo

    sti                         ; Habilita interrupcoes

    ; Processa tela
    call process_screen

    mov  byte ptr cs:active,0   ; Indica que esta ativo

idlesai:

    sti

    iret

newidle endp


calculate_loop_delay proc near

    mov  ax,040h
    mov  es,ax
    mov  bx,6ch   ; Endereco do timer

    xor  cx,cx    ; Zera o contador

    mov  dx,es:[bx]  ; Pega a parte baixa do contador

clockloop1:
    mov  ax,es:[bx]
    sub  ax,dx
    cmp  ax,1
    jl   clockloop1

    inc  dx

clockloop2:
    inc  cx
    mov  ax,es:[bx]
    sub  ax,dx
    cmp  ax,1
    jl   clockloop2

    ; Neste ponto CX possui o numero de operacoes necessarias
    ;
    ; waittime ---- maxtimes
    ;    x     ---- CX
    ;
    mov  ax,waittime
    xor  dx,dx
    mul  cx
    mov  cx,maxtimes
    div  cx

    ; Para o caso de haver resto incrementa AX
    inc  ax
    mov  word ptr cs:waitinstr,ax    ; Guarda o numero de instrucoes

    ret

calculate_loop_delay endp


get_dirname proc near

    mov  bx,offset dirname
    mov  si,81h            ; Get dirname from PSP

    mov  cx,si
    add  cx,ax             ; Pointer to EOL

find_str_begining:
    cmp  byte ptr es:[si],' '
    je   str_is_space

    cmp  byte ptr es:[si],13   ; 13 = CR
    je   str_is_space

    cmp  si,cx
    jge  invalid_str

    jmp  found_str_begining

str_is_space:
    inc  si
    jmp  find_str_begining

invalid_str:

    push cs
    pop  es

    mov  ax,default_dirlength
    mov  dirlength,ax  ; Save length of directory for use with strcpy later

    mov  bx,offset dirname ; Assume a default directory
    mov  si,offset default_dirname
    call strcpy

    call calculate_loop_delay

    mov  ax,0ffffh

    jmp  has_backslash

found_str_begining:

    push si


find_str_end:
    cmp  byte ptr es:[si],' '
    jne  test_for_eol1

    jmp  short end_of_str_test

test_for_eol1:
    cmp  si,cx
    je   end_of_str_test

    inc  si
    jmp  find_str_end

end_of_str_test:
    mov  byte ptr es:[si],0

    mov  cx,si
    pop  si

    push si
    call strcpy
    mov  dx,bx
    mov  ax,si
    pop  si

    push ax
    mov  ax,cx
    sub  ax,si

    mov  dirlength,ax  ; Save length of directory for use with strcpy later
    pop  ax

    mov  bx,dx

    dec  bx                 ; Get last position before EOL
    cmp  byte ptr [bx],'\'  ; See if there's a terminating BACKSLASH
    je   has_backslash      ; Yes there is
    inc  word ptr dirlength ; In this case, add 1 to the string lenght
    inc  bx
    mov  byte ptr [bx],'\'  ; No. So, include one
    inc  bx
    mov  byte ptr [bx],0   ; Terminate string

has_backslash:

    ret

get_dirname endp


get_clock_count proc near

    mov  cx,81h
    add  cx,ax             ; Pointer to EOL

find_clock_begining:
    cmp  byte ptr es:[si],' '
    je   clock_is_space

    cmp  byte ptr es:[si],13    ; 13 = CR
    je   clock_is_space

    cmp  si,cx
    jge  invalid_clock

    jmp  found_clock_begining

clock_is_space:

    inc  si
    jmp  find_clock_begining

invalid_clock:
    mov  ax,0ffffh

    call calculate_loop_delay
    jmp  finish_clock

found_clock_begining:

    push si

find_clock_end:
    cmp  byte ptr es:[si],' '
    jne  test_for_eol2

    jmp  short end_of_clock_test

test_for_eol2:
    cmp  si,cx
    je   end_of_clock_test

    inc  si
    jmp  find_clock_end

end_of_clock_test:
    mov  byte ptr es:[si],0

    mov  bx,si
    pop  si

    mov  cl,10
    xor  dx,dx
    xor  ax,ax

str_to_word:
    cmp  byte ptr es:[si],0
    je   set_clock
    mul  cl
    xor  dh,dh
    mov  dl,byte ptr es:[si]
    sub  dl,'0'
    add  ax,dx
    inc  si
    jmp  str_to_word

set_clock:

    mov  word ptr cs:waitinstr,ax

finish_clock:
    ret

get_clock_count endp


;--------------------------------------------------------------
; Programa principal
;--------------------------------------------------------------
start:
    push cs
    pop  ds

    cld

    ; Get PSP
    mov  ah,62h
    int  21h
    mov  es,bx

    mov  bx,80h     ; Endereco do numero de bytes da linha de comando
    xor  ah,ah
    mov  al,byte ptr es:[bx]    ; Pega no PSP o numero de bytes
    cmp  ax,0
    jne  retrieve_dirname_and_clock

    push cs
    pop  es

    mov  ax,default_dirlength
    mov  dirlength,ax  ; Save length of directory for use with strcpy later

    mov  bx,offset dirname ; Assume a default directory
    mov  si,offset default_dirname
    call strcpy

    call calculate_loop_delay

    jmp  short continue_setup

retrieve_dirname_and_clock:

    push ax
    call get_dirname
    mov  si,ax
    pop  ax

    cmp  si,0ffffh
    je   skip_get_clock

    call get_clock_count

skip_get_clock:

    push cs
    pop  es

continue_setup:

    ; Guarda o endereco da DOS BUSY FLAG
    mov  ah,34h
    int  21h
    mov  cs:_dosflag,bx
    mov  cs:_dosflag[2],es

    ; Guarda os enderecos originais dos vetores de interrupcao que
    ; serao interceptados
    mov  ax,3508h
    int  21h
    mov  cs:_oldtimer,bx
    mov  cs:_oldtimer[2],es

    mov  ax,3509h
    int  21h
    mov  cs:_oldkey,bx
    mov  cs:_oldkey[2],es

    mov  ax,3528h
    int  21h
    mov  cs:_oldidle,bx
    mov  cs:_oldidle[2],es

    ; Intercepta os vetores de interrupcao necessarios
    push cs
    pop  ds

    mov  ax,2509h
    mov  dx,offset newkey
    int  21h

    push cs
    pop  ds

    mov  ax,2508h
    mov  dx,offset newtimer
    int  21h

    push cs
    pop  ds

    mov  ax,2528h
    mov  dx,offset newidle
    int  21h

    mov  ax,0e07h
    xor  bh,bh
    int  10h

    ; Termina o programa e fica residente
    mov  dx,offset start
    int  27h

main endp

code ends
    end main
