{$M 16384,0,40000}

{--------------------------------------------------------}
{
{    Programa Cata Palavras
{
{    Autor: Jose' Antonio Borges
{
{    Em 25/10/97
{
{--------------------------------------------------------}

program catavox;

uses dos, crt, lenumstr, readvox, sintvox, traduvox, intervox;

const
    ESC   = #$1b;
    ENTER = #$0d;

    DIM = 20;

var
    tabPal: array [1..25] of string[DIM];
    achada: array [1..25] of boolean;

    tabul: array [1..DIM, 1..DIM] of char;
    marcado: array [1..DIM, 1..DIM] of boolean;
    jogo, njogos: integer;
    arq: text;
    nPal: integer;
    xcur, ycur: integer;
    processando: boolean;
    achadas: integer;

    bt: array [1..1000] of char;
    maxbt, posbt: integer;

    titulo: string;
    nivel: integer;

    int8Original: procedure;
    ncham: integer;
    regs: registers;
    h0, m0, s0, c0: word;

{--------------------------------------------------------}
{                      da mensagem falada
{--------------------------------------------------------}

procedure mensagem (s: string);
begin
    if s = 'CAINIC'   then writeln ('JOGO CATAVOX - v 1.0')
    else
    if s = 'CAREDES'  then writeln ('JOGO CATAVOX - v 1.0')
    else
    if s = 'CAQUERIN' then write ('Deseja instrucoes (s/n) ? ')
    else
    if s = 'CAINSTRU' then
        begin
            clrscr;
            writeln ('JOGO CATAVOX - v 1.0');
            writeln;
            writeln ('O objetivo do jogo e'' localizar uma serie de palavras dadas');
            writeln ('num tabuleiro que contem uma "Sopa de Letras".  As palavras estao');
            writeln ('imersas nesta sopa. No nivel um de dificuldade, as letras estao');
            writeln ('apenas na horizontal, mas nos niveis mais altos de dificuldade');
            writeln ('podem estar dispostas em outras direcoes, inclusive diagonal e');
            writeln ('de tras para diante.');
            writeln;
            writeln ('Para se caminhar nesta sopa, usam-se as setas, e tambem as teclas');
            writeln ('home, end para movimentos de 45 graus para a esquerda, e page up e');
            writeln ('page dn para 45 graus a direita.  Pode-se opcionalmente usar o teclado');
            writeln ('numerico, em que a disposicao das teclas e'' intuitiva inclusive');
            writeln ('para os movimentos diagonais.');
            writeln;
            writeln ('Para marcar uma palavra localizada, deve-se estar no inicio desta');
            writeln ('e teclar enter.  O programa perguntara'' a direcao da palavra,');
            writeln ('o que deve ser indicado com as mesmas teclas de movimento.');
            writeln;
            writeln ('Tecle espaco para saber o tempo, e quantas palavras faltam.');
            writeln ('Tecle F1 para saber as palavras buscadas.');
            writeln;
        end
    else
    if s = 'CASEMTRD' then writeln ('Erro no diretorio do tradutor')
    else
    if s = 'CAARNENC' then writeln ('Nao achei o arquivo pedido')
    else
    if s = 'CAARQCOR' then writeln ('Arquivo de palavras esta'' corrompido !')
    else
    if s = 'CAERRPAL' then write   ('Erro no arquivo na linha ')
    else
    if s = 'CAPRGCAN' then writeln ('O programa foi cancelado.')
    else
    if s = 'CAMOSTAM' then write ('Mostra tambem as que ja'' encontrou (s/n): ')
    else
    if s = 'CADENOVO' then write ('Quer jogar de novo (s/n) ? ')
    else
    if s = 'CATCHAU'  then writeln ('Gostei de jogar com voce, tchau...')
    else
    if s = 'CAVEPAL'  then write ('Quer conhecer as palavras (s/n) ? ')
    else              
    if s = 'CATEMA'   then write ('Tema: ')
    else              
    if s = 'CADISPON' then write ('Numero de jogos disponiveis: ')
    else              
    if s = 'CAESCNUM' then write ('Escolha o numero do jogo: ')
    else
    if s = 'CANIVEL'  then write ('Escolha o nivel de 1 a 8: ')
    else
    if s = 'CAERRGER' then write ('Erro na carga do gerador de cata palavras')
    else
    if s = 'CAAGUARD' then write ('Aguarde sem teclar nada: estou gerando o tabuleiro !')
    else
    if s = 'CAOK'     then write ('Ok, tabuleiro gerado.')
    else
    if s = 'CAACHAD'  then write (' Achadas ')
    else              
    if s = 'CATEMPO'  then write ('Tempo: ')
    else              
    if s = 'CAFALTAN' then write (', faltando ')
    else
    if s = 'CAQUERDS' then write ('Quer mesmo desistir (s/n) ? ')
    else
    if s = 'CAINDDIR' then write ('Indique a direcao')
    else
    if s = 'CADIRINV' then write (' -> Direcao invalida.')
    else
    if s = 'CAACHOU'  then write ('Achou !')
    else
    if s = 'CABLEFOU' then write ('Nao tem nada aqui !')
    else
    if s = 'CAGANHOU' then write ('G A N H O U  ! ! !')
    else
    ;

    sintSom (s);
end;

{-----------------------------------------------------------}
{                   relogio de tempo real
{-----------------------------------------------------------}

procedure tempoReal;
var h, m, s, c: word;
    difh, difm, difs: integer;
begin
    gotoxy (70, 25);  clreol;
    gettime (h, m, s, c);

    difh := integer(h) - h0;
    if difh < 0 then difh := difh + 24;
    difm := integer(m) - m0;
    if difm < 0 then
        begin
            difm := difm + 60;
            difh := difh - 1;
        end;
    difs := integer(s) - s0;
    if difs < 0 then
        begin
            difs := difs + 60;
            difm := difm - 1;
        end;

    if difh < 10 then write ('0'); write (difh, ':');
    if difm < 10 then write ('0'); write (difm, ':');
    if difs < 10 then write ('0'); write (difs);
end;

{-----------------------------------------------------------}
{                       calcula o tempo                     }
{-----------------------------------------------------------}

procedure mostraTempo;
var h, m, s, c: word;
    difh, difm, difs: integer;
begin
    gotoxy (1, 25);  clreol;
    mensagem ('CATEMPO');
    gettime (h, m, s, c);

    difh := integer(h) - h0;
    if difh < 0 then difh := difh + 24;
    difm := integer(m) - m0;
    if difm < 0 then
        begin
            difm := difm + 60;
            difh := difh - 1;
        end;
    difs := integer(s) - s0;
    if difs < 0 then
        begin
            difs := difs + 60;
            difm := difm - 1;
        end;

    if difh < 10 then write ('0'); write (difh, ':');
    if difm < 10 then write ('0'); write (difm, ':');
    if difs < 10 then write ('0'); write (difs);

     if difh > 0 then
         begin
             falaNumeroConv (numeroParaString (difh), FEMININO);
             if difh = 1 then sintSom ('_HORA')
                         else sintSom ('_HORAS');
         end;

     falaNumeroConv (numeroParaString (difm), MASCULINO);
     if difm > 1 then
         sintSom ('_MINUTOS')
     else
         sintSom ('_MINUTO');
     falaNumeroConv (numeroParaString (difs), MASCULINO);
     sintSom ('_SEGUNDS');

     mensagem ('CAACHAD');
     write (achadas);
     falaNumeroConv (numeroParaString (achadas), FEMININO);

     if npal <> achadas then
         begin
             mensagem ('CAFALTAN');
             write (npal-achadas);
             falaNumeroConv (numeroParaString (npal-achadas), FEMININO);
         end;

     sintsom ('CAPLIN');
end;

{--------------------------------------------------------}
{             carrega as palavras selecionadas
{--------------------------------------------------------}

procedure carregaPalavras;
var s, sai: string;
    i: integer;

    procedure adicionaPalavras (s: string);
    var i, j: integer;
        temp: string;
    begin
        for i := 1 to length (s) do
            if s[i] = ',' then s[i] := ' ';

        s := s + ' ';

        while s <> '' do
            begin
                while (s <> '') and (s[1] = ' ') do
                    delete (s, 1, 1);

                sai := '';
                while (s <> '') and (s[1] <> ' ') do
                    begin
                        sai := sai + s[1];
                        delete (s, 1, 1);
                    end;
                if sai <> '' then
                    begin
                        npal := npal + 1;
                        tabPal [npal] := sai;
                        achada [npal] := false;
                    end;
            end;

         for i := 1 to npal-1 do
             for j := i+1 to npal do
                 if tabPal [i] > tabPal[j] then
                     begin
                         temp := tabPal [i];
                         tabPal [i] := tabPal[j];
                         tabPal [j] := temp;
                     end;
    end;

begin
    njogos := 0;
    achadas := 0;

    reset (arq);
    while not eof (arq) do
        begin
            readln (arq, s);
            if s[1] = '*' then njogos := njogos + 1;
        end;

    close (arq);

    if njogos = 0 then
        begin
            mensagem ('CAARQCOR');
            mensagem ('CAPRGCAN');
            tradfim;
            halt;
        end;

    reset (arq);

    mensagem ('CADISPON');
    str (njogos, s);
    write (njogos);
    sintetiza (s);
    writeln;

    mensagem ('CAESCNUM');
    jogo := 0;
    xreadint (jogo);
    if (jogo = 0) or (jogo > njogos) then
        begin
            mensagem ('CAPRGCAN');
            tradfim;
            halt;
        end;

    i := 0;
    while i < jogo do
        begin
            readln (arq, s);
            if s[1] = '*' then i := i + 1;
        end;

    delete (s, 1, 1);
    titulo := s;

    mensagem ('CATEMA');
    writeln (ansiParaPc(s));
    sintetiza (s);

    s := ' ';
    npal := 0;
    while (not eof (arq)) and (copy (s, 1, 1) <> '*') do
        begin
            readln (arq, s);
            if copy (s, 1, 1) <> '*' then
                adicionaPalavras (s);
        end;

    close (arq);
end;

{--------------------------------------------------------}
{                  cancela o programa
{--------------------------------------------------------}

procedure cancelaPrograma;
begin
    mensagem ('CAPRGCAN');
    tradfim;
    halt;
end;

{--------------------------------------------------------}
{                     inicializacao
{--------------------------------------------------------}

procedure inicializa;
var dir: string;
    linha, pal: string;
    c: char;
label fim;

begin
    clrscr;
    sintInic (0, 'DIRCATAVOX');

    if tradinic <> 0 then
        begin
            mensagem ('CASEMTRD');
            tradfim;
            halt;
        end;

    mensagem ('CAINIC');
    writeln;

    mensagem ('CAQUERIN');
    c := readkey;
    writeln (c);
    sintCarac (c);
    if c = #$1b then cancelaPrograma;
    if upcase(c) = 'S' then
        mensagem ('CAINSTRU');

    while keypressed do c := readkey;
    
    dir := sintAmbiente('DIRCATAVOX');
    if dir <> '' then
        if dir [length(dir)] <> '\' then
           dir := dir + '\';

    assign (arq, dir+'CATAVOX.PAL');
    {$i-}   reset (arq);   {$i+}
    if ioresult <> 0 then
        begin
            mensagem ('CAARNENC');
            cancelaPrograma;
        end;

    close (arq);
end;

{--------------------------------------------------------}
{     interrupcao de timer para jogar teclas no buffer
{--------------------------------------------------------}

{$F-}
procedure novaIntTimer; interrupt;
var regs: registers;
begin
    asm; pushf; end;
    int8Original;

    ncham := ncham + 1;
    if ncham > 60 then
        begin
            asm; cli; end;
            with regs do
                begin
                    ah := 5;
                    ch := 0;
                    cl := ord(bt [posbt]);

                    intr ($16, regs);

                    if bt[posbt] = #$0d then
                        begin
                            sound (100);  delay (20);  nosound;
                        end;

                    posbt := posbt + 1;
                    if posbt > maxbt then
                        setIntVec (8, @int8Original);
                end;
        end;

    asm; sti; end;
end;

{--------------------------------------------------------}
{              elimina acento de uma letra
{--------------------------------------------------------}

function semAcento (c: char): char;

const tabSemAcento: array [#$c0..#$ff] of char =
    (
        'a','a','a','a','a','a','x','c','e','e','e','e','i','i','i','i',
        'x','n','o','o','o','o','o','x','o','u','u','u','u','y','x','x',
        'a','a','a','a','a','a','x','c','e','e','e','e','i','i','i','i',
        'x','n','o','o','o','o','o','x','o','u','u','u','u','y','x','x'
    );

begin
    if c >= #$c0 then
        semAcento := tabSemAcento [c]
    else
        semAcento := c;
end;

{--------------------------------------------------------}
{                gera um tabuleiro de jogo
{--------------------------------------------------------}

procedure geraJogo;
var i: integer;

    procedure montaCadeia (cad: string);
    var i: integer;
    begin
        for i := 1 to length (cad) do
           begin
               maxbt := maxbt + 1;
               bt [maxbt] := semAcento (cad[i]);
           end;
    end;


var s, nomeCom: string;
    c: char;

begin
    nivel := 0;
    repeat
        mensagem ('CANIVEL');
        c := readkey;
        writeln (c);
        sintCarac (c);
        nivel := ord (c) - ord ('0');
    until nivel in [1..8];

    mensagem ('CAAGUARD');
    while keypressed do c := readkey;

    posbt := 1;
    maxbt := 0;

    str (DIM, s);
    montaCadeia (s + ^m + s + ^m);
    for i := 1 to npal do
        montaCadeia (tabPal[i] + ^m);
    montaCadeia (^m);
    montaCadeia (chr (nivel + ord ('0')));
    montaCadeia (^m + 'y');
    montaCadeia (titulo + ^m + 'fnn');

    ncham := 0;

    asm cli; end;
    ncham := 0;
    getIntVec (8, @Int8Original);       { substitui interrupcao de timer }
    setIntVec (8, addr (novaIntTimer));
    asm sti; end;

    tradfim;

    nomeCom := getenv ('COMSPEC');
    if nomecom = '' then
        nomeCom := 'C:\COMMAND.COM';
    Exec(nomecom, ' /C ' + 'wordsrch');

    if DosError <> 0 then
        begin
            WriteLn('Dos error #', DosError);
            setIntVec (8, @int8Original);

            sintInic (0, 'DIRCATAVOX');
            if tradinic <> 0 then;
            mensagem ('CAERRGER');
            cancelaPrograma;
        end;

    sintInic (0, 'DIRCATAVOX');
    if tradinic <> 0 then;
    clrscr;

    mensagem ('CAREDES');
    mensagem ('CAOK');
end;

{--------------------------------------------------------}
{                      redesenha tela
{--------------------------------------------------------}

procedure redesenhaTela;
var x, y: integer;
begin
    gotoxy (1, 1);
    mensagem ('CAREDES');

    textBackground (BLACK);
    for y := 1 to DIM do
        begin
            gotoxy (1, y+3);
            write (' ');
            for x := 1 to DIM do
                begin
                    if marcado [x, y] then
                        textColor (YELLOW)
                    else
                        textColor (LIGHTGRAY);
                    write (tabul [x, y]);
                    write (' ');
                end;
        end;

    textBackground (BLACK);
    textColor (LIGHTGRAY);
    for y := 1 to 25 do
        begin
            gotoxy (50, y);
            if achada [y] then textBackground (MAGENTA);
            if y <= npal then write (ansiParaPc (tabPal[y]));
            textBackground (BLACK);
            clreol;
        end;
end;

{--------------------------------------------------------}
{                      carrega o jogo
{--------------------------------------------------------}

procedure carregaJogo;
var s: string;
    x, y, i: integer;
    c: char;
    arq: text;
begin
    assign (arq, 'WORDSRCH.OUT');
    reset (arq);

    readln (arq);
    readln (arq);
    repeat
        readln (arq, s);
    until s = '';

    for y := 1 to DIM do
        begin
            for x := 1 to DIM do
                begin
                    if x <> 1 then read (arq, c);
                    read (arq, tabul [x, y]);
                    marcado [x, y] := false;
                end;

            readln (arq);
        end;

    close (arq);
end;

{--------------------------------------------------------}
{                    mostra as palavras
{--------------------------------------------------------}

procedure mostraPalavras;
var y: integer;
    c: char;
    mostraTudo: boolean;
begin
    mostraTudo := true;
    if achadas <> 0 then
        begin
            gotoxy (1, 25);
            mensagem ('CAMOSTAM');
            c := readkey;
            write (c);
            sintCarac (c);
            mostraTudo := upcase(c) = 'S';
        end;

    textBackground (BLACK);
    for y := 1 to npal do
        begin
            gotoxy (50, y);
            if mostraTudo or (not achada [y]) then
                begin
                    textBackground (BLUE);
                    if y <= npal then write (ansiParaPc (tabPal[y]));
                    sintetiza (tabPal [y]);
                    gotoxy (50, y);
                    if achada [y] then
                        textBackground (MAGENTA)
                    else
                        textBackground (BLACK);
                    if y <= npal then write (ansiParaPc (tabPal[y]));
                end;
        end;

    sintSom ('CAPLIN');
end;

{--------------------------------------------------------}
{                     ve se trecho coincide
{--------------------------------------------------------}

function coincide (s: string; x, y, dx, dy: integer): boolean;
var i: integer;
begin
    coincide := false;
    for i := 1 to length (s) do
        begin
            if (x < 0) or (y < 0) or
               (x > DIM) or (y > DIM) then
                   exit;

            if upcase (semAcento (s[i])) <> tabul [x, y] then
                exit;

            x := x + dx;
            y := y + dy;
        end;

    coincide := true;
end;

{--------------------------------------------------------}
{                     marca uma palavra
{--------------------------------------------------------}

procedure marcaPalavra;
var
    i, n: integer;
    x, y, dx, dy: integer;
    c: char;
begin
    gotoxy (1, 25);  clreol;
    mensagem ('CAINDDIR');

    c := readkey;
    dx := 0;
    dy := 0;
    if c = #$0 then
        begin
            c := readkey;
            case c of
                CIMA: dy := -1;
                BAIX: dy :=  1;
                ESQ:  dx := -1;
                DIR:  dx :=  1;
                HOME: begin  dy := -1;  dx := -1;  end;
                TEND: begin  dy :=  1;  dx := -1;  end;
                PGUP: begin  dy := -1;  dx :=  1;  end;
                PGDN: begin  dy :=  1;  dx :=  1;  end;
            else
                begin
                    mensagem ('CADIRINV');
                    exit;
                end;
            end;
        end

    else
        begin
            case c of
                '8': dy := -1;
                '2': dy :=  1;
                '4': dx := -1;
                '6': dx :=  1;
                '7': begin  dy := -1;  dx := -1;  end;
                '1': begin  dy :=  1;  dx := -1;  end;
                '9': begin  dy := -1;  dx :=  1;  end;
                '3': begin  dy :=  1;  dx :=  1;  end;
            else
                begin
                    mensagem ('CADIRINV');
                    exit;
                end;
            end;
        end;

    for i := 1 to npal do
        begin
            if not achada [i] then
                if coincide (tabPal [i], xcur, ycur, dx, dy) then
                    begin
                        achada [i] := true;

                        x := xcur;
                        y := ycur;
                        for n := 1 to length (tabPal [i]) do
                            begin
                                marcado [x, y] := true;
                                x := x + dx;
                                y := y + dy;
                            end;

                        redesenhaTela;

                        gotoxy (1, 25);  clreol;
                        mensagem ('CAACHOU');

                        sintetiza (tabPal [i]);

                        achadas := achadas + 1;
                        exit;
                    end;
        end;

    gotoxy (1, 25);  clreol;
    mensagem ('CABLEFOU');
    exit;
end;

{--------------------------------------------------------}
{                         desiste
{--------------------------------------------------------}

procedure desiste;
var c: char;
begin
    gotoxy (1, 25); clreol;
    mensagem ('CAQUERDS');
    c := readkey;
    write (c);
    sintCarac (c);
    if upcase(c) = 'S' then
        processando := false
    else
        begin
            gotoxy (1, 25); clreol;
        end;
end;

{--------------------------------------------------------}
{                 transforma letra em minuscula
{--------------------------------------------------------}

function minusc (c: char): char;
begin
    minusc := c;
    if c in ['A'..'Z'] then
        minusc := chr (ord (c) + $20);
end;

{--------------------------------------------------------}
{                         vitoria
{--------------------------------------------------------}

procedure vitoria;
begin
    gotoxy (50, 24);   clreol;
    textColor (White+blink);
    mensagem ('CAGANHOU');
    textColor (lightGray);

    gotoxy (1, 24);
    mostraTempo;
end;

{--------------------------------------------------------}
{                jogo propriamente dito
{--------------------------------------------------------}

procedure joga;
var i, t: integer;
    c: char;
begin
    clrscr;
    redesenhaTela;
    xcur := 1;
    ycur := 1;

    gettime (h0, m0, s0, c0);

    while keypressed do c := readkey;

    processando := true;
    while processando do
        begin
            gotoxy (xcur*2, ycur+3);
            if marcado [xcur, ycur] then
                sintcarac (tabul [xcur, ycur])
            else
                sintcarac (minusc (tabul [xcur, ycur]));

            t := 0;
            while not keypressed do
                begin
                    delay (100);
                    if t = 0 then tempoReal;
                    t := (t + 1) mod 10;
                    gotoxy (xcur*2, ycur+3);
                end;

            c := readkey;
            if c = #$0 then
                begin
                    c := readkey;
                    case c of
                        CIMA: ycur := ycur - 1;
                        BAIX: ycur := ycur + 1;
                        ESQ:  xcur := xcur - 1;
                        DIR:  xcur := xcur + 1;
                        HOME: begin  ycur := ycur - 1;  xcur := xcur - 1;  end;
                        TEND: begin  ycur := ycur + 1;  xcur := xcur - 1;  end;
                        PGUP: begin  ycur := ycur - 1;  xcur := xcur + 1;  end;
                        PGDN: begin  ycur := ycur + 1;  xcur := xcur + 1;  end;

                        F1:   mostraPalavras;
                    else
                        sintBip;
                    end
                end
            else
                begin
                    case c of
                        '8': ycur := ycur - 1;
                        '2': ycur := ycur + 1;
                        '4': xcur := xcur - 1;
                        '6': xcur := xcur + 1;
                        '7': begin  ycur := ycur - 1;  xcur := xcur - 1;  end;
                        '1': begin  ycur := ycur + 1;  xcur := xcur - 1;  end;
                        '9': begin  ycur := ycur - 1;  xcur := xcur + 1;  end;
                        '3': begin  ycur := ycur + 1;  xcur := xcur + 1;  end;

                        ENTER:  begin
                                    marcaPalavra;
                                    if achadas = npal then
                                        begin
                                            processando := false;
                                            vitoria;
                                        end;
                                end;    
                        ' ':    mostraTempo;
                        ESC:    desiste;
                    else
                        sintbip;
                    end;
                end;

            if (xcur < 1) or (xcur > DIM) or
               (ycur < 1) or (ycur > DIM) then
                  sintbip;

            if (xcur < 1)   then xcur := 1;
            if (ycur < 1)   then ycur := 1;
            if (xcur > DIM) then xcur := DIM;
            if (ycur > DIM) then ycur := DIM;
        end;
end;

{--------------------------------------------------------}
{                   programa principal
{--------------------------------------------------------}

var resp: char;
    i, njog: integer;

    c: char;
begin
    inicializa;

    repeat
        carregaPalavras;
        geraJogo;
        carregaJogo;

        gotoxy (1, 25);  clreol;
        while keypressed do resp := readkey;
        mensagem ('CAVEPAL');
        resp := readkey;
        sintCarac (resp);
        write (resp);
        if upcase(resp) <> 'N' then
            mostraPalavras
        else
            delay (1000);

        joga;

        gotoxy (1, 25);  clreol;
        while keypressed do resp := readkey;
        mensagem ('CADENOVO');
        resp := readkey;
        if resp > #20 then write (resp);
        sintcarac (upcase(resp));

        clrscr;
        mensagem ('CAREDES');
        writeln;
    until upcase (resp) = 'N';

    mensagem ('CATCHAU');
    tradFim;
end.
