{--------------------------------------------------------}
{
{   Leitor de telas 3.0
{
{   Autores: Jose' Antonio Borges
{            Xyko Goncalves (Serpro)
{
{   Baseado no programa original em assembler de
{       Orlando Jose' Rodrigues Alves
{
{   Em 14/1/97
{
{--------------------------------------------------------}

{$M 20000,50000,50000}
program vox3;
uses
    dos, crt,
    traduvox, intervox, sintvox, playvox, vox3func, vox3glob, vox3mon;

var
    intTecOrig: procedure;
    intDosIdleOrig: procedure;
    int8Original: procedure;

    dosOcup: ^byte;
    codFunc1, codFunc2: char;

    segStackNova, stackPtrNova: word;

    salvaStatus, statusVox: (INATIVO, PENDENTE, MONITORANDO, ATIVO, TECLAPENDENTE);
    pins, pret: integer;
    bufFalar: array [0..15] of char;

    quantTimer: byte;
    funcaoPendente: boolean;

{$F+}

{--------------------------------------------------------}
{                   fala tecla digitada
{--------------------------------------------------------}

procedure falaTecla;       { interrupcoes estao inibidas }
var
    tecla: char;
    teclaAtual: char;

begin
    salvaStatus := statusVox;
    statusVox := TECLAPENDENTE;

    asm              
        mov ax,ss
        mov bx,sp

        mov ss,segStackNova
        mov sp,stackPtrNova

        push ax  {salva ss e sp}
        push bx
    end;

    asm sti; end;    { libera interrupcoes }

    sintInic (0, '');
    teclaCortaFala (false);

    case veloAtual of
    '1': begin
            falaRapida (false);
            falacondensada (false);
         end;
    '2': begin
            falaRapida (true);
            falacondensada (false);
         end;
    '3': begin
            falacondensada (true);
            falarapida (false);
         end;
    '4': begin
            falaRapida (true);
            falacondensada (true);
         end;
    end;

    while pins <> pret do
        begin
            teclaAtual := bufFalar [pret];
            pret := (pret + 1) mod 15;
            if teclaAtual >= #32 then
                begin
                case teclaAtual of
                #34 : sintsom ('_vo34');
                #40 : sintsom ('_vo40');
                #41 : sintsom ('_vo41');
                #42 : sintsom ('_vo42');
                #44 : sintsom ('_vo44');
                #47 : sintsom ('_vo47');
                #48 : sintsom ('_vo48');
                #58 : sintsom ('_vo58');
                #59 : sintsom ('_vo59');
                #91 : sintsom ('_vo91');
                #93 : sintsom ('_vo93');
                else sintcarac (teclaAtual);
                    end;
                end;
        end;

    monitoracao;

    asm
        cli;     {inibe interrupcoes}
        pop ax   {pega sp e ss salvo}
        pop ss
        mov sp,ax
    end;

    statusVox := salvaStatus;
                 {interrupcoes saem inibidas}
end;

{--------------------------------------------------------}
{                       ativa o vox
{--------------------------------------------------------}

procedure ativaVox;
var vetor: pointer;
begin
    statusVox := ATIVO;

    asm              { interrupcoes estao inibidas }
        mov ax,ss
        mov bx,sp

        mov ss,segStackNova
        mov sp,stackPtrNova

        push ax  {salva ss e sp}
        push bx
    end;

    asm sti; end;    { libera interrupcoes }

    if (codFunc1 = #0) and (codFunc2 = #0) then
        ativaLedor
    else
        ativaImediato (codFunc1, codFunc2);

    asm
        cli      {inibe interrupcoes}
        pop ax   {pega sp e ss salvo}
        pop ss
        mov sp,ax
    end;

    statusVox := INATIVO;
                 {interrupcoes saem inibidas}
    funcaoPendente := false;
    pins := 0;   {inibe eventual fala de tecla pendente}
    pret := 0;
end;

{--------------------------------------------------------}
{                       ativa o vox
{--------------------------------------------------------}

procedure fazMonitoracao;
begin
     if statusVox <> INATIVO THEN
        exit;

    statusVox := MONITORANDO;

    asm              { interrupcoes estao inibidas }
        mov ax,ss
        mov bx,sp

        mov ss,segStackNova
        mov sp,stackPtrNova

        push ax  {salva ss e sp}
        push bx
    end;

    asm sti; end;    { libera interrupcoes }

    if funcaoPendente then
        begin
            if (codFunc1 = #0) and (codFunc2 = #0) then
                ativaLedor
            else
                ativaImediato (codFunc1, codFunc2);
            funcaoPendente := false;
            pins := 0;   {inibe eventual fala de tecla pendente}
            pret := 0;
        end;

    monitoracao;

    asm
        cli      {inibe interrupcoes}
        pop ax   {pega sp e ss salvo}
        pop ss
        mov sp,ax
    end;

    if statusVox = MONITORANDO then
        statusVox := INATIVO;
                 {interrupcoes saem inibidas}
end;

{--------------------------------------------------------}
{                insere no buffer de teclado
{--------------------------------------------------------}

procedure insBufFalar (c: char);
begin
    if ecoaTecla then
        begin
            bufFalar [pins] := c;
            pins := (pins + 1) mod 15;
        end;
end;

{--------------------------------------------------------}
{                nova interrupcao de teclado
{--------------------------------------------------------}

var regist: registers;

procedure novaIntTec; interrupt;

var
    acionou, imediato: boolean;
    cod: char;
    tecla: byte;
    c: char;
    posbt: integer;
    kbdFlags: byte;

const
      SHIFT   = 2;
      CONTROL = 4;
      ALT     = 8;

const
    CIMA = #72;
    BAIX = #80;
    ESQ  = #75;
    DIR  = #77;

begin
    tecla := port [$60];

    asm; pushf; end;
    intTecOrig;

    asm; sti; end;    { libera interrupcoes }

    regist.ah := 2;
    intr ($16, regist);
    regist.al := regist.al or ((regist.al and 1) shl 1);   { aceita shift direito }

    acionou := (regist.al and (CONTROL+ALT)) = CONTROL+ALT;
    if acionou then
        begin
            codFunc1 := #0;
            codFunc2 := #0;
            if statusVox <> INATIVO then
                begin
                    funcaoPendente := true;
                    exit;
                end;
        end
    else
        begin
            imediato := (regist.al and (CONTROL+SHIFT)) = CONTROL+SHIFT;
            if imediato then
                begin
                    if mem [$40:$1a] <> mem [$40:$1c] {keypressed} then
                        begin
                            acionou := true;
                            regist.ax := 0;
                            intr ($16, regist);

                            codFunc1 := chr(regist.ax and $ff);
                            codFunc2 := chr(regist.ax shr 8);
                            if statusVox <> INATIVO then
                                begin
                                    funcaoPendente := true;
                                    exit;
                                end;
                        end;
                end
            else
                begin
                    if (statusVox <> ATIVO) and ((tecla and $80) = 0) {apertando} then
                        begin
                            vertical := false;
                            regist.ah := $11;
                            intr ($16, regist);

                            if (regist.flags and $40) <> $40 then
                                begin
                                    c := chr(regist.al);
                                    case c of
                                        #$0, #224:  begin
                                                  case chr(regist.ah) of
                                                      ESQ: insBufFalar (leTela (wherey, wherex-1));
                                                      DIR: insBufFalar (leTela (wherey, wherex));
                                                      Del: insBufFalar (leTela (wherey, wherex+1));
                                                      CIMA, BAIX: vertical := true;
                                                  else
                                                      insBufFalar (#$1);
                                                  end;
                                              end;

                                        #$8:  begin
                                                  posbt := mem [$40:$1c] - 2;
                                                  if posbt < $1e then posbt := posbt + 32;
                                                  if posbt = (mem [$40:$1a]) then
                                                      begin
                                                          insBufFalar (#$1);
                                                          insBufFalar (leTela (wherey, wherex-1));
                                                      end
                                                  else
                                                     insBufFalar(#$1);

                                              end;

                                        #$0d:       begin
                                                        linhAt := -1;
                                                        insBufFalar (#$1);
                                                    end;
                                        #$1..#$1f:  insBufFalar (#$1);
                                    else
                                        begin
                                            posbt := mem [$40:$1c] - 2;
                                            if posbt < $1e then posbt := posbt + 32;
                                            c := chr (mem [$40:posbt]);
                                            insBufFalar (c);
                                        end;
                                    end;
                                end;
                        end;
                end;
        end;

    asm; cli; end;    { inibe interrupcoes }

    if (statusVox = INATIVO) then
        begin
            if acionou then
                begin
                    if dosOcup^ = 0 then
                        ativaVox
                    else
                        statusVox := PENDENTE;
                end
            else
                begin
                    if (pins <> pret) and (dosOcup^ = 0) then
                        falaTecla;
                end;
        end
    else
        if acionou then
            statusVox := PENDENTE;

    asm; sti; end;    { libera interrupcoes }
end;

{--------------------------------------------------------}
{                nova interrupcao de Dos Idle
{--------------------------------------------------------}

procedure novaDosIdle; interrupt;
begin
    asm pushf; end;
    intDosIdleOrig;

    asm cli; end;    { inibe interrupcoes }

    if statusVox = PENDENTE then
        ativaVox
    else
        if (statusVox = INATIVO) then
            if (pins <> pret) then
                falaTecla
            else
                fazMonitoracao;

    asm sti; end;    { libera Interrupcoes }
end;

{--------------------------------------------------------}
{                nova interrupcao do timer
{--------------------------------------------------------}

{$f+}
procedure novaIntTimer; interrupt;
begin
    asm; pushf; end;
    int8Original;
    port [$20] := $20;

    asm cli; end;    { inibe interrupcoes }

    if (statusVox = INATIVO) then
      if dosOcup^ = 0 then
            fazMonitoracao;

    if statusVox = PENDENTE then
        begin
            quantTimer := quantTimer + 1;

            if quantTimer >= 9 then
                begin
                    if dosOcup^ = 0 then
                        begin
                            asm cli; end;    { inibe interrupcoes }

                            if statusVox = PENDENTE then
                                ativaVox
                            else
                                if (statusVox = INATIVO) then
                                    if (pins <> pret) then
                                        falaTecla
                                    else
                                        fazMonitoracao;

                            asm sti; end;    { libera Interrupcoes }
                        end;

                    quantTimer := 0;
                end;
        end;

    asm; sti; end;    { libera interrupcoes }
end;

{--------------------------------------------------------}
{                       ativa o vox
{--------------------------------------------------------}

var
    regs: registers;
begin
    statusVox := INATIVO;
    pins := 0;
    pret := 0;
    quantTimer := 0;
    funcaoPendente := false;

    regs.ah := $34;          { pega endereco de Dos Busy }
    intr ($21, regs);
    dosOcup := ptr (regs.es, regs.bx);

    segStackNova := SSeg;
    stackPtrNova := SPtr;

    inicLedor;

    asm cli; end;

    GetIntVec (  9, @IntTecOrig);       { substitui interrupcao de teclado }
    SetIntVec (  9, addr (novaIntTec));

    GetIntVec ($28, @IntDosIdleOrig);   { substitui interrupcao Dos Idle }
    SetIntVec ($28, addr (novaDosIdle));

    getIntVec (8, @Int8Original);       { substitui interrupcao de timer }
    setIntVec (8, addr (novaIntTimer));
    asm sti; end;

    keep (0);
end.
